/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.util.iterator;

import java.util.Iterator;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NiceIterator;
import org.apache.jena.util.iterator.NullIterator;

public class WrappedIterator<T>
extends NiceIterator<T> {
    protected boolean removeDenied;
    protected final Iterator<? extends T> base;

    public static <T> ExtendedIterator<T> create(Iterator<T> it) {
        return it instanceof ExtendedIterator ? (ExtendedIterator)it : new WrappedIterator<T>(it, false);
    }

    public static <T> WrappedIterator<T> createNoRemove(Iterator<T> it) {
        return new WrappedIterator<T>(it, true);
    }

    public static <T> ExtendedIterator<T> createIteratorIterator(Iterator<Iterator<T>> it) {
        ExtendedIterator retval = NullIterator.instance();
        while (it.hasNext()) {
            retval = retval.andThen(it.next());
        }
        return retval;
    }

    public Iterator<? extends T> forTestingOnly_getBase() {
        return this.base;
    }

    protected WrappedIterator(Iterator<? extends T> base) {
        this(base, false);
    }

    protected WrappedIterator(Iterator<? extends T> base, boolean removeDenied) {
        this.base = base;
        this.removeDenied = removeDenied;
    }

    @Override
    public boolean hasNext() {
        return this.base.hasNext();
    }

    @Override
    public T next() {
        return this.base.next();
    }

    @Override
    public void remove() {
        if (this.removeDenied) {
            throw new UnsupportedOperationException();
        }
        this.base.remove();
    }

    @Override
    public void close() {
        WrappedIterator.close(this.base);
    }

    public static void close(Iterator<?> it) {
        NiceIterator.close(it);
    }
}

