/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of the libe-book project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef PDXLZ77STREAM_H_INCLUDED
#define PDXLZ77STREAM_H_INCLUDED

#include <boost/scoped_ptr.hpp>

#include <librevenge-stream/librevenge-stream.h>

namespace libebook
{

class PDXLZ77Stream : public librevenge::RVNGInputStream
{
// disable copying
  PDXLZ77Stream(const PDXLZ77Stream &other);
  PDXLZ77Stream &operator=(const PDXLZ77Stream &other);

public:
  PDXLZ77Stream(librevenge::RVNGInputStream *stream);
  virtual ~PDXLZ77Stream();

  virtual bool isStructured();
  virtual unsigned subStreamCount();
  virtual const char *subStreamName(unsigned id);
  virtual bool existsSubStream(const char *name);
  virtual librevenge::RVNGInputStream *getSubStreamByName(const char *name);
  virtual RVNGInputStream *getSubStreamById(unsigned id);

  virtual const unsigned char *read(unsigned long numBytes, unsigned long &numBytesRead);
  virtual int seek(long offset, librevenge::RVNG_SEEK_TYPE seekType);
  virtual long tell();
  virtual bool isEnd();

private:
  boost::scoped_ptr<librevenge::RVNGInputStream> m_stream;
};

}

#endif // PDXLZ77STREAM_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
