/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of the libe-book project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#include <map>

#include "FB2Content.h"
#include "FB2ContentMap.h"

using std::string;

namespace libebook
{

struct ContentMapImpl
{
  ContentMapImpl();

  std::map<string, const FB2Content *> m_map;
};

typedef std::map<string, const FB2Content *>::value_type Value_t;
typedef std::map<string, const FB2Content *>::const_iterator Iterator_t;

ContentMapImpl::ContentMapImpl()
  : m_map()
{
}

FB2ContentMap::FB2ContentMap()
  : m_impl(new ContentMapImpl())
{
}

FB2ContentMap::~FB2ContentMap()
{
  for (Iterator_t it = m_impl->m_map.begin(), last = m_impl->m_map.end(); it != last; ++it)
    delete it->second;
  delete m_impl;
}

bool FB2ContentMap::insert(const string &id, const FB2Content *const content)
{
  return m_impl->m_map.insert(Value_t(id, content)).second;
}

bool FB2ContentMap::exists(const string &id) const
{
  return get(id) != 0;
}

const FB2Content *FB2ContentMap::get(const string &id) const
{
  const Iterator_t iter = m_impl->m_map.find(id);
  if (iter != m_impl->m_map.end())
    return iter->second;
  return 0;
}

}

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
