; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes=dfa-jump-threading,sccp,simplifycfg %s | FileCheck %s

; This test checks that a constant propagation is applied for a basic loop.
; Related to bug 44679.
define i32 @test(i32 %a) {
; CHECK-LABEL: @test(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret i32 3
;
entry:
  br label %while.cond

while.cond:
  %num = phi i32 [ 0, %entry ], [ %add, %case1 ]
  %state = phi i32 [ 1, %entry ], [ %state.next, %case1 ]
  switch i32 %state, label %end [
  i32 1, label %case1
  i32 2, label %case2
  ]

case1:
  %state.next = phi i32 [ 3, %case2 ], [ 2, %while.cond ]
  %add = add nsw i32 %num, %state
  br label %while.cond

case2:
  br label %case1

end:
  ret i32 %num
}
