/* math-buttons.c generated by valac 0.24.0, the Vala compiler
 * generated from math-buttons.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <atk/atk.h>


#define TYPE_BUTTON_MODE (button_mode_get_type ())

#define TYPE_MATH_BUTTONS (math_buttons_get_type ())
#define MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_BUTTONS, MathButtons))
#define MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_BUTTONS, MathButtonsClass))
#define IS_MATH_BUTTONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_BUTTONS))
#define IS_MATH_BUTTONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_BUTTONS))
#define MATH_BUTTONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_BUTTONS, MathButtonsClass))

typedef struct _MathButtons MathButtons;
typedef struct _MathButtonsClass MathButtonsClass;
typedef struct _MathButtonsPrivate MathButtonsPrivate;

#define TYPE_MATH_EQUATION (math_equation_get_type ())
#define MATH_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_EQUATION, MathEquation))
#define MATH_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_EQUATION, MathEquationClass))
#define IS_MATH_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_EQUATION))
#define IS_MATH_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_EQUATION))
#define MATH_EQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_EQUATION, MathEquationClass))

typedef struct _MathEquation MathEquation;
typedef struct _MathEquationClass MathEquationClass;

#define TYPE_MATH_CONVERTER (math_converter_get_type ())
#define MATH_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_CONVERTER, MathConverter))
#define MATH_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_CONVERTER, MathConverterClass))
#define IS_MATH_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_CONVERTER))
#define IS_MATH_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_CONVERTER))
#define MATH_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_CONVERTER, MathConverterClass))

typedef struct _MathConverter MathConverter;
typedef struct _MathConverterClass MathConverterClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define TYPE_FINANCIAL_DIALOG (financial_dialog_get_type ())

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;
#define _number_unref0(var) ((var == NULL) ? NULL : (var = (number_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_SERIALIZER (serializer_get_type ())
#define SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SERIALIZER, Serializer))
#define SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SERIALIZER, SerializerClass))
#define IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SERIALIZER))
#define IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SERIALIZER))
#define SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SERIALIZER, SerializerClass))

typedef struct _Serializer Serializer;
typedef struct _SerializerClass SerializerClass;

#define TYPE_NUMBER_MODE (number_mode_get_type ())

#define TYPE_UNIT (unit_get_type ())
#define UNIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNIT, Unit))
#define UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNIT, UnitClass))
#define IS_UNIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNIT))
#define IS_UNIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNIT))
#define UNIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNIT, UnitClass))

typedef struct _Unit Unit;
typedef struct _UnitClass UnitClass;

#define TYPE_MATH_VARIABLE_POPUP (math_variable_popup_get_type ())
#define MATH_VARIABLE_POPUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_VARIABLE_POPUP, MathVariablePopup))
#define MATH_VARIABLE_POPUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_VARIABLE_POPUP, MathVariablePopupClass))
#define IS_MATH_VARIABLE_POPUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_VARIABLE_POPUP))
#define IS_MATH_VARIABLE_POPUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_VARIABLE_POPUP))
#define MATH_VARIABLE_POPUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_VARIABLE_POPUP, MathVariablePopupClass))

typedef struct _MathVariablePopup MathVariablePopup;
typedef struct _MathVariablePopupClass MathVariablePopupClass;

typedef enum  {
	BUTTON_MODE_BASIC,
	BUTTON_MODE_ADVANCED,
	BUTTON_MODE_FINANCIAL,
	BUTTON_MODE_PROGRAMMING
} ButtonMode;

struct _MathButtons {
	GtkBox parent_instance;
	MathButtonsPrivate * priv;
};

struct _MathButtonsClass {
	GtkBoxClass parent_class;
};

struct _MathButtonsPrivate {
	MathEquation* equation;
	ButtonMode _mode;
	gint _programming_base;
	MathConverter* converter;
	GtkBuilder* basic_ui;
	GtkBuilder* advanced_ui;
	GtkBuilder* financial_ui;
	GtkBuilder* programming_ui;
	GtkWidget* bas_panel;
	GtkWidget* adv_panel;
	GtkWidget* fin_panel;
	GtkWidget* prog_panel;
	GtkWidget* active_panel;
	GtkMenu* shift_left_menu;
	GtkMenu* shift_right_menu;
	GtkMenu* function_menu;
	GList* superscript_toggles;
	GList* subscript_toggles;
	GtkComboBox* base_combo;
	GtkLabel* base_label;
	GtkWidget* bit_panel;
	GList* bit_labels;
	GtkDialog* character_code_dialog;
	GtkEntry* character_code_entry;
};

typedef enum  {
	FINANCIAL_DIALOG_CTRM_DIALOG,
	FINANCIAL_DIALOG_DDB_DIALOG,
	FINANCIAL_DIALOG_FV_DIALOG,
	FINANCIAL_DIALOG_GPM_DIALOG,
	FINANCIAL_DIALOG_PMT_DIALOG,
	FINANCIAL_DIALOG_PV_DIALOG,
	FINANCIAL_DIALOG_RATE_DIALOG,
	FINANCIAL_DIALOG_SLN_DIALOG,
	FINANCIAL_DIALOG_SYD_DIALOG,
	FINANCIAL_DIALOG_TERM_DIALOG
} FinancialDialog;

typedef enum  {
	NUMBER_MODE_NORMAL,
	NUMBER_MODE_SUPERSCRIPT,
	NUMBER_MODE_SUBSCRIPT
} NumberMode;


static gpointer math_buttons_parent_class = NULL;

GType button_mode_get_type (void) G_GNUC_CONST;
GType math_buttons_get_type (void) G_GNUC_CONST;
GType math_equation_get_type (void) G_GNUC_CONST;
GType math_converter_get_type (void) G_GNUC_CONST;
#define MATH_BUTTONS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MATH_BUTTONS, MathButtonsPrivate))
enum  {
	MATH_BUTTONS_DUMMY_PROPERTY,
	MATH_BUTTONS_MODE,
	MATH_BUTTONS_PROGRAMMING_BASE
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
MathButtons* math_buttons_new (MathEquation* equation);
MathButtons* math_buttons_construct (GType object_type, MathEquation* equation);
static void math_buttons_load_buttons (MathButtons* self);
static void _math_buttons_load_buttons_gtk_widget_show (GtkWidget* _sender, gpointer self);
static void __lambda29_ (MathButtons* self, GParamSpec* pspec);
static void math_buttons_update_bit_panel (MathButtons* self);
static void ___lambda29__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda30_ (MathButtons* self, GParamSpec* pspec);
static void math_buttons_number_mode_changed_cb (MathButtons* self);
static void ___lambda30__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda31_ (MathButtons* self, GParamSpec* pspec);
static void ___lambda31__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda32_ (MathButtons* self, GParamSpec* pspec);
static void ___lambda32__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void math_buttons_load_finc_dialogs (MathButtons* self);
GType financial_dialog_get_type (void) G_GNUC_CONST;
static void math_buttons_load_finc_dialog (MathButtons* self, const gchar* name, gchar** entry_names, int entry_names_length1, FinancialDialog function);
static void math_buttons_finc_response_cb (MathButtons* self, GtkWidget* widget, gint response_id);
static void _math_buttons_finc_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void math_buttons_finc_activate_cb (MathButtons* self, GtkWidget* widget);
static void _math_buttons_finc_activate_cb_gtk_entry_activate (GtkEntry* _sender, gpointer self);
gpointer number_ref (gpointer instance);
void number_unref (gpointer instance);
GParamSpec* param_spec_number (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_number (GValue* value, gpointer v_object);
void value_take_number (GValue* value, gpointer v_object);
gpointer value_get_number (const GValue* value);
GType number_get_type (void) G_GNUC_CONST;
Number* math_equation_get_number (MathEquation* self);
Number* number_new_unsigned_integer (guint64 x);
Number* number_construct_unsigned_integer (GType object_type, guint64 x);
Number* number_fractional_part (Number* self);
gboolean number_is_negative (Number* self);
gint number_compare (Number* self, Number* y);
gboolean number_is_zero (Number* self);
guint64 number_to_unsigned_integer (Number* self);
gint math_equation_get_number_base (MathEquation* self);
static void math_buttons_base_combobox_changed_cb (MathButtons* self, GtkComboBox* combo);
void math_buttons_set_programming_base (MathButtons* self, gint value);
static void math_buttons_base_changed_cb (MathButtons* self);
ButtonMode math_buttons_get_mode (MathButtons* self);
gint math_buttons_get_programming_base (MathButtons* self);
static GtkWidget* math_buttons_load_mode (MathButtons* self, ButtonMode mode);
static void math_buttons_setup_button (MathButtons* self, GtkBuilder* builder, const gchar* name, const gchar* data, const gchar* tooltip, gboolean connect);
gunichar math_equation_get_digit_text (MathEquation* self, guint digit);
static void ______lambda15_ (MathButtons* self, GtkButton* widget);
void math_equation_insert_digit (MathEquation* self, guint digit);
static void _______lambda15__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda16_ (MathButtons* self);
void math_equation_insert_subtract (MathEquation* self);
static void ____lambda16__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda17_ (MathButtons* self);
void math_equation_insert_square (MathEquation* self);
static void ____lambda17__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda18_ (MathButtons* self);
void math_equation_undo (MathEquation* self);
static void ____lambda18__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda19_ (MathButtons* self);
void math_equation_solve (MathEquation* self);
static void ____lambda19__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda20_ (MathButtons* self);
void math_equation_clear (MathEquation* self);
static void ____lambda20__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_memory_cb (MathButtons* self, GtkWidget* widget);
static void _math_buttons_memory_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_function_cb (MathButtons* self, GtkButton* button);
static void _math_buttons_function_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda23_ (MathButtons* self);
void math_equation_factorize (MathEquation* self);
static void ____lambda23__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ___lambda24_ (MathButtons* self);
void math_equation_insert_exponent (MathEquation* self);
static void ____lambda24__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_shift_left_cb (MathButtons* self, GtkButton* button);
static void _math_buttons_shift_left_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_shift_right_cb (MathButtons* self, GtkButton* button);
static void _math_buttons_shift_right_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_insert_character_code_cb (MathButtons* self, GtkWidget* widget);
static void _math_buttons_insert_character_code_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
GType serializer_get_type (void) G_GNUC_CONST;
Serializer* math_equation_get_serializer (MathEquation* self);
gunichar serializer_get_radix (Serializer* self);
static void ___lambda27_ (MathButtons* self);
void math_equation_insert_numeric_point (MathEquation* self);
static void ____lambda27__gtk_button_clicked (GtkButton* _sender, gpointer self);
GType number_mode_get_type (void) G_GNUC_CONST;
NumberMode math_equation_get_number_mode (MathEquation* self);
static void math_buttons_set_superscript_cb (MathButtons* self, GtkButton* widget);
static void _math_buttons_set_superscript_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_set_subscript_cb (MathButtons* self, GtkButton* widget);
static void _math_buttons_set_subscript_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_character_code_dialog_response_cb (MathButtons* self, GtkWidget* dialog, gint response_id);
static void _math_buttons_character_code_dialog_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static gboolean math_buttons_character_code_dialog_delete_cb (MathButtons* self, GtkWidget* dialog, GdkEventAny* event);
static gboolean _math_buttons_character_code_dialog_delete_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void math_buttons_character_code_dialog_activate_cb (MathButtons* self, GtkWidget* entry);
static void _math_buttons_character_code_dialog_activate_cb_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static gboolean math_buttons_bit_toggle_cb (MathButtons* self, GtkWidget* event_box, GdkEventButton* event);
static gboolean _math_buttons_bit_toggle_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void _math_buttons_base_combobox_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void ___lambda28_ (MathButtons* self, GParamSpec* pspec);
static void ____lambda28__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void math_buttons_finc_cb (MathButtons* self, GtkWidget* widget);
static void _math_buttons_finc_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void ____lambda14_ (MathButtons* self, GtkButton* widget);
void math_equation_insert (MathEquation* self, const gchar* text);
static void _____lambda14__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void math_buttons_converter_changed_cb (MathButtons* self);
GType unit_get_type (void) G_GNUC_CONST;
void math_converter_get_conversion (MathConverter* self, Unit** from_unit, Unit** to_unit);
gchar* unit_get_name (Unit* self);
void math_equation_set_source_currency (MathEquation* self, const gchar* value);
void math_equation_set_target_currency (MathEquation* self, const gchar* value);
void math_equation_set_source_units (MathEquation* self, const gchar* value);
void math_equation_set_target_units (MathEquation* self, const gchar* value);
MathConverter* math_converter_new (MathEquation* equation);
MathConverter* math_converter_construct (GType object_type, MathEquation* equation);
static void _math_buttons_converter_changed_cb_math_converter_changed (MathConverter* _sender, gpointer self);
static void math_buttons_popup_button_menu (MathButtons* self, GtkButton* button, GtkMenu* menu);
static void math_buttons_button_menu_position_func (MathButtons* self, GtkMenu* menu, gint* x, gint* y, gboolean* push_in);
static void _math_buttons_button_menu_position_func_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self);
GType math_variable_popup_get_type (void) G_GNUC_CONST;
MathVariablePopup* math_variable_popup_new (MathEquation* equation);
MathVariablePopup* math_variable_popup_construct (GType object_type, MathEquation* equation);
static void ______lambda25_ (MathButtons* self, GtkMenuItem* widget);
void math_equation_shift (MathEquation* self, gint count);
static void _______lambda25__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void ______lambda26_ (MathButtons* self, GtkMenuItem* widget);
static void _______lambda26__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void math_buttons_add_function_menu_item (MathButtons* self, GtkMenu* menu, const gchar* label, const gchar* function);
static void __lambda22_ (MathButtons* self, GtkMenuItem* widget);
static void ___lambda22__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static gchar** _vala_array_dup1 (gchar** self, int length);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gchar** _vala_array_dup3 (gchar** self, int length);
static gchar** _vala_array_dup4 (gchar** self, int length);
static gchar** _vala_array_dup5 (gchar** self, int length);
static gchar** _vala_array_dup6 (gchar** self, int length);
static gchar** _vala_array_dup7 (gchar** self, int length);
static gchar** _vala_array_dup8 (gchar** self, int length);
static gchar** _vala_array_dup9 (gchar** self, int length);
static gchar** _vala_array_dup10 (gchar** self, int length);
Number* number_new_integer (gint64 value);
Number* number_construct_integer (GType object_type, gint64 value);
Number* mp_set_from_string (const gchar* str, gint default_base);
void do_finc_expression (MathEquation* equation, FinancialDialog function, Number* arg1, Number* arg2, Number* arg3, Number* arg4);
Number* number_add (Number* self, Number* y);
Number* number_shift (Number* self, gint count);
void math_equation_insert_number (MathEquation* self, Number* x);
void math_equation_toggle_bit (MathEquation* self, guint bit);
static void math_buttons_remove_trailing_spaces (MathButtons* self);
void math_equation_set_number_mode (MathEquation* self, NumberMode value);
void math_buttons_set_mode (MathButtons* self, ButtonMode value);
void math_equation_set_number_base (MathEquation* self, gint value);
void math_converter_set_category (MathConverter* self, const gchar* category);
void math_converter_set_conversion (MathConverter* self, const gchar* unit_a, const gchar* unit_b);
gchar* math_equation_get_source_units (MathEquation* self);
gchar* math_equation_get_target_units (MathEquation* self);
gchar* math_equation_get_source_currency (MathEquation* self);
gchar* math_equation_get_target_currency (MathEquation* self);
static void math_buttons_finalize (GObject* obj);
static void _vala_math_buttons_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_math_buttons_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const gchar* MATH_BUTTONS_ctrm_entries[3] = {"ctrm_pint", "ctrm_fv", "ctrm_pv"};
static const gchar* MATH_BUTTONS_ddb_entries[3] = {"ddb_cost", "ddb_life", "ddb_period"};
static const gchar* MATH_BUTTONS_fv_entries[3] = {"fv_pmt", "fv_pint", "fv_n"};
static const gchar* MATH_BUTTONS_gpm_entries[2] = {"gpm_cost", "gpm_margin"};
static const gchar* MATH_BUTTONS_pmt_entries[3] = {"pmt_prin", "pmt_pint", "pmt_n"};
static const gchar* MATH_BUTTONS_pv_entries[3] = {"pv_pmt", "pv_pint", "pv_n"};
static const gchar* MATH_BUTTONS_rate_entries[3] = {"rate_fv", "rate_pv", "rate_n"};
static const gchar* MATH_BUTTONS_sln_entries[3] = {"sln_cost", "sln_salvage", "sln_life"};
static const gchar* MATH_BUTTONS_syd_entries[3] = {"syd_cost", "syd_salvage", "syd_life"};
static const gchar* MATH_BUTTONS_term_entries[3] = {"term_pmt", "term_fv", "term_pint"};

GType button_mode_get_type (void) {
	static volatile gsize button_mode_type_id__volatile = 0;
	if (g_once_init_enter (&button_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{BUTTON_MODE_BASIC, "BUTTON_MODE_BASIC", "basic"}, {BUTTON_MODE_ADVANCED, "BUTTON_MODE_ADVANCED", "advanced"}, {BUTTON_MODE_FINANCIAL, "BUTTON_MODE_FINANCIAL", "financial"}, {BUTTON_MODE_PROGRAMMING, "BUTTON_MODE_PROGRAMMING", "programming"}, {0, NULL, NULL}};
		GType button_mode_type_id;
		button_mode_type_id = g_enum_register_static ("ButtonMode", values);
		g_once_init_leave (&button_mode_type_id__volatile, button_mode_type_id);
	}
	return button_mode_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void _math_buttons_load_buttons_gtk_widget_show (GtkWidget* _sender, gpointer self) {
	math_buttons_load_buttons ((MathButtons*) self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda29_ (MathButtons* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	math_buttons_update_bit_panel (self);
}


static void ___lambda29__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda29_ ((MathButtons*) self, pspec);
}


static void __lambda30_ (MathButtons* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	math_buttons_number_mode_changed_cb (self);
}


static void ___lambda30__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda30_ ((MathButtons*) self, pspec);
}


static void __lambda31_ (MathButtons* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	math_buttons_update_bit_panel (self);
}


static void ___lambda31__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda31_ ((MathButtons*) self, pspec);
}


static void __lambda32_ (MathButtons* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	math_buttons_update_bit_panel (self);
}


static void ___lambda32__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda32_ ((MathButtons*) self, pspec);
}


MathButtons* math_buttons_construct (GType object_type, MathEquation* equation) {
	MathButtons * self = NULL;
	MathEquation* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	MathEquation* _tmp2_ = NULL;
	MathEquation* _tmp3_ = NULL;
	MathEquation* _tmp4_ = NULL;
	MathEquation* _tmp5_ = NULL;
	g_return_val_if_fail (equation != NULL, NULL);
	self = (MathButtons*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, NULL);
	gtk_box_set_spacing ((GtkBox*) self, 6);
	g_signal_connect_object ((GtkWidget*) self, "show", (GCallback) _math_buttons_load_buttons_gtk_widget_show, self, 0);
	_tmp0_ = equation;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->equation);
	self->priv->equation = _tmp1_;
	_tmp2_ = equation;
	g_signal_connect_object ((GObject*) _tmp2_, "notify::display", (GCallback) ___lambda29__g_object_notify, self, 0);
	_tmp3_ = equation;
	g_signal_connect_object ((GObject*) _tmp3_, "notify::number-mode", (GCallback) ___lambda30__g_object_notify, self, 0);
	_tmp4_ = equation;
	g_signal_connect_object ((GObject*) _tmp4_, "notify::angle-units", (GCallback) ___lambda31__g_object_notify, self, 0);
	_tmp5_ = equation;
	g_signal_connect_object ((GObject*) _tmp5_, "notify::number-format", (GCallback) ___lambda32__g_object_notify, self, 0);
	math_buttons_number_mode_changed_cb (self);
	math_buttons_update_bit_panel (self);
	return self;
}


MathButtons* math_buttons_new (MathEquation* equation) {
	return math_buttons_construct (TYPE_MATH_BUTTONS, equation);
}


static void math_buttons_load_finc_dialogs (MathButtons* self) {
	g_return_if_fail (self != NULL);
	math_buttons_load_finc_dialog (self, "ctrm_dialog", MATH_BUTTONS_ctrm_entries, G_N_ELEMENTS (MATH_BUTTONS_ctrm_entries), FINANCIAL_DIALOG_CTRM_DIALOG);
	math_buttons_load_finc_dialog (self, "ddb_dialog", MATH_BUTTONS_ddb_entries, G_N_ELEMENTS (MATH_BUTTONS_ddb_entries), FINANCIAL_DIALOG_DDB_DIALOG);
	math_buttons_load_finc_dialog (self, "fv_dialog", MATH_BUTTONS_fv_entries, G_N_ELEMENTS (MATH_BUTTONS_fv_entries), FINANCIAL_DIALOG_FV_DIALOG);
	math_buttons_load_finc_dialog (self, "gpm_dialog", MATH_BUTTONS_gpm_entries, G_N_ELEMENTS (MATH_BUTTONS_gpm_entries), FINANCIAL_DIALOG_GPM_DIALOG);
	math_buttons_load_finc_dialog (self, "pmt_dialog", MATH_BUTTONS_pmt_entries, G_N_ELEMENTS (MATH_BUTTONS_pmt_entries), FINANCIAL_DIALOG_PMT_DIALOG);
	math_buttons_load_finc_dialog (self, "pv_dialog", MATH_BUTTONS_pv_entries, G_N_ELEMENTS (MATH_BUTTONS_pv_entries), FINANCIAL_DIALOG_PV_DIALOG);
	math_buttons_load_finc_dialog (self, "rate_dialog", MATH_BUTTONS_rate_entries, G_N_ELEMENTS (MATH_BUTTONS_rate_entries), FINANCIAL_DIALOG_RATE_DIALOG);
	math_buttons_load_finc_dialog (self, "sln_dialog", MATH_BUTTONS_sln_entries, G_N_ELEMENTS (MATH_BUTTONS_sln_entries), FINANCIAL_DIALOG_SLN_DIALOG);
	math_buttons_load_finc_dialog (self, "syd_dialog", MATH_BUTTONS_syd_entries, G_N_ELEMENTS (MATH_BUTTONS_syd_entries), FINANCIAL_DIALOG_SYD_DIALOG);
	math_buttons_load_finc_dialog (self, "term_dialog", MATH_BUTTONS_term_entries, G_N_ELEMENTS (MATH_BUTTONS_term_entries), FINANCIAL_DIALOG_TERM_DIALOG);
}


static void _math_buttons_finc_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	math_buttons_finc_response_cb ((MathButtons*) self, _sender, response_id);
}


static void _math_buttons_finc_activate_cb_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	math_buttons_finc_activate_cb ((MathButtons*) self, _sender);
}


static void math_buttons_load_finc_dialog (MathButtons* self, const gchar* name, gchar** entry_names, int entry_names_length1, FinancialDialog function) {
	GtkDialog* dialog = NULL;
	GtkBuilder* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GObject* _tmp2_ = NULL;
	GtkDialog* _tmp3_ = NULL;
	GtkDialog* _tmp4_ = NULL;
	FinancialDialog _tmp5_ = 0;
	GtkDialog* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->financial_ui;
	_tmp1_ = name;
	_tmp2_ = gtk_builder_get_object (_tmp0_, _tmp1_);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GTK_TYPE_DIALOG) ? ((GtkDialog*) _tmp2_) : NULL);
	dialog = _tmp3_;
	_tmp4_ = dialog;
	_tmp5_ = function;
	g_object_set_data_full ((GObject*) _tmp4_, "finc-function", (gpointer) ((gintptr) ((gint) _tmp5_)), NULL);
	_tmp6_ = dialog;
	g_signal_connect_object (_tmp6_, "response", (GCallback) _math_buttons_finc_response_cb_gtk_dialog_response, self, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint _tmp9_ = 0;
				gchar** _tmp10_ = NULL;
				gint _tmp10__length1 = 0;
				GtkEntry* entry = NULL;
				GtkBuilder* _tmp11_ = NULL;
				gchar** _tmp12_ = NULL;
				gint _tmp12__length1 = 0;
				gint _tmp13_ = 0;
				const gchar* _tmp14_ = NULL;
				GObject* _tmp15_ = NULL;
				GtkEntry* _tmp16_ = NULL;
				gint _tmp17_ = 0;
				GtkEntry* _tmp25_ = NULL;
				if (!_tmp7_) {
					gint _tmp8_ = 0;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = i;
				_tmp10_ = entry_names;
				_tmp10__length1 = entry_names_length1;
				if (!(_tmp9_ < _tmp10__length1)) {
					break;
				}
				_tmp11_ = self->priv->financial_ui;
				_tmp12_ = entry_names;
				_tmp12__length1 = entry_names_length1;
				_tmp13_ = i;
				_tmp14_ = _tmp12_[_tmp13_];
				_tmp15_ = gtk_builder_get_object (_tmp11_, _tmp14_);
				_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, GTK_TYPE_ENTRY) ? ((GtkEntry*) _tmp15_) : NULL);
				entry = _tmp16_;
				_tmp17_ = i;
				if (_tmp17_ != (G_N_ELEMENTS (MATH_BUTTONS_ctrm_entries) - 1)) {
					GtkEntry* _tmp18_ = NULL;
					GtkBuilder* _tmp19_ = NULL;
					gchar** _tmp20_ = NULL;
					gint _tmp20__length1 = 0;
					gint _tmp21_ = 0;
					const gchar* _tmp22_ = NULL;
					GObject* _tmp23_ = NULL;
					GtkEntry* _tmp24_ = NULL;
					_tmp18_ = entry;
					_tmp19_ = self->priv->financial_ui;
					_tmp20_ = entry_names;
					_tmp20__length1 = entry_names_length1;
					_tmp21_ = i;
					_tmp22_ = _tmp20_[_tmp21_ + 1];
					_tmp23_ = gtk_builder_get_object (_tmp19_, _tmp22_);
					_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, GTK_TYPE_ENTRY) ? ((GtkEntry*) _tmp23_) : NULL);
					g_object_set_data_full ((GObject*) _tmp18_, "next-entry", _tmp24_, g_object_unref);
				}
				_tmp25_ = entry;
				g_signal_connect_object (_tmp25_, "activate", (GCallback) _math_buttons_finc_activate_cb_gtk_entry_activate, self, 0);
				_g_object_unref0 (entry);
			}
		}
	}
	_g_object_unref0 (dialog);
}


static void math_buttons_update_bit_panel (MathButtons* self) {
	GtkWidget* _tmp0_ = NULL;
	Number* x = NULL;
	MathEquation* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	guint64 bits = 0ULL;
	gboolean enabled = FALSE;
	Number* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GtkWidget* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	GtkLabel* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gint i = 0;
	GList* _tmp26_ = NULL;
	gint number_base = 0;
	MathEquation* _tmp35_ = NULL;
	gint _tmp36_ = 0;
	gint _tmp37_ = 0;
	gchar* label = NULL;
	gchar* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	gint _tmp45_ = 0;
	gint _tmp54_ = 0;
	GtkLabel* _tmp63_ = NULL;
	const gchar* _tmp64_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bit_panel;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->equation;
	_tmp2_ = math_equation_get_number (_tmp1_);
	_tmp3_ = _tmp2_;
	x = _tmp3_;
	bits = (guint64) 0;
	_tmp4_ = x;
	enabled = _tmp4_ != NULL;
	_tmp5_ = enabled;
	if (_tmp5_) {
		Number* max = NULL;
		guint64 _tmp6_ = 0ULL;
		Number* _tmp7_ = NULL;
		Number* fraction = NULL;
		Number* _tmp8_ = NULL;
		Number* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		Number* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		_tmp6_ = G_MAXUINT64;
		_tmp7_ = number_new_unsigned_integer (_tmp6_);
		max = _tmp7_;
		_tmp8_ = x;
		_tmp9_ = number_fractional_part (_tmp8_);
		fraction = _tmp9_;
		_tmp12_ = x;
		_tmp13_ = number_is_negative (_tmp12_);
		if (_tmp13_) {
			_tmp11_ = TRUE;
		} else {
			Number* _tmp14_ = NULL;
			Number* _tmp15_ = NULL;
			gint _tmp16_ = 0;
			_tmp14_ = x;
			_tmp15_ = max;
			_tmp16_ = number_compare (_tmp14_, _tmp15_);
			_tmp11_ = _tmp16_ > 0;
		}
		if (_tmp11_) {
			_tmp10_ = TRUE;
		} else {
			Number* _tmp17_ = NULL;
			gboolean _tmp18_ = FALSE;
			_tmp17_ = fraction;
			_tmp18_ = number_is_zero (_tmp17_);
			_tmp10_ = !_tmp18_;
		}
		if (_tmp10_) {
			enabled = FALSE;
		} else {
			Number* _tmp19_ = NULL;
			guint64 _tmp20_ = 0ULL;
			_tmp19_ = x;
			_tmp20_ = number_to_unsigned_integer (_tmp19_);
			bits = _tmp20_;
		}
		_number_unref0 (fraction);
		_number_unref0 (max);
	}
	_tmp21_ = self->priv->bit_panel;
	_tmp22_ = enabled;
	gtk_widget_set_sensitive (_tmp21_, _tmp22_);
	_tmp23_ = self->priv->base_label;
	_tmp24_ = enabled;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp23_, _tmp24_);
	_tmp25_ = enabled;
	if (!_tmp25_) {
		_number_unref0 (x);
		return;
	}
	i = 0;
	_tmp26_ = self->priv->bit_labels;
	{
		GList* label_collection = NULL;
		GList* label_it = NULL;
		label_collection = _tmp26_;
		for (label_it = label_collection; label_it != NULL; label_it = label_it->next) {
			GtkLabel* _tmp27_ = NULL;
			GtkLabel* label = NULL;
			_tmp27_ = _g_object_ref0 ((GtkLabel*) label_it->data);
			label = _tmp27_;
			{
				gchar* text = NULL;
				gchar* _tmp28_ = NULL;
				guint64 _tmp29_ = 0ULL;
				gint _tmp30_ = 0;
				GtkLabel* _tmp32_ = NULL;
				const gchar* _tmp33_ = NULL;
				gint _tmp34_ = 0;
				_tmp28_ = g_strdup (" 0");
				text = _tmp28_;
				_tmp29_ = bits;
				_tmp30_ = i;
				if ((_tmp29_ & (1LL << _tmp30_)) != ((guint64) 0)) {
					gchar* _tmp31_ = NULL;
					_tmp31_ = g_strdup (" 1");
					_g_free0 (text);
					text = _tmp31_;
				}
				_tmp32_ = label;
				_tmp33_ = text;
				gtk_label_set_text (_tmp32_, _tmp33_);
				_tmp34_ = i;
				i = _tmp34_ + 1;
				_g_free0 (text);
				_g_object_unref0 (label);
			}
		}
	}
	_tmp35_ = self->priv->equation;
	_tmp36_ = math_equation_get_number_base (_tmp35_);
	_tmp37_ = _tmp36_;
	number_base = _tmp37_;
	_tmp38_ = g_strdup ("");
	label = _tmp38_;
	_tmp39_ = number_base;
	if (_tmp39_ != 8) {
		const gchar* _tmp40_ = NULL;
		guint64 _tmp41_ = 0ULL;
		gchar* _tmp42_ = NULL;
		gchar* _tmp43_ = NULL;
		gchar* _tmp44_ = NULL;
		_tmp40_ = label;
		_tmp41_ = bits;
		_tmp42_ = g_strdup_printf ("%llo₈", _tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = g_strconcat (_tmp40_, _tmp43_, NULL);
		_g_free0 (label);
		label = _tmp44_;
		_g_free0 (_tmp43_);
	}
	_tmp45_ = number_base;
	if (_tmp45_ != 10) {
		const gchar* _tmp46_ = NULL;
		const gchar* _tmp49_ = NULL;
		guint64 _tmp50_ = 0ULL;
		gchar* _tmp51_ = NULL;
		gchar* _tmp52_ = NULL;
		gchar* _tmp53_ = NULL;
		_tmp46_ = label;
		if (g_strcmp0 (_tmp46_, "") != 0) {
			const gchar* _tmp47_ = NULL;
			gchar* _tmp48_ = NULL;
			_tmp47_ = label;
			_tmp48_ = g_strconcat (_tmp47_, " = ", NULL);
			_g_free0 (label);
			label = _tmp48_;
		}
		_tmp49_ = label;
		_tmp50_ = bits;
		_tmp51_ = g_strdup_printf ("%llu₁₀", _tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = g_strconcat (_tmp49_, _tmp52_, NULL);
		_g_free0 (label);
		label = _tmp53_;
		_g_free0 (_tmp52_);
	}
	_tmp54_ = number_base;
	if (_tmp54_ != 16) {
		const gchar* _tmp55_ = NULL;
		const gchar* _tmp58_ = NULL;
		guint64 _tmp59_ = 0ULL;
		gchar* _tmp60_ = NULL;
		gchar* _tmp61_ = NULL;
		gchar* _tmp62_ = NULL;
		_tmp55_ = label;
		if (g_strcmp0 (_tmp55_, "") != 0) {
			const gchar* _tmp56_ = NULL;
			gchar* _tmp57_ = NULL;
			_tmp56_ = label;
			_tmp57_ = g_strconcat (_tmp56_, " = ", NULL);
			_g_free0 (label);
			label = _tmp57_;
		}
		_tmp58_ = label;
		_tmp59_ = bits;
		_tmp60_ = g_strdup_printf ("%llX₁₆", _tmp59_);
		_tmp61_ = _tmp60_;
		_tmp62_ = g_strconcat (_tmp58_, _tmp61_, NULL);
		_g_free0 (label);
		label = _tmp62_;
		_g_free0 (_tmp61_);
	}
	_tmp63_ = self->priv->base_label;
	_tmp64_ = label;
	gtk_label_set_text (_tmp63_, _tmp64_);
	_g_free0 (label);
	_number_unref0 (x);
}


static void math_buttons_base_combobox_changed_cb (MathButtons* self, GtkComboBox* combo) {
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
	gint value = 0;
	GtkTreeIter _tmp5_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	model = _tmp2_;
	_tmp3_ = combo;
	gtk_combo_box_get_active_iter (_tmp3_, &_tmp4_);
	iter = _tmp4_;
	_tmp5_ = iter;
	gtk_tree_model_get (model, &_tmp5_, 1, &value, -1, -1);
	math_buttons_set_programming_base (self, value);
	_g_object_unref0 (model);
}


static void math_buttons_base_changed_cb (MathButtons* self) {
	ButtonMode _tmp0_ = 0;
	ButtonMode _tmp1_ = 0;
	MathEquation* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp5_ = NULL;
	GtkTreeModel* _tmp6_ = NULL;
	GtkTreeModel* _tmp7_ = NULL;
	GtkTreeIter iter = {0};
	gboolean valid = FALSE;
	GtkTreeModel* _tmp8_ = NULL;
	GtkTreeIter _tmp9_ = {0};
	gboolean _tmp10_ = FALSE;
	gboolean _tmp19_ = FALSE;
	GtkComboBox* _tmp23_ = NULL;
	GtkTreeIter _tmp24_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = math_buttons_get_mode (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != BUTTON_MODE_PROGRAMMING) {
		return;
	}
	_tmp2_ = self->priv->equation;
	_tmp3_ = math_equation_get_number_base (_tmp2_);
	_tmp4_ = _tmp3_;
	self->priv->_programming_base = _tmp4_;
	_tmp5_ = self->priv->base_combo;
	_tmp6_ = gtk_combo_box_get_model (_tmp5_);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	model = _tmp7_;
	_tmp8_ = model;
	_tmp10_ = gtk_tree_model_get_iter_first (_tmp8_, &_tmp9_);
	iter = _tmp9_;
	valid = _tmp10_;
	while (TRUE) {
		gboolean _tmp11_ = FALSE;
		gint v = 0;
		GtkTreeModel* _tmp12_ = NULL;
		GtkTreeIter _tmp13_ = {0};
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		GtkTreeModel* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
		_tmp11_ = valid;
		if (!_tmp11_) {
			break;
		}
		_tmp12_ = model;
		_tmp13_ = iter;
		gtk_tree_model_get (_tmp12_, &_tmp13_, 1, &v, -1, -1);
		_tmp14_ = v;
		_tmp15_ = math_buttons_get_programming_base (self);
		_tmp16_ = _tmp15_;
		if (_tmp14_ == _tmp16_) {
			break;
		}
		_tmp17_ = model;
		_tmp18_ = gtk_tree_model_iter_next (_tmp17_, &iter);
		valid = _tmp18_;
	}
	_tmp19_ = valid;
	if (!_tmp19_) {
		GtkTreeModel* _tmp20_ = NULL;
		GtkTreeIter _tmp21_ = {0};
		gboolean _tmp22_ = FALSE;
		_tmp20_ = model;
		_tmp22_ = gtk_tree_model_get_iter_first (_tmp20_, &_tmp21_);
		iter = _tmp21_;
		valid = _tmp22_;
	}
	_tmp23_ = self->priv->base_combo;
	_tmp24_ = iter;
	gtk_combo_box_set_active_iter (_tmp23_, &_tmp24_);
	_g_object_unref0 (model);
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


static void ______lambda15_ (MathButtons* self, GtkButton* widget) {
	MathEquation* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = widget;
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "calc_digit");
	math_equation_insert_digit (_tmp0_, (guint) ((gint) ((gintptr) _tmp2_)));
}


static void _______lambda15__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	______lambda15_ ((MathButtons*) self, _sender);
}


static void ___lambda16_ (MathButtons* self) {
	MathEquation* _tmp0_ = NULL;
	_tmp0_ = self->priv->equation;
	math_equation_insert_subtract (_tmp0_);
}


static void ____lambda16__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda16_ ((MathButtons*) self);
}


static void ___lambda17_ (MathButtons* self) {
	MathEquation* _tmp0_ = NULL;
	_tmp0_ = self->priv->equation;
	math_equation_insert_square (_tmp0_);
}


static void ____lambda17__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda17_ ((MathButtons*) self);
}


static void ___lambda18_ (MathButtons* self) {
	MathEquation* _tmp0_ = NULL;
	_tmp0_ = self->priv->equation;
	math_equation_undo (_tmp0_);
}


static void ____lambda18__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda18_ ((MathButtons*) self);
}


static void ___lambda19_ (MathButtons* self) {
	MathEquation* _tmp0_ = NULL;
	_tmp0_ = self->priv->equation;
	math_equation_solve (_tmp0_);
}


static void ____lambda19__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda19_ ((MathButtons*) self);
}


static void ___lambda20_ (MathButtons* self) {
	MathEquation* _tmp0_ = NULL;
	_tmp0_ = self->priv->equation;
	math_equation_clear (_tmp0_);
}


static void ____lambda20__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda20_ ((MathButtons*) self);
}


static void _math_buttons_memory_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	math_buttons_memory_cb ((MathButtons*) self, _sender);
}


static void _math_buttons_function_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	math_buttons_function_cb ((MathButtons*) self, _sender);
}


static void ___lambda23_ (MathButtons* self) {
	MathEquation* _tmp0_ = NULL;
	_tmp0_ = self->priv->equation;
	math_equation_factorize (_tmp0_);
}


static void ____lambda23__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda23_ ((MathButtons*) self);
}


static void ___lambda24_ (MathButtons* self) {
	MathEquation* _tmp0_ = NULL;
	_tmp0_ = self->priv->equation;
	math_equation_insert_exponent (_tmp0_);
}


static void ____lambda24__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda24_ ((MathButtons*) self);
}


static void _math_buttons_shift_left_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	math_buttons_shift_left_cb ((MathButtons*) self, _sender);
}


static void _math_buttons_shift_right_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	math_buttons_shift_right_cb ((MathButtons*) self, _sender);
}


static void _math_buttons_insert_character_code_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	math_buttons_insert_character_code_cb ((MathButtons*) self, _sender);
}


static void ___lambda27_ (MathButtons* self) {
	MathEquation* _tmp0_ = NULL;
	_tmp0_ = self->priv->equation;
	math_equation_insert_numeric_point (_tmp0_);
}


static void ____lambda27__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda27_ ((MathButtons*) self);
}


static void _math_buttons_set_superscript_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	math_buttons_set_superscript_cb ((MathButtons*) self, _sender);
}


static void _math_buttons_set_subscript_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	math_buttons_set_subscript_cb ((MathButtons*) self, _sender);
}


static void _math_buttons_character_code_dialog_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	math_buttons_character_code_dialog_response_cb ((MathButtons*) self, _sender, response_id);
}


static gboolean _math_buttons_character_code_dialog_delete_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = math_buttons_character_code_dialog_delete_cb ((MathButtons*) self, _sender, event);
	return result;
}


static void _math_buttons_character_code_dialog_activate_cb_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	math_buttons_character_code_dialog_activate_cb ((MathButtons*) self, _sender);
}


static gboolean _math_buttons_bit_toggle_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = math_buttons_bit_toggle_cb ((MathButtons*) self, _sender, event);
	return result;
}


static void _math_buttons_base_combobox_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	math_buttons_base_combobox_changed_cb ((MathButtons*) self, _sender);
}


static void ___lambda28_ (MathButtons* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	math_buttons_base_changed_cb (self);
}


static void ____lambda28__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	___lambda28_ ((MathButtons*) self, pspec);
}


static void _math_buttons_finc_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	math_buttons_finc_cb ((MathButtons*) self, _sender);
}


static GtkWidget* math_buttons_load_mode (MathButtons* self, ButtonMode mode) {
	GtkWidget* result = NULL;
	GtkBuilder* builder = NULL;
	gchar* builder_resource = NULL;
	ButtonMode _tmp0_ = 0;
	GtkWidget* panel = NULL;
	GtkBuilder* _tmp34_ = NULL;
	GObject* _tmp35_ = NULL;
	GtkWidget* _tmp36_ = NULL;
	GtkWidget* _tmp37_ = NULL;
	ButtonMode _tmp38_ = 0;
	GtkBuilder* _tmp47_ = NULL;
	const gchar* _tmp48_ = NULL;
	GtkBuilder* _tmp49_ = NULL;
	const gchar* _tmp50_ = NULL;
	GtkBuilder* _tmp51_ = NULL;
	GtkBuilder* _tmp52_ = NULL;
	GtkBuilder* _tmp53_ = NULL;
	const gchar* _tmp54_ = NULL;
	GtkBuilder* _tmp55_ = NULL;
	const gchar* _tmp56_ = NULL;
	GtkBuilder* _tmp57_ = NULL;
	const gchar* _tmp58_ = NULL;
	GtkBuilder* _tmp59_ = NULL;
	const gchar* _tmp60_ = NULL;
	GtkBuilder* _tmp61_ = NULL;
	const gchar* _tmp62_ = NULL;
	GtkBuilder* _tmp63_ = NULL;
	const gchar* _tmp64_ = NULL;
	GtkBuilder* _tmp65_ = NULL;
	const gchar* _tmp66_ = NULL;
	GtkBuilder* _tmp67_ = NULL;
	const gchar* _tmp68_ = NULL;
	GtkBuilder* _tmp69_ = NULL;
	const gchar* _tmp70_ = NULL;
	GtkBuilder* _tmp71_ = NULL;
	const gchar* _tmp72_ = NULL;
	GtkBuilder* _tmp73_ = NULL;
	const gchar* _tmp74_ = NULL;
	GtkBuilder* _tmp75_ = NULL;
	const gchar* _tmp76_ = NULL;
	GtkBuilder* _tmp77_ = NULL;
	const gchar* _tmp78_ = NULL;
	GtkBuilder* _tmp79_ = NULL;
	const gchar* _tmp80_ = NULL;
	GtkBuilder* _tmp81_ = NULL;
	const gchar* _tmp82_ = NULL;
	GtkBuilder* _tmp83_ = NULL;
	const gchar* _tmp84_ = NULL;
	GtkBuilder* _tmp85_ = NULL;
	const gchar* _tmp86_ = NULL;
	GtkBuilder* _tmp87_ = NULL;
	const gchar* _tmp88_ = NULL;
	GtkBuilder* _tmp89_ = NULL;
	const gchar* _tmp90_ = NULL;
	GtkBuilder* _tmp91_ = NULL;
	const gchar* _tmp92_ = NULL;
	GtkBuilder* _tmp93_ = NULL;
	const gchar* _tmp94_ = NULL;
	GtkBuilder* _tmp95_ = NULL;
	const gchar* _tmp96_ = NULL;
	GtkBuilder* _tmp97_ = NULL;
	const gchar* _tmp98_ = NULL;
	GtkBuilder* _tmp99_ = NULL;
	const gchar* _tmp100_ = NULL;
	GtkBuilder* _tmp101_ = NULL;
	const gchar* _tmp102_ = NULL;
	GtkBuilder* _tmp103_ = NULL;
	const gchar* _tmp104_ = NULL;
	GtkBuilder* _tmp105_ = NULL;
	const gchar* _tmp106_ = NULL;
	GtkBuilder* _tmp107_ = NULL;
	const gchar* _tmp108_ = NULL;
	GtkBuilder* _tmp109_ = NULL;
	const gchar* _tmp110_ = NULL;
	GtkBuilder* _tmp111_ = NULL;
	const gchar* _tmp112_ = NULL;
	GtkBuilder* _tmp113_ = NULL;
	const gchar* _tmp114_ = NULL;
	GtkBuilder* _tmp115_ = NULL;
	const gchar* _tmp116_ = NULL;
	GtkBuilder* _tmp117_ = NULL;
	const gchar* _tmp118_ = NULL;
	GtkBuilder* _tmp119_ = NULL;
	const gchar* _tmp120_ = NULL;
	GtkBuilder* _tmp121_ = NULL;
	const gchar* _tmp122_ = NULL;
	GtkBuilder* _tmp123_ = NULL;
	const gchar* _tmp124_ = NULL;
	GtkBuilder* _tmp125_ = NULL;
	const gchar* _tmp126_ = NULL;
	GtkBuilder* _tmp127_ = NULL;
	const gchar* _tmp128_ = NULL;
	GtkBuilder* _tmp129_ = NULL;
	const gchar* _tmp130_ = NULL;
	GtkBuilder* _tmp131_ = NULL;
	const gchar* _tmp132_ = NULL;
	GtkBuilder* _tmp133_ = NULL;
	const gchar* _tmp134_ = NULL;
	GtkBuilder* _tmp135_ = NULL;
	const gchar* _tmp136_ = NULL;
	GtkBuilder* _tmp137_ = NULL;
	const gchar* _tmp138_ = NULL;
	GtkBuilder* _tmp139_ = NULL;
	const gchar* _tmp140_ = NULL;
	GtkBuilder* _tmp141_ = NULL;
	const gchar* _tmp142_ = NULL;
	GtkBuilder* _tmp143_ = NULL;
	const gchar* _tmp144_ = NULL;
	GtkBuilder* _tmp145_ = NULL;
	const gchar* _tmp146_ = NULL;
	GtkBuilder* _tmp147_ = NULL;
	const gchar* _tmp148_ = NULL;
	GtkBuilder* _tmp149_ = NULL;
	const gchar* _tmp150_ = NULL;
	GtkBuilder* _tmp151_ = NULL;
	const gchar* _tmp152_ = NULL;
	GtkBuilder* _tmp153_ = NULL;
	const gchar* _tmp154_ = NULL;
	GtkBuilder* _tmp155_ = NULL;
	const gchar* _tmp156_ = NULL;
	GtkBuilder* _tmp157_ = NULL;
	const gchar* _tmp158_ = NULL;
	GtkBuilder* _tmp159_ = NULL;
	const gchar* _tmp160_ = NULL;
	GtkBuilder* _tmp161_ = NULL;
	const gchar* _tmp162_ = NULL;
	GtkBuilder* _tmp163_ = NULL;
	const gchar* _tmp164_ = NULL;
	GtkBuilder* _tmp165_ = NULL;
	const gchar* _tmp166_ = NULL;
	GtkButton* button = NULL;
	GtkBuilder* _tmp186_ = NULL;
	GObject* _tmp187_ = NULL;
	GtkButton* _tmp188_ = NULL;
	GtkButton* _tmp189_ = NULL;
	GtkBuilder* _tmp191_ = NULL;
	GObject* _tmp192_ = NULL;
	GtkButton* _tmp193_ = NULL;
	GtkButton* _tmp194_ = NULL;
	GtkBuilder* _tmp198_ = NULL;
	GObject* _tmp199_ = NULL;
	GtkButton* _tmp200_ = NULL;
	GtkButton* _tmp201_ = NULL;
	GtkBuilder* _tmp203_ = NULL;
	GObject* _tmp204_ = NULL;
	GtkButton* _tmp205_ = NULL;
	GtkButton* _tmp206_ = NULL;
	GtkBuilder* _tmp208_ = NULL;
	GObject* _tmp209_ = NULL;
	GtkButton* _tmp210_ = NULL;
	GtkButton* _tmp211_ = NULL;
	GtkBuilder* _tmp213_ = NULL;
	GObject* _tmp214_ = NULL;
	GtkButton* _tmp215_ = NULL;
	GtkButton* _tmp216_ = NULL;
	GtkBuilder* _tmp218_ = NULL;
	GObject* _tmp219_ = NULL;
	GtkButton* _tmp220_ = NULL;
	GtkButton* _tmp221_ = NULL;
	GtkBuilder* _tmp223_ = NULL;
	GObject* _tmp224_ = NULL;
	GtkButton* _tmp225_ = NULL;
	GtkButton* _tmp226_ = NULL;
	GtkBuilder* _tmp228_ = NULL;
	GObject* _tmp229_ = NULL;
	GtkButton* _tmp230_ = NULL;
	GtkButton* _tmp231_ = NULL;
	GtkBuilder* _tmp233_ = NULL;
	GObject* _tmp234_ = NULL;
	GtkButton* _tmp235_ = NULL;
	GtkButton* _tmp236_ = NULL;
	GtkBuilder* _tmp238_ = NULL;
	GObject* _tmp239_ = NULL;
	GtkButton* _tmp240_ = NULL;
	GtkButton* _tmp241_ = NULL;
	GtkBuilder* _tmp243_ = NULL;
	GObject* _tmp244_ = NULL;
	GtkButton* _tmp245_ = NULL;
	GtkButton* _tmp246_ = NULL;
	GtkBuilder* _tmp248_ = NULL;
	GObject* _tmp249_ = NULL;
	GtkButton* _tmp250_ = NULL;
	GtkButton* _tmp251_ = NULL;
	GtkToggleButton* toggle_button = NULL;
	GtkBuilder* _tmp260_ = NULL;
	GObject* _tmp261_ = NULL;
	GtkToggleButton* _tmp262_ = NULL;
	GtkToggleButton* _tmp263_ = NULL;
	GtkBuilder* _tmp271_ = NULL;
	GObject* _tmp272_ = NULL;
	GtkToggleButton* _tmp273_ = NULL;
	GtkToggleButton* _tmp274_ = NULL;
	ButtonMode _tmp282_ = 0;
	ButtonMode _tmp350_ = 0;
	GtkBuilder* _tmp421_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = mode;
	switch (_tmp0_) {
		default:
		case BUTTON_MODE_BASIC:
		{
			GtkWidget* _tmp1_ = NULL;
			GtkBuilder* _tmp4_ = NULL;
			GtkBuilder* _tmp5_ = NULL;
			GtkBuilder* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			_tmp1_ = self->priv->bas_panel;
			if (_tmp1_ != NULL) {
				GtkWidget* _tmp2_ = NULL;
				GtkWidget* _tmp3_ = NULL;
				_tmp2_ = self->priv->bas_panel;
				_tmp3_ = _g_object_ref0 (_tmp2_);
				result = _tmp3_;
				_g_free0 (builder_resource);
				_g_object_unref0 (builder);
				return result;
			}
			_tmp4_ = gtk_builder_new ();
			_g_object_unref0 (self->priv->basic_ui);
			self->priv->basic_ui = _tmp4_;
			_tmp5_ = self->priv->basic_ui;
			_tmp6_ = _g_object_ref0 (_tmp5_);
			_g_object_unref0 (builder);
			builder = _tmp6_;
			_tmp7_ = g_strdup ("buttons-basic.ui");
			_g_free0 (builder_resource);
			builder_resource = _tmp7_;
			break;
		}
		case BUTTON_MODE_ADVANCED:
		{
			GtkWidget* _tmp8_ = NULL;
			GtkBuilder* _tmp11_ = NULL;
			GtkBuilder* _tmp12_ = NULL;
			GtkBuilder* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			_tmp8_ = self->priv->adv_panel;
			if (_tmp8_ != NULL) {
				GtkWidget* _tmp9_ = NULL;
				GtkWidget* _tmp10_ = NULL;
				_tmp9_ = self->priv->adv_panel;
				_tmp10_ = _g_object_ref0 (_tmp9_);
				result = _tmp10_;
				_g_free0 (builder_resource);
				_g_object_unref0 (builder);
				return result;
			}
			_tmp11_ = gtk_builder_new ();
			_g_object_unref0 (self->priv->advanced_ui);
			self->priv->advanced_ui = _tmp11_;
			_tmp12_ = self->priv->advanced_ui;
			_tmp13_ = _g_object_ref0 (_tmp12_);
			_g_object_unref0 (builder);
			builder = _tmp13_;
			_tmp14_ = g_strdup ("buttons-advanced.ui");
			_g_free0 (builder_resource);
			builder_resource = _tmp14_;
			break;
		}
		case BUTTON_MODE_FINANCIAL:
		{
			GtkWidget* _tmp15_ = NULL;
			GtkBuilder* _tmp18_ = NULL;
			GtkBuilder* _tmp19_ = NULL;
			GtkBuilder* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			_tmp15_ = self->priv->fin_panel;
			if (_tmp15_ != NULL) {
				GtkWidget* _tmp16_ = NULL;
				GtkWidget* _tmp17_ = NULL;
				_tmp16_ = self->priv->fin_panel;
				_tmp17_ = _g_object_ref0 (_tmp16_);
				result = _tmp17_;
				_g_free0 (builder_resource);
				_g_object_unref0 (builder);
				return result;
			}
			_tmp18_ = gtk_builder_new ();
			_g_object_unref0 (self->priv->financial_ui);
			self->priv->financial_ui = _tmp18_;
			_tmp19_ = self->priv->financial_ui;
			_tmp20_ = _g_object_ref0 (_tmp19_);
			_g_object_unref0 (builder);
			builder = _tmp20_;
			_tmp21_ = g_strdup ("buttons-financial.ui");
			_g_free0 (builder_resource);
			builder_resource = _tmp21_;
			break;
		}
		case BUTTON_MODE_PROGRAMMING:
		{
			GtkWidget* _tmp22_ = NULL;
			GtkBuilder* _tmp25_ = NULL;
			GtkBuilder* _tmp26_ = NULL;
			GtkBuilder* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
			_tmp22_ = self->priv->prog_panel;
			if (_tmp22_ != NULL) {
				GtkWidget* _tmp23_ = NULL;
				GtkWidget* _tmp24_ = NULL;
				_tmp23_ = self->priv->prog_panel;
				_tmp24_ = _g_object_ref0 (_tmp23_);
				result = _tmp24_;
				_g_free0 (builder_resource);
				_g_object_unref0 (builder);
				return result;
			}
			_tmp25_ = gtk_builder_new ();
			_g_object_unref0 (self->priv->programming_ui);
			self->priv->programming_ui = _tmp25_;
			_tmp26_ = self->priv->programming_ui;
			_tmp27_ = _g_object_ref0 (_tmp26_);
			_g_object_unref0 (builder);
			builder = _tmp27_;
			_tmp28_ = g_strdup ("buttons-programming.ui");
			_g_free0 (builder_resource);
			builder_resource = _tmp28_;
			break;
		}
	}
	{
		GtkBuilder* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		_tmp29_ = builder;
		_tmp30_ = builder_resource;
		_tmp31_ = g_strdup_printf ("/org/gnome/calculator/%s", _tmp30_);
		_tmp32_ = _tmp31_;
		gtk_builder_add_from_resource (_tmp29_, _tmp32_, &_inner_error_);
		_g_free0 (_tmp32_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp33_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp33_ = e->message;
		g_error ("math-buttons.vala:268: Error loading button UI: %s", _tmp33_);
		_g_error_free0 (e);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		_g_free0 (builder_resource);
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp34_ = builder;
	_tmp35_ = gtk_builder_get_object (_tmp34_, "button_panel");
	_tmp36_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, GTK_TYPE_WIDGET) ? ((GtkWidget*) _tmp35_) : NULL);
	panel = _tmp36_;
	_tmp37_ = panel;
	gtk_box_pack_end ((GtkBox*) self, _tmp37_, TRUE, TRUE, (guint) 0);
	_tmp38_ = mode;
	switch (_tmp38_) {
		default:
		case BUTTON_MODE_BASIC:
		{
			GtkWidget* _tmp39_ = NULL;
			GtkWidget* _tmp40_ = NULL;
			_tmp39_ = panel;
			_tmp40_ = _g_object_ref0 (_tmp39_);
			_g_object_unref0 (self->priv->bas_panel);
			self->priv->bas_panel = _tmp40_;
			break;
		}
		case BUTTON_MODE_ADVANCED:
		{
			GtkWidget* _tmp41_ = NULL;
			GtkWidget* _tmp42_ = NULL;
			_tmp41_ = panel;
			_tmp42_ = _g_object_ref0 (_tmp41_);
			_g_object_unref0 (self->priv->adv_panel);
			self->priv->adv_panel = _tmp42_;
			break;
		}
		case BUTTON_MODE_FINANCIAL:
		{
			GtkWidget* _tmp43_ = NULL;
			GtkWidget* _tmp44_ = NULL;
			_tmp43_ = panel;
			_tmp44_ = _g_object_ref0 (_tmp43_);
			_g_object_unref0 (self->priv->fin_panel);
			self->priv->fin_panel = _tmp44_;
			break;
		}
		case BUTTON_MODE_PROGRAMMING:
		{
			GtkWidget* _tmp45_ = NULL;
			GtkWidget* _tmp46_ = NULL;
			_tmp45_ = panel;
			_tmp46_ = _g_object_ref0 (_tmp45_);
			_g_object_unref0 (self->priv->prog_panel);
			self->priv->prog_panel = _tmp46_;
			break;
		}
	}
	_tmp47_ = builder;
	_tmp48_ = _ ("Pi [Ctrl+P]");
	math_buttons_setup_button (self, _tmp47_, "pi", "π", _tmp48_, TRUE);
	_tmp49_ = builder;
	_tmp50_ = _ ("Euler’s Number");
	math_buttons_setup_button (self, _tmp49_, "eulers_number", "e", _tmp50_, TRUE);
	_tmp51_ = builder;
	math_buttons_setup_button (self, _tmp51_, "imaginary", "i", NULL, TRUE);
	_tmp52_ = builder;
	math_buttons_setup_button (self, _tmp52_, "numeric_point", NULL, NULL, TRUE);
	_tmp53_ = builder;
	_tmp54_ = _ ("Subscript mode [Alt]");
	math_buttons_setup_button (self, _tmp53_, "subscript", NULL, _tmp54_, TRUE);
	_tmp55_ = builder;
	_tmp56_ = _ ("Superscript mode [Ctrl]");
	math_buttons_setup_button (self, _tmp55_, "superscript", NULL, _tmp56_, TRUE);
	_tmp57_ = builder;
	_tmp58_ = _ ("Scientific exponent [Ctrl+E]");
	math_buttons_setup_button (self, _tmp57_, "exponential", NULL, _tmp58_, TRUE);
	_tmp59_ = builder;
	_tmp60_ = _ ("Add [+]");
	math_buttons_setup_button (self, _tmp59_, "add", "+", _tmp60_, TRUE);
	_tmp61_ = builder;
	_tmp62_ = _ ("Subtract [-]");
	math_buttons_setup_button (self, _tmp61_, "subtract", "−", _tmp62_, FALSE);
	_tmp63_ = builder;
	_tmp64_ = _ ("Multiply [*]");
	math_buttons_setup_button (self, _tmp63_, "multiply", "×", _tmp64_, TRUE);
	_tmp65_ = builder;
	_tmp66_ = _ ("Divide [/]");
	math_buttons_setup_button (self, _tmp65_, "divide", "÷", _tmp66_, TRUE);
	_tmp67_ = builder;
	_tmp68_ = _ ("Modulus divide");
	math_buttons_setup_button (self, _tmp67_, "modulus_divide", " mod ", _tmp68_, TRUE);
	_tmp69_ = builder;
	_tmp70_ = _ ("Additional Functions");
	math_buttons_setup_button (self, _tmp69_, "function", NULL, _tmp70_, TRUE);
	_tmp71_ = builder;
	_tmp72_ = _ ("Exponent [^ or **]");
	math_buttons_setup_button (self, _tmp71_, "x_pow_y", "^", _tmp72_, TRUE);
	_tmp73_ = builder;
	_tmp74_ = _ ("Percentage [%]");
	math_buttons_setup_button (self, _tmp73_, "percentage", "%", _tmp74_, TRUE);
	_tmp75_ = builder;
	_tmp76_ = _ ("Factorial [!]");
	math_buttons_setup_button (self, _tmp75_, "factorial", "!", _tmp76_, TRUE);
	_tmp77_ = builder;
	_tmp78_ = _ ("Absolute value [|]");
	math_buttons_setup_button (self, _tmp77_, "abs", "|", _tmp78_, TRUE);
	_tmp79_ = builder;
	_tmp80_ = _ ("Complex argument");
	math_buttons_setup_button (self, _tmp79_, "arg", "Arg ", _tmp80_, TRUE);
	_tmp81_ = builder;
	_tmp82_ = _ ("Complex conjugate");
	math_buttons_setup_button (self, _tmp81_, "conjugate", "conj ", _tmp82_, TRUE);
	_tmp83_ = builder;
	_tmp84_ = _ ("Root [Ctrl+R]");
	math_buttons_setup_button (self, _tmp83_, "root", "√", _tmp84_, TRUE);
	_tmp85_ = builder;
	_tmp86_ = _ ("Square root [Ctrl+R]");
	math_buttons_setup_button (self, _tmp85_, "square_root", "√", _tmp86_, TRUE);
	_tmp87_ = builder;
	_tmp88_ = _ ("Logarithm");
	math_buttons_setup_button (self, _tmp87_, "logarithm", "log ", _tmp88_, TRUE);
	_tmp89_ = builder;
	_tmp90_ = _ ("Natural Logarithm");
	math_buttons_setup_button (self, _tmp89_, "natural_logarithm", "ln ", _tmp90_, TRUE);
	_tmp91_ = builder;
	_tmp92_ = _ ("Sine");
	math_buttons_setup_button (self, _tmp91_, "sine", "sin ", _tmp92_, TRUE);
	_tmp93_ = builder;
	_tmp94_ = _ ("Cosine");
	math_buttons_setup_button (self, _tmp93_, "cosine", "cos ", _tmp94_, TRUE);
	_tmp95_ = builder;
	_tmp96_ = _ ("Tangent");
	math_buttons_setup_button (self, _tmp95_, "tangent", "tan ", _tmp96_, TRUE);
	_tmp97_ = builder;
	_tmp98_ = _ ("Hyperbolic Sine");
	math_buttons_setup_button (self, _tmp97_, "hyperbolic_sine", "sinh ", _tmp98_, TRUE);
	_tmp99_ = builder;
	_tmp100_ = _ ("Hyperbolic Cosine");
	math_buttons_setup_button (self, _tmp99_, "hyperbolic_cosine", "cosh ", _tmp100_, TRUE);
	_tmp101_ = builder;
	_tmp102_ = _ ("Hyperbolic Tangent");
	math_buttons_setup_button (self, _tmp101_, "hyperbolic_tangent", "tanh ", _tmp102_, TRUE);
	_tmp103_ = builder;
	_tmp104_ = _ ("Inverse [Ctrl+I]");
	math_buttons_setup_button (self, _tmp103_, "inverse", "⁻¹", _tmp104_, TRUE);
	_tmp105_ = builder;
	_tmp106_ = _ ("Boolean AND");
	math_buttons_setup_button (self, _tmp105_, "and", "∧", _tmp106_, TRUE);
	_tmp107_ = builder;
	_tmp108_ = _ ("Boolean OR");
	math_buttons_setup_button (self, _tmp107_, "or", "∨", _tmp108_, TRUE);
	_tmp109_ = builder;
	_tmp110_ = _ ("Boolean Exclusive OR");
	math_buttons_setup_button (self, _tmp109_, "xor", "⊻", _tmp110_, TRUE);
	_tmp111_ = builder;
	_tmp112_ = _ ("Boolean NOT");
	math_buttons_setup_button (self, _tmp111_, "not", "¬", _tmp112_, TRUE);
	_tmp113_ = builder;
	_tmp114_ = _ ("Integer Component");
	math_buttons_setup_button (self, _tmp113_, "integer_portion", "int ", _tmp114_, TRUE);
	_tmp115_ = builder;
	_tmp116_ = _ ("Fractional Component");
	math_buttons_setup_button (self, _tmp115_, "fractional_portion", "frac ", _tmp116_, TRUE);
	_tmp117_ = builder;
	_tmp118_ = _ ("Real Component");
	math_buttons_setup_button (self, _tmp117_, "real_portion", "Re ", _tmp118_, TRUE);
	_tmp119_ = builder;
	_tmp120_ = _ ("Imaginary Component");
	math_buttons_setup_button (self, _tmp119_, "imaginary_portion", "Im ", _tmp120_, TRUE);
	_tmp121_ = builder;
	_tmp122_ = _ ("Ones' Complement");
	math_buttons_setup_button (self, _tmp121_, "ones_complement", "ones ", _tmp122_, TRUE);
	_tmp123_ = builder;
	_tmp124_ = _ ("Two's Complement");
	math_buttons_setup_button (self, _tmp123_, "twos_complement", "twos ", _tmp124_, TRUE);
	_tmp125_ = builder;
	_tmp126_ = _ ("Truncate");
	math_buttons_setup_button (self, _tmp125_, "trunc", "trunc ", _tmp126_, TRUE);
	_tmp127_ = builder;
	_tmp128_ = _ ("Start Group [(]");
	math_buttons_setup_button (self, _tmp127_, "start_group", "(", _tmp128_, TRUE);
	_tmp129_ = builder;
	_tmp130_ = _ ("End Group [)]");
	math_buttons_setup_button (self, _tmp129_, "end_group", ")", _tmp130_, TRUE);
	_tmp131_ = builder;
	_tmp132_ = _ ("Memory");
	math_buttons_setup_button (self, _tmp131_, "memory", NULL, _tmp132_, TRUE);
	_tmp133_ = builder;
	_tmp134_ = _ ("Insert Character Code");
	math_buttons_setup_button (self, _tmp133_, "character", NULL, _tmp134_, TRUE);
	_tmp135_ = builder;
	_tmp136_ = _ ("Calculate Result");
	math_buttons_setup_button (self, _tmp135_, "result", NULL, _tmp136_, TRUE);
	_tmp137_ = builder;
	_tmp138_ = _ ("Factorize [Ctrl+F]");
	math_buttons_setup_button (self, _tmp137_, "factor", NULL, _tmp138_, TRUE);
	_tmp139_ = builder;
	_tmp140_ = _ ("Clear Display [Escape]");
	math_buttons_setup_button (self, _tmp139_, "clear", NULL, _tmp140_, TRUE);
	_tmp141_ = builder;
	_tmp142_ = _ ("Undo [Ctrl+Z]");
	math_buttons_setup_button (self, _tmp141_, "undo", NULL, _tmp142_, TRUE);
	_tmp143_ = builder;
	_tmp144_ = _ ("Shift Left");
	math_buttons_setup_button (self, _tmp143_, "shift_left", NULL, _tmp144_, TRUE);
	_tmp145_ = builder;
	_tmp146_ = _ ("Shift Right");
	math_buttons_setup_button (self, _tmp145_, "shift_right", NULL, _tmp146_, TRUE);
	_tmp147_ = builder;
	_tmp148_ = _ ("Compounding Term");
	math_buttons_setup_button (self, _tmp147_, "finc_compounding_term", NULL, _tmp148_, TRUE);
	_tmp149_ = builder;
	_tmp150_ = _ ("Double Declining Depreciation");
	math_buttons_setup_button (self, _tmp149_, "finc_double_declining_depreciation", NULL, _tmp150_, TRUE);
	_tmp151_ = builder;
	_tmp152_ = _ ("Future Value");
	math_buttons_setup_button (self, _tmp151_, "finc_future_value", NULL, _tmp152_, TRUE);
	_tmp153_ = builder;
	_tmp154_ = _ ("Financial Term");
	math_buttons_setup_button (self, _tmp153_, "finc_term", NULL, _tmp154_, TRUE);
	_tmp155_ = builder;
	_tmp156_ = _ ("Sum of the Years Digits Depreciation");
	math_buttons_setup_button (self, _tmp155_, "finc_sum_of_the_years_digits_depreciation", NULL, _tmp156_, TRUE);
	_tmp157_ = builder;
	_tmp158_ = _ ("Straight Line Depreciation");
	math_buttons_setup_button (self, _tmp157_, "finc_straight_line_depreciation", NULL, _tmp158_, TRUE);
	_tmp159_ = builder;
	_tmp160_ = _ ("Periodic Interest Rate");
	math_buttons_setup_button (self, _tmp159_, "finc_periodic_interest_rate", NULL, _tmp160_, TRUE);
	_tmp161_ = builder;
	_tmp162_ = _ ("Present Value");
	math_buttons_setup_button (self, _tmp161_, "finc_present_value", NULL, _tmp162_, TRUE);
	_tmp163_ = builder;
	_tmp164_ = _ ("Periodic Payment");
	math_buttons_setup_button (self, _tmp163_, "finc_periodic_payment", NULL, _tmp164_, TRUE);
	_tmp165_ = builder;
	_tmp166_ = _ ("Gross Profit Margin");
	math_buttons_setup_button (self, _tmp165_, "finc_gross_profit_margin", NULL, _tmp166_, TRUE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp167_ = FALSE;
			_tmp167_ = TRUE;
			while (TRUE) {
				gint _tmp169_ = 0;
				gchar* name = NULL;
				gint _tmp170_ = 0;
				gchar* _tmp171_ = NULL;
				GtkButton* button = NULL;
				GtkBuilder* _tmp172_ = NULL;
				const gchar* _tmp173_ = NULL;
				GObject* _tmp174_ = NULL;
				GtkButton* _tmp175_ = NULL;
				GtkButton* _tmp176_ = NULL;
				if (!_tmp167_) {
					gint _tmp168_ = 0;
					_tmp168_ = i;
					i = _tmp168_ + 1;
				}
				_tmp167_ = FALSE;
				_tmp169_ = i;
				if (!(_tmp169_ < 16)) {
					break;
				}
				_tmp170_ = i;
				_tmp171_ = g_strdup_printf ("calc_%d_button", _tmp170_);
				name = _tmp171_;
				_tmp172_ = builder;
				_tmp173_ = name;
				_tmp174_ = gtk_builder_get_object (_tmp172_, _tmp173_);
				_tmp175_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp174_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp174_) : NULL);
				button = _tmp175_;
				_tmp176_ = button;
				if (_tmp176_ != NULL) {
					GtkButton* _tmp177_ = NULL;
					gint _tmp178_ = 0;
					GtkButton* _tmp179_ = NULL;
					MathEquation* _tmp180_ = NULL;
					gint _tmp181_ = 0;
					gunichar _tmp182_ = 0U;
					gchar* _tmp183_ = NULL;
					gchar* _tmp184_ = NULL;
					GtkButton* _tmp185_ = NULL;
					_tmp177_ = button;
					_tmp178_ = i;
					g_object_set_data_full ((GObject*) _tmp177_, "calc_digit", (gpointer) ((gintptr) _tmp178_), NULL);
					_tmp179_ = button;
					_tmp180_ = self->priv->equation;
					_tmp181_ = i;
					_tmp182_ = math_equation_get_digit_text (_tmp180_, (guint) _tmp181_);
					_tmp183_ = g_unichar_to_string (_tmp182_);
					_tmp184_ = _tmp183_;
					gtk_button_set_label (_tmp179_, _tmp184_);
					_g_free0 (_tmp184_);
					_tmp185_ = button;
					g_signal_connect_object (_tmp185_, "clicked", (GCallback) _______lambda15__gtk_button_clicked, self, 0);
				}
				_g_object_unref0 (button);
				_g_free0 (name);
			}
		}
	}
	_tmp186_ = builder;
	_tmp187_ = gtk_builder_get_object (_tmp186_, "calc_subtract_button");
	_tmp188_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp187_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp187_) : NULL);
	button = _tmp188_;
	_tmp189_ = button;
	if (_tmp189_ != NULL) {
		GtkButton* _tmp190_ = NULL;
		_tmp190_ = button;
		g_signal_connect_object (_tmp190_, "clicked", (GCallback) ____lambda16__gtk_button_clicked, self, 0);
	}
	_tmp191_ = builder;
	_tmp192_ = gtk_builder_get_object (_tmp191_, "calc_x_squared_button");
	_tmp193_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp192_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp192_) : NULL);
	_g_object_unref0 (button);
	button = _tmp193_;
	_tmp194_ = button;
	if (_tmp194_ != NULL) {
		GtkButton* _tmp195_ = NULL;
		GtkButton* _tmp196_ = NULL;
		const gchar* _tmp197_ = NULL;
		_tmp195_ = button;
		g_signal_connect_object (_tmp195_, "clicked", (GCallback) ____lambda17__gtk_button_clicked, self, 0);
		_tmp196_ = button;
		_tmp197_ = _ ("Square [Ctrl+2]");
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp196_, _tmp197_);
	}
	_tmp198_ = builder;
	_tmp199_ = gtk_builder_get_object (_tmp198_, "calc_undo_button");
	_tmp200_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp199_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp199_) : NULL);
	_g_object_unref0 (button);
	button = _tmp200_;
	_tmp201_ = button;
	if (_tmp201_ != NULL) {
		GtkButton* _tmp202_ = NULL;
		_tmp202_ = button;
		g_signal_connect_object (_tmp202_, "clicked", (GCallback) ____lambda18__gtk_button_clicked, self, 0);
	}
	_tmp203_ = builder;
	_tmp204_ = gtk_builder_get_object (_tmp203_, "calc_result_button");
	_tmp205_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp204_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp204_) : NULL);
	_g_object_unref0 (button);
	button = _tmp205_;
	_tmp206_ = button;
	if (_tmp206_ != NULL) {
		GtkButton* _tmp207_ = NULL;
		_tmp207_ = button;
		g_signal_connect_object (_tmp207_, "clicked", (GCallback) ____lambda19__gtk_button_clicked, self, 0);
	}
	_tmp208_ = builder;
	_tmp209_ = gtk_builder_get_object (_tmp208_, "calc_clear_button");
	_tmp210_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp209_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp209_) : NULL);
	_g_object_unref0 (button);
	button = _tmp210_;
	_tmp211_ = button;
	if (_tmp211_ != NULL) {
		GtkButton* _tmp212_ = NULL;
		_tmp212_ = button;
		g_signal_connect_object (_tmp212_, "clicked", (GCallback) ____lambda20__gtk_button_clicked, self, 0);
	}
	_tmp213_ = builder;
	_tmp214_ = gtk_builder_get_object (_tmp213_, "calc_memory_button");
	_tmp215_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp214_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp214_) : NULL);
	_g_object_unref0 (button);
	button = _tmp215_;
	_tmp216_ = button;
	if (_tmp216_ != NULL) {
		GtkButton* _tmp217_ = NULL;
		_tmp217_ = button;
		g_signal_connect_object (_tmp217_, "clicked", (GCallback) _math_buttons_memory_cb_gtk_button_clicked, self, 0);
	}
	_tmp218_ = builder;
	_tmp219_ = gtk_builder_get_object (_tmp218_, "calc_function_button");
	_tmp220_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp219_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp219_) : NULL);
	_g_object_unref0 (button);
	button = _tmp220_;
	_tmp221_ = button;
	if (_tmp221_ != NULL) {
		GtkButton* _tmp222_ = NULL;
		_tmp222_ = button;
		g_signal_connect_object (_tmp222_, "clicked", (GCallback) _math_buttons_function_cb_gtk_button_clicked, self, 0);
	}
	_tmp223_ = builder;
	_tmp224_ = gtk_builder_get_object (_tmp223_, "calc_factor_button");
	_tmp225_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp224_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp224_) : NULL);
	_g_object_unref0 (button);
	button = _tmp225_;
	_tmp226_ = button;
	if (_tmp226_ != NULL) {
		GtkButton* _tmp227_ = NULL;
		_tmp227_ = button;
		g_signal_connect_object (_tmp227_, "clicked", (GCallback) ____lambda23__gtk_button_clicked, self, 0);
	}
	_tmp228_ = builder;
	_tmp229_ = gtk_builder_get_object (_tmp228_, "calc_exponential_button");
	_tmp230_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp229_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp229_) : NULL);
	_g_object_unref0 (button);
	button = _tmp230_;
	_tmp231_ = button;
	if (_tmp231_ != NULL) {
		GtkButton* _tmp232_ = NULL;
		_tmp232_ = button;
		g_signal_connect_object (_tmp232_, "clicked", (GCallback) ____lambda24__gtk_button_clicked, self, 0);
	}
	_tmp233_ = builder;
	_tmp234_ = gtk_builder_get_object (_tmp233_, "calc_shift_left_button");
	_tmp235_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp234_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp234_) : NULL);
	_g_object_unref0 (button);
	button = _tmp235_;
	_tmp236_ = button;
	if (_tmp236_ != NULL) {
		GtkButton* _tmp237_ = NULL;
		_tmp237_ = button;
		g_signal_connect_object (_tmp237_, "clicked", (GCallback) _math_buttons_shift_left_cb_gtk_button_clicked, self, 0);
	}
	_tmp238_ = builder;
	_tmp239_ = gtk_builder_get_object (_tmp238_, "calc_shift_right_button");
	_tmp240_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp239_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp239_) : NULL);
	_g_object_unref0 (button);
	button = _tmp240_;
	_tmp241_ = button;
	if (_tmp241_ != NULL) {
		GtkButton* _tmp242_ = NULL;
		_tmp242_ = button;
		g_signal_connect_object (_tmp242_, "clicked", (GCallback) _math_buttons_shift_right_cb_gtk_button_clicked, self, 0);
	}
	_tmp243_ = builder;
	_tmp244_ = gtk_builder_get_object (_tmp243_, "calc_character_button");
	_tmp245_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp244_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp244_) : NULL);
	_g_object_unref0 (button);
	button = _tmp245_;
	_tmp246_ = button;
	if (_tmp246_ != NULL) {
		GtkButton* _tmp247_ = NULL;
		_tmp247_ = button;
		g_signal_connect_object (_tmp247_, "clicked", (GCallback) _math_buttons_insert_character_code_cb_gtk_button_clicked, self, 0);
	}
	_tmp248_ = builder;
	_tmp249_ = gtk_builder_get_object (_tmp248_, "calc_numeric_point_button");
	_tmp250_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp249_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp249_) : NULL);
	_g_object_unref0 (button);
	button = _tmp250_;
	_tmp251_ = button;
	if (_tmp251_ != NULL) {
		GtkButton* _tmp252_ = NULL;
		MathEquation* _tmp253_ = NULL;
		Serializer* _tmp254_ = NULL;
		Serializer* _tmp255_ = NULL;
		gunichar _tmp256_ = 0U;
		gchar* _tmp257_ = NULL;
		gchar* _tmp258_ = NULL;
		GtkButton* _tmp259_ = NULL;
		_tmp252_ = button;
		_tmp253_ = self->priv->equation;
		_tmp254_ = math_equation_get_serializer (_tmp253_);
		_tmp255_ = _tmp254_;
		_tmp256_ = serializer_get_radix (_tmp255_);
		_tmp257_ = g_unichar_to_string (_tmp256_);
		_tmp258_ = _tmp257_;
		gtk_button_set_label (_tmp252_, _tmp258_);
		_g_free0 (_tmp258_);
		_tmp259_ = button;
		g_signal_connect_object (_tmp259_, "clicked", (GCallback) ____lambda27__gtk_button_clicked, self, 0);
	}
	_tmp260_ = builder;
	_tmp261_ = gtk_builder_get_object (_tmp260_, "calc_superscript_button");
	_tmp262_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp261_, GTK_TYPE_TOGGLE_BUTTON) ? ((GtkToggleButton*) _tmp261_) : NULL);
	toggle_button = _tmp262_;
	_tmp263_ = toggle_button;
	if (_tmp263_ != NULL) {
		GtkToggleButton* _tmp264_ = NULL;
		GtkToggleButton* _tmp265_ = NULL;
		MathEquation* _tmp266_ = NULL;
		NumberMode _tmp267_ = 0;
		NumberMode _tmp268_ = 0;
		GtkToggleButton* _tmp270_ = NULL;
		_tmp264_ = toggle_button;
		_tmp265_ = _g_object_ref0 (_tmp264_);
		self->priv->superscript_toggles = g_list_append (self->priv->superscript_toggles, _tmp265_);
		_tmp266_ = self->priv->equation;
		_tmp267_ = math_equation_get_number_mode (_tmp266_);
		_tmp268_ = _tmp267_;
		if (_tmp268_ == NUMBER_MODE_SUPERSCRIPT) {
			GtkToggleButton* _tmp269_ = NULL;
			_tmp269_ = toggle_button;
			gtk_toggle_button_set_active (_tmp269_, TRUE);
		}
		_tmp270_ = toggle_button;
		g_signal_connect_object ((GtkButton*) _tmp270_, "clicked", (GCallback) _math_buttons_set_superscript_cb_gtk_button_clicked, self, 0);
	}
	_tmp271_ = builder;
	_tmp272_ = gtk_builder_get_object (_tmp271_, "calc_subscript_button");
	_tmp273_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp272_, GTK_TYPE_TOGGLE_BUTTON) ? ((GtkToggleButton*) _tmp272_) : NULL);
	_g_object_unref0 (toggle_button);
	toggle_button = _tmp273_;
	_tmp274_ = toggle_button;
	if (_tmp274_ != NULL) {
		GtkToggleButton* _tmp275_ = NULL;
		GtkToggleButton* _tmp276_ = NULL;
		MathEquation* _tmp277_ = NULL;
		NumberMode _tmp278_ = 0;
		NumberMode _tmp279_ = 0;
		GtkToggleButton* _tmp281_ = NULL;
		_tmp275_ = toggle_button;
		_tmp276_ = _g_object_ref0 (_tmp275_);
		self->priv->subscript_toggles = g_list_append (self->priv->subscript_toggles, _tmp276_);
		_tmp277_ = self->priv->equation;
		_tmp278_ = math_equation_get_number_mode (_tmp277_);
		_tmp279_ = _tmp278_;
		if (_tmp279_ == NUMBER_MODE_SUBSCRIPT) {
			GtkToggleButton* _tmp280_ = NULL;
			_tmp280_ = toggle_button;
			gtk_toggle_button_set_active (_tmp280_, TRUE);
		}
		_tmp281_ = toggle_button;
		g_signal_connect_object ((GtkButton*) _tmp281_, "clicked", (GCallback) _math_buttons_set_subscript_cb_gtk_button_clicked, self, 0);
	}
	_tmp282_ = mode;
	if (_tmp282_ == BUTTON_MODE_PROGRAMMING) {
		GtkBuilder* _tmp283_ = NULL;
		GObject* _tmp284_ = NULL;
		GtkLabel* _tmp285_ = NULL;
		GtkBuilder* _tmp286_ = NULL;
		GObject* _tmp287_ = NULL;
		GtkDialog* _tmp288_ = NULL;
		GtkDialog* _tmp289_ = NULL;
		GtkDialog* _tmp290_ = NULL;
		GtkBuilder* _tmp291_ = NULL;
		GObject* _tmp292_ = NULL;
		GtkEntry* _tmp293_ = NULL;
		GtkEntry* _tmp294_ = NULL;
		GtkBuilder* _tmp295_ = NULL;
		GObject* _tmp296_ = NULL;
		GtkWidget* _tmp297_ = NULL;
		gint i = 0;
		GtkBuilder* _tmp317_ = NULL;
		GObject* _tmp318_ = NULL;
		GtkComboBox* _tmp319_ = NULL;
		GtkListStore* model = NULL;
		GtkListStore* _tmp320_ = NULL;
		GtkComboBox* _tmp321_ = NULL;
		GtkListStore* _tmp322_ = NULL;
		GtkTreeIter iter = {0};
		GtkListStore* _tmp323_ = NULL;
		GtkTreeIter _tmp324_ = {0};
		GtkListStore* _tmp325_ = NULL;
		GtkTreeIter _tmp326_ = {0};
		const gchar* _tmp327_ = NULL;
		GtkListStore* _tmp328_ = NULL;
		GtkTreeIter _tmp329_ = {0};
		GtkListStore* _tmp330_ = NULL;
		GtkTreeIter _tmp331_ = {0};
		const gchar* _tmp332_ = NULL;
		GtkListStore* _tmp333_ = NULL;
		GtkTreeIter _tmp334_ = {0};
		GtkListStore* _tmp335_ = NULL;
		GtkTreeIter _tmp336_ = {0};
		const gchar* _tmp337_ = NULL;
		GtkListStore* _tmp338_ = NULL;
		GtkTreeIter _tmp339_ = {0};
		GtkListStore* _tmp340_ = NULL;
		GtkTreeIter _tmp341_ = {0};
		const gchar* _tmp342_ = NULL;
		GtkCellRendererText* renderer = NULL;
		GtkCellRendererText* _tmp343_ = NULL;
		GtkComboBox* _tmp344_ = NULL;
		GtkCellRendererText* _tmp345_ = NULL;
		GtkComboBox* _tmp346_ = NULL;
		GtkCellRendererText* _tmp347_ = NULL;
		GtkComboBox* _tmp348_ = NULL;
		MathEquation* _tmp349_ = NULL;
		_tmp283_ = builder;
		_tmp284_ = gtk_builder_get_object (_tmp283_, "base_label");
		_tmp285_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp284_, GTK_TYPE_LABEL) ? ((GtkLabel*) _tmp284_) : NULL);
		_g_object_unref0 (self->priv->base_label);
		self->priv->base_label = _tmp285_;
		_tmp286_ = builder;
		_tmp287_ = gtk_builder_get_object (_tmp286_, "character_code_dialog");
		_tmp288_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp287_, GTK_TYPE_DIALOG) ? ((GtkDialog*) _tmp287_) : NULL);
		_g_object_unref0 (self->priv->character_code_dialog);
		self->priv->character_code_dialog = _tmp288_;
		_tmp289_ = self->priv->character_code_dialog;
		g_signal_connect_object (_tmp289_, "response", (GCallback) _math_buttons_character_code_dialog_response_cb_gtk_dialog_response, self, 0);
		_tmp290_ = self->priv->character_code_dialog;
		g_signal_connect_object ((GtkWidget*) _tmp290_, "delete-event", (GCallback) _math_buttons_character_code_dialog_delete_cb_gtk_widget_delete_event, self, 0);
		_tmp291_ = builder;
		_tmp292_ = gtk_builder_get_object (_tmp291_, "character_code_entry");
		_tmp293_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp292_, GTK_TYPE_ENTRY) ? ((GtkEntry*) _tmp292_) : NULL);
		_g_object_unref0 (self->priv->character_code_entry);
		self->priv->character_code_entry = _tmp293_;
		_tmp294_ = self->priv->character_code_entry;
		g_signal_connect_object (_tmp294_, "activate", (GCallback) _math_buttons_character_code_dialog_activate_cb_gtk_entry_activate, self, 0);
		_tmp295_ = builder;
		_tmp296_ = gtk_builder_get_object (_tmp295_, "bit_table");
		_tmp297_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp296_, GTK_TYPE_WIDGET) ? ((GtkWidget*) _tmp296_) : NULL);
		_g_object_unref0 (self->priv->bit_panel);
		self->priv->bit_panel = _tmp297_;
		__g_list_free__g_object_unref0_0 (self->priv->bit_labels);
		self->priv->bit_labels = NULL;
		i = 0;
		while (TRUE) {
			gchar* name = NULL;
			gint _tmp298_ = 0;
			gchar* _tmp299_ = NULL;
			GtkLabel* label = NULL;
			GtkBuilder* _tmp300_ = NULL;
			const gchar* _tmp301_ = NULL;
			GObject* _tmp302_ = NULL;
			GtkLabel* _tmp303_ = NULL;
			GtkLabel* _tmp304_ = NULL;
			GtkLabel* _tmp305_ = NULL;
			GtkLabel* _tmp306_ = NULL;
			gint _tmp307_ = 0;
			gchar* _tmp308_ = NULL;
			GtkEventBox* box = NULL;
			GtkBuilder* _tmp309_ = NULL;
			const gchar* _tmp310_ = NULL;
			GObject* _tmp311_ = NULL;
			GtkEventBox* _tmp312_ = NULL;
			GtkEventBox* _tmp313_ = NULL;
			gint _tmp314_ = 0;
			GtkEventBox* _tmp315_ = NULL;
			gint _tmp316_ = 0;
			_tmp298_ = i;
			_tmp299_ = g_strdup_printf ("bit_label_%d", _tmp298_);
			name = _tmp299_;
			_tmp300_ = builder;
			_tmp301_ = name;
			_tmp302_ = gtk_builder_get_object (_tmp300_, _tmp301_);
			_tmp303_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp302_, GTK_TYPE_LABEL) ? ((GtkLabel*) _tmp302_) : NULL);
			label = _tmp303_;
			_tmp304_ = label;
			if (_tmp304_ == NULL) {
				_g_object_unref0 (label);
				_g_free0 (name);
				break;
			}
			_tmp305_ = label;
			_tmp306_ = _g_object_ref0 (_tmp305_);
			self->priv->bit_labels = g_list_append (self->priv->bit_labels, _tmp306_);
			_tmp307_ = i;
			_tmp308_ = g_strdup_printf ("bit_eventbox_%d", _tmp307_);
			_g_free0 (name);
			name = _tmp308_;
			_tmp309_ = builder;
			_tmp310_ = name;
			_tmp311_ = gtk_builder_get_object (_tmp309_, _tmp310_);
			_tmp312_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp311_, GTK_TYPE_EVENT_BOX) ? ((GtkEventBox*) _tmp311_) : NULL);
			box = _tmp312_;
			_tmp313_ = box;
			_tmp314_ = i;
			g_object_set_data_full ((GObject*) _tmp313_, "bit_index", (gpointer) ((gintptr) _tmp314_), NULL);
			_tmp315_ = box;
			g_signal_connect_object ((GtkWidget*) _tmp315_, "button-press-event", (GCallback) _math_buttons_bit_toggle_cb_gtk_widget_button_press_event, self, 0);
			_tmp316_ = i;
			i = _tmp316_ + 1;
			_g_object_unref0 (box);
			_g_object_unref0 (label);
			_g_free0 (name);
		}
		self->priv->bit_labels = g_list_reverse (self->priv->bit_labels);
		_tmp317_ = builder;
		_tmp318_ = gtk_builder_get_object (_tmp317_, "base_combo");
		_tmp319_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp318_, GTK_TYPE_COMBO_BOX) ? ((GtkComboBox*) _tmp318_) : NULL);
		_g_object_unref0 (self->priv->base_combo);
		self->priv->base_combo = _tmp319_;
		_tmp320_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_INT);
		model = _tmp320_;
		_tmp321_ = self->priv->base_combo;
		_tmp322_ = model;
		gtk_combo_box_set_model (_tmp321_, (GtkTreeModel*) _tmp322_);
		_tmp323_ = model;
		gtk_list_store_append (_tmp323_, &_tmp324_);
		iter = _tmp324_;
		_tmp325_ = model;
		_tmp326_ = iter;
		_tmp327_ = _ ("Binary");
		gtk_list_store_set (_tmp325_, &_tmp326_, 0, _tmp327_, 1, 2, -1, -1);
		_tmp328_ = model;
		gtk_list_store_append (_tmp328_, &_tmp329_);
		iter = _tmp329_;
		_tmp330_ = model;
		_tmp331_ = iter;
		_tmp332_ = _ ("Octal");
		gtk_list_store_set (_tmp330_, &_tmp331_, 0, _tmp332_, 1, 8, -1, -1);
		_tmp333_ = model;
		gtk_list_store_append (_tmp333_, &_tmp334_);
		iter = _tmp334_;
		_tmp335_ = model;
		_tmp336_ = iter;
		_tmp337_ = _ ("Decimal");
		gtk_list_store_set (_tmp335_, &_tmp336_, 0, _tmp337_, 1, 10, -1, -1);
		_tmp338_ = model;
		gtk_list_store_append (_tmp338_, &_tmp339_);
		iter = _tmp339_;
		_tmp340_ = model;
		_tmp341_ = iter;
		_tmp342_ = _ ("Hexadecimal");
		gtk_list_store_set (_tmp340_, &_tmp341_, 0, _tmp342_, 1, 16, -1, -1);
		_tmp343_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
		g_object_ref_sink (_tmp343_);
		renderer = _tmp343_;
		_tmp344_ = self->priv->base_combo;
		_tmp345_ = renderer;
		gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp344_, (GtkCellRenderer*) _tmp345_, TRUE);
		_tmp346_ = self->priv->base_combo;
		_tmp347_ = renderer;
		gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp346_, (GtkCellRenderer*) _tmp347_, "text", 0);
		_tmp348_ = self->priv->base_combo;
		g_signal_connect_object (_tmp348_, "changed", (GCallback) _math_buttons_base_combobox_changed_cb_gtk_combo_box_changed, self, 0);
		_tmp349_ = self->priv->equation;
		g_signal_connect_object ((GObject*) _tmp349_, "notify::number-base", (GCallback) ____lambda28__g_object_notify, self, 0);
		math_buttons_base_changed_cb (self);
		_g_object_unref0 (renderer);
		_g_object_unref0 (model);
	}
	_tmp350_ = mode;
	if (_tmp350_ == BUTTON_MODE_FINANCIAL) {
		GtkBuilder* _tmp351_ = NULL;
		GObject* _tmp352_ = NULL;
		GtkButton* _tmp353_ = NULL;
		GtkButton* _tmp354_ = NULL;
		GtkBuilder* _tmp358_ = NULL;
		GObject* _tmp359_ = NULL;
		GtkButton* _tmp360_ = NULL;
		GtkButton* _tmp361_ = NULL;
		GtkBuilder* _tmp365_ = NULL;
		GObject* _tmp366_ = NULL;
		GtkButton* _tmp367_ = NULL;
		GtkButton* _tmp368_ = NULL;
		GtkBuilder* _tmp372_ = NULL;
		GObject* _tmp373_ = NULL;
		GtkButton* _tmp374_ = NULL;
		GtkButton* _tmp375_ = NULL;
		GtkBuilder* _tmp379_ = NULL;
		GObject* _tmp380_ = NULL;
		GtkButton* _tmp381_ = NULL;
		GtkButton* _tmp382_ = NULL;
		GtkBuilder* _tmp386_ = NULL;
		GObject* _tmp387_ = NULL;
		GtkButton* _tmp388_ = NULL;
		GtkButton* _tmp389_ = NULL;
		GtkBuilder* _tmp393_ = NULL;
		GObject* _tmp394_ = NULL;
		GtkButton* _tmp395_ = NULL;
		GtkButton* _tmp396_ = NULL;
		GtkBuilder* _tmp400_ = NULL;
		GObject* _tmp401_ = NULL;
		GtkButton* _tmp402_ = NULL;
		GtkButton* _tmp403_ = NULL;
		GtkBuilder* _tmp407_ = NULL;
		GObject* _tmp408_ = NULL;
		GtkButton* _tmp409_ = NULL;
		GtkButton* _tmp410_ = NULL;
		GtkBuilder* _tmp414_ = NULL;
		GObject* _tmp415_ = NULL;
		GtkButton* _tmp416_ = NULL;
		GtkButton* _tmp417_ = NULL;
		math_buttons_load_finc_dialogs (self);
		_tmp351_ = builder;
		_tmp352_ = gtk_builder_get_object (_tmp351_, "calc_finc_compounding_term_button");
		_tmp353_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp352_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp352_) : NULL);
		_g_object_unref0 (button);
		button = _tmp353_;
		_tmp354_ = button;
		if (_tmp354_ != NULL) {
			GtkButton* _tmp355_ = NULL;
			gchar* _tmp356_ = NULL;
			GtkButton* _tmp357_ = NULL;
			_tmp355_ = button;
			_tmp356_ = g_strdup ("ctrm_dialog");
			g_object_set_data_full ((GObject*) _tmp355_, "finc-dialog-name", _tmp356_, g_free);
			_tmp357_ = button;
			g_signal_connect_object (_tmp357_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
		_tmp358_ = builder;
		_tmp359_ = gtk_builder_get_object (_tmp358_, "calc_finc_double_declining_depreciation_button");
		_tmp360_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp359_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp359_) : NULL);
		_g_object_unref0 (button);
		button = _tmp360_;
		_tmp361_ = button;
		if (_tmp361_ != NULL) {
			GtkButton* _tmp362_ = NULL;
			gchar* _tmp363_ = NULL;
			GtkButton* _tmp364_ = NULL;
			_tmp362_ = button;
			_tmp363_ = g_strdup ("ddb_dialog");
			g_object_set_data_full ((GObject*) _tmp362_, "finc-dialog-name", _tmp363_, g_free);
			_tmp364_ = button;
			g_signal_connect_object (_tmp364_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
		_tmp365_ = builder;
		_tmp366_ = gtk_builder_get_object (_tmp365_, "calc_finc_future_value_button");
		_tmp367_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp366_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp366_) : NULL);
		_g_object_unref0 (button);
		button = _tmp367_;
		_tmp368_ = button;
		if (_tmp368_ != NULL) {
			GtkButton* _tmp369_ = NULL;
			gchar* _tmp370_ = NULL;
			GtkButton* _tmp371_ = NULL;
			_tmp369_ = button;
			_tmp370_ = g_strdup ("fv_dialog");
			g_object_set_data_full ((GObject*) _tmp369_, "finc-dialog-name", _tmp370_, g_free);
			_tmp371_ = button;
			g_signal_connect_object (_tmp371_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
		_tmp372_ = builder;
		_tmp373_ = gtk_builder_get_object (_tmp372_, "calc_finc_gross_profit_margin_button");
		_tmp374_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp373_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp373_) : NULL);
		_g_object_unref0 (button);
		button = _tmp374_;
		_tmp375_ = button;
		if (_tmp375_ != NULL) {
			GtkButton* _tmp376_ = NULL;
			gchar* _tmp377_ = NULL;
			GtkButton* _tmp378_ = NULL;
			_tmp376_ = button;
			_tmp377_ = g_strdup ("gpm_dialog");
			g_object_set_data_full ((GObject*) _tmp376_, "finc-dialog-name", _tmp377_, g_free);
			_tmp378_ = button;
			g_signal_connect_object (_tmp378_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
		_tmp379_ = builder;
		_tmp380_ = gtk_builder_get_object (_tmp379_, "calc_finc_periodic_payment_button");
		_tmp381_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp380_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp380_) : NULL);
		_g_object_unref0 (button);
		button = _tmp381_;
		_tmp382_ = button;
		if (_tmp382_ != NULL) {
			GtkButton* _tmp383_ = NULL;
			gchar* _tmp384_ = NULL;
			GtkButton* _tmp385_ = NULL;
			_tmp383_ = button;
			_tmp384_ = g_strdup ("pmt_dialog");
			g_object_set_data_full ((GObject*) _tmp383_, "finc-dialog-name", _tmp384_, g_free);
			_tmp385_ = button;
			g_signal_connect_object (_tmp385_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
		_tmp386_ = builder;
		_tmp387_ = gtk_builder_get_object (_tmp386_, "calc_finc_present_value_button");
		_tmp388_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp387_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp387_) : NULL);
		_g_object_unref0 (button);
		button = _tmp388_;
		_tmp389_ = button;
		if (_tmp389_ != NULL) {
			GtkButton* _tmp390_ = NULL;
			gchar* _tmp391_ = NULL;
			GtkButton* _tmp392_ = NULL;
			_tmp390_ = button;
			_tmp391_ = g_strdup ("pv_dialog");
			g_object_set_data_full ((GObject*) _tmp390_, "finc-dialog-name", _tmp391_, g_free);
			_tmp392_ = button;
			g_signal_connect_object (_tmp392_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
		_tmp393_ = builder;
		_tmp394_ = gtk_builder_get_object (_tmp393_, "calc_finc_periodic_interest_rate_button");
		_tmp395_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp394_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp394_) : NULL);
		_g_object_unref0 (button);
		button = _tmp395_;
		_tmp396_ = button;
		if (_tmp396_ != NULL) {
			GtkButton* _tmp397_ = NULL;
			gchar* _tmp398_ = NULL;
			GtkButton* _tmp399_ = NULL;
			_tmp397_ = button;
			_tmp398_ = g_strdup ("rate_dialog");
			g_object_set_data_full ((GObject*) _tmp397_, "finc-dialog-name", _tmp398_, g_free);
			_tmp399_ = button;
			g_signal_connect_object (_tmp399_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
		_tmp400_ = builder;
		_tmp401_ = gtk_builder_get_object (_tmp400_, "calc_finc_straight_line_depreciation_button");
		_tmp402_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp401_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp401_) : NULL);
		_g_object_unref0 (button);
		button = _tmp402_;
		_tmp403_ = button;
		if (_tmp403_ != NULL) {
			GtkButton* _tmp404_ = NULL;
			gchar* _tmp405_ = NULL;
			GtkButton* _tmp406_ = NULL;
			_tmp404_ = button;
			_tmp405_ = g_strdup ("sln_dialog");
			g_object_set_data_full ((GObject*) _tmp404_, "finc-dialog-name", _tmp405_, g_free);
			_tmp406_ = button;
			g_signal_connect_object (_tmp406_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
		_tmp407_ = builder;
		_tmp408_ = gtk_builder_get_object (_tmp407_, "calc_finc_sum_of_the_years_digits_depreciation_button");
		_tmp409_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp408_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp408_) : NULL);
		_g_object_unref0 (button);
		button = _tmp409_;
		_tmp410_ = button;
		if (_tmp410_ != NULL) {
			GtkButton* _tmp411_ = NULL;
			gchar* _tmp412_ = NULL;
			GtkButton* _tmp413_ = NULL;
			_tmp411_ = button;
			_tmp412_ = g_strdup ("syd_dialog");
			g_object_set_data_full ((GObject*) _tmp411_, "finc-dialog-name", _tmp412_, g_free);
			_tmp413_ = button;
			g_signal_connect_object (_tmp413_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
		_tmp414_ = builder;
		_tmp415_ = gtk_builder_get_object (_tmp414_, "calc_finc_term_button");
		_tmp416_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp415_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp415_) : NULL);
		_g_object_unref0 (button);
		button = _tmp416_;
		_tmp417_ = button;
		if (_tmp417_ != NULL) {
			GtkButton* _tmp418_ = NULL;
			gchar* _tmp419_ = NULL;
			GtkButton* _tmp420_ = NULL;
			_tmp418_ = button;
			_tmp419_ = g_strdup ("term_dialog");
			g_object_set_data_full ((GObject*) _tmp418_, "finc-dialog-name", _tmp419_, g_free);
			_tmp420_ = button;
			g_signal_connect_object (_tmp420_, "clicked", (GCallback) _math_buttons_finc_cb_gtk_button_clicked, self, 0);
		}
	}
	_tmp421_ = builder;
	gtk_builder_connect_signals (_tmp421_, self);
	math_buttons_update_bit_panel (self);
	result = panel;
	_g_object_unref0 (toggle_button);
	_g_object_unref0 (button);
	_g_free0 (builder_resource);
	_g_object_unref0 (builder);
	return result;
}


static void ____lambda14_ (MathButtons* self, GtkButton* widget) {
	MathEquation* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = widget;
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "calc_text");
	math_equation_insert (_tmp0_, (const gchar*) _tmp2_);
}


static void _____lambda14__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	____lambda14_ ((MathButtons*) self, _sender);
}


static void math_buttons_setup_button (MathButtons* self, GtkBuilder* builder, const gchar* name, const gchar* data, const gchar* tooltip, gboolean connect) {
	gchar* widget_name = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GtkButton* button = NULL;
	GtkBuilder* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GObject* _tmp4_ = NULL;
	GtkButton* _tmp5_ = NULL;
	GtkButton* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp13_ = NULL;
	GtkButton* _tmp16_ = NULL;
	AtkObject* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = g_strdup_printf ("calc_%s_button", _tmp0_);
	widget_name = _tmp1_;
	_tmp2_ = builder;
	_tmp3_ = widget_name;
	_tmp4_ = gtk_builder_get_object (_tmp2_, _tmp3_);
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, GTK_TYPE_BUTTON) ? ((GtkButton*) _tmp4_) : NULL);
	button = _tmp5_;
	_tmp6_ = button;
	if (_tmp6_ == NULL) {
		_g_object_unref0 (button);
		_g_free0 (widget_name);
		return;
	}
	_tmp7_ = data;
	if (_tmp7_ != NULL) {
		GtkButton* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		_tmp8_ = button;
		_tmp9_ = data;
		_tmp10_ = g_strdup (_tmp9_);
		g_object_set_data_full ((GObject*) _tmp8_, "calc_text", _tmp10_, g_free);
		_tmp11_ = connect;
		if (_tmp11_) {
			GtkButton* _tmp12_ = NULL;
			_tmp12_ = button;
			g_signal_connect_object (_tmp12_, "clicked", (GCallback) _____lambda14__gtk_button_clicked, self, 0);
		}
	}
	_tmp13_ = tooltip;
	if (_tmp13_ != NULL) {
		GtkButton* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		_tmp14_ = button;
		_tmp15_ = tooltip;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp14_, _tmp15_);
	}
	_tmp16_ = button;
	_tmp17_ = gtk_widget_get_accessible ((GtkWidget*) _tmp16_);
	_tmp18_ = name;
	atk_object_set_name (_tmp17_, _tmp18_);
	_g_object_unref0 (button);
	_g_free0 (widget_name);
}


static void math_buttons_converter_changed_cb (MathButtons* self) {
	Unit* from_unit = NULL;
	Unit* to_unit = NULL;
	MathConverter* _tmp0_ = NULL;
	Unit* _tmp1_ = NULL;
	Unit* _tmp2_ = NULL;
	ButtonMode _tmp3_ = 0;
	ButtonMode _tmp4_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->converter;
	math_converter_get_conversion (_tmp0_, &_tmp1_, &_tmp2_);
	_g_object_unref0 (from_unit);
	from_unit = _tmp1_;
	_g_object_unref0 (to_unit);
	to_unit = _tmp2_;
	_tmp3_ = math_buttons_get_mode (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == BUTTON_MODE_FINANCIAL) {
		MathEquation* _tmp5_ = NULL;
		Unit* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		MathEquation* _tmp10_ = NULL;
		Unit* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		_tmp5_ = self->priv->equation;
		_tmp6_ = from_unit;
		_tmp7_ = unit_get_name (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		math_equation_set_source_currency (_tmp5_, _tmp9_);
		_g_free0 (_tmp9_);
		_tmp10_ = self->priv->equation;
		_tmp11_ = to_unit;
		_tmp12_ = unit_get_name (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_;
		math_equation_set_target_currency (_tmp10_, _tmp14_);
		_g_free0 (_tmp14_);
	} else {
		MathEquation* _tmp15_ = NULL;
		Unit* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		MathEquation* _tmp20_ = NULL;
		Unit* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		_tmp15_ = self->priv->equation;
		_tmp16_ = from_unit;
		_tmp17_ = unit_get_name (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = _tmp18_;
		math_equation_set_source_units (_tmp15_, _tmp19_);
		_g_free0 (_tmp19_);
		_tmp20_ = self->priv->equation;
		_tmp21_ = to_unit;
		_tmp22_ = unit_get_name (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = _tmp23_;
		math_equation_set_target_units (_tmp20_, _tmp24_);
		_g_free0 (_tmp24_);
	}
	_g_object_unref0 (to_unit);
	_g_object_unref0 (from_unit);
}


static void _math_buttons_converter_changed_cb_math_converter_changed (MathConverter* _sender, gpointer self) {
	math_buttons_converter_changed_cb ((MathButtons*) self);
}


static void math_buttons_load_buttons (MathButtons* self) {
	gboolean _tmp0_ = FALSE;
	MathConverter* _tmp1_ = NULL;
	GtkWidget* panel = NULL;
	ButtonMode _tmp6_ = 0;
	ButtonMode _tmp7_ = 0;
	GtkWidget* _tmp8_ = NULL;
	GtkWidget* _tmp9_ = NULL;
	GtkWidget* _tmp10_ = NULL;
	GtkWidget* _tmp11_ = NULL;
	GtkWidget* _tmp13_ = NULL;
	GtkWidget* _tmp14_ = NULL;
	GtkWidget* _tmp15_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_visible ((GtkWidget*) self);
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->converter;
	if (_tmp1_ == NULL) {
		MathEquation* _tmp2_ = NULL;
		MathConverter* _tmp3_ = NULL;
		MathConverter* _tmp4_ = NULL;
		MathConverter* _tmp5_ = NULL;
		_tmp2_ = self->priv->equation;
		_tmp3_ = math_converter_new (_tmp2_);
		g_object_ref_sink (_tmp3_);
		_g_object_unref0 (self->priv->converter);
		self->priv->converter = _tmp3_;
		_tmp4_ = self->priv->converter;
		g_signal_connect_object (_tmp4_, "changed", (GCallback) _math_buttons_converter_changed_cb_math_converter_changed, self, 0);
		_tmp5_ = self->priv->converter;
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp5_, FALSE, TRUE, (guint) 0);
	}
	_tmp6_ = math_buttons_get_mode (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = math_buttons_load_mode (self, _tmp7_);
	panel = _tmp8_;
	_tmp9_ = self->priv->active_panel;
	_tmp10_ = panel;
	if (_tmp9_ == _tmp10_) {
		_g_object_unref0 (panel);
		return;
	}
	_tmp11_ = self->priv->active_panel;
	if (_tmp11_ != NULL) {
		GtkWidget* _tmp12_ = NULL;
		_tmp12_ = self->priv->active_panel;
		gtk_widget_hide (_tmp12_);
	}
	_tmp13_ = panel;
	_tmp14_ = _g_object_ref0 (_tmp13_);
	_g_object_unref0 (self->priv->active_panel);
	self->priv->active_panel = _tmp14_;
	_tmp15_ = panel;
	if (_tmp15_ != NULL) {
		GtkWidget* _tmp16_ = NULL;
		_tmp16_ = panel;
		gtk_widget_show (_tmp16_);
	}
	_g_object_unref0 (panel);
}


static void _math_buttons_button_menu_position_func_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self) {
	math_buttons_button_menu_position_func ((MathButtons*) self, menu, x, y, push_in);
}


static void math_buttons_popup_button_menu (MathButtons* self, GtkButton* button, GtkMenu* menu) {
	GtkMenu* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkMenu* _tmp3_ = NULL;
	guint32 _tmp4_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	g_return_if_fail (menu != NULL);
	_tmp0_ = menu;
	_tmp1_ = button;
	_tmp2_ = _g_object_ref0 ((GtkWidget*) _tmp1_);
	g_object_set_data_full ((GObject*) _tmp0_, "button", _tmp2_, g_object_unref);
	_tmp3_ = menu;
	_tmp4_ = gtk_get_current_event_time ();
	gtk_menu_popup (_tmp3_, NULL, NULL, _math_buttons_button_menu_position_func_gtk_menu_position_func, self, (guint) 1, _tmp4_);
}


static void math_buttons_button_menu_position_func (MathButtons* self, GtkMenu* menu, gint* x, gint* y, gboolean* push_in) {
	gint _vala_x = 0;
	gint _vala_y = 0;
	gboolean _vala_push_in = FALSE;
	GtkButton* button = NULL;
	GtkMenu* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	GtkButton* _tmp2_ = NULL;
	gint origin_x = 0;
	gint origin_y = 0;
	GdkWindow* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	guint border = 0U;
	guint _tmp6_ = 0U;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp7_ = {0};
	GtkAllocation _tmp8_ = {0};
	gint _tmp9_ = 0;
	GtkAllocation _tmp10_ = {0};
	gint _tmp11_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	_tmp0_ = menu;
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "button");
	_tmp2_ = _g_object_ref0 ((GtkButton*) _tmp1_);
	button = _tmp2_;
	_tmp3_ = gtk_widget_get_window ((GtkWidget*) button);
	gdk_window_get_origin (_tmp3_, &_tmp4_, &_tmp5_);
	origin_x = _tmp4_;
	origin_y = _tmp5_;
	_tmp6_ = gtk_container_get_border_width ((GtkContainer*) button);
	border = _tmp6_;
	gtk_widget_get_allocation ((GtkWidget*) button, &_tmp7_);
	allocation = _tmp7_;
	_tmp8_ = allocation;
	_tmp9_ = _tmp8_.x;
	_vala_x = (gint) ((origin_x + _tmp9_) + border);
	_tmp10_ = allocation;
	_tmp11_ = _tmp10_.y;
	_vala_y = (gint) ((origin_y + _tmp11_) + border);
	_vala_push_in = FALSE;
	_g_object_unref0 (button);
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (push_in) {
		*push_in = _vala_push_in;
	}
}


static void math_buttons_memory_cb (MathButtons* self, GtkWidget* widget) {
	MathVariablePopup* popup = NULL;
	MathEquation* _tmp0_ = NULL;
	MathVariablePopup* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	GtkAllocation allocation = {0};
	GtkWidget* _tmp4_ = NULL;
	GtkAllocation _tmp5_ = {0};
	gint x = 0;
	gint y = 0;
	GtkWidget* _tmp6_ = NULL;
	GdkWindow* _tmp7_ = NULL;
	GtkAllocation _tmp8_ = {0};
	gint _tmp9_ = 0;
	GtkAllocation _tmp10_ = {0};
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = math_variable_popup_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	popup = _tmp1_;
	_tmp2_ = widget;
	_tmp3_ = gtk_widget_get_toplevel (_tmp2_);
	gtk_window_set_transient_for ((GtkWindow*) popup, G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GTK_TYPE_WINDOW) ? ((GtkWindow*) _tmp3_) : NULL);
	_tmp4_ = widget;
	gtk_widget_get_allocation (_tmp4_, &_tmp5_);
	allocation = _tmp5_;
	_tmp6_ = widget;
	_tmp7_ = gtk_widget_get_window (_tmp6_);
	_tmp8_ = allocation;
	_tmp9_ = _tmp8_.x;
	_tmp10_ = allocation;
	_tmp11_ = _tmp10_.y;
	gdk_window_get_root_coords (_tmp7_, _tmp9_, _tmp11_, &_tmp12_, &_tmp13_);
	x = _tmp12_;
	y = _tmp13_;
	gtk_window_move ((GtkWindow*) popup, x, y);
	gtk_widget_show ((GtkWidget*) popup);
	_g_object_unref0 (popup);
}


static void ______lambda25_ (MathButtons* self, GtkMenuItem* widget) {
	MathEquation* _tmp0_ = NULL;
	GtkMenuItem* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = widget;
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "shiftcount");
	math_equation_shift (_tmp0_, (gint) ((gintptr) _tmp2_));
}


static void _______lambda25__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	______lambda25_ ((MathButtons*) self, _sender);
}


static void math_buttons_shift_left_cb (MathButtons* self, GtkButton* button) {
	GtkMenu* _tmp0_ = NULL;
	GtkButton* _tmp28_ = NULL;
	GtkMenu* _tmp29_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->shift_left_menu;
	if (_tmp0_ == NULL) {
		GtkMenu* _tmp1_ = NULL;
		GtkMenu* _tmp2_ = NULL;
		_tmp1_ = (GtkMenu*) gtk_menu_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->shift_left_menu);
		self->priv->shift_left_menu = _tmp1_;
		_tmp2_ = self->priv->shift_left_menu;
		gtk_menu_set_reserve_toggle_size (_tmp2_, FALSE);
		{
			gint i = 0;
			i = 1;
			{
				gboolean _tmp3_ = FALSE;
				_tmp3_ = TRUE;
				while (TRUE) {
					gint _tmp5_ = 0;
					gchar* format = NULL;
					gint _tmp6_ = 0;
					gchar* text = NULL;
					const gchar* _tmp13_ = NULL;
					gint _tmp14_ = 0;
					gchar* _tmp15_ = NULL;
					GtkLabel* label = NULL;
					const gchar* _tmp16_ = NULL;
					GtkLabel* _tmp17_ = NULL;
					GtkMenuItem* item = NULL;
					GtkMenuItem* _tmp18_ = NULL;
					GtkMenuItem* _tmp19_ = NULL;
					gint _tmp20_ = 0;
					GtkMenuItem* _tmp21_ = NULL;
					GtkLabel* _tmp22_ = NULL;
					GtkMenu* _tmp23_ = NULL;
					GtkMenuItem* _tmp24_ = NULL;
					GtkMenuItem* _tmp25_ = NULL;
					GtkLabel* _tmp26_ = NULL;
					GtkMenuItem* _tmp27_ = NULL;
					if (!_tmp3_) {
						gint _tmp4_ = 0;
						_tmp4_ = i;
						i = _tmp4_ + 1;
					}
					_tmp3_ = FALSE;
					_tmp5_ = i;
					if (!(_tmp5_ < 16)) {
						break;
					}
					_tmp6_ = i;
					if (_tmp6_ < 10) {
						gint _tmp7_ = 0;
						const gchar* _tmp8_ = NULL;
						gchar* _tmp9_ = NULL;
						_tmp7_ = i;
						_tmp8_ = ngettext ("_%d place", "_%d places", (gulong) _tmp7_);
						_tmp9_ = g_strdup (_tmp8_);
						_g_free0 (format);
						format = _tmp9_;
					} else {
						gint _tmp10_ = 0;
						const gchar* _tmp11_ = NULL;
						gchar* _tmp12_ = NULL;
						_tmp10_ = i;
						_tmp11_ = ngettext ("%d place", "%d places", (gulong) _tmp10_);
						_tmp12_ = g_strdup (_tmp11_);
						_g_free0 (format);
						format = _tmp12_;
					}
					_tmp13_ = format;
					_tmp14_ = i;
					_tmp15_ = g_strdup_printf (_tmp13_, _tmp14_);
					text = _tmp15_;
					_tmp16_ = text;
					_tmp17_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp16_);
					g_object_ref_sink (_tmp17_);
					label = _tmp17_;
					_tmp18_ = (GtkMenuItem*) gtk_menu_item_new ();
					g_object_ref_sink (_tmp18_);
					item = _tmp18_;
					_tmp19_ = item;
					_tmp20_ = i;
					g_object_set_data_full ((GObject*) _tmp19_, "shiftcount", (gpointer) ((gintptr) _tmp20_), NULL);
					_tmp21_ = item;
					_tmp22_ = label;
					gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp22_);
					_tmp23_ = self->priv->shift_left_menu;
					_tmp24_ = item;
					gtk_menu_shell_append ((GtkMenuShell*) _tmp23_, (GtkWidget*) _tmp24_);
					_tmp25_ = item;
					g_signal_connect_object (_tmp25_, "activate", (GCallback) _______lambda25__gtk_menu_item_activate, self, 0);
					_tmp26_ = label;
					gtk_widget_show ((GtkWidget*) _tmp26_);
					_tmp27_ = item;
					gtk_widget_show ((GtkWidget*) _tmp27_);
					_g_object_unref0 (item);
					_g_object_unref0 (label);
					_g_free0 (text);
					_g_free0 (format);
				}
			}
		}
	}
	_tmp28_ = button;
	_tmp29_ = self->priv->shift_left_menu;
	math_buttons_popup_button_menu (self, _tmp28_, _tmp29_);
}


static void ______lambda26_ (MathButtons* self, GtkMenuItem* widget) {
	MathEquation* _tmp0_ = NULL;
	GtkMenuItem* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = widget;
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "shiftcount");
	math_equation_shift (_tmp0_, (gint) ((gintptr) _tmp2_));
}


static void _______lambda26__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	______lambda26_ ((MathButtons*) self, _sender);
}


static void math_buttons_shift_right_cb (MathButtons* self, GtkButton* button) {
	GtkMenu* _tmp0_ = NULL;
	GtkButton* _tmp28_ = NULL;
	GtkMenu* _tmp29_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->shift_right_menu;
	if (_tmp0_ == NULL) {
		GtkMenu* _tmp1_ = NULL;
		GtkMenu* _tmp2_ = NULL;
		_tmp1_ = (GtkMenu*) gtk_menu_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->shift_right_menu);
		self->priv->shift_right_menu = _tmp1_;
		_tmp2_ = self->priv->shift_right_menu;
		gtk_menu_set_reserve_toggle_size (_tmp2_, FALSE);
		{
			gint i = 0;
			i = 1;
			{
				gboolean _tmp3_ = FALSE;
				_tmp3_ = TRUE;
				while (TRUE) {
					gint _tmp5_ = 0;
					gchar* format = NULL;
					gint _tmp6_ = 0;
					gchar* text = NULL;
					const gchar* _tmp13_ = NULL;
					gint _tmp14_ = 0;
					gchar* _tmp15_ = NULL;
					GtkLabel* label = NULL;
					const gchar* _tmp16_ = NULL;
					GtkLabel* _tmp17_ = NULL;
					GtkMenuItem* item = NULL;
					GtkMenuItem* _tmp18_ = NULL;
					GtkMenuItem* _tmp19_ = NULL;
					gint _tmp20_ = 0;
					GtkMenuItem* _tmp21_ = NULL;
					GtkLabel* _tmp22_ = NULL;
					GtkMenu* _tmp23_ = NULL;
					GtkMenuItem* _tmp24_ = NULL;
					GtkMenuItem* _tmp25_ = NULL;
					GtkLabel* _tmp26_ = NULL;
					GtkMenuItem* _tmp27_ = NULL;
					if (!_tmp3_) {
						gint _tmp4_ = 0;
						_tmp4_ = i;
						i = _tmp4_ + 1;
					}
					_tmp3_ = FALSE;
					_tmp5_ = i;
					if (!(_tmp5_ < 16)) {
						break;
					}
					_tmp6_ = i;
					if (_tmp6_ < 10) {
						gint _tmp7_ = 0;
						const gchar* _tmp8_ = NULL;
						gchar* _tmp9_ = NULL;
						_tmp7_ = i;
						_tmp8_ = ngettext ("_%d place", "_%d places", (gulong) _tmp7_);
						_tmp9_ = g_strdup (_tmp8_);
						_g_free0 (format);
						format = _tmp9_;
					} else {
						gint _tmp10_ = 0;
						const gchar* _tmp11_ = NULL;
						gchar* _tmp12_ = NULL;
						_tmp10_ = i;
						_tmp11_ = ngettext ("%d place", "%d places", (gulong) _tmp10_);
						_tmp12_ = g_strdup (_tmp11_);
						_g_free0 (format);
						format = _tmp12_;
					}
					_tmp13_ = format;
					_tmp14_ = i;
					_tmp15_ = g_strdup_printf (_tmp13_, _tmp14_);
					text = _tmp15_;
					_tmp16_ = text;
					_tmp17_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp16_);
					g_object_ref_sink (_tmp17_);
					label = _tmp17_;
					_tmp18_ = (GtkMenuItem*) gtk_menu_item_new ();
					g_object_ref_sink (_tmp18_);
					item = _tmp18_;
					_tmp19_ = item;
					_tmp20_ = i;
					g_object_set_data_full ((GObject*) _tmp19_, "shiftcount", (gpointer) ((gintptr) (-_tmp20_)), NULL);
					_tmp21_ = item;
					_tmp22_ = label;
					gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp22_);
					_tmp23_ = self->priv->shift_right_menu;
					_tmp24_ = item;
					gtk_menu_shell_append ((GtkMenuShell*) _tmp23_, (GtkWidget*) _tmp24_);
					_tmp25_ = item;
					g_signal_connect_object (_tmp25_, "activate", (GCallback) _______lambda26__gtk_menu_item_activate, self, 0);
					_tmp26_ = label;
					gtk_widget_show ((GtkWidget*) _tmp26_);
					_tmp27_ = item;
					gtk_widget_show ((GtkWidget*) _tmp27_);
					_g_object_unref0 (item);
					_g_object_unref0 (label);
					_g_free0 (text);
					_g_free0 (format);
				}
			}
		}
	}
	_tmp28_ = button;
	_tmp29_ = self->priv->shift_right_menu;
	math_buttons_popup_button_menu (self, _tmp28_, _tmp29_);
}


static void math_buttons_function_cb (MathButtons* self, GtkButton* button) {
	GtkMenu* _tmp0_ = NULL;
	GtkButton* _tmp15_ = NULL;
	GtkMenu* _tmp16_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->function_menu;
	if (_tmp0_ == NULL) {
		GtkMenu* _tmp1_ = NULL;
		GtkMenu* _tmp2_ = NULL;
		GtkMenu* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		GtkMenu* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		GtkMenu* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		GtkMenu* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		GtkMenu* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		GtkMenu* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		_tmp1_ = (GtkMenu*) gtk_menu_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->function_menu);
		self->priv->function_menu = _tmp1_;
		_tmp2_ = self->priv->function_menu;
		gtk_menu_set_reserve_toggle_size (_tmp2_, FALSE);
		_tmp3_ = self->priv->function_menu;
		_tmp4_ = _ ("Integer Component");
		math_buttons_add_function_menu_item (self, _tmp3_, _tmp4_, "int ");
		_tmp5_ = self->priv->function_menu;
		_tmp6_ = _ ("Fractional Component");
		math_buttons_add_function_menu_item (self, _tmp5_, _tmp6_, "frac ");
		_tmp7_ = self->priv->function_menu;
		_tmp8_ = _ ("Round");
		math_buttons_add_function_menu_item (self, _tmp7_, _tmp8_, "round ");
		_tmp9_ = self->priv->function_menu;
		_tmp10_ = _ ("Floor");
		math_buttons_add_function_menu_item (self, _tmp9_, _tmp10_, "floor ");
		_tmp11_ = self->priv->function_menu;
		_tmp12_ = _ ("Ceiling");
		math_buttons_add_function_menu_item (self, _tmp11_, _tmp12_, "ceil ");
		_tmp13_ = self->priv->function_menu;
		_tmp14_ = _ ("Sign");
		math_buttons_add_function_menu_item (self, _tmp13_, _tmp14_, "sgn ");
	}
	_tmp15_ = button;
	_tmp16_ = self->priv->function_menu;
	math_buttons_popup_button_menu (self, _tmp15_, _tmp16_);
}


static void __lambda22_ (MathButtons* self, GtkMenuItem* widget) {
	MathEquation* _tmp0_ = NULL;
	GtkMenuItem* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = widget;
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "function");
	math_equation_insert (_tmp0_, (const gchar*) _tmp2_);
}


static void ___lambda22__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda22_ ((MathButtons*) self, _sender);
}


static void math_buttons_add_function_menu_item (MathButtons* self, GtkMenu* menu, const gchar* label, const gchar* function) {
	GtkMenuItem* item = NULL;
	const gchar* _tmp0_ = NULL;
	GtkMenuItem* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GtkMenu* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	g_return_if_fail (label != NULL);
	g_return_if_fail (function != NULL);
	_tmp0_ = label;
	_tmp1_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp0_);
	g_object_ref_sink (_tmp1_);
	item = _tmp1_;
	_tmp2_ = function;
	_tmp3_ = g_strdup (_tmp2_);
	g_object_set_data_full ((GObject*) item, "function", _tmp3_, g_free);
	_tmp4_ = menu;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp4_, (GtkWidget*) item);
	g_signal_connect_object (item, "activate", (GCallback) ___lambda22__gtk_menu_item_activate, self, 0);
	gtk_widget_show ((GtkWidget*) item);
	_g_object_unref0 (item);
}


static void math_buttons_finc_cb (MathButtons* self, GtkWidget* widget) {
	gchar* name = NULL;
	GtkWidget* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GtkDialog* dialog = NULL;
	GtkBuilder* _tmp3_ = NULL;
	GObject* _tmp4_ = NULL;
	GtkDialog* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "finc-dialog-name");
	_tmp2_ = g_strdup ((const gchar*) _tmp1_);
	name = _tmp2_;
	_tmp3_ = self->priv->financial_ui;
	_tmp4_ = gtk_builder_get_object (_tmp3_, name);
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, GTK_TYPE_DIALOG) ? ((GtkDialog*) _tmp4_) : NULL);
	dialog = _tmp5_;
	gtk_dialog_run (dialog);
	gtk_widget_hide ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
	_g_free0 (name);
}


static void math_buttons_insert_character_code_cb (MathButtons* self, GtkWidget* widget) {
	GtkDialog* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->character_code_dialog;
	gtk_window_present ((GtkWindow*) _tmp0_);
}


static void math_buttons_finc_activate_cb (MathButtons* self, GtkWidget* widget) {
	GtkEntry* next_entry = NULL;
	GtkWidget* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	GtkEntry* _tmp2_ = NULL;
	GtkEntry* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "next-entry");
	_tmp2_ = _g_object_ref0 ((GtkEntry*) _tmp1_);
	next_entry = _tmp2_;
	_tmp3_ = next_entry;
	if (_tmp3_ == NULL) {
		GtkDialog* dialog = NULL;
		GtkWidget* _tmp4_ = NULL;
		GtkWidget* _tmp5_ = NULL;
		GtkDialog* _tmp6_ = NULL;
		GtkDialog* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		_tmp4_ = widget;
		_tmp5_ = gtk_widget_get_toplevel (_tmp4_);
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, GTK_TYPE_DIALOG) ? ((GtkDialog*) _tmp5_) : NULL);
		dialog = _tmp6_;
		_tmp7_ = dialog;
		_tmp8_ = gtk_widget_is_toplevel ((GtkWidget*) _tmp7_);
		if (_tmp8_) {
			GtkDialog* _tmp9_ = NULL;
			_tmp9_ = dialog;
			gtk_dialog_response (_tmp9_, (gint) GTK_RESPONSE_OK);
			_g_object_unref0 (dialog);
			_g_object_unref0 (next_entry);
			return;
		}
		_g_object_unref0 (dialog);
	} else {
		GtkEntry* _tmp10_ = NULL;
		_tmp10_ = next_entry;
		gtk_widget_grab_focus ((GtkWidget*) _tmp10_);
	}
	_g_object_unref0 (next_entry);
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup5 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup6 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup7 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup8 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup9 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** _vala_array_dup10 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void math_buttons_finc_response_cb (MathButtons* self, GtkWidget* widget, gint response_id) {
	gint _tmp0_ = 0;
	FinancialDialog function = 0;
	GtkWidget* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	gchar** entries = NULL;
	gchar** _tmp3_ = NULL;
	gint entries_length1 = 0;
	gint _entries_size_ = 0;
	FinancialDialog _tmp4_ = 0;
	Number* arg[4] = {0};
	Number* _tmp15_ = NULL;
	Number* _tmp16_ = NULL;
	Number* _tmp17_ = NULL;
	Number* _tmp18_ = NULL;
	Number* _tmp19_[4] = {0};
	GtkEntry* first_entry = NULL;
	GtkBuilder* _tmp36_ = NULL;
	gchar** _tmp37_ = NULL;
	gint _tmp37__length1 = 0;
	const gchar* _tmp38_ = NULL;
	GObject* _tmp39_ = NULL;
	GtkEntry* _tmp40_ = NULL;
	GtkEntry* _tmp41_ = NULL;
	MathEquation* _tmp42_ = NULL;
	FinancialDialog _tmp43_ = 0;
	Number* _tmp44_ = NULL;
	Number* _tmp45_ = NULL;
	Number* _tmp46_ = NULL;
	Number* _tmp47_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = response_id;
	if (_tmp0_ != ((gint) GTK_RESPONSE_OK)) {
		return;
	}
	_tmp1_ = widget;
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "finc-function");
	function = (FinancialDialog) ((gint) ((gintptr) _tmp2_));
	_tmp3_ = g_new0 (gchar*, 0 + 1);
	entries = _tmp3_;
	entries_length1 = 0;
	_entries_size_ = entries_length1;
	_tmp4_ = function;
	switch (_tmp4_) {
		case FINANCIAL_DIALOG_CTRM_DIALOG:
		{
			gchar** _tmp5_ = NULL;
			gint _tmp5__length1 = 0;
			_tmp5_ = (MATH_BUTTONS_ctrm_entries != NULL) ? _vala_array_dup1 (MATH_BUTTONS_ctrm_entries, G_N_ELEMENTS (MATH_BUTTONS_ctrm_entries)) : ((gpointer) MATH_BUTTONS_ctrm_entries);
			_tmp5__length1 = G_N_ELEMENTS (MATH_BUTTONS_ctrm_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp5_;
			entries_length1 = _tmp5__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_DDB_DIALOG:
		{
			gchar** _tmp6_ = NULL;
			gint _tmp6__length1 = 0;
			_tmp6_ = (MATH_BUTTONS_ddb_entries != NULL) ? _vala_array_dup2 (MATH_BUTTONS_ddb_entries, G_N_ELEMENTS (MATH_BUTTONS_ddb_entries)) : ((gpointer) MATH_BUTTONS_ddb_entries);
			_tmp6__length1 = G_N_ELEMENTS (MATH_BUTTONS_ddb_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp6_;
			entries_length1 = _tmp6__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_FV_DIALOG:
		{
			gchar** _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
			_tmp7_ = (MATH_BUTTONS_fv_entries != NULL) ? _vala_array_dup3 (MATH_BUTTONS_fv_entries, G_N_ELEMENTS (MATH_BUTTONS_fv_entries)) : ((gpointer) MATH_BUTTONS_fv_entries);
			_tmp7__length1 = G_N_ELEMENTS (MATH_BUTTONS_fv_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp7_;
			entries_length1 = _tmp7__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_GPM_DIALOG:
		{
			gchar** _tmp8_ = NULL;
			gint _tmp8__length1 = 0;
			_tmp8_ = (MATH_BUTTONS_gpm_entries != NULL) ? _vala_array_dup4 (MATH_BUTTONS_gpm_entries, G_N_ELEMENTS (MATH_BUTTONS_gpm_entries)) : ((gpointer) MATH_BUTTONS_gpm_entries);
			_tmp8__length1 = G_N_ELEMENTS (MATH_BUTTONS_gpm_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp8_;
			entries_length1 = _tmp8__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_PMT_DIALOG:
		{
			gchar** _tmp9_ = NULL;
			gint _tmp9__length1 = 0;
			_tmp9_ = (MATH_BUTTONS_pmt_entries != NULL) ? _vala_array_dup5 (MATH_BUTTONS_pmt_entries, G_N_ELEMENTS (MATH_BUTTONS_pmt_entries)) : ((gpointer) MATH_BUTTONS_pmt_entries);
			_tmp9__length1 = G_N_ELEMENTS (MATH_BUTTONS_pmt_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp9_;
			entries_length1 = _tmp9__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_PV_DIALOG:
		{
			gchar** _tmp10_ = NULL;
			gint _tmp10__length1 = 0;
			_tmp10_ = (MATH_BUTTONS_pv_entries != NULL) ? _vala_array_dup6 (MATH_BUTTONS_pv_entries, G_N_ELEMENTS (MATH_BUTTONS_pv_entries)) : ((gpointer) MATH_BUTTONS_pv_entries);
			_tmp10__length1 = G_N_ELEMENTS (MATH_BUTTONS_pv_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp10_;
			entries_length1 = _tmp10__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_RATE_DIALOG:
		{
			gchar** _tmp11_ = NULL;
			gint _tmp11__length1 = 0;
			_tmp11_ = (MATH_BUTTONS_rate_entries != NULL) ? _vala_array_dup7 (MATH_BUTTONS_rate_entries, G_N_ELEMENTS (MATH_BUTTONS_rate_entries)) : ((gpointer) MATH_BUTTONS_rate_entries);
			_tmp11__length1 = G_N_ELEMENTS (MATH_BUTTONS_rate_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp11_;
			entries_length1 = _tmp11__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_SLN_DIALOG:
		{
			gchar** _tmp12_ = NULL;
			gint _tmp12__length1 = 0;
			_tmp12_ = (MATH_BUTTONS_sln_entries != NULL) ? _vala_array_dup8 (MATH_BUTTONS_sln_entries, G_N_ELEMENTS (MATH_BUTTONS_sln_entries)) : ((gpointer) MATH_BUTTONS_sln_entries);
			_tmp12__length1 = G_N_ELEMENTS (MATH_BUTTONS_sln_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp12_;
			entries_length1 = _tmp12__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_SYD_DIALOG:
		{
			gchar** _tmp13_ = NULL;
			gint _tmp13__length1 = 0;
			_tmp13_ = (MATH_BUTTONS_syd_entries != NULL) ? _vala_array_dup9 (MATH_BUTTONS_syd_entries, G_N_ELEMENTS (MATH_BUTTONS_syd_entries)) : ((gpointer) MATH_BUTTONS_syd_entries);
			_tmp13__length1 = G_N_ELEMENTS (MATH_BUTTONS_syd_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp13_;
			entries_length1 = _tmp13__length1;
			_entries_size_ = entries_length1;
			break;
		}
		case FINANCIAL_DIALOG_TERM_DIALOG:
		{
			gchar** _tmp14_ = NULL;
			gint _tmp14__length1 = 0;
			_tmp14_ = (MATH_BUTTONS_term_entries != NULL) ? _vala_array_dup10 (MATH_BUTTONS_term_entries, G_N_ELEMENTS (MATH_BUTTONS_term_entries)) : ((gpointer) MATH_BUTTONS_term_entries);
			_tmp14__length1 = G_N_ELEMENTS (MATH_BUTTONS_term_entries);
			entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
			entries = _tmp14_;
			entries_length1 = _tmp14__length1;
			_entries_size_ = entries_length1;
			break;
		}
		default:
		break;
	}
	_tmp15_ = number_new_integer ((gint64) 0);
	_tmp16_ = number_new_integer ((gint64) 0);
	_tmp17_ = number_new_integer ((gint64) 0);
	_tmp18_ = number_new_integer ((gint64) 0);
	_tmp19_[0] = _tmp15_;
	_tmp19_[1] = _tmp16_;
	_tmp19_[2] = _tmp17_;
	_tmp19_[3] = _tmp18_;
	memcpy (arg, _tmp19_, 4 * sizeof (Number*));
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp20_ = FALSE;
			_tmp20_ = TRUE;
			while (TRUE) {
				gint _tmp22_ = 0;
				gchar** _tmp23_ = NULL;
				gint _tmp23__length1 = 0;
				GtkEntry* entry = NULL;
				GtkBuilder* _tmp24_ = NULL;
				gchar** _tmp25_ = NULL;
				gint _tmp25__length1 = 0;
				gint _tmp26_ = 0;
				const gchar* _tmp27_ = NULL;
				GObject* _tmp28_ = NULL;
				GtkEntry* _tmp29_ = NULL;
				gint _tmp30_ = 0;
				GtkEntry* _tmp31_ = NULL;
				const gchar* _tmp32_ = NULL;
				Number* _tmp33_ = NULL;
				Number* _tmp34_ = NULL;
				GtkEntry* _tmp35_ = NULL;
				if (!_tmp20_) {
					gint _tmp21_ = 0;
					_tmp21_ = i;
					i = _tmp21_ + 1;
				}
				_tmp20_ = FALSE;
				_tmp22_ = i;
				_tmp23_ = entries;
				_tmp23__length1 = entries_length1;
				if (!(_tmp22_ < _tmp23__length1)) {
					break;
				}
				_tmp24_ = self->priv->financial_ui;
				_tmp25_ = entries;
				_tmp25__length1 = entries_length1;
				_tmp26_ = i;
				_tmp27_ = _tmp25_[_tmp26_];
				_tmp28_ = gtk_builder_get_object (_tmp24_, _tmp27_);
				_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, GTK_TYPE_ENTRY) ? ((GtkEntry*) _tmp28_) : NULL);
				entry = _tmp29_;
				_tmp30_ = i;
				_tmp31_ = entry;
				_tmp32_ = gtk_entry_get_text (_tmp31_);
				_tmp33_ = mp_set_from_string (_tmp32_, 10);
				_number_unref0 (arg[_tmp30_]);
				arg[_tmp30_] = _tmp33_;
				_tmp34_ = arg[_tmp30_];
				_tmp35_ = entry;
				gtk_entry_set_text (_tmp35_, "0");
				_g_object_unref0 (entry);
			}
		}
	}
	_tmp36_ = self->priv->financial_ui;
	_tmp37_ = entries;
	_tmp37__length1 = entries_length1;
	_tmp38_ = _tmp37_[0];
	_tmp39_ = gtk_builder_get_object (_tmp36_, _tmp38_);
	_tmp40_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp39_, GTK_TYPE_ENTRY) ? ((GtkEntry*) _tmp39_) : NULL);
	first_entry = _tmp40_;
	_tmp41_ = first_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp41_);
	_tmp42_ = self->priv->equation;
	_tmp43_ = function;
	_tmp44_ = arg[0];
	_tmp45_ = arg[1];
	_tmp46_ = arg[2];
	_tmp47_ = arg[3];
	do_finc_expression (_tmp42_, _tmp43_, _tmp44_, _tmp45_, _tmp46_, _tmp47_);
	_g_object_unref0 (first_entry);
	_vala_array_destroy (arg, 4, (GDestroyNotify) number_unref);
	entries = (_vala_array_free (entries, entries_length1, (GDestroyNotify) g_free), NULL);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void math_buttons_character_code_dialog_response_cb (MathButtons* self, GtkWidget* dialog, gint response_id) {
	gchar* text = NULL;
	GtkEntry* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GtkWidget* _tmp21_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	_tmp0_ = self->priv->character_code_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	text = _tmp2_;
	_tmp3_ = response_id;
	if (_tmp3_ == ((gint) GTK_RESPONSE_OK)) {
		Number* x = NULL;
		Number* _tmp4_ = NULL;
		MathEquation* _tmp19_ = NULL;
		Number* _tmp20_ = NULL;
		_tmp4_ = number_new_integer ((gint64) 0);
		x = _tmp4_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					const gchar* _tmp7_ = NULL;
					gint _tmp8_ = 0;
					gchar _tmp9_ = '\0';
					Number* _tmp10_ = NULL;
					const gchar* _tmp11_ = NULL;
					gint _tmp12_ = 0;
					gchar _tmp13_ = '\0';
					Number* _tmp14_ = NULL;
					Number* _tmp15_ = NULL;
					Number* _tmp16_ = NULL;
					Number* _tmp17_ = NULL;
					Number* _tmp18_ = NULL;
					if (!_tmp5_) {
						gint _tmp6_ = 0;
						_tmp6_ = i;
						i = _tmp6_ + 1;
					}
					_tmp5_ = FALSE;
					_tmp7_ = text;
					_tmp8_ = i;
					_tmp9_ = string_get (_tmp7_, (glong) _tmp8_);
					if (!(_tmp9_ != '\0')) {
						break;
					}
					_tmp10_ = x;
					_tmp11_ = text;
					_tmp12_ = i;
					_tmp13_ = string_get (_tmp11_, (glong) _tmp12_);
					_tmp14_ = number_new_integer ((gint64) _tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = number_add (_tmp10_, _tmp15_);
					_number_unref0 (x);
					x = _tmp16_;
					_number_unref0 (_tmp15_);
					_tmp17_ = x;
					_tmp18_ = number_shift (_tmp17_, 8);
					_number_unref0 (x);
					x = _tmp18_;
				}
			}
		}
		_tmp19_ = self->priv->equation;
		_tmp20_ = x;
		math_equation_insert_number (_tmp19_, _tmp20_);
		_number_unref0 (x);
	}
	_tmp21_ = dialog;
	gtk_widget_hide (_tmp21_);
	_g_free0 (text);
}


static void math_buttons_character_code_dialog_activate_cb (MathButtons* self, GtkWidget* entry) {
	GtkDialog* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	_tmp0_ = self->priv->character_code_dialog;
	math_buttons_character_code_dialog_response_cb (self, (GtkWidget*) _tmp0_, (gint) GTK_RESPONSE_OK);
}


static gboolean math_buttons_character_code_dialog_delete_cb (MathButtons* self, GtkWidget* dialog, GdkEventAny* event) {
	gboolean result = FALSE;
	GtkWidget* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dialog != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = dialog;
	math_buttons_character_code_dialog_response_cb (self, _tmp0_, (gint) GTK_RESPONSE_CANCEL);
	result = TRUE;
	return result;
}


static gboolean math_buttons_bit_toggle_cb (MathButtons* self, GtkWidget* event_box, GdkEventButton* event) {
	gboolean result = FALSE;
	MathEquation* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event_box != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->equation;
	_tmp1_ = event_box;
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "bit_index");
	math_equation_toggle_bit (_tmp0_, (guint) ((gint) ((gintptr) _tmp2_)));
	result = TRUE;
	return result;
}


static void math_buttons_remove_trailing_spaces (MathButtons* self) {
	GtkTextMark* insert_mark = NULL;
	MathEquation* _tmp0_ = NULL;
	GtkTextMark* _tmp1_ = NULL;
	GtkTextMark* _tmp2_ = NULL;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	MathEquation* _tmp3_ = NULL;
	GtkTextMark* _tmp4_ = NULL;
	GtkTextIter _tmp5_ = {0};
	GtkTextIter _tmp6_ = {0};
	MathEquation* _tmp10_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	insert_mark = _tmp2_;
	_tmp3_ = self->priv->equation;
	_tmp4_ = insert_mark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp3_, &_tmp5_, _tmp4_);
	end = _tmp5_;
	_tmp6_ = end;
	start = _tmp6_;
	while (TRUE) {
		gboolean _tmp7_ = FALSE;
		gunichar _tmp8_ = 0U;
		gboolean _tmp9_ = FALSE;
		_tmp7_ = gtk_text_iter_backward_char (&start);
		if (!_tmp7_) {
			break;
		}
		_tmp8_ = gtk_text_iter_get_char (&start);
		_tmp9_ = g_unichar_isspace (_tmp8_);
		if (!_tmp9_) {
			gtk_text_iter_forward_char (&start);
			break;
		}
	}
	_tmp10_ = self->priv->equation;
	gtk_text_buffer_delete ((GtkTextBuffer*) _tmp10_, &start, &end);
	_g_object_unref0 (insert_mark);
}


static void math_buttons_set_superscript_cb (MathButtons* self, GtkButton* widget) {
	GtkToggleButton* button = NULL;
	GtkButton* _tmp0_ = NULL;
	GtkToggleButton* _tmp1_ = NULL;
	GtkToggleButton* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GTK_TYPE_TOGGLE_BUTTON) ? ((GtkToggleButton*) _tmp0_) : NULL);
	button = _tmp1_;
	_tmp2_ = button;
	_tmp3_ = gtk_toggle_button_get_active (_tmp2_);
	if (_tmp3_) {
		MathEquation* _tmp4_ = NULL;
		MathEquation* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		_tmp4_ = self->priv->equation;
		math_equation_set_number_mode (_tmp4_, NUMBER_MODE_SUPERSCRIPT);
		_tmp5_ = self->priv->equation;
		_tmp6_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) _tmp5_);
		_tmp7_ = _tmp6_;
		if (!_tmp7_) {
			math_buttons_remove_trailing_spaces (self);
		}
	} else {
		MathEquation* _tmp8_ = NULL;
		NumberMode _tmp9_ = 0;
		NumberMode _tmp10_ = 0;
		_tmp8_ = self->priv->equation;
		_tmp9_ = math_equation_get_number_mode (_tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_ == NUMBER_MODE_SUPERSCRIPT) {
			MathEquation* _tmp11_ = NULL;
			_tmp11_ = self->priv->equation;
			math_equation_set_number_mode (_tmp11_, NUMBER_MODE_NORMAL);
		}
	}
	_g_object_unref0 (button);
}


static void math_buttons_set_subscript_cb (MathButtons* self, GtkButton* widget) {
	GtkToggleButton* button = NULL;
	GtkButton* _tmp0_ = NULL;
	GtkToggleButton* _tmp1_ = NULL;
	GtkToggleButton* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, GTK_TYPE_TOGGLE_BUTTON) ? ((GtkToggleButton*) _tmp0_) : NULL);
	button = _tmp1_;
	_tmp2_ = button;
	_tmp3_ = gtk_toggle_button_get_active (_tmp2_);
	if (_tmp3_) {
		MathEquation* _tmp4_ = NULL;
		MathEquation* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		_tmp4_ = self->priv->equation;
		math_equation_set_number_mode (_tmp4_, NUMBER_MODE_SUBSCRIPT);
		_tmp5_ = self->priv->equation;
		_tmp6_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) _tmp5_);
		_tmp7_ = _tmp6_;
		if (!_tmp7_) {
			math_buttons_remove_trailing_spaces (self);
		}
	} else {
		MathEquation* _tmp8_ = NULL;
		NumberMode _tmp9_ = 0;
		NumberMode _tmp10_ = 0;
		_tmp8_ = self->priv->equation;
		_tmp9_ = math_equation_get_number_mode (_tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_ == NUMBER_MODE_SUBSCRIPT) {
			MathEquation* _tmp11_ = NULL;
			_tmp11_ = self->priv->equation;
			math_equation_set_number_mode (_tmp11_, NUMBER_MODE_NORMAL);
		}
	}
	_g_object_unref0 (button);
}


static void math_buttons_number_mode_changed_cb (MathButtons* self) {
	NumberMode mode = 0;
	MathEquation* _tmp0_ = NULL;
	NumberMode _tmp1_ = 0;
	NumberMode _tmp2_ = 0;
	GList* _tmp3_ = NULL;
	GList* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = math_equation_get_number_mode (_tmp0_);
	_tmp2_ = _tmp1_;
	mode = _tmp2_;
	_tmp3_ = self->priv->superscript_toggles;
	{
		GList* toggle_collection = NULL;
		GList* toggle_it = NULL;
		toggle_collection = _tmp3_;
		for (toggle_it = toggle_collection; toggle_it != NULL; toggle_it = toggle_it->next) {
			GtkToggleButton* _tmp4_ = NULL;
			GtkToggleButton* toggle = NULL;
			_tmp4_ = _g_object_ref0 ((GtkToggleButton*) toggle_it->data);
			toggle = _tmp4_;
			{
				GtkToggleButton* _tmp5_ = NULL;
				NumberMode _tmp6_ = 0;
				_tmp5_ = toggle;
				_tmp6_ = mode;
				gtk_toggle_button_set_active (_tmp5_, _tmp6_ == NUMBER_MODE_SUPERSCRIPT);
				_g_object_unref0 (toggle);
			}
		}
	}
	_tmp7_ = self->priv->subscript_toggles;
	{
		GList* toggle_collection = NULL;
		GList* toggle_it = NULL;
		toggle_collection = _tmp7_;
		for (toggle_it = toggle_collection; toggle_it != NULL; toggle_it = toggle_it->next) {
			GtkToggleButton* _tmp8_ = NULL;
			GtkToggleButton* toggle = NULL;
			_tmp8_ = _g_object_ref0 ((GtkToggleButton*) toggle_it->data);
			toggle = _tmp8_;
			{
				GtkToggleButton* _tmp9_ = NULL;
				NumberMode _tmp10_ = 0;
				_tmp9_ = toggle;
				_tmp10_ = mode;
				gtk_toggle_button_set_active (_tmp9_, _tmp10_ == NUMBER_MODE_SUBSCRIPT);
				_g_object_unref0 (toggle);
			}
		}
	}
}


ButtonMode math_buttons_get_mode (MathButtons* self) {
	ButtonMode result;
	ButtonMode _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_mode;
	result = _tmp0_;
	return result;
}


void math_buttons_set_mode (MathButtons* self, ButtonMode value) {
	ButtonMode _tmp0_ = 0;
	ButtonMode _tmp1_ = 0;
	ButtonMode _tmp2_ = 0;
	ButtonMode _tmp3_ = 0;
	ButtonMode _tmp4_ = 0;
	gboolean _tmp8_ = FALSE;
	ButtonMode _tmp9_ = 0;
	ButtonMode _tmp10_ = 0;
	MathConverter* _tmp13_ = NULL;
	ButtonMode _tmp14_ = 0;
	ButtonMode _tmp15_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_mode;
	_tmp1_ = value;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = value;
	self->priv->_mode = _tmp2_;
	_tmp3_ = math_buttons_get_mode (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == BUTTON_MODE_PROGRAMMING) {
		MathEquation* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		_tmp5_ = self->priv->equation;
		_tmp6_ = self->priv->_programming_base;
		math_equation_set_number_base (_tmp5_, _tmp6_);
	} else {
		MathEquation* _tmp7_ = NULL;
		_tmp7_ = self->priv->equation;
		math_equation_set_number_base (_tmp7_, 10);
	}
	math_buttons_load_buttons (self);
	_tmp9_ = math_buttons_get_mode (self);
	_tmp10_ = _tmp9_;
	if (_tmp10_ == BUTTON_MODE_ADVANCED) {
		_tmp8_ = TRUE;
	} else {
		ButtonMode _tmp11_ = 0;
		ButtonMode _tmp12_ = 0;
		_tmp11_ = math_buttons_get_mode (self);
		_tmp12_ = _tmp11_;
		_tmp8_ = _tmp12_ == BUTTON_MODE_FINANCIAL;
	}
	_tmp13_ = self->priv->converter;
	gtk_widget_set_visible ((GtkWidget*) _tmp13_, _tmp8_);
	_tmp14_ = math_buttons_get_mode (self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ == BUTTON_MODE_ADVANCED) {
		MathConverter* _tmp16_ = NULL;
		MathConverter* _tmp17_ = NULL;
		MathEquation* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		MathEquation* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		_tmp16_ = self->priv->converter;
		math_converter_set_category (_tmp16_, NULL);
		_tmp17_ = self->priv->converter;
		_tmp18_ = self->priv->equation;
		_tmp19_ = math_equation_get_source_units (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = _tmp20_;
		_tmp22_ = self->priv->equation;
		_tmp23_ = math_equation_get_target_units (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = _tmp24_;
		math_converter_set_conversion (_tmp17_, _tmp21_, _tmp25_);
		_g_free0 (_tmp25_);
		_g_free0 (_tmp21_);
	} else {
		ButtonMode _tmp26_ = 0;
		ButtonMode _tmp27_ = 0;
		_tmp26_ = math_buttons_get_mode (self);
		_tmp27_ = _tmp26_;
		if (_tmp27_ == BUTTON_MODE_FINANCIAL) {
			MathConverter* _tmp28_ = NULL;
			MathConverter* _tmp29_ = NULL;
			MathEquation* _tmp30_ = NULL;
			gchar* _tmp31_ = NULL;
			gchar* _tmp32_ = NULL;
			gchar* _tmp33_ = NULL;
			MathEquation* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			gchar* _tmp37_ = NULL;
			_tmp28_ = self->priv->converter;
			math_converter_set_category (_tmp28_, "currency");
			_tmp29_ = self->priv->converter;
			_tmp30_ = self->priv->equation;
			_tmp31_ = math_equation_get_source_currency (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = _tmp32_;
			_tmp34_ = self->priv->equation;
			_tmp35_ = math_equation_get_target_currency (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = _tmp36_;
			math_converter_set_conversion (_tmp29_, _tmp33_, _tmp37_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp33_);
		}
	}
	g_object_notify ((GObject *) self, "mode");
}


gint math_buttons_get_programming_base (MathButtons* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_programming_base;
	result = _tmp0_;
	return result;
}


void math_buttons_set_programming_base (MathButtons* self, gint value) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	ButtonMode _tmp3_ = 0;
	ButtonMode _tmp4_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_programming_base;
	_tmp1_ = value;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = value;
	self->priv->_programming_base = _tmp2_;
	g_object_notify ((GObject*) self, "programming-base");
	_tmp3_ = math_buttons_get_mode (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == BUTTON_MODE_PROGRAMMING) {
		MathEquation* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		_tmp5_ = self->priv->equation;
		_tmp6_ = value;
		math_equation_set_number_base (_tmp5_, _tmp6_);
	}
	g_object_notify ((GObject *) self, "programming-base");
}


static void math_buttons_class_init (MathButtonsClass * klass) {
	math_buttons_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MathButtonsPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_math_buttons_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_math_buttons_set_property;
	G_OBJECT_CLASS (klass)->finalize = math_buttons_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_BUTTONS_MODE, g_param_spec_enum ("mode", "mode", "mode", TYPE_BUTTON_MODE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_BUTTONS_PROGRAMMING_BASE, g_param_spec_int ("programming-base", "programming-base", "programming-base", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void math_buttons_instance_init (MathButtons * self) {
	self->priv = MATH_BUTTONS_GET_PRIVATE (self);
	self->priv->_programming_base = 10;
	self->priv->active_panel = NULL;
}


static void math_buttons_finalize (GObject* obj) {
	MathButtons * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_BUTTONS, MathButtons);
	_g_object_unref0 (self->priv->equation);
	_g_object_unref0 (self->priv->converter);
	_g_object_unref0 (self->priv->basic_ui);
	_g_object_unref0 (self->priv->advanced_ui);
	_g_object_unref0 (self->priv->financial_ui);
	_g_object_unref0 (self->priv->programming_ui);
	_g_object_unref0 (self->priv->bas_panel);
	_g_object_unref0 (self->priv->adv_panel);
	_g_object_unref0 (self->priv->fin_panel);
	_g_object_unref0 (self->priv->prog_panel);
	_g_object_unref0 (self->priv->active_panel);
	_g_object_unref0 (self->priv->shift_left_menu);
	_g_object_unref0 (self->priv->shift_right_menu);
	_g_object_unref0 (self->priv->function_menu);
	__g_list_free__g_object_unref0_0 (self->priv->superscript_toggles);
	__g_list_free__g_object_unref0_0 (self->priv->subscript_toggles);
	_g_object_unref0 (self->priv->base_combo);
	_g_object_unref0 (self->priv->base_label);
	_g_object_unref0 (self->priv->bit_panel);
	__g_list_free__g_object_unref0_0 (self->priv->bit_labels);
	_g_object_unref0 (self->priv->character_code_dialog);
	_g_object_unref0 (self->priv->character_code_entry);
	G_OBJECT_CLASS (math_buttons_parent_class)->finalize (obj);
}


GType math_buttons_get_type (void) {
	static volatile gsize math_buttons_type_id__volatile = 0;
	if (g_once_init_enter (&math_buttons_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MathButtonsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_buttons_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathButtons), 0, (GInstanceInitFunc) math_buttons_instance_init, NULL };
		GType math_buttons_type_id;
		math_buttons_type_id = g_type_register_static (GTK_TYPE_BOX, "MathButtons", &g_define_type_info, 0);
		g_once_init_leave (&math_buttons_type_id__volatile, math_buttons_type_id);
	}
	return math_buttons_type_id__volatile;
}


static void _vala_math_buttons_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MathButtons * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_BUTTONS, MathButtons);
	switch (property_id) {
		case MATH_BUTTONS_MODE:
		g_value_set_enum (value, math_buttons_get_mode (self));
		break;
		case MATH_BUTTONS_PROGRAMMING_BASE:
		g_value_set_int (value, math_buttons_get_programming_base (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_math_buttons_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MathButtons * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_BUTTONS, MathButtons);
	switch (property_id) {
		case MATH_BUTTONS_MODE:
		math_buttons_set_mode (self, g_value_get_enum (value));
		break;
		case MATH_BUTTONS_PROGRAMMING_BASE:
		math_buttons_set_programming_base (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



