# brltty.spec.  Generated from brltty.spec.in by configure.
###############################################################################
# BRLTTY - A background process providing access to the console screen (when in
#          text mode) for a blind person using a refreshable braille display.
#
# Copyright (C) 1995-2014 by The BRLTTY Developers.
#
# BRLTTY comes with ABSOLUTELY NO WARRANTY.
#
# This is free software, placed under the terms of the
# GNU General Public License, as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any
# later version. Please see the file LICENSE-GPL for details.
#
# Web Page: http://mielke.cc/brltty/
#
# This software is maintained by Dave Mielke <dave@mielke.cc>.
###############################################################################

Name: brltty
Version: 5.0
Release: 1
Group: System Environment/Daemons
License: GPL

Vendor: The BRLTTY Developers
Packager: Dave Mielke <dave@mielke.cc>
URL: http://mielke.cc/brltty/
Source: http://mielke.cc/brltty/releases/%{name}-%{version}.tar.gz

BuildRoot: %{_tmppath}/%{name}-%{version}-InstallRoot
%define _bindir /bin
%define _sbindir /sbin
%define _libdir /lib
%define _sysconfdir /etc
%define _systemddir /usr/lib/systemd/system

Requires: libicu

BuildRequires: /bin/sh
BuildRequires: /usr/bin/env
BuildRequires: autoconf >= 2.53
BuildRequires: make
BuildRequires: gcc
BuildRequires: coreutils
BuildRequires: binutils
BuildRequires: /usr/bin/awk
BuildRequires: glibc-devel
BuildRequires: tcl
BuildRequires: libicu-devel
BuildRequires: ncurses-devel
BuildRequires: linuxdoc-tools
BuildRequires: doxygen
BuildRequires: bluez-libs-devel
BuildRequires: alsa-lib-devel

AutoProv: no
Provides: brlapi-server
AutoReq: yes

Summary: Braille display driver for Linux/Unix.
%description
BRLTTY is a background process (daemon) which provides access to
the console screen (when in text mode) for a blind person using a
refreshable braille display.  It drives the braille display, and
provides complete screen review functionality.  Some speech capability
has also been incorporated.

Install this package if you use a refreshable braille display.


%package -n brltty-braille-brlapi
Version: 5.0
Release: 1
Group: System Environment/Daemons
License: GPL

AutoProv: no
AutoReq: yes

Summary: BrlAPI braille driver for BRLTTY.
%description -n brltty-braille-brlapi
This package provides the BrlAPI braille driver for BRLTTY.

Install this package if you need to communicate with
another instance of BRLTTY which is actually in control
of the braille device.


%package -n brltty-braille-xwindow
Version: 5.0
Release: 1
Group: System Environment/Daemons
License: GPL

BuildRequires: xorg-x11-proto-devel
BuildRequires: libX11-devel
BuildRequires: libXt-devel
BuildRequires: neXtaw-devel

AutoProv: no
AutoReq: yes

Summary: XWindow braille driver for BRLTTY.
%description -n brltty-braille-xwindow
This package provides the XWindow braille driver for BRLTTY.
This driver presents a virtual braille device within a graphical
user interface. It is primarily intended for sighted developers
who don't have access to a real braille device but still wish to
assess the accessibility of their applications.

Install this package if you would like to see how usable an
application would be by a blind person using a braille device.


%package -n brltty-speech-espeak
Version: 5.0
Release: 1
Group: System Environment/Daemons
License: GPL

Requires: espeak

BuildRequires: espeak-devel

AutoProv: no
AutoReq: yes
Requires: espeak

Summary: eSpeak speech driver for BRLTTY.
%description -n brltty-speech-espeak
This package provides the eSpeak speech driver for BRLTTY.

Install this package if you would like to be able to use the
eSpeak text-to-speech engine.


%package -n brltty-speech-festival
Version: 5.0
Release: 1
Group: System Environment/Daemons
License: GPL

Requires: festival

AutoProv: no
AutoReq: yes
Requires: festival

Summary: Festival speech driver for BRLTTY.
%description -n brltty-speech-festival
This package provides the Festival speech driver for BRLTTY.

Install this package if you would like to be able to use the
Festival text-to-speech engine.


%package -n brltty-speech-flite
Version: 5.0
Release: 1
Group: System Environment/Daemons
License: GPL

Requires: flite

BuildRequires: flite-devel

AutoProv: no
AutoReq: yes
Requires: flite

Summary: Festival Lite speech driver for BRLTTY.
%description -n brltty-speech-flite
This package provides the Festival Lite speech driver for BRLTTY.

Install this package if you would like to be able to use the
Festival Lite text-to-speech engine.


%package -n brltty-speech-speechd
Version: 5.0
Release: 1
Group: System Environment/Daemons
License: GPL

Requires: speech-dispatcher

BuildRequires: speech-dispatcher-devel

AutoProv: no
AutoReq: yes
Requires: speech-dispatcher

Summary: Speech Dispatcher speech driver for BRLTTY.
%description -n brltty-speech-speechd
This package provides the Speech Dispatcher speech driver for BRLTTY.

Install this package if you would like to be able to use the
Speech Dispatcher text-to-speech server.


%package -n brltty-screen-atspi
Version: 5.0
Release: 1
Group: System Environment/Daemons
License: GPL

Requires: at-spi

BuildRequires: at-spi-devel

AutoProv: no
AutoReq: yes
Requires: at-spi

Summary: AT-SPI screen driver for BRLTTY.
%description -n brltty-screen-atspi
This package provides the AT-SPI screen driver for BRLTTY.

Install this package if you would like to be able to
access GTK-based applications via the Assistive
Technology Service Provider Interface.


%package -n brltty-screen-atspi2
Version: 5.0
Release: 1
Group: System Environment/Daemons
License: GPL

Requires: dbus

BuildRequires: at-spi2-core-devel

AutoProv: no
AutoReq: yes
Requires: dbus

Summary: AT-SPI2 screen driver for BRLTTY.
%description -n brltty-screen-atspi2
This package provides the AT-SPI2 screen driver for BRLTTY.

Install this package if you would like to be able to
access graphical applications via the D-Bus port of
the Assistive Technology Service Provider Interface.


%package -n brltty-screen-screen
Version: 5.0
Release: 1
Group: System Environment/Daemons
License: GPL

AutoProv: no
AutoReq: yes
Requires: screen

Summary: Screen screen driver for BRLTTY.
%description -n brltty-screen-screen
This package provides the Screen screen driver for BRLTTY.

Install this package if you would like to be able to
directly access session windows maintained by the
screen program.


%package -n brltty-utils
Version: 5.0
Release: 1
Group: Development/Tools
License: GPL

BuildRequires: ncurses-devel

AutoProv: no
AutoReq: yes

Summary: Commands for maintaining BRLTTY data files.
%description -n brltty-utils
This package provides a set of commands for maintaining BRLTTY's datafiles.


%package -n brlapi
Version: 0.6.1
Release: 1
Group: System Environment/Libraries
License: LGPL

AutoProv: yes
AutoReq: yes

Summary: Appliation Programming Interface for BRLTTY.
%description -n brlapi
This package provides the run-time support for the Application
Programming Interface to BRLTTY.

Install this package if you have an application
which directly accesses a refreshable braille display.


%package -n brlapi-devel
Version: 0.6.1
Release: 1
Group: Development/Libraries
License: LGPL

AutoProv: yes
AutoReq: yes

Summary: Headers, static archive, and documentation for BrlAPI.
%description -n brlapi-devel
This package provides the header files, static archive, shared object
linker reference, and reference documentation for BrlAPI (the
Application Programming Interface to BRLTTY).  It enables the
implementation of applications which take direct advantage of a
refreshable braille display in order to present information in ways
which are more appropriate for blind users and/or to provide user
interfaces which are more specifically atuned to their needs.

Install this package if you're developing or maintaining an application
which directly accesses a refreshable braille display.


%package -n brlapi-java
Version: 0.6.1
Release: 1
Group: System Environment/Libraries
License: LGPL

BuildRequires: gcc-java

AutoProv: no
AutoReq: yes

Summary: Java bindings for BrlAPI.
%description -n brlapi-java
This package provides the Java bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have a Java application
which directly accesses a refreshable braille display.


%package -n brlapi-ocaml
Version: 0.6.1
Release: 1
Group: System Environment/Libraries
License: LGPL

BuildRequires: ocaml
BuildRequires: ocaml-findlib

AutoProv: no
AutoReq: yes

Summary: OCaml bindings for BrlAPI.
%description -n brlapi-ocaml
This package provides the OCaml bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have an OCaml application
which directly accesses a refreshable braille display.


%package -n brlapi-python
Version: 0.6.1
Release: 1
Group: System Environment/Libraries
License: LGPL

BuildRequires: python
BuildRequires: python-devel
BuildRequires: Cython

AutoProv: no
AutoReq: yes

Summary: Python bindings for BrlAPI.
%description -n brlapi-python
This package provides the Python bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have a Python application
which directly accesses a refreshable braille display.


%package -n brlapi-tcl
Version: 0.6.1
Release: 1
Group: System Environment/Libraries
License: LGPL

BuildRequires: tcl
BuildRequires: tcl-devel

AutoProv: no
AutoReq: yes

Summary: Tcl bindings for BrlAPI.
%description -n brlapi-tcl
This package provides the Tcl bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have a Tcl application
which directly accesses a refreshable braille display.


%package -n brlapi-utils
Version: 0.6.1
Release: 1
Group: Applications/System
License: LGPL

BuildRequires: xorg-x11-proto-devel
BuildRequires: libX11-devel
BuildRequires: libXtst-devel

AutoProv: no
AutoReq: yes

Summary: Appliation Programming Interface for BRLTTY.
%description -n brlapi-utils
This package provides a set of commands for maintaining BRLTTY's datafiles.


%prep
# %setup -n %{name}-%{version}
%setup -n brltty-5.0

%build
%configure --disable-relocatable-install --with-install-root="${RPM_BUILD_ROOT}" --disable-gpm --without-mikropuhe --without-swift --without-theta --without-viavoice --without-libbraille --with-braille-driver=-tt,-vr
make

%install
make install install-documents install-messages
install -m 644 Documents/brltty.conf "${RPM_BUILD_ROOT}%{_sysconfdir}"
install -d "${RPM_BUILD_ROOT}%{_systemddir}"
install -m 644 Autostart/Systemd/brltty.service "${RPM_BUILD_ROOT}%{_systemddir}/brltty.service"
%find_lang %{name}

%clean
rm -fr "${RPM_BUILD_ROOT}"


%files -f %{name}.lang
%defattr(-,root,root)
%{_bindir}/brltty
%{_libdir}/brltty
%exclude %{_libdir}/brltty/libbrlttybba.so
%exclude %{_libdir}/brltty/libbrlttybxw.so
%exclude %{_libdir}/brltty/libbrlttyses.so
%exclude %{_libdir}/brltty/libbrlttysfl.so
%exclude %{_libdir}/brltty/libbrlttysfv.so
%exclude %{_libdir}/brltty/libbrlttyssd.so
%exclude %{_libdir}/brltty/libbrlttyxas.so
%exclude %{_libdir}/brltty/libbrlttyxa2.so
%exclude %{_libdir}/brltty/libbrlttyxsc.so
%{_sysconfdir}/brltty
%doc %{_mandir}/man1/brltty.1.gz
%doc %{_docdir}/*/LICENSE*
%doc %{_docdir}/*/README*
%doc %{_docdir}/*/ChangeLog
%doc %{_docdir}/*/CONTRIBUTORS
%doc %{_docdir}/*/TODO
%doc %{_docdir}/*/brltty.conf
%doc %{_docdir}/*/KeyTables
%doc %{_docdir}/*/Manual-BRLTTY
%config(noreplace) %verify(not size md5 mtime) %{_sysconfdir}/brltty.conf
%{_systemddir}/brltty.service

%files -n brltty-braille-brlapi
%{_libdir}/brltty/libbrlttybba.so

%files -n brltty-braille-xwindow
%{_libdir}/brltty/libbrlttybxw.so

%files -n brltty-speech-espeak
%{_libdir}/brltty/libbrlttyses.so

%files -n brltty-speech-festival
%{_libdir}/brltty/libbrlttysfv.so

%files -n brltty-speech-flite
%{_libdir}/brltty/libbrlttysfl.so

%files -n brltty-speech-speechd
%{_libdir}/brltty/libbrlttyssd.so

%files -n brltty-screen-atspi
%{_libdir}/brltty/libbrlttyxas.so

%files -n brltty-screen-atspi2
%{_libdir}/brltty/libbrlttyxa2.so

%files -n brltty-screen-screen
%{_libdir}/brltty/libbrlttyxsc.so

%files -n brltty-utils
%{_bindir}/brltty-*

%files -n brlapi
%defattr(-,root,root)
%{_libdir}/libbrlapi.so.*
%doc %{_docdir}/*/Manual-BrlAPI

%files -n brlapi-java
/usr/share/java/*
/usr/lib/java/*

%files -n brlapi-ocaml
/usr/lib/ocaml/brlapi

%files -n brlapi-python
/usr/lib/python2.7/site-packages/[bB]rlapi[-.]*

%files -n brlapi-tcl
/usr/lib/tcl8.5/brlapi-0.6.1/libbrlapi_tcl.so
/usr/lib/tcl8.5/brlapi-0.6.1/pkgIndex.tcl

%files -n brlapi-devel
%defattr(-,root,root)
%{_libdir}/libbrlapi.a
%{_libdir}/libbrlapi.so
%{_includedir}/brlapi.h
%{_includedir}/brlapi_*.h
%{_includedir}/brltty
%doc %{_mandir}/man3/*
%doc %{_docdir}/*/BrlAPIref

%files -n brlapi-utils
%{_bindir}/xbrlapi
%{_bindir}/eutp
%{_bindir}/vstp
%doc %{_mandir}/man1/xbrlapi.1.gz
%doc %{_mandir}/man1/eutp.1.gz
%doc %{_mandir}/man1/vstp.1.gz
/usr/share/gdm/greeter/autostart/xbrlapi.desktop


%changelog
* Mon Jan 27 2014 Dave Mielke <dave@mielke.cc> 5.0
+  Major Changes:
      Conversion from frequent regular polling to event-based scheduling.
      The speech driver now runs in its own thread.
+  General Changes:
      The --message-delay brltty option has been renamed to --message-timeout.
      The -Q [--quiet-if-no-braille] brltty option has been added.
      The -U [--update-interval=] brltty option has been removed.
      The CLIP_SAVE and CLIP_RESTORE commands have been added.
      The PWGEN command has been removed.
      The FREEZE toggle can now be explicitly set to on or off.
      The confirmation tune is played twice if an explicit toggle is already set.
      Braille driver selection using the Bluetooth device name is now supported.
      A Bluetooth device address may now contain dashes (-) instead of colons (:).
      The "bth:" and "bluez:" device qualifier aliases are no longer supported.
      Braille device identifiers may now contain parameters (see README.Devices).
      Lots of improvements to Android support have been made.
+  Preferences Menu Changes:
      Input Options Submenu:
         The Autorepeat Delay setting has been renamed to Long Press Time.
         The Braille Orientation setting has been added.
      Internal Parameters Submenu:
         The log categories have been moved down into their own submenu.
+  The following braille drivers have been added:
      bg: B2G models (from NBP).
      mm: Braille Memo models (from KGS).
+  Significant upgrades have been made to the following braille drivers:
      Alva, Baum,  Cebra, FreedomScientific, HandyTech, HumanWare,
      Papenmeier, Pegasus, Seika.
+  Alva Braille Driver Changes:
      Support has been added for the newer Braille Pen models (from Harpo).
      Support has been added for the Easy Link 12 Touch (from Optelec).
+  FreedomScientific Braille Driver Changes:
      All of the bumper keys now have bindings.
      The rocker keys of the Focus 80 Blue now have bindings.
      For Focus models:
         The left shift key now functions as a control modifier key.
         The right shift key now functions as a meta (left alt) modifier key.
         The left GDF key plus the left bumper keys goes to the top/bottom line.
         The right GDF key plus the right bumper keys goes to the top/bottom line.
+  HandyTech Braille Driver Changes:
      Support has been added for the Basic Braille models.
+  HIMS Braille Driver Changes:
      Support has been added for the Braille Sense U2.
      Support has been added for using Braille Edge models via Bluetooth.
      Support for models which have a qwerty keyboard has been improved.
+  Papenmeier Braille Driver Changes:
      The status key bindings for models with 22 status keys have been revised.
+  Seika Braille Driver Changes:
      The K2, K3, and K4 keys of the braille display models now work.
+  Voyager Braille Driver Changes:
      Support has been added for the routing keys on newer Braille Pen models.
+  XWindow Braille Driver Changes:
      It is now usable when only the default fonts are available.
+  BrlAPI Changes:
      Version updated to 0.6.1.
      API parameter syntax problems are now errors (rather than warnings).
      Autorepeat key events are now being delivered to clients.
      A crash when visual text wasn't being supplied by the core has been fixed.
      Orca braille output is no longer being hidden by xbrlapi output.
      gdm should now automatically start xbrlapi.
+  Text Table Changes:
      The Slovenian table (sl) has been added.
      The full-width Latin letters now have braille representations.
      The full-width Latin digits now have braille representations.
      brltty-trtxt now preserves space characters.
+  Attributes Table Changes:
      The existing tables have been given more descriptive names:
         attrib -> invleft_right
         attributes -> left_right
      The upper_lower table has been added.
+  Contraction Table Changes:
      The US English Grade 2 table has been improved.
      The German table has been improved.
      The -v (--verification-table=) option has been added to brltty-ctb.
+  Key Table Changes:
      A binding for TIME (KP0+T) has been added to the desktop key table.
      A table for Sun type 6 keyboards (sun_type6) has been added.
      Support has been added for long key press bindings.
      The value of an assign statement may now contain variable expansions.
+  Build Changes:
      The libusb-1.0 package is now preferred over the libusb package.
      The message catalogs are now installed if the needed tools are available.
      pyrexc is no longer an alternate compiler for the Python bindings.
      Paths to Java build commands which contain blanks are now supported.
      Many fixes for building on Mac OS X (Darwin) have been made.
      The following wrapper scripts for a number of platforms have been added:
         cfg-android, cfg-darwin.
      The eutp command (for EuroBraille file transfer) has been added.

