#!/bin/sh

# panic: mtx_lock() of spin mutex (null) @ ../../../kern/uipc_ktls.c:1034
# cpuid = 5
# time = 1591684934
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x2b/frame 0xfffffe013a91b6c0
# vpanic() at vpanic+0x182/frame 0xfffffe013a91b710
# panic() at panic+0x43/frame 0xfffffe013a91b770
# __mtx_lock_flags() at __mtx_lock_flags+0x13c/frame 0xfffffe013a91b7c0
# ktls_get_rx_mode() at ktls_get_rx_mode+0x4e/frame 0xfffffe013a91b7f0
# tcp_default_ctloutput() at tcp_default_ctloutput+0x800/frame 0xfffffe013a91b960
# tcp_ctloutput() at tcp_ctloutput+0x1f5/frame 0xfffffe013a91b9d0
# sogetopt() at sogetopt+0x101/frame 0xfffffe013a91ba40
# kern_getsockopt() at kern_getsockopt+0xb4/frame 0xfffffe013a91baa0
# sys_getsockopt() at sys_getsockopt+0x52/frame 0xfffffe013a91bad0
# amd64_syscall() at amd64_syscall+0x159/frame 0xfffffe013a91bbf0
# fast_syscall_common() at fast_syscall_common+0x101/frame 0xfffffe013a91bbf0
# --- syscall (0, FreeBSD ELF64, nosys), rip = 0x80045446a, rsp = 0x7fffdffdcf88, rbp = 0x7fffdffdcfc0 ---
# KDB: enter: panic
# [ thread pid 5313 tid 101679 ]
# Stopped at      kdb_enter+0x37: movq    $0,0x10c7fa6(%rip)
# db> x/s version
# version:        FreeBSD 13.0-CURRENT #0 r361886: Tue Jun  9 08:32:24 CEST 2020\012    pho@t2.osted.lan:/usr/src/sys/amd64/compile/KTLS\012
# db>

# Reproduced on r361886 with "options KERN_TLS"

[ `uname -p` = "i386" ] && exit 0

. ../default.cfg
cat > /tmp/syzkaller14.c <<EOF
// https://syzkaller.appspot.com/bug?id=d50164ce557a20a785510aac5d6f104d8a62e779
// autogenerated by syzkaller (https://github.com/google/syzkaller)
// Reported-by: syzbot+a8829e888a93a4a04619@syzkaller.appspotmail.com

#define _GNU_SOURCE

#include <sys/types.h>

#include <errno.h>
#include <pthread.h>
#include <pwd.h>
#include <signal.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/syscall.h>
#include <sys/wait.h>
#include <time.h>
#include <unistd.h>

static unsigned long long procid;

static void kill_and_wait(int pid, int* status)
{
  kill(pid, SIGKILL);
  while (waitpid(-1, status, 0) != pid) {
  }
}

static void sleep_ms(uint64_t ms)
{
  usleep(ms * 1000);
}

static uint64_t current_time_ms(void)
{
  struct timespec ts;
  if (clock_gettime(CLOCK_MONOTONIC, &ts))
    exit(1);
  return (uint64_t)ts.tv_sec * 1000 + (uint64_t)ts.tv_nsec / 1000000;
}

static void thread_start(void* (*fn)(void*), void* arg)
{
  pthread_t th;
  pthread_attr_t attr;
  pthread_attr_init(&attr);
  pthread_attr_setstacksize(&attr, 128 << 10);
  int i;
  for (i = 0; i < 100; i++) {
    if (pthread_create(&th, &attr, fn, arg) == 0) {
      pthread_attr_destroy(&attr);
      return;
    }
    if (errno == EAGAIN) {
      usleep(50);
      continue;
    }
    break;
  }
  exit(1);
}

typedef struct {
  pthread_mutex_t mu;
  pthread_cond_t cv;
  int state;
} event_t;

static void event_init(event_t* ev)
{
  if (pthread_mutex_init(&ev->mu, 0))
    exit(1);
  if (pthread_cond_init(&ev->cv, 0))
    exit(1);
  ev->state = 0;
}

static void event_reset(event_t* ev)
{
  ev->state = 0;
}

static void event_set(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  if (ev->state)
    exit(1);
  ev->state = 1;
  pthread_mutex_unlock(&ev->mu);
  pthread_cond_broadcast(&ev->cv);
}

static void event_wait(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  while (!ev->state)
    pthread_cond_wait(&ev->cv, &ev->mu);
  pthread_mutex_unlock(&ev->mu);
}

static int event_isset(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  int res = ev->state;
  pthread_mutex_unlock(&ev->mu);
  return res;
}

static int event_timedwait(event_t* ev, uint64_t timeout)
{
  uint64_t start = current_time_ms();
  uint64_t now = start;
  pthread_mutex_lock(&ev->mu);
  for (;;) {
    if (ev->state)
      break;
    uint64_t remain = timeout - (now - start);
    struct timespec ts;
    ts.tv_sec = remain / 1000;
    ts.tv_nsec = (remain % 1000) * 1000 * 1000;
    pthread_cond_timedwait(&ev->cv, &ev->mu, &ts);
    now = current_time_ms();
    if (now - start > timeout)
      break;
  }
  int res = ev->state;
  pthread_mutex_unlock(&ev->mu);
  return res;
}

struct thread_t {
  int created, call;
  event_t ready, done;
};

static struct thread_t threads[16];
static void execute_call(int call);
static int running;

static void* thr(void* arg)
{
  struct thread_t* th = (struct thread_t*)arg;
  for (;;) {
    event_wait(&th->ready);
    event_reset(&th->ready);
    execute_call(th->call);
    __atomic_fetch_sub(&running, 1, __ATOMIC_RELAXED);
    event_set(&th->done);
  }
  return 0;
}

static void execute_one(void)
{
  int i, call, thread;
  int collide = 0;
again:
  for (call = 0; call < 3; call++) {
    for (thread = 0; thread < (int)(sizeof(threads) / sizeof(threads[0]));
         thread++) {
      struct thread_t* th = &threads[thread];
      if (!th->created) {
        th->created = 1;
        event_init(&th->ready);
        event_init(&th->done);
        event_set(&th->done);
        thread_start(thr, th);
      }
      if (!event_isset(&th->done))
        continue;
      event_reset(&th->done);
      th->call = call;
      __atomic_fetch_add(&running, 1, __ATOMIC_RELAXED);
      event_set(&th->ready);
      if (collide && (call % 2) == 0)
        break;
      event_timedwait(&th->done, 45);
      break;
    }
  }
  for (i = 0; i < 100 && __atomic_load_n(&running, __ATOMIC_RELAXED); i++)
    sleep_ms(1);
  if (!collide) {
    collide = 1;
    goto again;
  }
}

static void execute_one(void);

#define WAIT_FLAGS 0

static void loop(void)
{
  int iter __unused;
  for (iter = 0;; iter++) {
    int pid = fork();
    if (pid < 0)
      exit(1);
    if (pid == 0) {
      execute_one();
      exit(0);
    }
    int status = 0;
    uint64_t start = current_time_ms();
    for (;;) {
      if (waitpid(-1, &status, WNOHANG | WAIT_FLAGS) == pid)
        break;
      sleep_ms(1);
      if (current_time_ms() - start < 5 * 1000)
        continue;
      kill_and_wait(pid, &status);
      break;
    }
  }
}

uint64_t r[1] = {0xffffffffffffffff};

void execute_call(int call)
{
  intptr_t res = 0;
  switch (call) {
  case 0:
    res = syscall(SYS_socket, 0x1cul, 1ul, 0);
    if (res != -1)
      r[0] = res;
    break;
  case 1:
    syscall(SYS_getsockopt, r[0], 6, 0x2a, 0ul, 0ul);
    break;
  case 2:
    syscall(SYS_listen, r[0], 1);
    break;
  }
}
int main(void)
{
  syscall(SYS_mmap, 0x20000000ul, 0x1000000ul, 7ul, 0x1012ul, -1, 0ul);
  for (procid = 0; procid < 4; procid++) {
    if (fork() == 0) {
      loop();
    }
  }
  sleep(1000000);
  return 0;
}
EOF
mycc -o /tmp/syzkaller14 -Wall -Wextra -O2 /tmp/syzkaller14.c -lpthread ||
    exit 1

(cd /tmp; ./syzkaller14) &
sleep 60
pkill -9 syzkaller14
wait

rm -f /tmp/syzkaller14 /tmp/syzkaller14.c /tmp/syzkaller14.core
exit 0
