--- src/licq.cpp.orig	2014-06-01 19:16:42 UTC
+++ src/licq.cpp
@@ -89,6 +89,19 @@ using std::string;
 extern SSL_CTX *gSSL_CTX;
 extern SSL_CTX *gSSL_CTX_NONICQ;
 
+# if !defined(OPENSSL_VERSION_NUMBER) || OPENSSL_VERSION_NUMBER < 0x10100001L || \
+     (defined(LIBRESSL_VERSION_NUMBER) && LIBRESSL_VERSION_NUMBER < 0x20700000L)
+static int
+DH_set0_pqg(DH *dh, BIGNUM *p, BIGNUM *q, BIGNUM *g)
+{
+        dh->p=p;
+        if (q != NULL)
+                dh->q=q;
+        dh->g=g;
+        return 1; /* success */
+}
+# endif /* !defined() || OPENSSL_VERSION_NUMBER < 0x00907000L */
+
 // AUTOGENERATED by dhparam
 static DH *get_dh512()
         {
@@ -104,12 +117,14 @@ static DH *get_dh512()
                 0x02,
                 };
         DH *dh;
+        BIGNUM *dhp_bn, *dhg_bn;
+
 
         if ((dh=DH_new()) == NULL) return(NULL);
-        dh->p=BN_bin2bn(dh512_p,sizeof(dh512_p),NULL);
-        dh->g=BN_bin2bn(dh512_g,sizeof(dh512_g),NULL);
-        if ((dh->p == NULL) || (dh->g == NULL))
-                { DH_free(dh); return(NULL); }
+        dhp_bn = BN_bin2bn(dh512_p, sizeof(dh512_p), NULL);
+        dhg_bn = BN_bin2bn(dh512_g, sizeof(dh512_g), NULL);
+        if ((dhp_bn == NULL) || (dhg_bn == NULL) || !DH_set0_pqg(dh, dhp_bn, NULL, dhg_bn))
+                { DH_free(dh); BN_free(dhp_bn); BN_free(dhg_bn); return(NULL); }
         return(dh);
         }
 
@@ -610,8 +625,8 @@ bool CLicq::Init(int argc, char **argv)
 #ifdef USE_OPENSSL
   // Initialize SSL
   SSL_library_init();
-  gSSL_CTX = SSL_CTX_new(TLSv1_method());
-  gSSL_CTX_NONICQ = SSL_CTX_new(TLSv1_method());
+  gSSL_CTX = SSL_CTX_new(SSLv23_method());
+  gSSL_CTX_NONICQ = SSL_CTX_new(SSLv23_method());
 #if OPENSSL_VERSION_NUMBER >= 0x00905000L
   SSL_CTX_set_cipher_list(gSSL_CTX, "ADH:@STRENGTH");
 #else
