#!/usr/bin/env python3




##################################################
## DEPENDENCIES
import sys
import os
import os.path
try:
    import builtins as builtin
except ImportError:
    import __builtin__ as builtin
from os.path import getmtime, exists
import time
import types
from Cheetah.Version import MinCompatibleVersion as RequiredCheetahVersion
from Cheetah.Version import MinCompatibleVersionTuple as RequiredCheetahVersionTuple
from Cheetah.Template import Template
from Cheetah.DummyTransaction import *
from Cheetah.NameMapper import NotFound, valueForName, valueFromSearchList, valueFromFrameOrSearchList
from Cheetah.CacheRegion import CacheRegion
import Cheetah.Filters as Filters
import Cheetah.ErrorCatchers as ErrorCatchers
from Cheetah.compat import unicode
from xpdeint.Stochastic.RandomVariables.GaussianRandomVariable import GaussianRandomVariable

##################################################
## MODULE CONSTANTS
VFFSL=valueFromFrameOrSearchList
VFSL=valueFromSearchList
VFN=valueForName
currentTime=time.time
__CHEETAH_version__ = '3.2.6.post2'
__CHEETAH_versionTuple__ = (3, 2, 6, 'post', 2)
__CHEETAH_genTime__ = 1634954792.6811678
__CHEETAH_genTimestamp__ = 'Sat Oct 23 13:06:32 2021'
__CHEETAH_src__ = '/home/mattias/xmds-3.0.0/admin/staging/xmds-3.1.0/xpdeint/Stochastic/RandomVariables/GaussianBoxMuellerRandomVariable.tmpl'
__CHEETAH_srcLastModified__ = 'Thu Apr  4 16:29:24 2019'
__CHEETAH_docstring__ = 'Autogenerated by Cheetah: The Python-Powered Template Engine'

if __CHEETAH_versionTuple__ < RequiredCheetahVersionTuple:
    raise AssertionError(
      'This template was compiled with Cheetah version'
      ' %s. Templates compiled before version %s must be recompiled.'%(
         __CHEETAH_version__, RequiredCheetahVersion))

##################################################
## CLASSES

class GaussianBoxMuellerRandomVariable(GaussianRandomVariable):

    ##################################################
    ## CHEETAH GENERATED METHODS


    def __init__(self, *args, **KWs):

        super(GaussianBoxMuellerRandomVariable, self).__init__(*args, **KWs)
        if not self._CHEETAH__instanceInitialized:
            cheetahKWArgs = {}
            allowedKWs = 'searchList namespaces filter filtersLib errorCatcher'.split()
            for k,v in KWs.items():
                if k in allowedKWs: cheetahKWArgs[k] = v
            self._initCheetahInstance(**cheetahKWArgs)
        

    def boxMuellerAlgorithm(self, **KWS):


        """
        Return the code to generate two gaussian noises
          using the Box-Mueller algorithm
        """

        ## CHEETAH: generated from @def boxMuellerAlgorithm at line 26, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        write('''real _v1, _v2, _rsq;
do {
  _v1 = ''')
        _v = VFFSL(SL,"generator.minusOneToOneRandomNumber",True) # '${generator.minusOneToOneRandomNumber}' on line 34, col 9
        if _v is not None: write(_filter(_v, rawExpr='${generator.minusOneToOneRandomNumber}')) # from line 34, col 9.
        write(''';
  _v2 = ''')
        _v = VFFSL(SL,"generator.minusOneToOneRandomNumber",True) # '${generator.minusOneToOneRandomNumber}' on line 35, col 9
        if _v is not None: write(_filter(_v, rawExpr='${generator.minusOneToOneRandomNumber}')) # from line 35, col 9.
        write(''';
  _rsq = _v1*_v1 + _v2*_v2;
} while(_rsq >= 1.0 || _rsq == 0.0);
const real _fac = sqrt(-2.0*_var*log(_rsq)/_rsq);
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def makeFixedVarianceNoises(self, **KWS):


        """
        Return the code for the contents of the makeNoises function for
          a gaussian noise generated with the Box Mueller algorithm
        """

        ## CHEETAH: generated from @def makeFixedVarianceNoises at line 42, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        noiseVector = VFFSL(SL,"parent",True)
        write('''const ptrdiff_t _evenNoises = _vector_size & ~1;
for (ptrdiff_t _i0 = 0; _i0 < _evenNoises; _i0 += 2) {
  ''')
        _v = VFFSL(SL,"boxMuellerAlgorithm",True) # '${boxMuellerAlgorithm, autoIndent=True}' on line 50, col 3
        if _v is not None: write(_filter(_v, autoIndent=True, rawExpr='${boxMuellerAlgorithm, autoIndent=True}')) # from line 50, col 3.
        write('''  reinterpret_cast<real*>(_active_''')
        _v = VFFSL(SL,"noiseVector.id",True) # '${noiseVector.id}' on line 51, col 35
        if _v is not None: write(_filter(_v, rawExpr='${noiseVector.id}')) # from line 51, col 35.
        write(''')[_i0 + 0] = _v1*_fac;
  reinterpret_cast<real*>(_active_''')
        _v = VFFSL(SL,"noiseVector.id",True) # '${noiseVector.id}' on line 52, col 35
        if _v is not None: write(_filter(_v, rawExpr='${noiseVector.id}')) # from line 52, col 35.
        write(''')[_i0 + 1] = _v2*_fac;
}

// If _n is odd, we need to generate the last random number
if (_vector_size & 1) {
  static real _spareNoise = 0.0;
  static bool _spareNoiseAvailable = false;
  static real _old_var = 0.0;
  
  if (_spareNoiseAvailable && _old_var == _var) {
    reinterpret_cast<real*>(_active_''')
        _v = VFFSL(SL,"noiseVector.id",True) # '${noiseVector.id}' on line 62, col 37
        if _v is not None: write(_filter(_v, rawExpr='${noiseVector.id}')) # from line 62, col 37.
        write(''')[_vector_size - 1] = _spareNoise;
    _spareNoiseAvailable = false;
  } else {
    ''')
        _v = VFFSL(SL,"boxMuellerAlgorithm",True) # '${boxMuellerAlgorithm, autoIndent=True}' on line 65, col 5
        if _v is not None: write(_filter(_v, autoIndent=True, rawExpr='${boxMuellerAlgorithm, autoIndent=True}')) # from line 65, col 5.
        write('''    reinterpret_cast<real*>(_active_''')
        _v = VFFSL(SL,"noiseVector.id",True) # '${noiseVector.id}' on line 66, col 37
        if _v is not None: write(_filter(_v, rawExpr='${noiseVector.id}')) # from line 66, col 37.
        write(''')[_vector_size - 1] = _v1*_fac;
    _spareNoise = _v2*_fac;
    
    _spareNoiseAvailable = true;
    _old_var = _var;
  }
}
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def writeBody(self, **KWS):



        ## CHEETAH: main method generated for this template
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write('''
''')
        # 
        # GaussianBoxMuellerRandomVariable.tmpl
        # 
        # Created by Joe Hope on 2009-08-20.
        # 
        # Copyright (c) 2009-2012, Joe Hope
        # 
        # This program is free software: you can redistribute it and/or modify
        # it under the terms of the GNU General Public License as published by
        # the Free Software Foundation, either version 2 of the License, or
        # (at your option) any later version.
        # 
        # This program is distributed in the hope that it will be useful,
        # but WITHOUT ANY WARRANTY; without even the implied warranty of
        # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        # GNU General Public License for more details.
        # 
        # You should have received a copy of the GNU General Public License
        # along with this program.  If not, see <http://www.gnu.org/licenses/>.
        # 
        write('''

''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        
    ##################################################
    ## CHEETAH GENERATED ATTRIBUTES


    _CHEETAH__instanceInitialized = False

    _CHEETAH_version = __CHEETAH_version__

    _CHEETAH_versionTuple = __CHEETAH_versionTuple__

    _CHEETAH_genTime = __CHEETAH_genTime__

    _CHEETAH_genTimestamp = __CHEETAH_genTimestamp__

    _CHEETAH_src = __CHEETAH_src__

    _CHEETAH_srcLastModified = __CHEETAH_srcLastModified__

    _mainCheetahMethod_for_GaussianBoxMuellerRandomVariable = 'writeBody'

## END CLASS DEFINITION

if not hasattr(GaussianBoxMuellerRandomVariable, '_initCheetahAttributes'):
    templateAPIClass = getattr(GaussianBoxMuellerRandomVariable,
                               '_CHEETAH_templateClass',
                               Template)
    templateAPIClass._addCheetahPlumbingCodeToClass(GaussianBoxMuellerRandomVariable)


# CHEETAH was developed by Tavis Rudd and Mike Orr
# with code, advice and input from many other volunteers.
# For more information visit https://cheetahtemplate.org/

##################################################
## if run from command line:
if __name__ == '__main__':
    from Cheetah.TemplateCmdLineIface import CmdLineIface
    CmdLineIface(templateObj=GaussianBoxMuellerRandomVariable()).run()


