/*
  Any copyright is dedicated to the Public Domain.
  http://creativecommons.org/publicdomain/zero/1.0/
*/

ChromeUtils.import("resource://gre/modules/Services.jsm");

async function testSteps()
{
  const principalInfo = {
    url: "http://example.org",
  };

  const data = {
    key: "foo",
    value: "bar",
  };

  function getLocalStorage(principalInfo)
  {
    let uri = Services.io.newURI(principalInfo.url);
    let principal =
      Services.scriptSecurityManager.createCodebasePrincipal(uri, {});
    return Services.domStorageManager.createStorage(null, principal, "");
  }

  info("Getting storage");

  let storage = getLocalStorage(principalInfo);

  info("Adding data");

  storage.setItem(data.key, data.value);
}
