---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, styles,
              composition des mathématiques, bonnes pratiques, double dollar
---

# Quels sont les arguments contre l'utilisation de `$$` ?

TeX définit des commandes mathématiques en mode texte et en mode hors-texte,
dupliquant apparemment les séquences mathématiques primitives TeX 
qui entourent les commandes mathématiques avec des `$` ou des `$$`.

De fait, la commande `\(`, suivie plus loin de `\)`, a presque le même effet
que la version primitive TeX  `$`, toujours suivie plus loin de `$` : 
la version LaTeX vérifie juste que vous ne mettez pas `\(` et `\)` 
dans le mauvais sens. Ceci fait parfois penser qu'il y a, de la même manière, 
équivalence entre `\[` suivie de `\]` et `$$` suivie de `$$`. 
Et ce n'est pas le cas ! L'utilisation de `$$` est déconseillée
pour plusieurs raisons :

1. Elle ne respecte pas les mécanismes de LaTeX, comme par exemple l'option 
  `fleqn` de la classe standard article : cette dernière doit avoir pour effet
  d'aligner à gauche (au lieu de centrer) les équations hors-texte, 
  mais les équations délimitées par `$$` restent obstinément centrées.
2. L'espacement vertical autour de l'équation peut poser problème 
  dans certains cas. Ainsi, il peut avoir des comportements étranges 
  quand l'équation est précédée ou suivie de changements de paragraphes 
  ou autres objets complexes.
3. Enfin, toutes les extensions faites pour LaTeX supposent que vous utilisez
  les constructions standard de LaTeX, et risquent donc de ne pas fonctionner 
  avec `$$`. C'est le cas de <ctanpkg:mathtools> (ou d’<ctanpkg:amsmath>), 
  et par exemple, de sa commande `\tag`. 

Pour être complet, les environnements initialement prévus par LaTeX 
pour les mathématiques hors-texte sont `displaymath`, `equation*` et `\[` 
suivie de `\]` : le dernier n'est guère plus long à taper que `$$` suivie 
de `$$` et rend par ailleurs le source plus lisible.


:::{sources}
- [Why use \[ ... \] in place of $$$...$$$](faquk:FAQ-dolldoll)
- [Trois arguments contre l'usage de $$$...$$$](https://www.elzevir.fr/imj/latex/tips.html#dollars), 
  par Manuel Pégourié-Gonnard
:::