RabbitMQ `3.12.5` is a maintenance release in the `3.12.x` [release series](https://www.rabbitmq.com/versions.html).
**All users are encouraged to skip this version in favor of [`3.12.6`](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.12.6)**.

Please refer to the upgrade section from the [3.12.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.12.0)
if upgrading from a version prior to 3.12.0.

This release requires Erlang 25 and supports Erlang versions up to `26.1.x`.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.12.0, RabbitMQ requires Erlang 25. Nodes **will fail to start** on older Erlang releases.

Users upgrading from 3.11.x (or older releases) on Erlang 25 to 3.12.x on Erlang 26
(both RabbitMQ *and* Erlang are upgraded at the same time) **must** consult
the [v3.12.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.12.0) first.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.12.x/release-notes).


### Core Server

#### Bug Fixes

 * Quorum queue leader changes are now correctly observed in certain network failure scenarios.

   GitHub issues: [#9241](https://github.com/rabbitmq/rabbitmq-server/pull/9241), [#9227](https://github.com/rabbitmq/rabbitmq-server/pull/9227)

 * High consumer churn with reused consumer tag on quorum queues could result in some messages not being delivered
   after a period of time.

   This did not affect environments where consumer churn does not exist or where it does but consumer tags vary.

   GitHub issue: [#9158](https://github.com/rabbitmq/rabbitmq-server/pull/9158)

 * Three environment variables, `LOG_BASE`, `MNESIA_BASE`, `CONFIG_FILE`, were not picked up when set in
   `rabbitmq-env-conf.bat` on Windows.

   Gi9158issue: [#9307](https://github.com/rabbitmq/rabbitmq-server/pull/9307)

 * Avoids a potential exception when autoheal partition handling process was initiated.

   GitHub issue: [#9222](https://github.com/rabbitmq/rabbitmq-server/pull/9222)

 * Avoids a potential exception in the credit flow subsystem.

   Contributed by @Ayanda-D.

   GitHub issue: [#9433](https://github.com/rabbitmq/rabbitmq-server/pull/9433)

 * Classic queues v2 (CQv2) that had priorities enabled were reporting their storage version
   incorrectly.

   Contributed by @gomoripeti (CloudAMQP).

   GitHub issue: [#9370](https://github.com/rabbitmq/rabbitmq-server/issues/9370)

#### Enhancements

 * Channels that had many thousands of consumers (usually due to a consumer leak in the application)
   now consume a lot less CPU resources when the channel is closed.

   As part of this optimization, individual `consumer.deleted` internal events are no
   longer emitted when a channel is closed, only a `channel.closed` event is. This also
   help reduce audit event log size, since those `consumer.deleted` events provided
   no useful information in this context.

   Contributed by @SimonUnge (AWS).

   GitHub issue: [#9356](https://github.com/rabbitmq/rabbitmq-server/pull/9356)

 * Initial forward compatibility with later Erlang 26.x and 27.0 releases.

   GitHub issue: [#9485](https://github.com/rabbitmq/rabbitmq-server/pull/9485)

 * Nodes now log boot time at info level instead of debug. This piece of information
   can be useful during root cause analysis.

   Contributed by @johanrhodin (CloudAMQP).

   GitHub issue: [#9466](https://github.com/rabbitmq/rabbitmq-server/pull/9466)

 * Channel interceptors (defined by plugins) now can return one more type of errors.

   Contributed by @Ayanda-D.

   GitHub issue: [#9459](https://github.com/rabbitmq/rabbitmq-server/pull/9459)


### CLI Tools

#### Bug Fixes

 * `rabbitmqctl delete_queue` now handles more queue replica failure scenarios
   (that were previously handled by client operations and the HTTP API but not CLI tools).

   Contributed by @Ayanda-D.

   GitHub issue: [#9324](https://github.com/rabbitmq/rabbitmq-server/pull/9324)

 * `rabbitmq-streams delete_replica` now handles scenarios where the replica is hosted
   on a node that is not accessiable (reachable).

   GitHub issue: [#9282](https://github.com/rabbitmq/rabbitmq-server/issues/9282)


### MQTT Plugin

#### Bug Fixes

 * If a socket write fails, close the connection quickly to avoid producing a lot of
   log noise.

   GitHub issue: [#9281](https://github.com/rabbitmq/rabbitmq-server/pull/9281)


### AMQP 1.0 Plugin

#### Bug Fixes

 * Listing AMQP 1.0 connections in a system that had both AMQP 1.0 and AMQP 0-9-1 clients connected
   resulted in exceptions logged and partial results returned to CLI tools.

   GitHub issue: [#9371](https://github.com/rabbitmq/rabbitmq-server/issues/9371)


### Prometheus Plugin

#### Enhancements

 * The plugin now exposes a new gauge, `rabbitmq_unreachable_cluster_peers_count`, that indicates how many cluster
   peers **cannot** be reached by this node.

   Contributed by @gomoripeti (CloudAMQP).

   GitHub issues: [#2508](https://github.com/rabbitmq/rabbitmq-server/issues/2508), [#9465](https://github.com/rabbitmq/rabbitmq-server/pull/9465)


## Dependency Upgrades

 * `osiris` was upgraded to [`1.6.7`](https://github.com/rabbitmq/osiris/tags)


## Dependency Upgrades

None in this release.

## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.12.5.tar.xz`
instead of the source tarball produced by GitHub.
