% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics_helpers.R
\name{graphics_helpers}
\alias{graphics_helpers}
\alias{graphics_dev}
\alias{is_svg}
\alias{dev_chr}
\title{Helper functions to use various graphics devices}
\usage{
graphics_dev(filename, width, height, res, ..., dev)

is_svg(dev)

dev_chr(dev)
}
\arguments{
\item{filename}{Passed through to the graphics device.}

\item{width, height}{Plot dimensions in pixels.}

\item{res}{The resolution of the plot; default is 300.}

\item{...}{extra parameters passing to the graphics-device function.}

\item{dev}{Character (e.g., "svg", "pdf") or function (e.g.,
\code{grDevices::svg}, \code{grDevices::pdf}).}
}
\value{
\code{graphics_dev}: nothing, a plot device is opened

'is_svg': logical

\code{dev_chr}: character
}
\description{
These helper functions generalize the use of strings (e.g.,
\code{"svg"}, \code{"pdf"}) or graphic device functions (e.g.,
\code{grDevices::svg}, \code{grDevices::pdf}) for in-table plots.
}
\details{
\itemize{
\item \code{graphics_dev} generalizes the use of 'res' and plot dimensions
across graphic devices. Raster-based devices (e.g., 'png',
'jpeg', 'tiff', 'bmp') tend to use 'res' and the width/height
units default to pixels. All other devices (e.g., 'pdf', 'svg')
tend to use inches as the default units for width/height, and
error when 'res' is provided.

The current heuristic is the look for the 'res' argument in the
function's formals; if that is present, then it is assumed that
the default units are in pixels, so 'width', 'height', and 'res'
are passed through unmodified. If 'res' is not present, then
'width' and 'height' are converted from pixels to inches, and
'res' is not passed to the function

Another purpose of this function is to generalize the different
graphic functions' use of 'file=' versus 'filename='.
}

\itemize{
\item \code{is_svg} determines if the plot device is svg-like, typically one
of \verb{"svg", }grDevices::svg\verb{, or }svglite::svglite`
}

\itemize{
\item \code{dev_chr} determines the filename extension for the applicable
plot function; when \code{dev} is a string, then it is returned
unchanged; when \code{dev} is a function, the formals of the function
are checked for clues (i.e., default value of a \verb{file=} argument)
}
}
\section{Functions}{
\itemize{
\item \code{graphics_dev()}: Generalize \code{res} and \code{filename} across device functions

\item \code{is_svg()}: Determine if plot device is svg-like

\item \code{dev_chr()}: Determine filename extension

}}
