% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/null-and-default.R
\name{null_tidiers}
\alias{null_tidiers}
\alias{tidy.NULL}
\alias{glance.NULL}
\alias{augment.NULL}
\title{Tidiers for NULL inputs}
\usage{
\method{tidy}{`NULL`}(x, ...)

\method{glance}{`NULL`}(x, ...)

\method{augment}{`NULL`}(x, ...)
}
\arguments{
\item{x}{The value \code{NULL}.}

\item{...}{Additional arguments (not used).}
}
\value{
An empty \link[tibble:tibble]{tibble::tibble}.
}
\description{
\code{tidy(NULL)}, \code{glance(NULL)} and \code{augment(NULL)} all return an empty
\link[tibble:tibble]{tibble::tibble}. This empty tibble can be treated a tibble with zero
rows, making it convenient to combine with other tibbles using
functions like \code{\link[purrr:map_dfr]{purrr::map_df()}} on lists of potentially \code{NULL} objects.
}
\seealso{
\link[tibble:tibble]{tibble::tibble}
}
