# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class MediaProcessorTestCase(IntegrationTestCase):

    def test_create_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.media.v1.media_processor.create(extension="extension", extension_context="extension_context")

        values = {'Extension': "extension", 'ExtensionContext': "extension_context", }

        self.holodeck.assert_has_request(Request(
            'post',
            'https://media.twilio.com/v1/MediaProcessors',
            data=values,
        ))

    def test_create_response(self):
        self.holodeck.mock(Response(
            201,
            '''
            {
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "date_created": "2015-07-30T20:00:00Z",
                "date_updated": "2015-07-30T20:00:00Z",
                "extension": "video-composer-v1",
                "extension_context": "{}",
                "sid": "ZXdeadbeefdeadbeefdeadbeefdeadbeef",
                "status": "started",
                "status_callback": "http://www.example.com",
                "status_callback_method": "POST",
                "ended_reason": null,
                "url": "https://media.twilio.com/v1/MediaProcessors/ZXdeadbeefdeadbeefdeadbeefdeadbeef",
                "max_duration": 300
            }
            '''
        ))

        actual = self.client.media.v1.media_processor.create(extension="extension", extension_context="extension_context")

        self.assertIsNotNone(actual)

    def test_fetch_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.media.v1.media_processor("ZXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").fetch()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://media.twilio.com/v1/MediaProcessors/ZXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
        ))

    def test_fetch_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "date_created": "2015-07-30T20:00:00Z",
                "date_updated": "2015-07-30T20:00:00Z",
                "extension": "video-composer-v1",
                "extension_context": "{}",
                "sid": "ZXdeadbeefdeadbeefdeadbeefdeadbeef",
                "status": "started",
                "status_callback": "http://www.example.com",
                "status_callback_method": "POST",
                "ended_reason": null,
                "url": "https://media.twilio.com/v1/MediaProcessors/ZXdeadbeefdeadbeefdeadbeefdeadbeef",
                "max_duration": 300
            }
            '''
        ))

        actual = self.client.media.v1.media_processor("ZXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").fetch()

        self.assertIsNotNone(actual)

    def test_update_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.media.v1.media_processor("ZXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").update(status="ended")

        values = {'Status': "ended", }

        self.holodeck.assert_has_request(Request(
            'post',
            'https://media.twilio.com/v1/MediaProcessors/ZXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
            data=values,
        ))

    def test_update_ended_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "date_created": "2015-07-30T20:00:00Z",
                "date_updated": "2015-07-30T20:01:00Z",
                "extension": "video-composer-v1",
                "extension_context": "{}",
                "sid": "ZXdeadbeefdeadbeefdeadbeefdeadbeef",
                "status": "ended",
                "status_callback": "http://www.example.com",
                "status_callback_method": "POST",
                "ended_reason": "ended-via-api",
                "url": "https://media.twilio.com/v1/MediaProcessors/ZXdeadbeefdeadbeefdeadbeefdeadbeef",
                "max_duration": 300
            }
            '''
        ))

        actual = self.client.media.v1.media_processor("ZXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").update(status="ended")

        self.assertIsNotNone(actual)

    def test_list_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.media.v1.media_processor.list()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://media.twilio.com/v1/MediaProcessors',
        ))

    def test_read_empty_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "meta": {
                    "page": 0,
                    "page_size": 10,
                    "first_page_url": "https://media.twilio.com/v1/MediaProcessors?Status=started&Order=asc&PageSize=10&Page=0",
                    "previous_page_url": null,
                    "url": "https://media.twilio.com/v1/MediaProcessors?Status=started&Order=asc&PageSize=10&Page=0",
                    "next_page_url": null,
                    "key": "media_processors"
                },
                "media_processors": []
            }
            '''
        ))

        actual = self.client.media.v1.media_processor.list()

        self.assertIsNotNone(actual)

    def test_read_items_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "meta": {
                    "page": 0,
                    "page_size": 10,
                    "first_page_url": "https://media.twilio.com/v1/MediaProcessors?Status=ended&Order=desc&PageSize=10&Page=0",
                    "previous_page_url": null,
                    "url": "https://media.twilio.com/v1/MediaProcessors?Status=ended&Order=desc&PageSize=10&Page=0",
                    "next_page_url": null,
                    "key": "media_processors"
                },
                "media_processors": [
                    {
                        "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "date_created": "2015-07-30T20:00:00Z",
                        "date_updated": "2015-07-30T20:01:00Z",
                        "extension": "video-composer-v1",
                        "extension_context": "{}",
                        "sid": "ZXdeadbeefdeadbeefdeadbeefdeadbeef",
                        "status": "ended",
                        "status_callback": "http://www.example.com",
                        "status_callback_method": "POST",
                        "ended_reason": "ended-via-api",
                        "url": "https://media.twilio.com/v1/MediaProcessors/ZXdeadbeefdeadbeefdeadbeefdeadbeef",
                        "max_duration": 300
                    }
                ]
            }
            '''
        ))

        actual = self.client.media.v1.media_processor.list()

        self.assertIsNotNone(actual)

    def test_read_items_using_page_token_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "meta": {
                    "page": 0,
                    "page_size": 10,
                    "first_page_url": "https://media.twilio.com/v1/MediaProcessors?Status=ended&Order=desc&PageSize=10&Page=0",
                    "previous_page_url": null,
                    "url": "https://media.twilio.com/v1/MediaProcessors?Status=ended&Order=desc&PageSize=10&Page=0&PageToken=PTTUszYTgyOGFhNDIzZWExNzA0OTkwODNlMDlkZTg3M2NiNDoxOjI%253D",
                    "next_page_url": null,
                    "key": "media_processors"
                },
                "media_processors": [
                    {
                        "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "date_created": "2015-07-30T20:00:00Z",
                        "date_updated": "2015-07-30T20:01:00Z",
                        "extension": "video-composer-v1",
                        "extension_context": "{}",
                        "sid": "ZXdeadbeefdeadbeefdeadbeefdeadbeef",
                        "status": "ended",
                        "status_callback": "http://www.example.com",
                        "status_callback_method": "POST",
                        "ended_reason": "ended-via-api",
                        "url": "https://media.twilio.com/v1/MediaProcessors/ZXdeadbeefdeadbeefdeadbeefdeadbeef",
                        "max_duration": 300
                    }
                ]
            }
            '''
        ))

        actual = self.client.media.v1.media_processor.list()

        self.assertIsNotNone(actual)

    def test_read_items_page_larger_than_max_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "meta": {
                    "page": 0,
                    "page_size": 100,
                    "first_page_url": "https://media.twilio.com/v1/MediaProcessors?Status=ended&Order=desc&PageSize=100&Page=0",
                    "previous_page_url": null,
                    "url": "https://media.twilio.com/v1/MediaProcessors?Status=ended&Order=desc&PageSize=100&Page=0",
                    "next_page_url": null,
                    "key": "media_processors"
                },
                "media_processors": [
                    {
                        "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "date_created": "2015-07-30T20:00:00Z",
                        "date_updated": "2015-07-30T20:01:00Z",
                        "extension": "video-composer-v1",
                        "extension_context": "{}",
                        "sid": "ZXdeadbeefdeadbeefdeadbeefdeadbeef",
                        "status": "ended",
                        "status_callback": "http://www.example.com",
                        "status_callback_method": "POST",
                        "ended_reason": "ended-via-api",
                        "url": "https://media.twilio.com/v1/MediaProcessors/ZXdeadbeefdeadbeefdeadbeefdeadbeef",
                        "max_duration": 300
                    }
                ]
            }
            '''
        ))

        actual = self.client.media.v1.media_processor.list()

        self.assertIsNotNone(actual)
