# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class USqlIndex(Model):
    """A Data Lake Analytics catalog U-SQL table index item.

    :param name: the name of the index in the table.
    :type name: str
    :param index_keys: the list of directed columns in the index
    :type index_keys:
     list[~azure.mgmt.datalake.analytics.catalog.models.USqlDirectedColumn]
    :param columns: the list of columns in the index
    :type columns: list[str]
    :param distribution_info: the distributions info of the index
    :type distribution_info:
     ~azure.mgmt.datalake.analytics.catalog.models.USqlDistributionInfo
    :param partition_function: partition function ID for the index.
    :type partition_function: str
    :param partition_key_list: the list of partion keys in the index
    :type partition_key_list: list[str]
    :param stream_names: the list of full paths to the streams that contain
     this index in the DataLake account.
    :type stream_names: list[str]
    :param is_columnstore: the switch indicating if this index is a
     columnstore index.
    :type is_columnstore: bool
    :param index_id: the ID of this index within the table.
    :type index_id: int
    :param is_unique: the switch indicating if this index is a unique index.
    :type is_unique: bool
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'index_keys': {'key': 'indexKeys', 'type': '[USqlDirectedColumn]'},
        'columns': {'key': 'columns', 'type': '[str]'},
        'distribution_info': {'key': 'distributionInfo', 'type': 'USqlDistributionInfo'},
        'partition_function': {'key': 'partitionFunction', 'type': 'str'},
        'partition_key_list': {'key': 'partitionKeyList', 'type': '[str]'},
        'stream_names': {'key': 'streamNames', 'type': '[str]'},
        'is_columnstore': {'key': 'isColumnstore', 'type': 'bool'},
        'index_id': {'key': 'indexId', 'type': 'int'},
        'is_unique': {'key': 'isUnique', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(USqlIndex, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.index_keys = kwargs.get('index_keys', None)
        self.columns = kwargs.get('columns', None)
        self.distribution_info = kwargs.get('distribution_info', None)
        self.partition_function = kwargs.get('partition_function', None)
        self.partition_key_list = kwargs.get('partition_key_list', None)
        self.stream_names = kwargs.get('stream_names', None)
        self.is_columnstore = kwargs.get('is_columnstore', None)
        self.index_id = kwargs.get('index_id', None)
        self.is_unique = kwargs.get('is_unique', None)
