// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//                             avtImageOptions.C                              //
// ************************************************************************* //

#include <avtImageOptions.h>

#include <DBOptionsAttributes.h>

#include <string>
#include <vector>

using std::string;
using std::vector;


// ****************************************************************************
//  Function: GetImageReadOptions
//
//  Purpose:
//      Creates the options for Image readers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require read options, no modifications are 
//      necessary.
//
//  Programmer: miller -- generated by xml2avt
//  Creation:   Thu Nov 29 11:03:26 PDT 2007
//
// ****************************************************************************

DBOptionsAttributes *
GetImageReadOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;
    return rv;
}


// ****************************************************************************
//  Function: GetImageWriteOptions
//
//  Purpose:
//      Creates the options for Image writers.
//
//  Important Note:
//      The code below sets up empty options.  If your format 
//      does not require write options, no modifications are 
//      necessary.
//
//  Programmer: miller -- generated by xml2avt
//  Creation:   Thu Nov 29 11:03:26 PDT 2007
//
// ****************************************************************************

DBOptionsAttributes *
GetImageWriteOptions(void)
{
    DBOptionsAttributes *rv = new DBOptionsAttributes;

    //
    // Format options
    //
    rv->SetEnum("Format", 0);
    vector<string> formats;
    formats.push_back("TIFF");  // 0
    formats.push_back("PNG");   // 1
    formats.push_back("JPEG");  // 2
    formats.push_back("BMP");   // 3
    formats.push_back("PNM");   // 4
    rv->SetEnumStrings("Format", formats);

    rv->SetBool("Normalize [0,255]", true);

    rv->SetEnum("TIFF Compression", 0);
    vector<string> compressions;
    compressions.push_back("None");     // 0
    compressions.push_back("PackBits"); // 1
    compressions.push_back("Deflate");  // 2
    rv->SetEnumStrings("TIFF Compression", compressions);

    rv->SetInt("JPEG Quality [0,100]", 100);

    return rv;
}
