<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

OCIO v2 WORKING GROUP MEETING  
2020-02-27  
via Zoom  

Participants:
  * Dennis Adams (Sony)
  * Mark Boorer (ILM)
  * Michael Dolan (Epic)
  * Joseph Goldstone (ARRI)
  * Bernard Lefebvre (Autodesk)
  * Thomas Mansencal (Weta)
  * Allie Moon (ILM)
  * Carol Payne (Netflix)
  * Carl Rand (Weta)
  * Matthias Scharfenberg (ILM)
  * Kevin Wheatley (Framestore)

Hosts:
  * Doug Walker (Autodesk)
  * Patrick Hodoul (Autodesk)

Recording on Zoom cloud:  
None this time.  :(   But PDF of slides was sent to the group.

**ASC CDL CLAMPING BEHAVIOR**

   - Doug reviewed the changes in CDL behavior for v2.  OCIO v2 provides several
options: follow the exact ASC math, or do a non-clamping version of the math. 
Note the non-clamp is different than v1 in that it does not clamp even if power
!= 1.
   - Doug:  We want to add a new attribute to FileTransform to allow specifying
which CDL math is desired when loading CDLs.
   - Group agreed it was useful.
   - Doug:  We propose that the default will be the ASC math rather than
no-clamp.
   - Mark, Kevin, Matthias, Thomas:  OCIO v1 was basically no-clamp and that is
virtually always what we use.  Default should be no-clamp.
   - Kevin:  I logged an issue related to ACES since using a CDL there requires
no clamping.
   - Carol:  It's a bit strange to have the default not follow the spec, but you
have a good point.  Should we contact ASC to find out if there is work underway
to address the clamping issue?
   - Doug:  As far as I know, there is no work underway to revise the CDL spec.
   - The group agreed to use no-clamp as the default.
   - Michael:  We need to make sure to document the reasoning.

**DISPLAY REFERENCE SPACE  PR #939**

   - Doug:  We went ahead and implemented this feature that we discussed at
length during the last meeting and which had some additional discussion via
issue #926.  It is PR #939.  Please give us your feedback!

**NAMING OF REFERENCE SPACE**

   - Doug:  PR #939 adds from/to_display_reference.  Thomas proposed in issue
#926 that we allow from/to_scene_reference to be used for from/to_reference.  We
like this idea and propose that OCIOYaml will load either syntax but will save
the proposed new syntax.
   - Group agreed that would be good.
   - Doug:  What about scene_reference as a role?  The existing reference role
is widely misinterpreted, some think it points to the reference color space
whereas other think it is for reference art.  Would it help to add a more
clearly named reference role?
   - Carol: The existing reference role is certainly a mess right now.
   - Doug:  Yes, the roles documentation needs a major reworking.
   - Mark:  Most people use scene_linear for the reference color space.  We
should not add a scene_reference role.
   - Group agreed not to add a new role.

**CONTROLLING THE DEFAULT ViewTransform**

   - Doug:  At the last v2 working group we discussed what ColorSpaceTransform
should do if it gets a scene-referred source and display-referred destination,
or vice versa.  (Remember that DisplayTransform is ideally what would be used
for that conversion since it allows explicit specification of the ViewTransform
to use.)  My opinion is that we want ColorSpaceTransform to always succeed
rather than throw.  In PR #939, the first scene-referred ViewTransform in the
config is considered the default ViewTransform and ColorSpaceTransform uses that
in such scenarios.
   - Doug:  In the previous meeting Kevin proposed that it would be useful to be
able to control which transform is used via context or environment variables. 
Should we go ahead and add an explicit default_view_transform attribute to the
config with an accompanying environment variable?
   - Michael:  Yes, the added benefit is that it makes it clear what the
behavior is.  In the past there has been confusion about whether order listed in
the config had some significance, e.g. some people thought that the reference
color space was the first one in the list (which is not true).  So having an
explicit attribute would help clarify that the transform has this additional
purpose.
   - Group agreed we should add this.
   - Michael:  Clear documentation will be important for the ViewTransform
stuff.

**DisplayTransform ISSUES**

   - Doug expressed the opinion that DisplayTransform, along with
ColorSpaceTransform are the heart of OCIO.  It is where all the business logic
for connecting color spaces lives.  However, DisplayTransform is very
complicated with many features that do not seem widely used (linearCC,
colorTimingCC, channelView, displayCC, looksOverride).  Also, the implementation
of colorTimingCC and channelView are not well suited to all apps.  More
importantly it throws if direction==inverse.  
   - Doug showed a diagram of the existing processing logic and a proposed
simplification.  Proposal is to take all the extra features and move them into
an app helpers directory outside the core library (the app helpers idea was
discussed at the November meeting).
   - Kevin:  Agree that the requirements vary a lot between apps.  The existing
DisplayTranform is missing color correction related features that we need.
   - Mark:  I didn't even realize some of that stuff was there.  Agree it should
be simplified.
   - Michael:  I've seen apps that use all of the currrent DisplayTransform
features (except for looksOverride).  The ColorTimingCC is sometimes used to
build a CDL interactively.  This is then saved to become the context-based Look
for a given shot.  But as long as the existing functionality remains available,
no objection to moving/renaming it.
   - Michael:  Looking at apps today, they are not very uniform in how their
viewports work.  It would be nice to try and encourage more consistency, that is
one purpose that DisplayTransform serves.
   - Doug:  Totally agree.   In fact we would like to make it even clearer how
to properly add exposure and gamma sliders to a viewing pipeline (using the new
ExposureContrast op with dynamic parameters).  And that is the idea behind the
app helpers directory, to serve as examples or best-practices for app developers
to look at.
   - The group agreed that simplifying DisplayTransform was a good idea.  We
will move forward with a PR of that and the app helpers.

**VIEWING DATA COLORSPACES**

   - Doug:  As discussed at the last meeting, the arrival of HDR monitors poses
a problem for viewing data.  Cannot simply put an alpha/matte channel up on an
HDR monitor like you could an SDR monitor without any color management.  A value
of 1 in the alpha should be at some reasonable value (e.g. 100-300 nits) rather
than 1000+ nits.  Also, PQ may not be as good a visual depiction of an alpha as
an SDR gamma curve.
   - Doug:  Does anyone know the story behind the comment in the Data section of
OpenColorIO.h that mentions "special data min and data max args" for
DisplayTransform?  There are no such arguments currently in DisplayTransform.
   - Mark:  Is it related to the min/max for LUTs?  Doug:  I don't think so
since they would not get applied to data and also they are not specific to
DisplayTransform.
   - There was some discussion about the need for being able to process data by
remapping normals, point positions, etc. to have a reasonable display in a
viewport.  So like alpha, an app may want to apply a viewing transform.
   - Doug:  The isData attribute of ColorSpaces is not widely used in the
library.  It is basically just in ColorSpaceTransform and DisplayTransform and
it turns off color space conversions (although not the CC transforms).  We need
to decide how to allow apps to apply color processing to data channels when
necessary.  One way of doing this would be to add a processData flag to
DisplayTransform (and ColorSpaceTransform, since DisplayTransform calls that).
   - Doug:  But that is only part of the problem, we also need a way for an app
to know which views are appropriate for use with data.
   - Kevin:  It's almost like each type of data is it's own color space, there
is not a one-size-fits-all scenario.
   - Doug:  I will try to come up with a proposal for viewing data.  Just wanted
to start the discussion for now.

**IsNoOp BEHAVIOR IN DisplayTransform AND LookTransform**

   - Doug:  We wanted to validate one aspect of DisplayTranform and
LookTransform.  Currently they build the ops specified by the given
Look/LinearCC/ColorTimingCC/DisplayCC and then use isNoOp to decide whether to
actually build the conversion to the processing space and apply the transform. 
In v1, isNoOp ignored clamping but in v2 isNoOp returns false if there is any
clamping.  (We added an isIdentity method that may be used to ignore clamping if
everything else is an identity.)  For example, a CDL using ASC style math and
all params at the default would have isNoOp==false and isIdentity==true. 
Therefore, it would trigger conversion to the process space and apply clamping
if used in DisplayTransform or LookTransform.  Are people ok with that?  Anyone
want us to use isIdentity (or some other approach) instead?
   - Mark:  In some pipelines you need an identity CDL, or similar transform, as
a placeholder.  Would get replaced by a non-identity for certain shots.
   - Mark, Kevin:  But there are ways to avoid the clamping.  Agree we should
not optimize out clamping if it is in the transforms that people have chosen to
use.  
   - The group discussed it and decided no changes related to isNoOp are needed.

**BUILT-IN TRANSFORMS**

   - Doug presented the proposal to add Built-in Transforms.  This would allow
many configs to not require any external files.  It would also simplify the
process of authoring configs.  It is basically like FileTransform but without
any files!   ;)
   - Doug:  An initial goal would be to be able to implement the ACES config
without needing external files.  Some other open source standards are looking at
using the ACES config as their default color management and it would be great if
this were as light weight as possible.
   - Doug:  When Mark's OpenColorMath is available, we will look at that and may
refactor.  But it doesn't affect our proposed public API, so we want to move
forward with that part.
   - Several people experessed concern over bringing ephemeral details like
camera non-linearities into the library.  Do they need to be supported
indefinitely?
   - Several people asked how we decide what to include and what not to?  Will
we accept PRs from anyone that wants to add more?  How to decide what is
generally useful and what is too narrow/specific/time-bound and should continue
to be done via a FileTransform?
   - Doug:  Yes, all excellent questions.
   - Kevin:  Coming up with a good set of names will be a big challenge.  May
want to set up a namespace syntax.
   - Carol:  Built-ins would be a huge benefit for people trying to make a
config who are not already OCIO / color experts.
   - Michael:  What about doing it as a plug-in API?
   - Doug:  The proposed feature is not adding any new ops, it is simply
populating existing ops to avoid the need for external files.  When Mark's stuff
is available, that may bring the bulk of what a plug-in API would do.  The
challenge with a plug-in API is that we need it to work robustly (full CPU and
GPU support, invertibility, etc.), so it would be a lot of work.
   - Mark:  Agreed.  One totally different thing that a plug-in API might be
useful for though is to be able to defer decisions about shot-based stuff, e.g.
to be able to query a facility pipeline database.
   - Doug:  Any objection to us going ahead and making a PR to facilitate future
discussion?  We could implement the ACES 1.2 CSC transforms as a starting point.
   - The group agreed to move forward with a PR and we will then have more
discussion about the questions raised.

**GENERAL DISCUSSION**

   - Mark:  I was testing master and found that role names are now
case-sensitive.  This is a change from OCIO v1.
   - Doug:  Are we agreed we want case-insensitive behavior?  Same for color
spaces too?   Group agreed.
   - Doug:  We will make a PR immediately to address this.  And add unit tests! 
;)
