<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

OCIO v2 WORKING GROUP MEETING  
2020-08-06  
via Zoom  

Participants:
  * Dennis Adams (Sony)
  * Mark Boorer (ILM)
  * Sean Cooper (DNeg)
  * Michael Dolan (Epic)
  * Joseph Goldstone (ARRI)
  * Deke Kincaid (Digital Domain)
  * Bernard Lefebvre (Autodesk)
  * Carol Payne (Netflix)
  * Troy Sobotka
  * Kevin Wheatley (Framestore)

Hosts:
  * Doug Walker (Autodesk)
  * Patrick Hodoul (Autodesk)

Recording on Zoom cloud:  
<https://autodesk.zoom.us/rec/share/Kd-mFiD4RogAsVe_bNYsNOV0Y1RNd7-FVq8WX_A1tdZqE3RRwEqAGKpKR1uK_k65.i8byG8ldH84wONl6>


**OUTREACH & MARKETING UPDATE**

   - Doug reviewed the various initiatives such as the new website, the paper
and presentation for DigiPro, ASWF Open Source Days, and the SIGGRAPH BoF.

**FEATURE COMPLETE DISCUSSION**

   - Doug: SIGGRAPH 2020 is the "Feature Complete" date that we have been
communicating since SIGGRAPH 2019 and we are on target for that.  Also, OCIO v2
is in the VFX Reference Platform for CY 2021.  The plan is a to have a four
month stabilization and bug-fixing period and then to make the stable v2 release
around the end of the year.
   - Patrick: The four month period is also for documentation and everything
else needed for the release.

**FEATURE WORK IN-PROGRESS**

   - Doug listed PRs that are in progress and other work planned for v2.  Issues
have been created for Processor Cache (#1084), Virtual Displays (#1082), Context
Variables (#1064, #1083), and Config Versioning (#1087).  These were all
discussed at previous meetings.  Rather than spend more time at this meeting,
please add your remaining thoughts about these (if any) in GitHub and we could
discuss them at a future meeting.

**NEW TRANSFORMS FOR BUILDING LOOKS**

   - Doug: Most people today are using either CDLs or Lut3Ds to build Looks. 
CDLs are editable and compact but not very powerful, whereas Lut3Ds are powerful
but not compact or easily editable.  We feel that there would be a lot of
benefit for something that falls in the middle ground between those two existing
transform types.  Also, following up on requests that were made when we
introduced the Dynamic Properties feature last year, we would like to leverage
that for this feature.
   - Doug: We are planning on adding three new transforms.  The first would be
for Primary color correction.  It will have three modes to allow optimal
handling of video, logarithmic, and scence-linear image encodings.  The second
would be for refinement of Tone reproduction.  It would have five zones for
blacks, shadows, midtones, highlights, and whites, and the size of the zones
would be adjustable via additional parameters.  There would also be a control
for imparting an S-shape response.  These controls would also be customized for
the three encoding types (video, log, scene-linear).  The third transform would
be for custom RGB curves using B-splines.  There would be red, green, blue, and
master curves.  The curves would always be monotonic and would not clamp.  All
transforms would be invertible.
   - Mark: So are these only for the Look section of the config or may they be
used anywhere?  Doug: They could be used anywhere.  Mark: So how would users
adjust the dynamic parameters?  Doug: There is already an example, the
ExposureContrastTransform that was added when the dynamic parameter feature was
added.  On the GPU these parameters become uniforms on the shader and allow
adjustment without re-finalizing the transform.
   - Mark: I'm pretty scared about giving users knobs to twiddle.  The original
DisplayTransform did allow this but that was a limited case.  How are UIs
supposed to deal with this?
   - Dennis: These don't have to be user-facing.  I could have used this feature
all over for our color transforms.  We had a number of cases where we could not
use OCIO at all because this type of feature was missing.  Being able to have
parameterized ops would be perfect for a lot of things.
   - Kevin: I can relate to all of those points.  Is there a way to use the
transforms without giving users dynamic controls?  Doug: Yes.
   - Mark: OCIO is supposed to be a fixed look at a config that has already been
made.
   - Patrick: The ociodisplay program is kind of a toy example.  For a
real-world case, having to re-gen the shader program every time a parmeter is
modified is unworkable.  But we're only talking about a few transform types that
allow this and they work correctly even if an application chooses to ignore the
dynamic nature.
   - Mark: I feel it's a really big departure from how OCIO has worked so far. 
How do developers decide what parameters would be editable?  We don't want
artists to be able to make custom curves.  We're not trying to build a grading
suite.
   - Kevin: I understand that concern, but I also think the dynamic parameters
could be very useful.  In the past controls like exposure were not always in the
correct place in a particular pipeline.  It would be nice to have control over
that.  Doug: Yes, that was one of the original intents of dynamic parameters.
   - Mark: I could imaging the benefit of having the dynamic part in the view
part only.
   - Doug: Like Dennis, we have also fallen into situations where we would have
liked to have used OCIO but could not due to this limitation.  The applications
should only use this in places where it makes sense for their users.
   - Dennis: As an example, Sony has an HDR to SDR conversion that is
controllable per frame.  I would have loved to implement this in OCIO but there
was no way to do this back then so I needed to use a mixture of OCIO and
proprietary code that made it a lot more complicated.
   - Mark: How would the parameters get communicated?
   - Kevin: I've got a similar use-case to Dennis, maybe the solution is to use
one of the new formats?
   - Doug: As was done in an earlier feature, everything in OCIO may not be
exported as XML in CTF format, so that may be useful in certain scenarios.
   - Kevin: Would that include the dynamic values being flagged as such?  Doug:
Yes, there is a flag for that.  But the current values are also stored.  Kevin:
Yes, of course.  But would be nice to know if someone on set may have changed
some, which were dynamic and editable.
   - Mark: All the parameters will be flagged since they'll want to change
everything. Kevin: My use-case would be more constrained than that, but I get
what you're saying.
   - Mark: What you're looking for is something different from what OCIO was
originally intended for.  Kevin: I think what you're arguing for is several apps
that author several shaders that would somehow get merged into one pipeline. 
But that's potentially more complicated than adding a few dynamic properties to
OCIO (subject to people being sensible).
   - Dennis: This is deja-vu for me.  We are also on the OpenFX group and have
contributed some extensions.  We suggested the ability to do something similar
for OFX (FXDL) that could be used to capture parameter values from set and apply
them later in post.  Similar to how ASC CDL is used, but for an entire plug-in
chain.
   - Mark: From the VFX perspective, the reason we don't want to do that is we
have a mix of technical and creative transforms.   We want to avoid confusion
between what should be artist controllable and what should be fixed.  If you
limit the artist to just a single CDL, it's clear.  I have a fear that we are
enabling bad workflows.  Kevin: It sounds like BLGs, but simpler.
   - Doug: The technical vs creative parts would still be clear.  For example,
the matrix and LUT entries are not dynamic.  The new transforms are clearly for
creative purposes.
   - Carol: I think the intention behind them sounds appealing but I understand
the concerns from an implementation perspective of having editable parameters. 
It seems like we will need more implementation awareness in terms of what is
artist facing and what is not.  I agree it is slightly scary but I also see
applications where this would be extremely useful.
   - Doug: We did have a lot of discussion about this a year and a half ago when
the dynamic properties feature was introduced.  But the editability aspect is 
somewhat tangential to the new proposed feature.  The new transforms are not
really more editable than any of the others transforms such as CDL.
   - Deke: I still can't even get people to give me CDLs rather than LUTs.
   - Sean: I think it will be important about how they are enabled and how they
are exposed in applications.  There are two parts, creating the look and then
applying it.  It needs to be clear to the application when to show what.  That
should be configurable.
   - Doug: There is a tag already to indicate that a parameter is dynamic.  This
could be used for that type of signaling.
   - Michael: I've looked at the dynamic parameter implementation and it will
require an intentional effort on the part of an application to allow these to be
edited, it won't be accidental.  The use-case is probably not the typical VFX
facility use-case and more things like live adjustments for image viewers and
stuff like that.  I think the points are all valid but hopefully documentation
will clarify the intended usage and implementation.
   - Sean: Thinking about the transition of a config from someone who is editing
the parameters to others that are using (not editing) seems awkward since you'd
have to go in and turn off the dynamic flags.  
   - Doug: Very interesting discussion with many good points.  I will create an
issue on GitHub to capture further thoughts and discussion.
   - *UPDATE:* Issue created as #1100.

**NAMED TRANSFORMS**

   - Doug: The problem this feature is trying to address is how to integrate
legacy transforms into OCIO.  Sometimes users want to apply just a gamma or
log-to-lin (with no matrices or channel cross-talk), but they want to express it
within an OCIO config and access it via OCIO tools.  An example are the "Utility
curve/shaper" color spaces in the ACES config.  However these are currently
broken since in general there is a matrix applied in addition to the curve
(unless the target space is the reference space).  There is a need for a type of
transform that does not convert to the reference space.
   - Doug: The proposal is to add a new section to the config where these
transforms could be stored.  (An example of the proposed YAML was presented.) 
It would be possible to use these transforms with ColorSpaceTransform or
DisplayViewTransform.
   - Mark: I don't think config authors need this.  Who is the audience?  Doug:
There has been discussion on forums where users are confused by why the Utility
transforms in the ACES config are not behaving as they would expect (due to the
extra matrix being applied).  
   - Mark: Isn't that just a fault of the ACES config not being well documented?
 It's also strange that it uses ACES2065-1 as the reference space, since that's
not a typical working space.
   - Doug: The issue is that for generic configs like the ACES one, the config
author does not necessarily know the working space.  Users may be using several
working spaces.
   - Mark: The config author should always know the working space.  Kevin: Doug
is referring to the application's working space, not the config's working space
(i.e., the reference space).
   - Mark: I would expect the scene_linear role to be the reference space.
Kevin: Not always.  Carol: Yes, not always.  And it's also not the default in
nuke.
   - Mark: But that's the config author not doing their job correctly.  Carol:
It's a combination of the config and the application, so making it more explicit
is not a bad thing.
   - Doug: If you're a color scientist at a VFX facility and you're defining a
config for a specific show, then they would know the working space.  But more
generally if we're talking about the ACES config or the default config that
might ship with an application, there may be several possible working spaces
that people likely want to use.
   - Mark: You'd be better shipping five different configs rather than trying to
introduce a new transform to work around that.  You're trying to use OCIO in a
way it was not designed for and introducing unwanted complexity.  In OCIO, the
scene_linear role is the only working space allowed.  OCIO is not meant to be a
color management system, it's meant to be a baked pipeline.
   - Kevin: I understand what Mark is saying. The ACES config is a nightmare for
that very reason and we strip a lot of those spaces out where possible because
they are not color spaces.  What you're proposing are not transformations 
between color spaces.
   - Doug: They are more technical color transforms.  Sometimes you want to
apply a curve without mixing the channels, for example if you need to convert
from linear to log to apply some type of image processing.  It would be nice to
be able to have that curve in OCIO and use OCIO to apply it.  Mark: That's what
the compositing_log role is supposed to be used for.  Doug: Yes, but again that
assumes the config author is able to predict in advance what the working space
is.
   - Mark: It should not be up for debate, the opinion of OCIO is that the
config author defines the working space.
   - Doug: Yes, that makes sense for a specific show.  I think the disconnect is
that I'm trying to enable people to create general purpose configs where the
working space is not known in advance.
   - Deke: We run into this all the time where artists get confused by the ACES
config and we have to explain that you have to convert into ACES2065-1 before
applying the utility curves.
   - Mark: There is no such thing as a generic config and OCIO was not designed
to do that.  I don't think we should warp it to be designed in that way. 
Instead we should educate our users on how to use the tool correctly.
   - Deke: Many of these users don't even know what OCIO is.
   - Kevin: We encourage people to use the built-in nuke transforms (which don't
know about color) if they just want to do a log to lin conversion.  And if
you're doing a color space conversion use OCIO.  Mark: There's an OCIOLogConvert
in nuke that we encourage people to use.  Doug: Again, the OCIOLogConvert will
apply a matrix unless the working space is known in advance.
   - Doug: I understand it would be possible to direct people outside OCIO to do
a conversion that avoids the channel cross-talk.  However, this type of
conversion often needs to happen in the same place where a color space
conversion is needed.  For example, we don't want to have both an OCIO and
non-OCIO method for importing textures.  If any of you have other suggestions
for how to implement this, we're very open to discussing that.
   - Mark: Make a lot of color spaces that don't have matrices in them.  Or have
a dynamic working space.
   - Carol: Configs are not always used as intended.  Most places don't have a
color scientist who is authoring configs for them.  A lot of places are just
relying on the ACES config.  I think having a better generic config would help
and more documentation or training would help, but I do think having something
like this that people would more often get right than wrong would help also.
   - Mark: If you just give people a "gamma 2.2" button, they're going to hit
that every time and ignore the proper color space conversions.  The ILM config
generator lets us specify the reference gamut, perhaps the ACES config has to
have something similar.
   - Kevin: Would these named transforms in color space lists or somewhere else?
Doug: They would not appear in color space menus by default but applications
would be allowed to add them if they want.  I think the "Utility Curve" type
naming such as in the ACES config shows that the transforms could be named in a
sensible way.
   - Kevin: I think they should be very distinct from color spaces.
   - Sean: I think we're mixing two different problems.  One is the technical
ability to apply color transforms that don't need a to- or from-reference.  The
other problem is what we expose to the general audience.  I think the utility
spaces often promote bad color management practices.  But that is more part of
the ACES config discussion.  I think we should just focus on the first problem
for now.  I can see utility for this.  If I have a series of steps that I need
done, e.g. I reverse engineered that I need to add 5% saturation to some of the
images, I don't want to make an "RGB plus 5% saturation" color space because it
is not a by-the-book color space.  I'd rather refer to it as just a transform in
the config and tell the artists to apply this transform to the images and then
tag them as being in a by-the-book color space.
   - Kevin: I also have a use-case that is similar to the unbaking of something.
 I have hidden it under several menus and given it a really long name to try and
make artists not think of it as a color space.  The reason I'm doing it in OCIO
is so I could get it across multiple applications.  I get the use-case.
   - Mark: The only concept we have in OCIO to express things is a color space. 
Not every color space in the config needs to be a legit standard color space. 
We already have color spaces with show LUTs, for example.
   - Sean: It's true that there are workarounds, but it requires something of
the user to understand what the reference space is, otherwise they accidentally
get other stuff in that transform.  I see the use-case for something which is
just "apply these five steps" without worrying about the user screwing it up
because the image is in the wrong color space.  Kevin: The really long name in
my use-case tells the user what the starting color space needs to be before
applying it.
   - Doug: It sounds like you're saying that having a section of the config for
named transforms would be useful but we need to be careful about if or when they
appear in color space menus, since they are different things.  Kevin/Sean:
Agreed.
   - Mark: I think we're making this be way more complicated than we should have
it be.  It should be just a pipeline in a box.  It's going to be a lot for
applications to implement.
   - Deke: It's not clear that new nodes are required. 
Mark: Applications should not allow users to use a working space that is
different from the reference space of the config.
   - Doug: If we had this feature, we could move the Utility Curve spaces out of
the list of ACES color spaces while still allowing the config author to provide
these.
   - Mark: None of this would be a problem if we simply educate the users. Doug:
But the education required is to tell people to do this strange hack where you
need to convert to a specific color space in order to use the Utility curves,
and that does not seem that desirable.  
   - Deke: And how would you even be able to communicate that to everyone using
the ACES config?  Mark: Put it in the description and show it as tooltips. 
Carol: Except many artists won't see that.  (Many artists don't even know there
is a config.)
   - Mark: They'll know if they did the wrong thing since they got the wrong
result.  Carol: They don't always realize that.  Kevin: And if they do, it's
only what we figure out after they send us an email asking why the supervisor
rejected their shot.
   - Mark: I still don't understand why this is not a config author problem and
if the ACES config is broken or confusing, that's their problem.  I don't want
to complicate OCIO to handle this.
   - Doug: We are almost to the end of our booked meeting time.  I was
anticipating that this might be a controversial issue, and indeed it turned out
to be.
   - Joseph: I'm just amazed that you had something so controversial that was
not about naming!  ;)  Doug: Well it's called "Named Transform" so maybe that
was the jinx!
   - Kevin: How would you implement the inverse?  Doug: The syntax could be the
same as for Looks, to allow both a forward and inverse transform.  Kevin: Yes, I
think that will be necessary sometimes.
   - Doug: I'll create an issue on GitHub as a place to have further discussion
on this.
   - *UPDATE:* Issue created as #1101.
