/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Lognormal distribution variance.
*
* @module @stdlib/stats/base/dists/lognormal/variance
*
* @example
* var variance = require( '@stdlib/stats/base/dists/lognormal/variance' );
*
* var y = variance( 0.0, 1.0 );
* // returns ~4.671
*
* y = variance( 4.0, 2.0 );
* // returns ~8723355.729
*/

// MODULES //

var variance = require( './variance.js' );


// EXPORTS //

module.exports = variance;
