---
id: fast-foundation
title: fast-foundation 
hide_title: false
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->



## Classes

|  Class | Description |
|  --- | --- |
|  [Accordion](./fast-foundation.accordion.md) | An Accordion Custom HTML Element Implements [ARIA Accordion](https://www.w3.org/TR/wai-aria-practices-1.1/#accordion)<!-- -->. |
|  [AccordionItem](./fast-foundation.accordionitem.md) | An individual item in an [Accordion](./fast-foundation.accordion.md)<!-- -->.<!-- -->start - Content which can be provided between the heading and the icon<!-- -->end - Content which can be provided between the start slot and icon<!-- -->heading - Content which serves as the accordion item heading and text of the expand button<!-- -->- The default slot for accordion item content<!-- -->expanded-icon - The expanded icon<!-- -->collapsed-icon - The collapsed icon<!-- -->change - Fires a custom 'change' event when the button is invoked<!-- -->heading - Wraps the button<!-- -->button - The button which serves to invoke the item<!-- -->heading-content - Wraps the slot for the heading content within the button<!-- -->icon - The icon container<!-- -->expanded-icon - The expanded icon slot<!-- -->collapsed-icon - The collapsed icon<!-- -->region - The wrapper for the accordion item content |
|  [Anchor](./fast-foundation.anchor.md) | An Anchor Custom HTML Element. Based largely on the [&lt;a&gt; element](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/a)<!-- -->.<!-- -->start - Content which can be provided before the anchor content<!-- -->end - Content which can be provided after the anchor content<!-- -->- The default slot for anchor content<!-- -->control - The anchor element<!-- -->content - The element wrapping anchor content |
|  [AnchoredRegion](./fast-foundation.anchoredregion.md) | An anchored region Custom HTML Element.<!-- -->- The default slot for the content<!-- -->loaded - Fires a custom 'loaded' event when the region is loaded and visible<!-- -->positionchange - Fires a custom 'positionchange' event when the position has changed |
|  [ARIAGlobalStatesAndProperties](./fast-foundation.ariaglobalstatesandproperties.md) | Some states and properties are applicable to all host language elements regardless of whether a role is applied. The following global states and properties are supported by all roles and by all base markup elements. [https://www.w3.org/TR/wai-aria-1.1/\#global\_states](https://www.w3.org/TR/wai-aria-1.1/#global_states)<!-- -->This is intended to be used as a mixin. Be sure you extend FASTElement. |
|  [Avatar](./fast-foundation.avatar.md) | An Avatar Custom HTML Element<!-- -->media - Used for media such as an image<!-- -->- The default slot for avatar text, commonly a name or initials<!-- -->badge - Used to provide a badge, such as a status badge<!-- -->backplate - The wrapping container for the avatar<!-- -->link - The avatar link<!-- -->media - The media slot<!-- -->content - The default slot |
|  [Badge](./fast-foundation.badge.md) | A Badge Custom HTML Element.<!-- -->- The default slot for the badge<!-- -->control - The element representing the badge, which wraps the default slot |
|  [BaseProgress](./fast-foundation.baseprogress.md) | An Progress HTML Element. Implements the [ARIA progressbar](https://www.w3.org/TR/wai-aria-1.1/#progressbar)<!-- -->.<!-- -->indeterminate - The slot for a custom indeterminate indicator<!-- -->progress - Represents the progress element<!-- -->determinate - The determinate indicator<!-- -->indeterminate - The indeterminate indicator |
|  [Breadcrumb](./fast-foundation.breadcrumb.md) | A Breadcrumb Custom HTML Element.<!-- -->- The default slot for the breadcrumb items<!-- -->list - The element wrapping the slotted items |
|  [BreadcrumbItem](./fast-foundation.breadcrumbitem.md) | A Breadcrumb Item Custom HTML Element. |
|  [Button](./fast-foundation.button.md) | A Button Custom HTML Element. Based largely on the [&lt;button&gt; element](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/button)<!-- -->.<!-- -->start - Content which can be provided before the button content<!-- -->end - Content which can be provided after the button content<!-- -->- The default slot for button content<!-- -->control - The button element<!-- -->content - The element wrapping button content |
|  [Calendar](./fast-foundation.calendar.md) | Calendar component<!-- -->- The default slot for calendar content<!-- -->dateselected - Fires a custom 'dateselected' event when Enter is invoked via keyboard on a date |
|  [Card](./fast-foundation.card.md) | An Card Custom HTML Element.<!-- -->- The default slot for the card content |
|  [Checkbox](./fast-foundation.checkbox.md) | A Checkbox Custom HTML Element. Implements the [ARIA checkbox](https://www.w3.org/TR/wai-aria-1.1/#checkbox)<!-- -->.<!-- -->checked-indicator - The checked indicator<!-- -->indeterminate-indicator - The indeterminate indicator<!-- -->- The default slot for the label<!-- -->control - The element representing the visual checkbox control<!-- -->label - The label<!-- -->change - Emits a custom change event when the checked state changes |
|  [Combobox](./fast-foundation.combobox.md) | A Combobox Custom HTML Element. Implements the [ARIA combobox](https://w3c.github.io/aria-practices/#combobox)<!-- -->.<!-- -->start - Content which can be provided before the input<!-- -->end - Content which can be provided after the input<!-- -->control - Used to replace the input element representing the combobox<!-- -->indicator - The visual indicator representing the expanded state<!-- -->- The default slot for the options<!-- -->control - The wrapper element containing the input area, including start and end<!-- -->selected-value - The input element representing the selected value<!-- -->indicator - The element wrapping the indicator slot<!-- -->listbox - The wrapper for the listbox slotted options<!-- -->change - Fires a custom 'change' event when the value updates |
|  [DataGrid](./fast-foundation.datagrid.md) | A Data Grid Custom HTML Element.<!-- -->- The default slot for custom row elements |
|  [DataGridCell](./fast-foundation.datagridcell.md) | A Data Grid Cell Custom HTML Element.<!-- -->cell-focused - Fires a custom 'cell-focused' event when focus is on the cell or its contents<!-- -->- The default slot for cell contents. The "cell contents template" renders here. |
|  [DataGridRow](./fast-foundation.datagridrow.md) | A Data Grid Row Custom HTML Element.<!-- -->row-focused - Fires a custom 'row-focused' event when focus is on an element (usually a cell or its contents) in the row<!-- -->- The default slot for custom cell elements |
|  [DateFormatter](./fast-foundation.dateformatter.md) | Date formatting utility |
|  [DefaultComponentPresentation](./fast-foundation.defaultcomponentpresentation.md) | The default implementation of ComponentPresentation, used by FoundationElement. |
|  [DelegatesARIAButton](./fast-foundation.delegatesariabutton.md) | Includes ARIA states and properties relating to the ARIA button role |
|  [DelegatesARIACombobox](./fast-foundation.delegatesariacombobox.md) | Includes ARIA states and properties relating to the ARIA combobox role. |
|  [DelegatesARIALink](./fast-foundation.delegatesarialink.md) | Includes ARIA states and properties relating to the ARIA link role |
|  [DelegatesARIAListbox](./fast-foundation.delegatesarialistbox.md) | Includes ARIA states and properties relating to the ARIA listbox role |
|  [DelegatesARIAListboxOption](./fast-foundation.delegatesarialistboxoption.md) | States and properties relating to the ARIA <code>option</code> role. |
|  [DelegatesARIASearch](./fast-foundation.delegatesariasearch.md) | Includes ARIA states and properties relating to the ARIA textbox role |
|  [DelegatesARIASelect](./fast-foundation.delegatesariaselect.md) | Includes ARIA states and properties relating to the ARIA select role. |
|  [DelegatesARIATextbox](./fast-foundation.delegatesariatextbox.md) | Includes ARIA states and properties relating to the ARIA textbox role |
|  [DelegatesARIAToolbar](./fast-foundation.delegatesariatoolbar.md) | Includes ARIA states and properties relating to the ARIA toolbar role |
|  [Dialog](./fast-foundation.dialog.md) | A Switch Custom HTML Element. Implements the [ARIA dialog](https://www.w3.org/TR/wai-aria-1.1/#dialog)<!-- -->.<!-- -->- The default slot for the dialog content<!-- -->positioning-region - A wrapping element used to center the dialog and position the modal overlay<!-- -->overlay - The modal dialog overlay<!-- -->control - The dialog element<!-- -->cancel - Fires a custom 'cancel' event when the modal overlay is clicked<!-- -->close - Fires a custom 'close' event when the dialog is hidden |
|  [Disclosure](./fast-foundation.disclosure.md) | A Disclosure Custom HTML Element. Based largely on the [disclosure element](https://w3c.github.io/aria-practices/#disclosure)<!-- -->.<!-- -->start - Content which can be provided before the summary content<!-- -->end - Content which can be provided after the summary content<!-- -->title - The summary content<!-- -->- The default slot for the disclosure content<!-- -->toggle - fires a toggle event when the summary is toggled |
|  [Divider](./fast-foundation.divider.md) | A Divider Custom HTML Element. Implements the [ARIA separator](https://www.w3.org/TR/wai-aria-1.1/#separator) or [ARIA presentation](https://www.w3.org/TR/wai-aria-1.1/#presentation)<!-- -->. |
|  [Flipper](./fast-foundation.flipper.md) | A Flipper Custom HTML Element. Flippers are a form of button that implies directional content navigation, such as in a carousel.<!-- -->next - The next flipper content<!-- -->previous - The previous flipper content<!-- -->next - Wraps the next flipper content<!-- -->previous - Wraps the previous flipper content<!-- -->click - Fires a custom 'click' event when Enter or Space is invoked via keyboard and the flipper is exposed to assistive technologies. |
|  [FoundationElement](./fast-foundation.foundationelement.md) | Defines a foundation element class that: 1. Connects the element to its ComponentPresentation 2. Allows resolving the element template from the instance or ComponentPresentation 3. Allows resolving the element styles from the instance or ComponentPresentation |
|  [HorizontalScroll](./fast-foundation.horizontalscroll.md) | A HorizontalScroll Custom HTML Element<!-- -->start - Content which can be provided before the scroll area<!-- -->end - Content which can be provided after the scroll area<!-- -->scroll-area - Wraps the entire scrollable region<!-- -->scroll-view - The visible scroll area<!-- -->content-container - The container for the content<!-- -->scroll-prev - The previous flipper container<!-- -->scroll-action-previous - The element wrapping the previous flipper<!-- -->scroll-next - The next flipper container<!-- -->scroll-action-next - The element wrapping the next flipper<!-- -->scrollstart - Fires a custom 'scrollstart' event when scrolling<!-- -->scrollend - Fires a custom 'scrollend' event when scrolling stops |
|  [Listbox](./fast-foundation.listbox.md) | A Listbox Custom HTML Element. Implements the [ARIA listbox](https://www.w3.org/TR/wai-aria-1.1/#listbox)<!-- -->.<!-- -->- The default slot for the listbox options |
|  [ListboxElement](./fast-foundation.listboxelement.md) | A Listbox Custom HTML Element. Implements the [ARIA listbox](https://w3c.github.io/aria/#listbox)<!-- -->. |
|  [ListboxOption](./fast-foundation.listboxoption.md) | An Option Custom HTML Element. Implements [ARIA option](https://www.w3.org/TR/wai-aria-1.1/#option)<!-- -->.<!-- -->start - Content which can be provided before the listbox option content<!-- -->end - Content which can be provided after the listbox option content<!-- -->- The default slot for listbox option content<!-- -->content - Wraps the listbox option content |
|  [MatchMediaBehavior](./fast-foundation.matchmediabehavior.md) | An abstract behavior to react to media queries. Implementations should implement the <code>constructListener</code> method to perform some action based on media query changes. |
|  [MatchMediaStyleSheetBehavior](./fast-foundation.matchmediastylesheetbehavior.md) | A behavior to add or remove a stylesheet from an element based on a media query. The behavior ensures that styles are applied while the a query matches the environment and that styles are not applied if the query does not match the environment. |
|  [Menu](./fast-foundation.menu.md) | A Menu Custom HTML Element. Implements the [ARIA menu](https://www.w3.org/TR/wai-aria-1.1/#menu)<!-- -->.<!-- -->- The default slot for the menu items |
|  [MenuItem](./fast-foundation.menuitem.md) | A Switch Custom HTML Element. Implements [ARIA menuitem](https://www.w3.org/TR/wai-aria-1.1/#menuitem)<!-- -->, [ARIA menuitemcheckbox](https://www.w3.org/TR/wai-aria-1.1/#menuitemcheckbox)<!-- -->, or [ARIA menuitemradio](https://www.w3.org/TR/wai-aria-1.1/#menuitemradio)<!-- -->.<!-- -->checked-indicator - The checked indicator<!-- -->radio-indicator - The radio indicator<!-- -->start - Content which can be provided before the menu item content<!-- -->end - Content which can be provided after the menu item content<!-- -->- The default slot for menu item content<!-- -->expand-collapse-indicator - The expand/collapse indicator<!-- -->submenu - Used to nest menu's within menu items<!-- -->input-container - The element representing the visual checked or radio indicator<!-- -->checkbox - The element wrapping the <code>menuitemcheckbox</code> indicator<!-- -->radio - The element wrapping the <code>menuitemradio</code> indicator<!-- -->content - The element wrapping the menu item content<!-- -->expand-collapse-glyph-container - The element wrapping the expand collapse element<!-- -->expand-collapse - The expand/collapse element<!-- -->submenu-region - The container for the submenu, used for positioning<!-- -->expanded-change - Fires a custom 'expanded-change' event when the expanded state changes<!-- -->change - Fires a custom 'change' event when a non-submenu item with a role of <code>menuitemcheckbox</code>, <code>menuitemradio</code>, or <code>menuitem</code> is invoked |
|  [NumberField](./fast-foundation.numberfield.md) | A Number Field Custom HTML Element. Based largely on the [&lt;input type="number" /&gt; element](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input/number)<!-- -->.<!-- -->start - Content which can be provided before the number field input<!-- -->end - Content which can be provided after the number field input<!-- -->- The default slot for the label<!-- -->step-up-glyph - The glyph for the step up control<!-- -->step-down-glyph - The glyph for the step down control<!-- -->label - The label<!-- -->root - The element wrapping the control, including start and end slots<!-- -->control - The element representing the input<!-- -->controls - The step up and step down controls<!-- -->step-up - The step up control<!-- -->step-down - The step down control<!-- -->input - Fires a custom 'input' event when the value has changed<!-- -->change - Fires a custom 'change' event when the value has changed |
|  [PropertyStyleSheetBehavior](./fast-foundation.propertystylesheetbehavior.md) | A behavior to add or remove a stylesheet from an element based on a property. The behavior ensures that styles are applied while the property matches and that styles are not applied if the property does not match. |
|  [Radio](./fast-foundation.radio.md) | A Radio Custom HTML Element. Implements the [ARIA radio](https://www.w3.org/TR/wai-aria-1.1/#radio)<!-- -->.<!-- -->checked-indicator - The checked indicator<!-- -->- The default slot for the label<!-- -->control - The element representing the visual radio control<!-- -->label - The label<!-- -->change - Emits a custom change event when the checked state changes |
|  [RadioGroup](./fast-foundation.radiogroup.md) | An Radio Group Custom HTML Element. Implements the [ARIA radiogroup](https://www.w3.org/TR/wai-aria-1.1/#radiogroup)<!-- -->.<!-- -->label - The slot for the label<!-- -->- The default slot for radio buttons<!-- -->positioning-region - The positioning region for laying out the radios<!-- -->change - Fires a custom 'change' event when the value changes |
|  [ResolverBuilder](./fast-foundation.resolverbuilder.md) | A utility class used that constructs and registers resolvers for a dependency injection container. Supports a standard set of object lifetimes. |
|  [Search](./fast-foundation.search.md) | A Search Custom HTML Element. Based largely on the [&lt;input type="search" /&gt; element](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input/search)<!-- -->.<!-- -->start - Content which can be provided before the search input<!-- -->end - Content which can be provided after the search clear button<!-- -->- The default slot for the label<!-- -->close-button - The clear button<!-- -->close-glyph - The clear glyph<!-- -->label - The label<!-- -->root - The element wrapping the control, including start and end slots<!-- -->control - The element representing the input<!-- -->clear-button - The button to clear the input |
|  [Select](./fast-foundation.select.md) | A Select Custom HTML Element. Implements the [ARIA select](https://www.w3.org/TR/wai-aria-1.1/#select)<!-- -->.<!-- -->start - Content which can be provided before the button content<!-- -->end - Content which can be provided after the button content<!-- -->button-container - The element representing the select button<!-- -->selected-value - The selected value<!-- -->indicator - The visual indicator for the expand/collapse state of the button<!-- -->- The default slot for slotted options<!-- -->control - The element representing the select invoking element<!-- -->selected-value - The element wrapping the selected value<!-- -->indicator - The element wrapping the visual indicator<!-- -->listbox - The listbox element<!-- -->input - Fires a custom 'input' event when the value updates<!-- -->change - Fires a custom 'change' event when the value updates |
|  [Skeleton](./fast-foundation.skeleton.md) | A Skeleton Custom HTML Element.<!-- -->- The default slot |
|  [Slider](./fast-foundation.slider.md) | A Slider Custom HTML Element. Implements the [ARIA slider](https://www.w3.org/TR/wai-aria-1.1/#slider)<!-- -->.<!-- -->track - The track of the slider<!-- -->track-start - The track-start visual indicator<!-- -->thumb - The slider thumb<!-- -->- The default slot for labels<!-- -->positioning-region - The region used to position the elements of the slider<!-- -->track-container - The region containing the track elements<!-- -->track-start - The element wrapping the track start slot<!-- -->thumb-container - The thumb container element which is programatically positioned<!-- -->change - Fires a custom 'change' event when the slider value changes |
|  [SliderLabel](./fast-foundation.sliderlabel.md) | A label element intended to be used with the [Slider](./fast-foundation.slider.md) component.<!-- -->- The default slot for the label content<!-- -->root - The element wrapping the label mark and text |
|  [StartEnd](./fast-foundation.startend.md) | A mixin class implementing start and end elements. These are generally used to decorate text elements with icons or other visual indicators. |
|  [Switch](./fast-foundation.switch.md) | A Switch Custom HTML Element. Implements the [ARIA switch](https://www.w3.org/TR/wai-aria-1.1/#switch)<!-- -->.<!-- -->- The deafult slot for the label<!-- -->checked-message - The message when in a checked state<!-- -->unchecked-message - The message when in an unchecked state<!-- -->label - The label<!-- -->switch - The element representing the switch, which wraps the indicator<!-- -->status-message - The wrapper for the status messages<!-- -->checked-message - The checked message<!-- -->unchecked-message - The unchecked message<!-- -->change - Emits a custom change event when the checked state changes |
|  [Tab](./fast-foundation.tab.md) | A Tab Component to be used with [Tabs](./fast-foundation.tabs.md)<!-- -->- The default slot for the tab content |
|  [TabPanel](./fast-foundation.tabpanel.md) | A TabPanel Component to be used with [Tabs](./fast-foundation.tabs.md)<!-- -->- The default slot for the tabpanel content |
|  [Tabs](./fast-foundation.tabs.md) | A Tabs Custom HTML Element. Implements the [ARIA tablist](https://www.w3.org/TR/wai-aria-1.1/#tablist)<!-- -->.<!-- -->start - Content which can be provided before the tablist element<!-- -->end - Content which can be provided after the tablist element<!-- -->tab - The slot for tabs<!-- -->tabpanel - The slot for tabpanels<!-- -->tablist - The element wrapping for the tabs<!-- -->tab - The tab slot<!-- -->activeIndicator - The visual indicator<!-- -->tabpanel - The tabpanel slot<!-- -->change - Fires a custom 'change' event when a tab is clicked or during keyboard navigation |
|  [TextArea](./fast-foundation.textarea.md) | A Text Area Custom HTML Element. Based largely on the [&lt;textarea&gt; element](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/textarea)<!-- -->.<!-- -->- The default slot for the label<!-- -->label - The label<!-- -->root - The element wrapping the control<!-- -->control - The textarea element<!-- -->change - Emits a custom 'change' event when the textarea emits a change event |
|  [TextField](./fast-foundation.textfield.md) | A Text Field Custom HTML Element. Based largely on the [&lt;input type="text" /&gt; element](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input/text)<!-- -->.<!-- -->start - Content which can be provided before the number field input<!-- -->end - Content which can be provided after the number field input<!-- -->- The default slot for the label<!-- -->label - The label<!-- -->root - The element wrapping the control, including start and end slots<!-- -->control - The text field element<!-- -->change - Fires a custom 'change' event when the value has changed |
|  [Toolbar](./fast-foundation.toolbar.md) | A Toolbar Custom HTML Element. Implements the [ARIA Toolbar](https://w3c.github.io/aria-practices/#Toolbar)<!-- -->.<!-- -->start - Content which can be provided before the slotted items<!-- -->end - Content which can be provided after the slotted items<!-- -->- The default slot for slotted items<!-- -->label - The toolbar label<!-- -->positioning-region - The element containing the items, start and end slots |
|  [Tooltip](./fast-foundation.tooltip.md) | An Tooltip Custom HTML Element.<!-- -->- The default slot for the tooltip content<!-- -->tooltip - The tooltip element<!-- -->dismiss - Fires a custom 'dismiss' event when the tooltip is visible and escape key is pressed |
|  [TreeItem](./fast-foundation.treeitem.md) | A Tree item Custom HTML Element.<!-- -->start - Content which can be provided before the tree item content<!-- -->end - Content which can be provided after the tree item content<!-- -->- The default slot for tree item text content<!-- -->item - The slot for tree items (fast tree items manage this assignment themselves)<!-- -->expand-collapse-button - The expand/collapse button<!-- -->positioning-region - The element used to position the tree item content with exception of any child nodes<!-- -->content-region - The element containing the expand/collapse, start, and end slots<!-- -->items - The element wrapping any child items<!-- -->expand-collapse-button - The expand/collapse button<!-- -->expanded-change - Fires a custom 'expanded-change' event when the expanded state changes<!-- -->selected-change - Fires a custom 'selected-change' event when the selected state changes |
|  [TreeView](./fast-foundation.treeview.md) | A Tree view Custom HTML Element. Implements the [ARIA TreeView](https://w3c.github.io/aria-practices/#TreeView)<!-- -->.<!-- -->- The default slot for tree items |

## Functions

|  Function | Description |
|  --- | --- |
|  [applyMixins(derivedCtor, baseCtors)](./fast-foundation.applymixins.md) | Apply mixins to a constructor. Sourced from [TypeScript Documentation](https://www.typescriptlang.org/docs/handbook/mixins.html)<!-- -->. |
|  [composedContains(reference, test)](./fast-foundation.composedcontains.md) | Determines if the reference element contains the test element in a "composed" DOM tree that ignores shadow DOM boundaries.<!-- -->Returns true of the test element is a descendent of the reference, or exist in a shadow DOM that is a logical descendent of the reference. Otherwise returns false. |
|  [composedParent(element)](./fast-foundation.composedparent.md) | Retrieves the "composed parent" element of a node, ignoring DOM tree boundaries. When the parent of a node is a shadow-root, it will return the host element of the shadow root. Otherwise it will return the parent node or null if no parent node exists. |
|  [display(displayValue)](./fast-foundation.display.md) | Applies a CSS display property. Also adds CSS rules to not display the element when the \[hidden\] attribute is applied to the element. |
|  [ignore(target, property, descriptor)](./fast-foundation.ignore.md) | A decorator that tells the container not to try to inject a dependency. |
|  [isListboxOption(el)](./fast-foundation.islistboxoption.md) | Determines if the element is a [ListboxOption](./fast-foundation.listboxoption.md) |
|  [isTreeItemElement(el)](./fast-foundation.istreeitemelement.md) | check if the item is a tree item |
|  [reflectAttributes(attributes)](./fast-foundation.reflectattributes.md) | <b><i>(BETA)</i></b> Reflects attributes from the host element to the target element of the directive. |
|  [singleton()](./fast-foundation.singleton.md) | Registers the decorated class as a singleton dependency; the class will only be created once. Each consecutive time the dependency is resolved, the same instance will be returned. |
|  [singleton(options)](./fast-foundation.singleton_1.md) |  |
|  [singleton(target)](./fast-foundation.singleton_2.md) | Registers the <code>target</code> class as a singleton dependency; the class will only be created once. Each consecutive time the dependency is resolved, the same instance will be returned. |
|  [transient()](./fast-foundation.transient.md) | Registers the decorated class as a transient dependency; each time the dependency is resolved a new instance will be created. |
|  [transient(target)](./fast-foundation.transient_1.md) | Registers the <code>target</code> class as a transient dependency; each time the dependency is resolved a new instance will be created. |
|  [whitespaceFilter(value, index, array)](./fast-foundation.whitespacefilter.md) | a method to filter out any whitespace \_only\_ nodes, to be used inside a template |

## Interfaces

|  Interface | Description |
|  --- | --- |
|  [AnchoredRegionConfig](./fast-foundation.anchoredregionconfig.md) | A utility interface to store anchored region configurations that correspond to various common flyout positioning schemes |
|  [ColumnDefinition](./fast-foundation.columndefinition.md) | Defines a column in the grid |
|  [ComponentPresentation](./fast-foundation.componentpresentation.md) | Applies presentation details, such as template and styles, to a component instance. |
|  [Container](./fast-foundation.container.md) | Implemented by dependency injection containers. |
|  [ContainerConfiguration](./fast-foundation.containerconfiguration.md) | Configuration for a dependency injection container. |
|  [CSSDesignToken](./fast-foundation.cssdesigntoken.md) | A  that emits a CSS custom property. |
|  [DesignSystem](./fast-foundation.designsystem.md) | Represents a configurable design system. |
|  [DesignSystemRegistrationContext](./fast-foundation.designsystemregistrationcontext.md) | Design system contextual APIs and configuration usable within component registries. |
|  [DesignToken](./fast-foundation.designtoken.md) | Describes a DesignToken instance. |
|  [DesignTokenChangeRecord](./fast-foundation.designtokenchangerecord.md) | Change record provided to to a [DesignTokenSubscriber](./fast-foundation.designtokensubscriber.md) when a token changes for a target. |
|  [DesignTokenConfiguration](./fast-foundation.designtokenconfiguration.md) | Describes a  configuration |
|  [DesignTokenSubscriber](./fast-foundation.designtokensubscriber.md) | A subscriber that should receive [change records](./fast-foundation.designtokenchangerecord.md) when a token changes for a target |
|  [ElementDefinitionContext](./fast-foundation.elementdefinitioncontext.md) | The design system context in which an element can be defined. |
|  [ElementDefinitionParams](./fast-foundation.elementdefinitionparams.md) | The element definition context interface. Designed to be used in <code>tryDefineElement</code> |
|  [Factory](./fast-foundation.factory.md) | Used by the default Resolver to create instances of objects when needed. |
|  [FoundationElementDefinition](./fast-foundation.foundationelementdefinition.md) | An element definition used to define a FoundationElement when registered through the design system registry. |
|  [InterfaceConfiguration](./fast-foundation.interfaceconfiguration.md) | Used to configure a dependency injection interface key. |
|  [Registration](./fast-foundation.registration.md) | Implemented by objects that wish to register dependencies in the container by creating resolvers. |
|  [Registry](./fast-foundation.registry.md) | Implemented by objects that which to register dependencies in a container. |
|  [Resolver](./fast-foundation.resolver.md) | Internally, the DI system maps "keys" to "resolvers". A resolver controls how a dependency is resolved. Resolvers for transient, singleton, etc. are provided out of the box, but you can also implement Resolver yourself and supply custom logic for resolution. |
|  [ServiceLocator](./fast-foundation.servicelocator.md) | Implemented by objects capable of resolving services and other dependencies. |
|  [SliderConfiguration](./fast-foundation.sliderconfiguration.md) | The configuration structure of [Slider](./fast-foundation.slider.md)<!-- -->. |

## Variables

|  Variable | Description |
|  --- | --- |
|  [AccordionExpandMode](./fast-foundation.accordionexpandmode.md) | Expand mode for [Accordion](./fast-foundation.accordion.md) |
|  [accordionItemTemplate](./fast-foundation.accordionitemtemplate.md) | The template for the [AccordionItem](./fast-foundation.accordionitem.md) component. |
|  [accordionTemplate](./fast-foundation.accordiontemplate.md) | The template for the [Accordion](./fast-foundation.accordion.md) component. |
|  [all](./fast-foundation.all.md) | A decorator and DI resolver that will resolve an array of all dependencies registered with the specified key. |
|  [anchoredRegionTemplate](./fast-foundation.anchoredregiontemplate.md) | The template for the [AnchoredRegion](./fast-foundation.anchoredregion.md) component. |
|  [anchorTemplate](./fast-foundation.anchortemplate.md) | The template for the [Anchor](./fast-foundation.anchor.md) component. |
|  [avatarTemplate](./fast-foundation.avatartemplate.md) | The template for [Avatar](./fast-foundation.avatar.md) component. |
|  [badgeTemplate](./fast-foundation.badgetemplate.md) | The template for the [Badge](./fast-foundation.badge.md) component. |
|  [breadcrumbItemTemplate](./fast-foundation.breadcrumbitemtemplate.md) | The template for the [BreadcrumbItem](./fast-foundation.breadcrumbitem.md) component. |
|  [breadcrumbTemplate](./fast-foundation.breadcrumbtemplate.md) | The template for the [Breadcrumb](./fast-foundation.breadcrumb.md) component. |
|  [buttonTemplate](./fast-foundation.buttontemplate.md) | The template for the [Button](./fast-foundation.button.md) component. |
|  [calendarCellTemplate](./fast-foundation.calendarcelltemplate.md) | A calendar day template |
|  [calendarRowTemplate](./fast-foundation.calendarrowtemplate.md) |  |
|  [calendarTemplate](./fast-foundation.calendartemplate.md) | The template for the [Calendar](./fast-foundation.calendar.md) component. |
|  [CalendarTitleTemplate](./fast-foundation.calendartitletemplate.md) | A basic Calendar title template that includes the month and year |
|  [calendarWeekdayTemplate](./fast-foundation.calendarweekdaytemplate.md) | Calendar weekday label template |
|  [cardTemplate](./fast-foundation.cardtemplate.md) | The template for the [Card](./fast-foundation.card.md) component. |
|  [checkboxTemplate](./fast-foundation.checkboxtemplate.md) | The template for the [Checkbox](./fast-foundation.checkbox.md) component. |
|  [ComboboxAutocomplete](./fast-foundation.comboboxautocomplete.md) | Autocomplete values for combobox. |
|  [comboboxTemplate](./fast-foundation.comboboxtemplate.md) | The template for the [Combobox](./fast-foundation.combobox.md) component. |
|  [ComponentPresentation](./fast-foundation.componentpresentation.md) | An API gateway to component presentation features. |
|  [Container](./fast-foundation.container.md) | The interface key that resolves the dependency injection container itself. |
|  [ContainerConfiguration](./fast-foundation.containerconfiguration.md) | Configuration for a dependency injection container. |
|  [darkModeStylesheetBehavior](./fast-foundation.darkmodestylesheetbehavior.md) | This can be used to construct a behavior to apply a prefers color scheme: dark only stylesheet. |
|  [dataGridCellTemplate](./fast-foundation.datagridcelltemplate.md) | Generates a template for the [DataGridCell](./fast-foundation.datagridcell.md) component using the provided prefix. |
|  [DataGridCellTypes](./fast-foundation.datagridcelltypes.md) | Enumerates possible data grid cell types. |
|  [dataGridRowTemplate](./fast-foundation.datagridrowtemplate.md) | Generates a template for the [DataGridRow](./fast-foundation.datagridrow.md) component using the provided prefix. |
|  [DataGridRowTypes](./fast-foundation.datagridrowtypes.md) | Enumerates possible data grid row types |
|  [dataGridTemplate](./fast-foundation.datagridtemplate.md) | Generates a template for the [DataGrid](./fast-foundation.datagrid.md) component using the provided prefix. |
|  [DefaultResolver](./fast-foundation.defaultresolver.md) | A set of default resolvers useful in configuring a container. |
|  [DesignSystem](./fast-foundation.designsystem.md) | An API gateway to design system features. |
|  [DesignToken](./fast-foundation.designtoken.md) | Factory object for creating  instances. |
|  [DI](./fast-foundation.di.md) | The gateway to dependency injection APIs. |
|  [dialogTemplate](./fast-foundation.dialogtemplate.md) | The template for the [Dialog](./fast-foundation.dialog.md) component. |
|  [disabledCursor](./fast-foundation.disabledcursor.md) | The CSS value for disabled cursors. |
|  [disclosureTemplate](./fast-foundation.disclosuretemplate.md) | The template for the [Disclosure](./fast-foundation.disclosure.md) component. |
|  [DividerRole](./fast-foundation.dividerrole.md) | Divider roles |
|  [dividerTemplate](./fast-foundation.dividertemplate.md) | The template for the [Divider](./fast-foundation.divider.md) component. |
|  [ElementDisambiguation](./fast-foundation.elementdisambiguation.md) | Indicates what to do with an ambiguous (duplicate) element. |
|  [endSlotTemplate](./fast-foundation.endslottemplate.md) | The template for the end element. For use with [StartEnd](./fast-foundation.startend.md) |
|  [endTemplate](./fast-foundation.endtemplate.md) | The template for the end element. For use with [StartEnd](./fast-foundation.startend.md) |
|  [FlipperDirection](./fast-foundation.flipperdirection.md) | The direction options for flipper. |
|  [flipperTemplate](./fast-foundation.flippertemplate.md) | The template for the [Flipper](./fast-foundation.flipper.md) component. |
|  [FlyoutPosBottom](./fast-foundation.flyoutposbottom.md) | A region that always places itself below the anchor, has a width to match the anchor, and is sized vertically by content |
|  [FlyoutPosBottomFill](./fast-foundation.flyoutposbottomfill.md) | A region that always places itself below the anchor, has a width to match the anchor, and is sized vertically by available space |
|  [FlyoutPosTallest](./fast-foundation.flyoutpostallest.md) | A region that places itself above or below the anchor based on available space, has a width to match the anchor, and is sized vertically by content |
|  [FlyoutPosTallestFill](./fast-foundation.flyoutpostallestfill.md) | A region that places itself above or below the anchor based on available space, has a width to match the anchor, and is sized vertically by available space |
|  [FlyoutPosTop](./fast-foundation.flyoutpostop.md) | A region that always places itself above the anchor, has a width to match the anchor, and is sized vertically by content |
|  [FlyoutPosTopFill](./fast-foundation.flyoutpostopfill.md) | A region that always places itself above the anchor, has a width to match the anchor, and is sized vertically by available space |
|  [focusVisible](./fast-foundation.focusvisible.md) | The string representing the focus selector to be used. Value will be "focus-visible" when https://drafts.csswg.org/selectors-4/\#the-focus-visible-pseudo is supported and "focus" when it is not. |
|  [forcedColorsStylesheetBehavior](./fast-foundation.forcedcolorsstylesheetbehavior.md) | This can be used to construct a behavior to apply a forced-colors only stylesheet. |
|  [GenerateHeaderOptions](./fast-foundation.generateheaderoptions.md) | Enumerates the data grid auto generated header options default option generates a non-sticky header row |
|  [getDirection](./fast-foundation.getdirection.md) | a method to determine the current localization direction of the view |
|  [hidden](./fast-foundation.hidden.md) | A CSS fragment to set <code>display: none;</code> when the host is hidden using the \[hidden\] attribute. |
|  [horizontalScrollTemplate](./fast-foundation.horizontalscrolltemplate.md) |  |
|  [inject](./fast-foundation.inject.md) | A decorator that specifies what to inject into its target. |
|  [lazy](./fast-foundation.lazy.md) | A decorator that lazily injects a dependency depending on whether the <code>Key</code> is present at the time of function call. |
|  [lightModeStylesheetBehavior](./fast-foundation.lightmodestylesheetbehavior.md) | This can be used to construct a behavior to apply a prefers color scheme: light only stylesheet. |
|  [listboxOptionTemplate](./fast-foundation.listboxoptiontemplate.md) | The template for the [ListboxOption](./fast-foundation.listboxoption.md) component. |
|  [listboxTemplate](./fast-foundation.listboxtemplate.md) | The template for the [Listbox](./fast-foundation.listbox.md) component. |
|  [MenuItemRole](./fast-foundation.menuitemrole.md) | Menu items roles. |
|  [menuItemTemplate](./fast-foundation.menuitemtemplate.md) | Generates a template for the [MenuItem](./fast-foundation.menuitem.md) component using the provided prefix. |
|  [menuTemplate](./fast-foundation.menutemplate.md) | The template for the [Menu](./fast-foundation.menu.md) component. |
|  [newInstanceForScope](./fast-foundation.newinstanceforscope.md) | A decorator that indicates that a new instance should be injected scoped to the container that requested the instance. |
|  [newInstanceOf](./fast-foundation.newinstanceof.md) | A decorator that indicates that a new instance should be injected. |
|  [numberFieldTemplate](./fast-foundation.numberfieldtemplate.md) | The template for the [NumberField](./fast-foundation.numberfield.md) component. |
|  [optional](./fast-foundation.optional.md) | A decorator that allows you to optionally inject a dependency depending on whether the \[\[<code>Key</code>\]\] is present, for example: |
|  [pickerListItemTemplate](./fast-foundation.pickerlistitemtemplate.md) |  |
|  [pickerListTemplate](./fast-foundation.pickerlisttemplate.md) |  |
|  [pickerMenuOptionTemplate](./fast-foundation.pickermenuoptiontemplate.md) |  |
|  [pickerMenuTemplate](./fast-foundation.pickermenutemplate.md) | The template for the List Picker component. |
|  [pickerTemplate](./fast-foundation.pickertemplate.md) | The template for the List Picker component. |
|  [progressRingTemplate](./fast-foundation.progressringtemplate.md) | The template for the [BaseProgress](./fast-foundation.baseprogress.md) component. |
|  [progressTemplate](./fast-foundation.progresstemplate.md) | The template for the [BaseProgress](./fast-foundation.baseprogress.md) component. |
|  [radioGroupTemplate](./fast-foundation.radiogrouptemplate.md) | The template for the [RadioGroup](./fast-foundation.radiogroup.md) component. |
|  [radioTemplate](./fast-foundation.radiotemplate.md) | The template for the [Radio](./fast-foundation.radio.md) component. |
|  [Registration](./fast-foundation.registration.md) | You can use the resulting Registration of any of the factory methods to register with the container. |
|  [searchTemplate](./fast-foundation.searchtemplate.md) | The template for the [Search](./fast-foundation.search.md) component. |
|  [SelectPosition](./fast-foundation.selectposition.md) | Positioning directions for the listbox when a select is open. |
|  [selectTemplate](./fast-foundation.selecttemplate.md) | The template for the [Select](./fast-foundation.select.md) component. |
|  [ServiceLocator](./fast-foundation.servicelocator.md) | The interface key that resolves the service locator itself. |
|  [skeletonTemplate](./fast-foundation.skeletontemplate.md) | The template for the fast-skeleton component |
|  [sliderLabelTemplate](./fast-foundation.sliderlabeltemplate.md) | The template for the [SliderLabel](./fast-foundation.sliderlabel.md) component. |
|  [SliderMode](./fast-foundation.slidermode.md) | The selection modes of a [Slider](./fast-foundation.slider.md)<!-- -->. |
|  [sliderTemplate](./fast-foundation.slidertemplate.md) | The template for the [Slider](./fast-foundation.slider.md) component. |
|  [startSlotTemplate](./fast-foundation.startslottemplate.md) | The template for the start element. For use with [StartEnd](./fast-foundation.startend.md) |
|  [startTemplate](./fast-foundation.starttemplate.md) | The template for the start element. For use with [StartEnd](./fast-foundation.startend.md) |
|  [switchTemplate](./fast-foundation.switchtemplate.md) | The template for the [Switch](./fast-foundation.switch.md) component. |
|  [tabPanelTemplate](./fast-foundation.tabpaneltemplate.md) | The template for the [TabPanel](./fast-foundation.tabpanel.md) component. |
|  [TabsOrientation](./fast-foundation.tabsorientation.md) | The orientation of the [Tabs](./fast-foundation.tabs.md) component |
|  [tabsTemplate](./fast-foundation.tabstemplate.md) | The template for the [Tabs](./fast-foundation.tabs.md) component. |
|  [tabTemplate](./fast-foundation.tabtemplate.md) | The template for the [Tab](./fast-foundation.tab.md) component. |
|  [TextAreaResize](./fast-foundation.textarearesize.md) | Resize mode for a TextArea |
|  [textAreaTemplate](./fast-foundation.textareatemplate.md) | The template for the [TextArea](./fast-foundation.textarea.md) component. |
|  [textFieldTemplate](./fast-foundation.textfieldtemplate.md) | The template for the [TextField](./fast-foundation.textfield.md) component. |
|  [TextFieldType](./fast-foundation.textfieldtype.md) | Text field sub-types |
|  [toolbarTemplate](./fast-foundation.toolbartemplate.md) | The template for the [Toolbar](./fast-foundation.toolbar.md) component. |
|  [TooltipPosition](./fast-foundation.tooltipposition.md) | Enumerates possible tooltip positions |
|  [tooltipTemplate](./fast-foundation.tooltiptemplate.md) | Creates a template for the [Tooltip](./fast-foundation.tooltip.md) component using the provided prefix. |
|  [treeItemTemplate](./fast-foundation.treeitemtemplate.md) | The template for the [TreeItem](./fast-foundation.treeitem.md) component. |
|  [treeViewTemplate](./fast-foundation.treeviewtemplate.md) | The template for the [TreeView](./fast-foundation.treeview.md) component. |

## Type Aliases

|  Type Alias | Description |
|  --- | --- |
|  [AccordionExpandMode](./fast-foundation.accordionexpandmode.md) | Type for the [Accordion](./fast-foundation.accordion.md) Expand Mode |
|  [AccordionItemOptions](./fast-foundation.accordionitemoptions.md) | Accordion Item configuration options |
|  [AnchoredRegionPositionLabel](./fast-foundation.anchoredregionpositionlabel.md) | Describes the possible positions of the region relative to its anchor. Depending on the axis start = left/top, end = right/bottom |
|  [AnchorOptions](./fast-foundation.anchoroptions.md) | Anchor configuration options |
|  [AutoUpdateMode](./fast-foundation.autoupdatemode.md) | Defines if the component updates its position automatically. Calling update() always provokes an update. anchor - the component only updates its position when the anchor resizes (default) auto - the component updates its position when: - update() is called - the anchor resizes - the window resizes - the viewport resizes - any scroll event in the document |
|  [AvatarOptions](./fast-foundation.avataroptions.md) | Avatar configuration options |
|  [AxisPositioningMode](./fast-foundation.axispositioningmode.md) | Defines the base behavior of an anchored region on a particular axis |
|  [AxisScalingMode](./fast-foundation.axisscalingmode.md) | Defines the scaling behavior of an anchored region on a particular axis |
|  [BreadcrumbItemOptions](./fast-foundation.breadcrumbitemoptions.md) | Breadcrumb Item configuration options<!-- -->- The default slot for when no href is provided or for providing your own custom elements<!-- -->separator - The slot for providing a custom separator<!-- -->listitem - The wrapping container for the item, represents a semantic listitem<!-- -->separator - The wrapping element for the separator |
|  [ButtonOptions](./fast-foundation.buttonoptions.md) | Button configuration options |
|  [CalendarDateInfo](./fast-foundation.calendardateinfo.md) | Caldendar date info used to represent a date |
|  [CalendarInfo](./fast-foundation.calendarinfo.md) | Calendar information needed for rendering including the next and previous months |
|  [CalendarOptions](./fast-foundation.calendaroptions.md) | Calendar configuration options |
|  [CheckboxOptions](./fast-foundation.checkboxoptions.md) | Checkbox configuration options |
|  [ComboboxAutocomplete](./fast-foundation.comboboxautocomplete.md) | Autocomplete type for combobox. |
|  [ComboboxOptions](./fast-foundation.comboboxoptions.md) | Combobox configuration options |
|  [ContextualElementDefinition](./fast-foundation.contextualelementdefinition.md) | Enables defining an element within the context of a design system. |
|  [CSSDisplayPropertyValue](./fast-foundation.cssdisplaypropertyvalue.md) | Define all possible CSS display values. |
|  [DataGridCellTypes](./fast-foundation.datagridcelltypes.md) | The possible cell types. |
|  [DataGridRowTypes](./fast-foundation.datagridrowtypes.md) | The possible data grid row types |
|  [DayFormat](./fast-foundation.dayformat.md) | A type representing the different day formats |
|  [DerivedDesignTokenValue](./fast-foundation.deriveddesigntokenvalue.md) | A  value that is derived. These values can depend on other s or arbitrary observable properties. |
|  [DesignTokenValue](./fast-foundation.designtokenvalue.md) | The type that a  can be set to. |
|  [DividerRole](./fast-foundation.dividerrole.md) | The types for Divider roles |
|  [ElementDefinitionCallback](./fast-foundation.elementdefinitioncallback.md) | The callback type that is invoked when an element can be defined by a design system. |
|  [ElementDisambiguationCallback](./fast-foundation.elementdisambiguationcallback.md) | The callback type that is invoked when two elements are trying to define themselves with the same name. |
|  [ElementDisambiguationResult](./fast-foundation.elementdisambiguationresult.md) | Represents the return values expected from an ElementDisambiguationCallback. |
|  [EndOptions](./fast-foundation.endoptions.md) | End configuration options |
|  [FlipperDirection](./fast-foundation.flipperdirection.md) | The types for the flipper direction options. |
|  [FlipperOptions](./fast-foundation.flipperoptions.md) | Flipper configuration options |
|  [FoundationElementTemplate](./fast-foundation.foundationelementtemplate.md) | A foundation element template function. |
|  [GenerateHeaderOptions](./fast-foundation.generateheaderoptions.md) | The types for the data grid auto generated header options |
|  [HorizontalPosition](./fast-foundation.horizontalposition.md) | Defines the horizontal positioning options for an anchored region |
|  [HorizontalScrollOptions](./fast-foundation.horizontalscrolloptions.md) | Horizontal scroll configuration options |
|  [HorizontalScrollView](./fast-foundation.horizontalscrollview.md) | The views types for a horizontal-scroll [HorizontalScroll](./fast-foundation.horizontalscroll.md) |
|  [Injectable](./fast-foundation.injectable.md) | A class that declares constructor injected dependencies through a static "inject" field array of keys. |
|  [InterfaceSymbol](./fast-foundation.interfacesymbol.md) | A constant key that can be used to represent an interface to a registered dependency. The key can be used in DI registrations but also doubles as a decorator for resolving the associated, registered dependency. |
|  [Key](./fast-foundation.key.md) | A key that is used to register dependencies with a dependency injection container. |
|  [ListboxOptionOptions](./fast-foundation.listboxoptionoptions.md) | Listbox option configuration options |
|  [MediaQueryListListener](./fast-foundation.mediaquerylistlistener.md) | An event listener fired by a [MediaQueryList](https://developer.mozilla.org/en-US/docs/Web/API/MediaQueryList)<!-- -->. |
|  [menuConfigs](./fast-foundation.menuconfigs.md) | <b><i>(BETA)</i></b> Defines the vertical positioning options for an anchored region |
|  [MenuItemColumnCount](./fast-foundation.menuitemcolumncount.md) | Types of menu item column count. |
|  [MenuItemOptions](./fast-foundation.menuitemoptions.md) | Menu Item configuration options |
|  [MenuItemRole](./fast-foundation.menuitemrole.md) | The types for menu item roles |
|  [MonthFormat](./fast-foundation.monthformat.md) | A type representing the different month formats |
|  [MonthInfo](./fast-foundation.monthinfo.md) | Information about a month |
|  [NumberFieldOptions](./fast-foundation.numberfieldoptions.md) | Number Field configuration options |
|  [OverrideFoundationElementDefinition](./fast-foundation.overridefoundationelementdefinition.md) | A set of properties which the component consumer can override during the element registration process. |
|  [ParentLocator](./fast-foundation.parentlocator.md) | A function capable of locating the parent container based on a container's owner. |
|  [ProgressOptions](./fast-foundation.progressoptions.md) | Progress configuration options |
|  [ProgressRingOptions](./fast-foundation.progressringoptions.md) | ProgressRing configuration options |
|  [RadioControl](./fast-foundation.radiocontrol.md) | A structure representing a [Radio](./fast-foundation.radio.md) element |
|  [RadioOptions](./fast-foundation.radiooptions.md) | Radio configuration options |
|  [RegisterSelf](./fast-foundation.registerself.md) | Represents an object that can register itself. |
|  [ResolveCallback](./fast-foundation.resolvecallback.md) | Represents a custom callback for resolving a request from the container. The handler is the container that is invoking the callback. The requestor is the original container that made the request. The handler and the requestor may not be the same if the request has bubbled up to a parent container in the DI hierarchy. The resolver is the instance of the resolver that stores the callback. This is provided in case the callback needs a place or key against which to store state across resolutions. |
|  [Resolved](./fast-foundation.resolved.md) | Represents something resolved from a service locator. |
|  [ScrollEasing](./fast-foundation.scrolleasing.md) | The easing types available for the horizontal-scroll [HorizontalScroll](./fast-foundation.horizontalscroll.md) |
|  [SearchOptions](./fast-foundation.searchoptions.md) | Search configuration options |
|  [SelectOptions](./fast-foundation.selectoptions.md) | Select configuration options |
|  [SelectPosition](./fast-foundation.selectposition.md) | Types for positioning the select element listbox when open |
|  [SkeletonShape](./fast-foundation.skeletonshape.md) | A structure representing skeleton shapes |
|  [SliderMode](./fast-foundation.slidermode.md) | The types for the selection mode of the slider |
|  [SliderOptions](./fast-foundation.slideroptions.md) | Slider configuration options |
|  [StartEndOptions](./fast-foundation.startendoptions.md) | Start/End configuration options |
|  [StartOptions](./fast-foundation.startoptions.md) | Start configuration options |
|  [StaticDesignTokenValue](./fast-foundation.staticdesigntokenvalue.md) | A design token value with no observable dependencies |
|  [SwitchOptions](./fast-foundation.switchoptions.md) | Switch configuration options |
|  [TabsOptions](./fast-foundation.tabsoptions.md) | Tabs option configuration options |
|  [TabsOrientation](./fast-foundation.tabsorientation.md) | The types for the Tabs component |
|  [TextAreaResize](./fast-foundation.textarearesize.md) | Types for the Text Area resize mode |
|  [TextFieldOptions](./fast-foundation.textfieldoptions.md) | Text field configuration options |
|  [TextFieldType](./fast-foundation.textfieldtype.md) | Types for the text field sub-types |
|  [ToolbarOptions](./fast-foundation.toolbaroptions.md) | Toolbar configuration options |
|  [TooltipPosition](./fast-foundation.tooltipposition.md) | The possible tooltip positions |
|  [Transformer\_2](./fast-foundation.transformer_2.md) | Transforms an object after it is created but before it is returned to the requestor. |
|  [TreeItemOptions](./fast-foundation.treeitemoptions.md) | Tree Item configuration options |
|  [VerticalPosition](./fast-foundation.verticalposition.md) | Defines the vertical positioning options for an anchored region |
|  [WeekdayFormat](./fast-foundation.weekdayformat.md) | A type representing the different weekday formats |
|  [YearFormat](./fast-foundation.yearformat.md) | A type representing the different year formats |
