/*
   mkvmerge -- utility for splicing together matroska files
   from component media subtypes

   Distributed under the GPL v2
   see the file COPYING for details
   or visit https://www.gnu.org/licenses/old-licenses/gpl-2.0.html

   ISO 15924 script list

   Written by Moritz Bunkus <moritz@bunkus.org>.
*/

// -------------------------------------------------------------------------
// NOTE: this file is auto-generated by the "dev:iso15924_list" rake target.
// -------------------------------------------------------------------------

#include "common/common_pch.h"

#include "common/iso15924.h"

namespace mtx::iso15924 {

std::vector<script_t> g_scripts;

struct script_init_t {
  char const *code;
  unsigned int number;
  char const *english_name;
  bool is_deprecated;
};

static script_init_t const s_scripts_init[] = {
  { "Adlm", 166, u8"Adlam",                                                                                           false },
  { "Afak", 439, u8"Afaka",                                                                                           false },
  { "Aghb", 239, u8"Caucasian Albanian",                                                                              false },
  { "Ahom", 338, u8"Ahom, Tai Ahom",                                                                                  false },
  { "Arab", 160, u8"Arabic",                                                                                          false },
  { "Aran", 161, u8"Arabic (Nastaliq variant)",                                                                       false },
  { "Armi", 124, u8"Imperial Aramaic",                                                                                false },
  { "Armn", 230, u8"Armenian",                                                                                        false },
  { "Avst", 134, u8"Avestan",                                                                                         false },
  { "Bali", 360, u8"Balinese",                                                                                        false },
  { "Bamu", 435, u8"Bamum",                                                                                           false },
  { "Bass", 259, u8"Bassa Vah",                                                                                       false },
  { "Batk", 365, u8"Batak",                                                                                           false },
  { "Beng", 325, u8"Bengali (Bangla)",                                                                                false },
  { "Bhks", 334, u8"Bhaiksuki",                                                                                       false },
  { "Blis", 550, u8"Blissymbols",                                                                                     false },
  { "Bopo", 285, u8"Bopomofo",                                                                                        false },
  { "Brah", 300, u8"Brahmi",                                                                                          false },
  { "Brai", 570, u8"Braille",                                                                                         false },
  { "Bugi", 367, u8"Buginese",                                                                                        false },
  { "Buhd", 372, u8"Buhid",                                                                                           false },
  { "Cakm", 349, u8"Chakma",                                                                                          false },
  { "Cans", 440, u8"Unified Canadian Aboriginal Syllabics",                                                           false },
  { "Cari", 201, u8"Carian",                                                                                          false },
  { "Cham", 358, u8"Cham",                                                                                            false },
  { "Cher", 445, u8"Cherokee",                                                                                        false },
  { "Chrs", 109, u8"Chorasmian",                                                                                      false },
  { "Cirt", 291, u8"Cirth",                                                                                           false },
  { "Copt", 204, u8"Coptic",                                                                                          false },
  { "Cpmn", 402, u8"Cypro-Minoan",                                                                                    false },
  { "Cprt", 403, u8"Cypriot syllabary",                                                                               false },
  { "Cyrl", 220, u8"Cyrillic",                                                                                        false },
  { "Cyrs", 221, u8"Cyrillic (Old Church Slavonic variant)",                                                          false },
  { "Deva", 315, u8"Devanagari (Nagari)",                                                                             false },
  { "Diak", 342, u8"Dives Akuru",                                                                                     false },
  { "Dogr", 328, u8"Dogra",                                                                                           false },
  { "Dsrt", 250, u8"Deseret (Mormon)",                                                                                false },
  { "Dupl", 755, u8"Duployan shorthand, Duployan stenography",                                                        false },
  { "Egyd",  70, u8"Egyptian demotic",                                                                                false },
  { "Egyh",  60, u8"Egyptian hieratic",                                                                               false },
  { "Egyp",  50, u8"Egyptian hieroglyphs",                                                                            false },
  { "Elba", 226, u8"Elbasan",                                                                                         false },
  { "Elym", 128, u8"Elymaic",                                                                                         false },
  { "Ethi", 430, u8"Ethiopic (Geʻez)",                                                                                false },
  { "Geok", 241, u8"Khutsuri (Asomtavruli and Nuskhuri)",                                                             false },
  { "Geor", 240, u8"Georgian (Mkhedruli and Mtavruli)",                                                               false },
  { "Glag", 225, u8"Glagolitic",                                                                                      false },
  { "Gong", 312, u8"Gunjala Gondi",                                                                                   false },
  { "Gonm", 313, u8"Masaram Gondi",                                                                                   false },
  { "Goth", 206, u8"Gothic",                                                                                          false },
  { "Gran", 343, u8"Grantha",                                                                                         false },
  { "Grek", 200, u8"Greek",                                                                                           false },
  { "Gujr", 320, u8"Gujarati",                                                                                        false },
  { "Guru", 310, u8"Gurmukhi",                                                                                        false },
  { "Hanb", 503, u8"Han with Bopomofo (alias for Han + Bopomofo)",                                                    false },
  { "Hang", 286, u8"Hangul (Hangŭl, Hangeul)",                                                                        false },
  { "Hani", 500, u8"Han (Hanzi, Kanji, Hanja)",                                                                       false },
  { "Hano", 371, u8"Hanunoo (Hanunóo)",                                                                               false },
  { "Hans", 501, u8"Han (Simplified variant)",                                                                        false },
  { "Hant", 502, u8"Han (Traditional variant)",                                                                       false },
  { "Hatr", 127, u8"Hatran",                                                                                          false },
  { "Hebr", 125, u8"Hebrew",                                                                                          false },
  { "Hira", 410, u8"Hiragana",                                                                                        false },
  { "Hluw",  80, u8"Anatolian Hieroglyphs (Luwian Hieroglyphs, Hittite Hieroglyphs)",                                 false },
  { "Hmng", 450, u8"Pahawh Hmong",                                                                                    false },
  { "Hmnp", 451, u8"Nyiakeng Puachue Hmong",                                                                          false },
  { "Hrkt", 412, u8"Japanese syllabaries (alias for Hiragana + Katakana)",                                            false },
  { "Hung", 176, u8"Old Hungarian (Hungarian Runic)",                                                                 false },
  { "Inds", 610, u8"Indus (Harappan)",                                                                                false },
  { "Ital", 210, u8"Old Italic (Etruscan, Oscan, etc.)",                                                              false },
  { "Jamo", 284, u8"Jamo (alias for Jamo subset of Hangul)",                                                          false },
  { "Java", 361, u8"Javanese",                                                                                        false },
  { "Jpan", 413, u8"Japanese (alias for Han + Hiragana + Katakana)",                                                  false },
  { "Jurc", 510, u8"Jurchen",                                                                                         false },
  { "Kali", 357, u8"Kayah Li",                                                                                        false },
  { "Kana", 411, u8"Katakana",                                                                                        false },
  { "Kawi", 368, u8"Kawi",                                                                                            false },
  { "Khar", 305, u8"Kharoshthi",                                                                                      false },
  { "Khmr", 355, u8"Khmer",                                                                                           false },
  { "Khoj", 322, u8"Khojki",                                                                                          false },
  { "Kitl", 505, u8"Khitan large script",                                                                             false },
  { "Kits", 288, u8"Khitan small script",                                                                             false },
  { "Knda", 345, u8"Kannada",                                                                                         false },
  { "Kore", 287, u8"Korean (alias for Hangul + Han)",                                                                 false },
  { "Kpel", 436, u8"Kpelle",                                                                                          false },
  { "Kthi", 317, u8"Kaithi",                                                                                          false },
  { "Lana", 351, u8"Tai Tham (Lanna)",                                                                                false },
  { "Laoo", 356, u8"Lao",                                                                                             false },
  { "Latf", 217, u8"Latin (Fraktur variant)",                                                                         false },
  { "Latg", 216, u8"Latin (Gaelic variant)",                                                                          false },
  { "Latn", 215, u8"Latin",                                                                                           false },
  { "Leke", 364, u8"Leke",                                                                                            false },
  { "Lepc", 335, u8"Lepcha (Róng)",                                                                                   false },
  { "Limb", 336, u8"Limbu",                                                                                           false },
  { "Lina", 400, u8"Linear A",                                                                                        false },
  { "Linb", 401, u8"Linear B",                                                                                        false },
  { "Lisu", 399, u8"Lisu (Fraser)",                                                                                   false },
  { "Loma", 437, u8"Loma",                                                                                            false },
  { "Lyci", 202, u8"Lycian",                                                                                          false },
  { "Lydi", 116, u8"Lydian",                                                                                          false },
  { "Mahj", 314, u8"Mahajani",                                                                                        false },
  { "Maka", 366, u8"Makasar",                                                                                         false },
  { "Mand", 140, u8"Mandaic, Mandaean",                                                                               false },
  { "Mani", 139, u8"Manichaean",                                                                                      false },
  { "Marc", 332, u8"Marchen",                                                                                         false },
  { "Maya",  90, u8"Mayan hieroglyphs",                                                                               false },
  { "Medf", 265, u8"Medefaidrin (Oberi Okaime, Oberi Ɔkaimɛ)",                                                        false },
  { "Mend", 438, u8"Mende Kikakui",                                                                                   false },
  { "Merc", 101, u8"Meroitic Cursive",                                                                                false },
  { "Mero", 100, u8"Meroitic Hieroglyphs",                                                                            false },
  { "Mlym", 347, u8"Malayalam",                                                                                       false },
  { "Modi", 324, u8"Modi, Moḍī",                                                                                      false },
  { "Mong", 145, u8"Mongolian",                                                                                       false },
  { "Moon", 218, u8"Moon (Moon code, Moon script, Moon type)",                                                        false },
  { "Mroo", 264, u8"Mro, Mru",                                                                                        false },
  { "Mtei", 337, u8"Meitei Mayek (Meithei, Meetei)",                                                                  false },
  { "Mult", 323, u8"Multani",                                                                                         false },
  { "Mymr", 350, u8"Myanmar (Burmese)",                                                                               false },
  { "Nagm", 295, u8"Nag Mundari",                                                                                     false },
  { "Nand", 311, u8"Nandinagari",                                                                                     false },
  { "Narb", 106, u8"Old North Arabian (Ancient North Arabian)",                                                       false },
  { "Nbat", 159, u8"Nabataean",                                                                                       false },
  { "Newa", 333, u8"Newa, Newar, Newari, Nepāla lipi",                                                                false },
  { "Nkdb",  85, u8"Naxi Dongba (na²¹ɕi³³ to³³ba²¹, Nakhi Tomba)",                                                    false },
  { "Nkgb", 420, u8"Naxi Geba (na²¹ɕi³³ gʌ²¹ba²¹, 'Na-'Khi ²Ggŏ-¹baw, Nakhi Geba)",                                   false },
  { "Nkoo", 165, u8"N’Ko",                                                                                            false },
  { "Nshu", 499, u8"Nüshu",                                                                                           false },
  { "Ogam", 212, u8"Ogham",                                                                                           false },
  { "Olck", 261, u8"Ol Chiki (Ol Cemet’, Ol, Santali)",                                                               false },
  { "Orkh", 175, u8"Old Turkic, Orkhon Runic",                                                                        false },
  { "Orya", 327, u8"Oriya (Odia)",                                                                                    false },
  { "Osge", 219, u8"Osage",                                                                                           false },
  { "Osma", 260, u8"Osmanya",                                                                                         false },
  { "Ougr", 143, u8"Old Uyghur",                                                                                      false },
  { "Palm", 126, u8"Palmyrene",                                                                                       false },
  { "Pauc", 263, u8"Pau Cin Hau",                                                                                     false },
  { "Pcun",  15, u8"Proto-Cuneiform",                                                                                 false },
  { "Pelm",  16, u8"Proto-Elamite",                                                                                   false },
  { "Perm", 227, u8"Old Permic",                                                                                      false },
  { "Phag", 331, u8"Phags-pa",                                                                                        false },
  { "Phli", 131, u8"Inscriptional Pahlavi",                                                                           false },
  { "Phlp", 132, u8"Psalter Pahlavi",                                                                                 false },
  { "Phlv", 133, u8"Book Pahlavi",                                                                                    false },
  { "Phnx", 115, u8"Phoenician",                                                                                      false },
  { "Piqd", 293, u8"Klingon (KLI pIqaD)",                                                                             false },
  { "Plrd", 282, u8"Miao (Pollard)",                                                                                  false },
  { "Prti", 130, u8"Inscriptional Parthian",                                                                          false },
  { "Psin", 103, u8"Proto-Sinaitic",                                                                                  false },
  { "Qaaa", 900, u8"Reserved for private use",                                                                        false },
  { "Qaab", 901, u8"Reserved for private use",                                                                        false },
  { "Qaac", 902, u8"Reserved for private use",                                                                        false },
  { "Qaad", 903, u8"Reserved for private use",                                                                        false },
  { "Qaae", 904, u8"Reserved for private use",                                                                        false },
  { "Qaaf", 905, u8"Reserved for private use",                                                                        false },
  { "Qaag", 906, u8"Reserved for private use",                                                                        false },
  { "Qaah", 907, u8"Reserved for private use",                                                                        false },
  { "Qaai", 908, u8"Reserved for private use",                                                                        false },
  { "Qaaj", 909, u8"Reserved for private use",                                                                        false },
  { "Qaak", 910, u8"Reserved for private use",                                                                        false },
  { "Qaal", 911, u8"Reserved for private use",                                                                        false },
  { "Qaam", 912, u8"Reserved for private use",                                                                        false },
  { "Qaan", 913, u8"Reserved for private use",                                                                        false },
  { "Qaao", 914, u8"Reserved for private use",                                                                        false },
  { "Qaap", 915, u8"Reserved for private use",                                                                        false },
  { "Qaaq", 916, u8"Reserved for private use",                                                                        false },
  { "Qaar", 917, u8"Reserved for private use",                                                                        false },
  { "Qaas", 918, u8"Reserved for private use",                                                                        false },
  { "Qaat", 919, u8"Reserved for private use",                                                                        false },
  { "Qaau", 920, u8"Reserved for private use",                                                                        false },
  { "Qaav", 921, u8"Reserved for private use",                                                                        false },
  { "Qaaw", 922, u8"Reserved for private use",                                                                        false },
  { "Qaax", 923, u8"Reserved for private use",                                                                        false },
  { "Qaay", 924, u8"Reserved for private use",                                                                        false },
  { "Qaaz", 925, u8"Reserved for private use",                                                                        false },
  { "Qaba", 926, u8"Reserved for private use",                                                                        false },
  { "Qabb", 927, u8"Reserved for private use",                                                                        false },
  { "Qabc", 928, u8"Reserved for private use",                                                                        false },
  { "Qabd", 929, u8"Reserved for private use",                                                                        false },
  { "Qabe", 930, u8"Reserved for private use",                                                                        false },
  { "Qabf", 931, u8"Reserved for private use",                                                                        false },
  { "Qabg", 932, u8"Reserved for private use",                                                                        false },
  { "Qabh", 933, u8"Reserved for private use",                                                                        false },
  { "Qabi", 934, u8"Reserved for private use",                                                                        false },
  { "Qabj", 935, u8"Reserved for private use",                                                                        false },
  { "Qabk", 936, u8"Reserved for private use",                                                                        false },
  { "Qabl", 937, u8"Reserved for private use",                                                                        false },
  { "Qabm", 938, u8"Reserved for private use",                                                                        false },
  { "Qabn", 939, u8"Reserved for private use",                                                                        false },
  { "Qabo", 940, u8"Reserved for private use",                                                                        false },
  { "Qabp", 941, u8"Reserved for private use",                                                                        false },
  { "Qabq", 942, u8"Reserved for private use",                                                                        false },
  { "Qabr", 943, u8"Reserved for private use",                                                                        false },
  { "Qabs", 944, u8"Reserved for private use",                                                                        false },
  { "Qabt", 945, u8"Reserved for private use",                                                                        false },
  { "Qabu", 946, u8"Reserved for private use",                                                                        false },
  { "Qabv", 947, u8"Reserved for private use",                                                                        false },
  { "Qabw", 948, u8"Reserved for private use",                                                                        false },
  { "Qabx", 949, u8"Reserved for private use",                                                                        false },
  { "Ranj", 303, u8"Ranjana",                                                                                         false },
  { "Rjng", 363, u8"Rejang (Redjang, Kaganga)",                                                                       false },
  { "Rohg", 167, u8"Hanifi Rohingya",                                                                                 false },
  { "Roro", 620, u8"Rongorongo",                                                                                      false },
  { "Runr", 211, u8"Runic",                                                                                           false },
  { "Samr", 123, u8"Samaritan",                                                                                       false },
  { "Sara", 292, u8"Sarati",                                                                                          false },
  { "Sarb", 105, u8"Old South Arabian",                                                                               false },
  { "Saur", 344, u8"Saurashtra",                                                                                      false },
  { "Sgnw",  95, u8"SignWriting",                                                                                     false },
  { "Shaw", 281, u8"Shavian (Shaw)",                                                                                  false },
  { "Shrd", 319, u8"Sharada, Śāradā",                                                                                 false },
  { "Shui", 530, u8"Shuishu",                                                                                         false },
  { "Sidd", 302, u8"Siddham, Siddhaṃ, Siddhamātṛkā",                                                                  false },
  { "Sind", 318, u8"Khudawadi, Sindhi",                                                                               false },
  { "Sinh", 348, u8"Sinhala",                                                                                         false },
  { "Sogd", 141, u8"Sogdian",                                                                                         false },
  { "Sogo", 142, u8"Old Sogdian",                                                                                     false },
  { "Sora", 398, u8"Sora Sompeng",                                                                                    false },
  { "Soyo", 329, u8"Soyombo",                                                                                         false },
  { "Sund", 362, u8"Sundanese",                                                                                       false },
  { "Sunu", 274, u8"Sunuwar",                                                                                         false },
  { "Sylo", 316, u8"Syloti Nagri",                                                                                    false },
  { "Syrc", 135, u8"Syriac",                                                                                          false },
  { "Syre", 138, u8"Syriac (Estrangelo variant)",                                                                     false },
  { "Syrj", 137, u8"Syriac (Western variant)",                                                                        false },
  { "Syrn", 136, u8"Syriac (Eastern variant)",                                                                        false },
  { "Tagb", 373, u8"Tagbanwa",                                                                                        false },
  { "Takr", 321, u8"Takri, Ṭākrī, Ṭāṅkrī",                                                                            false },
  { "Tale", 353, u8"Tai Le",                                                                                          false },
  { "Talu", 354, u8"New Tai Lue",                                                                                     false },
  { "Taml", 346, u8"Tamil",                                                                                           false },
  { "Tang", 520, u8"Tangut",                                                                                          false },
  { "Tavt", 359, u8"Tai Viet",                                                                                        false },
  { "Telu", 340, u8"Telugu",                                                                                          false },
  { "Teng", 290, u8"Tengwar",                                                                                         false },
  { "Tfng", 120, u8"Tifinagh (Berber)",                                                                               false },
  { "Tglg", 370, u8"Tagalog (Baybayin, Alibata)",                                                                     false },
  { "Thaa", 170, u8"Thaana",                                                                                          false },
  { "Thai", 352, u8"Thai",                                                                                            false },
  { "Tibt", 330, u8"Tibetan",                                                                                         false },
  { "Tirh", 326, u8"Tirhuta",                                                                                         false },
  { "Tnsa", 275, u8"Tangsa",                                                                                          false },
  { "Toto", 294, u8"Toto",                                                                                            false },
  { "Ugar",  40, u8"Ugaritic",                                                                                        false },
  { "Vaii", 470, u8"Vai",                                                                                             false },
  { "Visp", 280, u8"Visible Speech",                                                                                  false },
  { "Vith", 228, u8"Vithkuqi",                                                                                        false },
  { "Wara", 262, u8"Warang Citi (Varang Kshiti)",                                                                     false },
  { "Wcho", 283, u8"Wancho",                                                                                          false },
  { "Wole", 480, u8"Woleai",                                                                                          false },
  { "Xpeo",  30, u8"Old Persian",                                                                                     false },
  { "Xsux",  20, u8"Cuneiform, Sumero-Akkadian",                                                                      false },
  { "Yezi", 192, u8"Yezidi",                                                                                          false },
  { "Yiii", 460, u8"Yi",                                                                                              false },
  { "Zanb", 339, u8"Zanabazar Square (Zanabazarin Dörböljin Useg, Xewtee Dörböljin Bicig, Horizontal Square Script)", false },
  { "Zinh", 994, u8"Code for inherited script",                                                                       false },
  { "Zmth", 995, u8"Mathematical notation",                                                                           false },
  { "Zsye", 993, u8"Symbols (Emoji variant)",                                                                         false },
  { "Zsym", 996, u8"Symbols",                                                                                         false },
  { "Zxxx", 997, u8"Code for unwritten documents",                                                                    false },
  { "Zyyy", 998, u8"Code for undetermined script",                                                                    false },
  { "Zzzz", 999, u8"Code for uncoded script",                                                                         false },
};

void
init() {
  g_scripts.reserve(261);

  for (script_init_t const *script = s_scripts_init, *end = script + 261; script < end; ++script)
    g_scripts.emplace_back(script->code, script->number, script->english_name, script->is_deprecated);
}

} // namespace mtx::iso15924
