# Contributing to MkDocs-Nature

An introduction to contributing to the MkDocs-Nature Theme.

Contributions from developers and users are welcome. Contributions can be made
in a number of ways, including:

- Code patches via pull requests
- Documentation improvements
- Bug reports and patch reviews

## Resources

When contributing to the project, the following resources will likely be helpful
to you:

- [Source Code]
- [Issue Tracker]
- [MkDocs Documentation]
- [Jinja Documentation]
- [Source][Sphinx Source] of parent [Sphinx theme].

## Code of Conduct

Everyone interacting with the project's codebases, issue trackers, etc. is
expected to follow the [PyPA Code of Conduct].

## Reporting an Issue

When reporting an issue, please include as much detail as you can, including
your platform, MkDocs version, theme version and relevent config settings. If
the problem is visual please include a screenshot and if you get an error please
include the full error and traceback.

[Source Code]: https://github.com/waylan/mkdocs-nature
[Issue Tracker]: https://github.com/waylan/mkdocs-nature/issues
[MkDocs Documentation]: https://www.mkdocs.org
[Jinja Documentation]: https://jinja.pocoo.org/
[Sphinx Source]: https://github.com/sphinx-doc/sphinx/tree/master/sphinx/themes
[Sphinx theme]: http://www.sphinx-doc.org/en/stable/theming.html?highlight=nature#builtin-themes
[PyPA Code of Conduct]: https://www.pypa.io/en/latest/code-of-conduct/
