; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes=inline < %s | FileCheck %s

; This tests cases where instructions in the callee are simplified to
; instructions in the caller, thus making VMap contain instructions from
; the caller. We should not be assigning incorrect noalias metadata in
; that case.

declare { ptr } @opaque_callee()

define { ptr } @callee(ptr %x) {
; CHECK-LABEL: @callee(
; CHECK-NEXT:    [[RES:%.*]] = insertvalue { ptr } undef, ptr [[X:%.*]], 0
; CHECK-NEXT:    ret { ptr } [[RES]]
;
  %res = insertvalue { ptr } undef, ptr %x, 0
  ret { ptr } %res
}

; @opaque_callee() should not receive noalias metadata here.
define void @caller() {
; CHECK-LABEL: @caller(
; CHECK-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata !0)
; CHECK-NEXT:    [[S:%.*]] = call { ptr } @opaque_callee()
; CHECK-NEXT:    [[X:%.*]] = extractvalue { ptr } [[S]], 0
; CHECK-NEXT:    ret void
;
  call void @llvm.experimental.noalias.scope.decl(metadata !0)
  %s = call { ptr } @opaque_callee()
  %x = extractvalue { ptr } %s, 0
  call { ptr } @callee(ptr %x), !noalias !0
  ret void
}

; @opaque_callee() should no the same noalias metadata as the load from the
; else branch, not as the load in the if branch.
define { ptr } @self_caller(i1 %c, ptr %a) {
; CHECK-LABEL: @self_caller(
; CHECK-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata !0)
; CHECK-NEXT:    br i1 [[C:%.*]], label [[IF:%.*]], label [[ELSE:%.*]]
; CHECK:       if:
; CHECK-NEXT:    [[S:%.*]] = call { ptr } @opaque_callee(), !noalias !0
; CHECK-NEXT:    [[X:%.*]] = extractvalue { ptr } [[S]], 0
; CHECK-NEXT:    call void @llvm.experimental.noalias.scope.decl(metadata !3)
; CHECK-NEXT:    [[TMP1:%.*]] = load volatile i64, ptr [[X]], align 4, !alias.scope !3
; CHECK-NEXT:    ret { ptr } [[S]]
; CHECK:       else:
; CHECK-NEXT:    [[R2:%.*]] = insertvalue { ptr } undef, ptr [[A:%.*]], 0
; CHECK-NEXT:    [[TMP2:%.*]] = load volatile i64, ptr [[A]], align 4, !alias.scope !0
; CHECK-NEXT:    ret { ptr } [[R2]]
;
  call void @llvm.experimental.noalias.scope.decl(metadata !0)
  br i1 %c, label %if, label %else

if:
  %s = call { ptr } @opaque_callee(), !noalias !0
  %x = extractvalue { ptr } %s, 0
  %r = call { ptr } @self_caller(i1 false, ptr %x)
  ret { ptr } %r

else:
  %r2 = insertvalue { ptr } undef, ptr %a, 0
  load volatile i64, ptr %a, !alias.scope !0
  ret { ptr } %r2
}

declare void @llvm.experimental.noalias.scope.decl(metadata)

!0 = !{!1}
!1 = !{!1, !2, !"scope"}
!2 = !{!2, !"domain"}
