; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes=sroa < %s | FileCheck %s

%st.half = type { half }

; Allow speculateSelectInstLoads to fold load and select
; even if there is an intervening bitcast.
define <2 x i16> @test_load_bitcast_select(i1 %cond1, i1 %cond2) {
; CHECK-LABEL: @test_load_bitcast_select(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast half 0xHFFFF to i16
; CHECK-NEXT:    [[TMP1:%.*]] = bitcast half 0xH0000 to i16
; CHECK-NEXT:    [[LD1_SROA_SPECULATED:%.*]] = select i1 [[COND1:%.*]], i16 [[TMP0]], i16 [[TMP1]]
; CHECK-NEXT:    [[V1:%.*]] = insertelement <2 x i16> poison, i16 [[LD1_SROA_SPECULATED]], i32 0
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast half 0xHFFFF to i16
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast half 0xH0000 to i16
; CHECK-NEXT:    [[LD2_SROA_SPECULATED:%.*]] = select i1 [[COND2:%.*]], i16 [[TMP2]], i16 [[TMP3]]
; CHECK-NEXT:    [[V2:%.*]] = insertelement <2 x i16> [[V1]], i16 [[LD2_SROA_SPECULATED]], i32 1
; CHECK-NEXT:    ret <2 x i16> [[V2]]
;
entry:
  %true = alloca half, align 2
  %false = alloca half, align 2
  store half 0xHFFFF, ptr %true, align 2
  store half 0xH0000, ptr %false, align 2
  %sel1 = select i1 %cond1, ptr %true, ptr %false
  %ld1 = load i16, ptr %sel1, align 2
  %v1 = insertelement <2 x i16> poison, i16 %ld1, i32 0
  %sel2 = select i1 %cond2, ptr %true, ptr %false
  %ld2 = load i16, ptr %sel2, align 2
  %v2 = insertelement <2 x i16> %v1, i16 %ld2, i32 1
  ret <2 x i16> %v2
}

%st.args = type { i32, ptr }

; A bitcasted load and a direct load of select.
define void @test_multiple_loads_select(i1 %cmp){
; CHECK-LABEL: @test_multiple_loads_select(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[ADDR_I8_SROA_SPECULATED:%.*]] = select i1 [[CMP:%.*]], ptr undef, ptr undef
; CHECK-NEXT:    call void @foo_i8(ptr [[ADDR_I8_SROA_SPECULATED]])
; CHECK-NEXT:    [[ADDR_I32_SROA_SPECULATED:%.*]] = select i1 [[CMP]], ptr undef, ptr undef
; CHECK-NEXT:    call void @foo_i32(ptr [[ADDR_I32_SROA_SPECULATED]])
; CHECK-NEXT:    ret void
;
entry:
  %args = alloca [2 x %st.args], align 16
  %arr1 = getelementptr inbounds [2 x %st.args], ptr %args, i64 0, i64 1
  %sel = select i1 %cmp, ptr %arr1, ptr %args
  %addr = getelementptr inbounds %st.args, ptr %sel, i64 0, i32 1
  %addr.i8 = load ptr, ptr %addr, align 8
  call void @foo_i8(ptr %addr.i8)
  %addr.i32 = load ptr, ptr %addr, align 8
  call void @foo_i32 (ptr %addr.i32)
  ret void
}

declare void @foo_i8(ptr)
declare void @foo_i32(ptr)
