// Code generated by gen_tests.py and process_polyglot.py.
// Do not edit this file directly.
// The template for this file is located at:
// ../template.go.tpl
package reql_tests

import (
	"testing"
	"time"

	"github.com/stretchr/testify/suite"
	r "gopkg.in/gorethink/gorethink.v3"
	"gopkg.in/gorethink/gorethink.v3/internal/compare"
)

// Tests of comparison operators
func TestMathLogicComparisonSuite(t *testing.T) {
	suite.Run(t, new(MathLogicComparisonSuite))
}

type MathLogicComparisonSuite struct {
	suite.Suite

	session *r.Session
}

func (suite *MathLogicComparisonSuite) SetupTest() {
	suite.T().Log("Setting up MathLogicComparisonSuite")
	// Use imports to prevent errors
	_ = time.Time{}
	_ = compare.AnythingIsFine

	session, err := r.Connect(r.ConnectOpts{
		Address: url,
	})
	suite.Require().NoError(err, "Error returned when connecting to server")
	suite.session = session

	r.DBDrop("test").Exec(suite.session)
	err = r.DBCreate("test").Exec(suite.session)
	suite.Require().NoError(err)
	err = r.DB("test").Wait().Exec(suite.session)
	suite.Require().NoError(err)

}

func (suite *MathLogicComparisonSuite) TearDownSuite() {
	suite.T().Log("Tearing down MathLogicComparisonSuite")

	if suite.session != nil {
		r.DB("rethinkdb").Table("_debug_scratch").Delete().Exec(suite.session)
		r.DBDrop("test").Exec(suite.session)

		suite.session.Close()
	}
}

func (suite *MathLogicComparisonSuite) TestCases() {
	suite.T().Log("Running MathLogicComparisonSuite: Tests of comparison operators")

	{
		// math_logic/comparison.yaml line #10
		/* true */
		var expected_ bool = true
		/* r.expr(1) < 2 */

		suite.T().Log("About to run line #10: r.Expr(1).Lt(2)")

		runAndAssert(suite.Suite, expected_, r.Expr(1).Lt(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #10")
	}

	{
		// math_logic/comparison.yaml line #11
		/* true */
		var expected_ bool = true
		/* 1 < r.expr(2) */

		suite.T().Log("About to run line #11: r.Lt(1, r.Expr(2))")

		runAndAssert(suite.Suite, expected_, r.Lt(1, r.Expr(2)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #11")
	}

	{
		// math_logic/comparison.yaml line #12
		/* true */
		var expected_ bool = true
		/* r.expr(1).lt(2) */

		suite.T().Log("About to run line #12: r.Expr(1).Lt(2)")

		runAndAssert(suite.Suite, expected_, r.Expr(1).Lt(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #12")
	}

	{
		// math_logic/comparison.yaml line #19
		/* false */
		var expected_ bool = false
		/* r.expr(3) < 2 */

		suite.T().Log("About to run line #19: r.Expr(3).Lt(2)")

		runAndAssert(suite.Suite, expected_, r.Expr(3).Lt(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #19")
	}

	{
		// math_logic/comparison.yaml line #22
		/* false */
		var expected_ bool = false
		/* r.expr(2) < 2 */

		suite.T().Log("About to run line #22: r.Expr(2).Lt(2)")

		runAndAssert(suite.Suite, expected_, r.Expr(2).Lt(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #22")
	}

	{
		// math_logic/comparison.yaml line #38
		/* false */
		var expected_ bool = false
		/* r.expr(1) > 2 */

		suite.T().Log("About to run line #38: r.Expr(1).Gt(2)")

		runAndAssert(suite.Suite, expected_, r.Expr(1).Gt(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #38")
	}

	{
		// math_logic/comparison.yaml line #39
		/* false */
		var expected_ bool = false
		/* 1 > r.expr(2) */

		suite.T().Log("About to run line #39: r.Gt(1, r.Expr(2))")

		runAndAssert(suite.Suite, expected_, r.Gt(1, r.Expr(2)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #39")
	}

	{
		// math_logic/comparison.yaml line #40
		/* false */
		var expected_ bool = false
		/* r.expr(1).gt(2) */

		suite.T().Log("About to run line #40: r.Expr(1).Gt(2)")

		runAndAssert(suite.Suite, expected_, r.Expr(1).Gt(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #40")
	}

	{
		// math_logic/comparison.yaml line #45
		/* true */
		var expected_ bool = true
		/* r.expr(3) > 2 */

		suite.T().Log("About to run line #45: r.Expr(3).Gt(2)")

		runAndAssert(suite.Suite, expected_, r.Expr(3).Gt(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #45")
	}

	{
		// math_logic/comparison.yaml line #49
		/* false */
		var expected_ bool = false
		/* r.expr(2) > 2 */

		suite.T().Log("About to run line #49: r.Expr(2).Gt(2)")

		runAndAssert(suite.Suite, expected_, r.Expr(2).Gt(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #49")
	}

	{
		// math_logic/comparison.yaml line #63
		/* false */
		var expected_ bool = false
		/* r.expr(1) == 2 */

		suite.T().Log("About to run line #63: r.Expr(1).Eq(2)")

		runAndAssert(suite.Suite, expected_, r.Expr(1).Eq(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #63")
	}

	{
		// math_logic/comparison.yaml line #64
		/* false */
		var expected_ bool = false
		/* 1 == r.expr(2) */

		suite.T().Log("About to run line #64: r.Eq(1, r.Expr(2))")

		runAndAssert(suite.Suite, expected_, r.Eq(1, r.Expr(2)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #64")
	}

	{
		// math_logic/comparison.yaml line #65
		/* false */
		var expected_ bool = false
		/* r.expr(1).eq(2) */

		suite.T().Log("About to run line #65: r.Expr(1).Eq(2)")

		runAndAssert(suite.Suite, expected_, r.Expr(1).Eq(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #65")
	}

	{
		// math_logic/comparison.yaml line #68
		/* false */
		var expected_ bool = false
		/* r.expr(3) == 2 */

		suite.T().Log("About to run line #68: r.Expr(3).Eq(2)")

		runAndAssert(suite.Suite, expected_, r.Expr(3).Eq(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #68")
	}

	{
		// math_logic/comparison.yaml line #72
		/* true */
		var expected_ bool = true
		/* r.expr(2) == 2 */

		suite.T().Log("About to run line #72: r.Expr(2).Eq(2)")

		runAndAssert(suite.Suite, expected_, r.Expr(2).Eq(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #72")
	}

	{
		// math_logic/comparison.yaml line #86
		/* true */
		var expected_ bool = true
		/* r.expr(1) != 2 */

		suite.T().Log("About to run line #86: r.Expr(1).Ne(2)")

		runAndAssert(suite.Suite, expected_, r.Expr(1).Ne(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #86")
	}

	{
		// math_logic/comparison.yaml line #87
		/* true */
		var expected_ bool = true
		/* 1 != r.expr(2) */

		suite.T().Log("About to run line #87: r.Ne(1, r.Expr(2))")

		runAndAssert(suite.Suite, expected_, r.Ne(1, r.Expr(2)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #87")
	}

	{
		// math_logic/comparison.yaml line #88
		/* true */
		var expected_ bool = true
		/* r.expr(1).ne(2) */

		suite.T().Log("About to run line #88: r.Expr(1).Ne(2)")

		runAndAssert(suite.Suite, expected_, r.Expr(1).Ne(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #88")
	}

	{
		// math_logic/comparison.yaml line #91
		/* true */
		var expected_ bool = true
		/* r.expr(3) != 2 */

		suite.T().Log("About to run line #91: r.Expr(3).Ne(2)")

		runAndAssert(suite.Suite, expected_, r.Expr(3).Ne(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #91")
	}

	{
		// math_logic/comparison.yaml line #95
		/* false */
		var expected_ bool = false
		/* r.expr(2) != 2 */

		suite.T().Log("About to run line #95: r.Expr(2).Ne(2)")

		runAndAssert(suite.Suite, expected_, r.Expr(2).Ne(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #95")
	}

	{
		// math_logic/comparison.yaml line #109
		/* true */
		var expected_ bool = true
		/* r.expr(1) <= 2 */

		suite.T().Log("About to run line #109: r.Expr(1).Le(2)")

		runAndAssert(suite.Suite, expected_, r.Expr(1).Le(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #109")
	}

	{
		// math_logic/comparison.yaml line #110
		/* true */
		var expected_ bool = true
		/* 1 <= r.expr(2) */

		suite.T().Log("About to run line #110: r.Le(1, r.Expr(2))")

		runAndAssert(suite.Suite, expected_, r.Le(1, r.Expr(2)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #110")
	}

	{
		// math_logic/comparison.yaml line #111
		/* true */
		var expected_ bool = true
		/* r.expr(1).le(2) */

		suite.T().Log("About to run line #111: r.Expr(1).Le(2)")

		runAndAssert(suite.Suite, expected_, r.Expr(1).Le(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #111")
	}

	{
		// math_logic/comparison.yaml line #116
		/* false */
		var expected_ bool = false
		/* r.expr(3) <= 2 */

		suite.T().Log("About to run line #116: r.Expr(3).Le(2)")

		runAndAssert(suite.Suite, expected_, r.Expr(3).Le(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #116")
	}

	{
		// math_logic/comparison.yaml line #120
		/* true */
		var expected_ bool = true
		/* r.expr(2) <= 2 */

		suite.T().Log("About to run line #120: r.Expr(2).Le(2)")

		runAndAssert(suite.Suite, expected_, r.Expr(2).Le(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #120")
	}

	{
		// math_logic/comparison.yaml line #134
		/* false */
		var expected_ bool = false
		/* r.expr(1) >= 2 */

		suite.T().Log("About to run line #134: r.Expr(1).Ge(2)")

		runAndAssert(suite.Suite, expected_, r.Expr(1).Ge(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #134")
	}

	{
		// math_logic/comparison.yaml line #135
		/* false */
		var expected_ bool = false
		/* 1 >= r.expr(2) */

		suite.T().Log("About to run line #135: r.Ge(1, r.Expr(2))")

		runAndAssert(suite.Suite, expected_, r.Ge(1, r.Expr(2)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #135")
	}

	{
		// math_logic/comparison.yaml line #136
		/* false */
		var expected_ bool = false
		/* r.expr(1).ge(2) */

		suite.T().Log("About to run line #136: r.Expr(1).Ge(2)")

		runAndAssert(suite.Suite, expected_, r.Expr(1).Ge(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #136")
	}

	{
		// math_logic/comparison.yaml line #141
		/* true */
		var expected_ bool = true
		/* r.expr(3) >= 2 */

		suite.T().Log("About to run line #141: r.Expr(3).Ge(2)")

		runAndAssert(suite.Suite, expected_, r.Expr(3).Ge(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #141")
	}

	{
		// math_logic/comparison.yaml line #145
		/* true */
		var expected_ bool = true
		/* r.expr(2) >= 2 */

		suite.T().Log("About to run line #145: r.Expr(2).Ge(2)")

		runAndAssert(suite.Suite, expected_, r.Expr(2).Ge(2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #145")
	}

	{
		// math_logic/comparison.yaml line #158
		/* true */
		var expected_ bool = true
		/* r.expr(null) == null */

		suite.T().Log("About to run line #158: r.Expr(nil).Eq(nil)")

		runAndAssert(suite.Suite, expected_, r.Expr(nil).Eq(nil), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #158")
	}

	{
		// math_logic/comparison.yaml line #159
		/* true */
		var expected_ bool = true
		/* null == r.expr(null) */

		suite.T().Log("About to run line #159: r.Eq(nil, r.Expr(nil))")

		runAndAssert(suite.Suite, expected_, r.Eq(nil, r.Expr(nil)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #159")
	}

	{
		// math_logic/comparison.yaml line #164
		/* false */
		var expected_ bool = false
		/* r.expr(null) < null */

		suite.T().Log("About to run line #164: r.Expr(nil).Lt(nil)")

		runAndAssert(suite.Suite, expected_, r.Expr(nil).Lt(nil), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #164")
	}

	{
		// math_logic/comparison.yaml line #165
		/* false */
		var expected_ bool = false
		/* null < r.expr(null) */

		suite.T().Log("About to run line #165: r.Lt(nil, r.Expr(nil))")

		runAndAssert(suite.Suite, expected_, r.Lt(nil, r.Expr(nil)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #165")
	}

	{
		// math_logic/comparison.yaml line #166
		/* false */
		var expected_ bool = false
		/* r.expr(null).lt(null) */

		suite.T().Log("About to run line #166: r.Expr(nil).Lt(nil)")

		runAndAssert(suite.Suite, expected_, r.Expr(nil).Lt(nil), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #166")
	}

	{
		// math_logic/comparison.yaml line #172
		/* false */
		var expected_ bool = false
		/* r.expr(null) > null */

		suite.T().Log("About to run line #172: r.Expr(nil).Gt(nil)")

		runAndAssert(suite.Suite, expected_, r.Expr(nil).Gt(nil), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #172")
	}

	{
		// math_logic/comparison.yaml line #173
		/* false */
		var expected_ bool = false
		/* null > r.expr(null) */

		suite.T().Log("About to run line #173: r.Gt(nil, r.Expr(nil))")

		runAndAssert(suite.Suite, expected_, r.Gt(nil, r.Expr(nil)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #173")
	}

	{
		// math_logic/comparison.yaml line #174
		/* false */
		var expected_ bool = false
		/* r.expr(null).gt(null) */

		suite.T().Log("About to run line #174: r.Expr(nil).Gt(nil)")

		runAndAssert(suite.Suite, expected_, r.Expr(nil).Gt(nil), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #174")
	}

	{
		// math_logic/comparison.yaml line #180
		/* true */
		var expected_ bool = true
		/* r.expr('a') == 'a' */

		suite.T().Log("About to run line #180: r.Expr('a').Eq('a')")

		runAndAssert(suite.Suite, expected_, r.Expr("a").Eq("a"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #180")
	}

	{
		// math_logic/comparison.yaml line #184
		/* false */
		var expected_ bool = false
		/* r.expr('a') == 'aa' */

		suite.T().Log("About to run line #184: r.Expr('a').Eq('aa')")

		runAndAssert(suite.Suite, expected_, r.Expr("a").Eq("aa"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #184")
	}

	{
		// math_logic/comparison.yaml line #188
		/* true */
		var expected_ bool = true
		/* r.expr('a') < 'aa' */

		suite.T().Log("About to run line #188: r.Expr('a').Lt('aa')")

		runAndAssert(suite.Suite, expected_, r.Expr("a").Lt("aa"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #188")
	}

	{
		// math_logic/comparison.yaml line #192
		/* true */
		var expected_ bool = true
		/* r.expr('a') < 'bb' */

		suite.T().Log("About to run line #192: r.Expr('a').Lt('bb')")

		runAndAssert(suite.Suite, expected_, r.Expr("a").Lt("bb"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #192")
	}

	{
		// math_logic/comparison.yaml line #196
		/* true */
		var expected_ bool = true
		/* r.expr('bb') > 'a' */

		suite.T().Log("About to run line #196: r.Expr('bb').Gt('a')")

		runAndAssert(suite.Suite, expected_, r.Expr("bb").Gt("a"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #196")
	}

	{
		// math_logic/comparison.yaml line #200
		/* true */
		var expected_ bool = true
		/* r.expr('abcdef') < 'abcdeg' */

		suite.T().Log("About to run line #200: r.Expr('abcdef').Lt('abcdeg')")

		runAndAssert(suite.Suite, expected_, r.Expr("abcdef").Lt("abcdeg"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #200")
	}

	{
		// math_logic/comparison.yaml line #204
		/* false */
		var expected_ bool = false
		/* r.expr('abcdefg') > 'abcdeg' */

		suite.T().Log("About to run line #204: r.Expr('abcdefg').Gt('abcdeg')")

		runAndAssert(suite.Suite, expected_, r.Expr("abcdefg").Gt("abcdeg"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #204")
	}

	{
		// math_logic/comparison.yaml line #208
		/* true */
		var expected_ bool = true
		/* r.expr('A quick brown fox') > 'A quick brawn fox' */

		suite.T().Log("About to run line #208: r.Expr('A quick brown fox').Gt('A quick brawn fox')")

		runAndAssert(suite.Suite, expected_, r.Expr("A quick brown fox").Gt("A quick brawn fox"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #208")
	}

	{
		// math_logic/comparison.yaml line #216
		/* true */
		var expected_ bool = true
		/* r.expr([1]) < [2] */

		suite.T().Log("About to run line #216: r.Expr([]interface{}{1}).Lt([]interface{}{2})")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{1}).Lt([]interface{}{2}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #216")
	}

	{
		// math_logic/comparison.yaml line #221
		/* false */
		var expected_ bool = false
		/* r.expr([1]) > [2] */

		suite.T().Log("About to run line #221: r.Expr([]interface{}{1}).Gt([]interface{}{2})")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{1}).Gt([]interface{}{2}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #221")
	}

	{
		// math_logic/comparison.yaml line #226
		/* true */
		var expected_ bool = true
		/* r.expr([1, 0]) < [2] */

		suite.T().Log("About to run line #226: r.Expr([]interface{}{1, 0}).Lt([]interface{}{2})")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{1, 0}).Lt([]interface{}{2}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #226")
	}

	{
		// math_logic/comparison.yaml line #231
		/* false */
		var expected_ bool = false
		/* r.expr([1, 0]) < [1] */

		suite.T().Log("About to run line #231: r.Expr([]interface{}{1, 0}).Lt([]interface{}{1})")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{1, 0}).Lt([]interface{}{1}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #231")
	}

	{
		// math_logic/comparison.yaml line #236
		/* true */
		var expected_ bool = true
		/* r.expr([1, 0]) > [0] */

		suite.T().Log("About to run line #236: r.Expr([]interface{}{1, 0}).Gt([]interface{}{0})")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{1, 0}).Gt([]interface{}{0}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #236")
	}

	{
		// math_logic/comparison.yaml line #241
		/* true */
		var expected_ bool = true
		/* r.expr([1, 'a']) < [1, 'b'] */

		suite.T().Log("About to run line #241: r.Expr([]interface{}{1, 'a'}).Lt([]interface{}{1, 'b'})")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{1, "a"}).Lt([]interface{}{1, "b"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #241")
	}

	{
		// math_logic/comparison.yaml line #246
		/* true */
		var expected_ bool = true
		/* r.expr([0, 'z']) < [1, 'b'] */

		suite.T().Log("About to run line #246: r.Expr([]interface{}{0, 'z'}).Lt([]interface{}{1, 'b'})")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{0, "z"}).Lt([]interface{}{1, "b"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #246")
	}

	{
		// math_logic/comparison.yaml line #251
		/* false */
		var expected_ bool = false
		/* r.expr([1, 1, 1]) < [1, 0, 2] */

		suite.T().Log("About to run line #251: r.Expr([]interface{}{1, 1, 1}).Lt([]interface{}{1, 0, 2})")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{1, 1, 1}).Lt([]interface{}{1, 0, 2}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #251")
	}

	{
		// math_logic/comparison.yaml line #256
		/* true */
		var expected_ bool = true
		/* r.expr([1, 0, 2]) < [1, 1, 1] */

		suite.T().Log("About to run line #256: r.Expr([]interface{}{1, 0, 2}).Lt([]interface{}{1, 1, 1})")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{1, 0, 2}).Lt([]interface{}{1, 1, 1}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #256")
	}

	{
		// math_logic/comparison.yaml line #263
		/* true */
		var expected_ bool = true
		/* r.expr({'a':0}) == {'a':0} */

		suite.T().Log("About to run line #263: r.Expr(map[interface{}]interface{}{'a': 0, }).Eq(map[interface{}]interface{}{'a': 0, })")

		runAndAssert(suite.Suite, expected_, r.Expr(map[interface{}]interface{}{"a": 0}).Eq(map[interface{}]interface{}{"a": 0}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #263")
	}

	{
		// math_logic/comparison.yaml line #267
		/* true */
		var expected_ bool = true
		/* r.expr({'a':0, 'b':1}) == {'b':1, 'a':0} */

		suite.T().Log("About to run line #267: r.Expr(map[interface{}]interface{}{'a': 0, 'b': 1, }).Eq(map[interface{}]interface{}{'b': 1, 'a': 0, })")

		runAndAssert(suite.Suite, expected_, r.Expr(map[interface{}]interface{}{"a": 0, "b": 1}).Eq(map[interface{}]interface{}{"b": 1, "a": 0}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #267")
	}

	{
		// math_logic/comparison.yaml line #271
		/* false */
		var expected_ bool = false
		/* r.expr({'a':0, 'b':1, 'c':2}) == {'b':1, 'a':0} */

		suite.T().Log("About to run line #271: r.Expr(map[interface{}]interface{}{'a': 0, 'b': 1, 'c': 2, }).Eq(map[interface{}]interface{}{'b': 1, 'a': 0, })")

		runAndAssert(suite.Suite, expected_, r.Expr(map[interface{}]interface{}{"a": 0, "b": 1, "c": 2}).Eq(map[interface{}]interface{}{"b": 1, "a": 0}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #271")
	}

	{
		// math_logic/comparison.yaml line #275
		/* false */
		var expected_ bool = false
		/* r.expr({'a':0, 'b':1}) == {'b':1, 'a':0, 'c':2} */

		suite.T().Log("About to run line #275: r.Expr(map[interface{}]interface{}{'a': 0, 'b': 1, }).Eq(map[interface{}]interface{}{'b': 1, 'a': 0, 'c': 2, })")

		runAndAssert(suite.Suite, expected_, r.Expr(map[interface{}]interface{}{"a": 0, "b": 1}).Eq(map[interface{}]interface{}{"b": 1, "a": 0, "c": 2}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #275")
	}

	{
		// math_logic/comparison.yaml line #279
		/* false */
		var expected_ bool = false
		/* r.expr({'a':0, 'b':1, 'd':2}) == {'b':1, 'a':0, 'c':2} */

		suite.T().Log("About to run line #279: r.Expr(map[interface{}]interface{}{'a': 0, 'b': 1, 'd': 2, }).Eq(map[interface{}]interface{}{'b': 1, 'a': 0, 'c': 2, })")

		runAndAssert(suite.Suite, expected_, r.Expr(map[interface{}]interface{}{"a": 0, "b": 1, "d": 2}).Eq(map[interface{}]interface{}{"b": 1, "a": 0, "c": 2}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #279")
	}

	{
		// math_logic/comparison.yaml line #283
		/* true */
		var expected_ bool = true
		/* r.expr({'a':0}) < {'b':0} */

		suite.T().Log("About to run line #283: r.Expr(map[interface{}]interface{}{'a': 0, }).Lt(map[interface{}]interface{}{'b': 0, })")

		runAndAssert(suite.Suite, expected_, r.Expr(map[interface{}]interface{}{"a": 0}).Lt(map[interface{}]interface{}{"b": 0}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #283")
	}

	{
		// math_logic/comparison.yaml line #287
		/* true */
		var expected_ bool = true
		/* r.expr({'a':1}) < {'b':0} */

		suite.T().Log("About to run line #287: r.Expr(map[interface{}]interface{}{'a': 1, }).Lt(map[interface{}]interface{}{'b': 0, })")

		runAndAssert(suite.Suite, expected_, r.Expr(map[interface{}]interface{}{"a": 1}).Lt(map[interface{}]interface{}{"b": 0}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #287")
	}

	{
		// math_logic/comparison.yaml line #291
		/* false */
		var expected_ bool = false
		/* r.expr({'b':1}) < {'b':0} */

		suite.T().Log("About to run line #291: r.Expr(map[interface{}]interface{}{'b': 1, }).Lt(map[interface{}]interface{}{'b': 0, })")

		runAndAssert(suite.Suite, expected_, r.Expr(map[interface{}]interface{}{"b": 1}).Lt(map[interface{}]interface{}{"b": 0}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #291")
	}

	{
		// math_logic/comparison.yaml line #295
		/* false */
		var expected_ bool = false
		/* r.expr({'b':1}) < {'a':0} */

		suite.T().Log("About to run line #295: r.Expr(map[interface{}]interface{}{'b': 1, }).Lt(map[interface{}]interface{}{'a': 0, })")

		runAndAssert(suite.Suite, expected_, r.Expr(map[interface{}]interface{}{"b": 1}).Lt(map[interface{}]interface{}{"a": 0}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #295")
	}

	{
		// math_logic/comparison.yaml line #299
		/* false */
		var expected_ bool = false
		/* r.expr({'a':0, 'b':1, 'c':2}) < {'a':0, 'b':1, 'c':2} */

		suite.T().Log("About to run line #299: r.Expr(map[interface{}]interface{}{'a': 0, 'b': 1, 'c': 2, }).Lt(map[interface{}]interface{}{'a': 0, 'b': 1, 'c': 2, })")

		runAndAssert(suite.Suite, expected_, r.Expr(map[interface{}]interface{}{"a": 0, "b": 1, "c": 2}).Lt(map[interface{}]interface{}{"a": 0, "b": 1, "c": 2}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #299")
	}

	{
		// math_logic/comparison.yaml line #303
		/* false */
		var expected_ bool = false
		/* r.expr({'a':0, 'b':1, 'c':2, 'd':3}) < {'a':0, 'b':1, 'c':2} */

		suite.T().Log("About to run line #303: r.Expr(map[interface{}]interface{}{'a': 0, 'b': 1, 'c': 2, 'd': 3, }).Lt(map[interface{}]interface{}{'a': 0, 'b': 1, 'c': 2, })")

		runAndAssert(suite.Suite, expected_, r.Expr(map[interface{}]interface{}{"a": 0, "b": 1, "c": 2, "d": 3}).Lt(map[interface{}]interface{}{"a": 0, "b": 1, "c": 2}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #303")
	}

	{
		// math_logic/comparison.yaml line #307
		/* true */
		var expected_ bool = true
		/* r.expr({'a':0, 'b':1, 'c':2}) < {'a':0, 'b':1, 'c':2, 'd':3} */

		suite.T().Log("About to run line #307: r.Expr(map[interface{}]interface{}{'a': 0, 'b': 1, 'c': 2, }).Lt(map[interface{}]interface{}{'a': 0, 'b': 1, 'c': 2, 'd': 3, })")

		runAndAssert(suite.Suite, expected_, r.Expr(map[interface{}]interface{}{"a": 0, "b": 1, "c": 2}).Lt(map[interface{}]interface{}{"a": 0, "b": 1, "c": 2, "d": 3}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #307")
	}

	{
		// math_logic/comparison.yaml line #311
		/* false */
		var expected_ bool = false
		/* r.expr({'a':0, 'c':2}) < {'a':0, 'b':1, 'c':2} */

		suite.T().Log("About to run line #311: r.Expr(map[interface{}]interface{}{'a': 0, 'c': 2, }).Lt(map[interface{}]interface{}{'a': 0, 'b': 1, 'c': 2, })")

		runAndAssert(suite.Suite, expected_, r.Expr(map[interface{}]interface{}{"a": 0, "c": 2}).Lt(map[interface{}]interface{}{"a": 0, "b": 1, "c": 2}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #311")
	}

	{
		// math_logic/comparison.yaml line #315
		/* true */
		var expected_ bool = true
		/* r.expr({'a':0, 'c':2}) > {'a':0, 'b':1, 'c':2} */

		suite.T().Log("About to run line #315: r.Expr(map[interface{}]interface{}{'a': 0, 'c': 2, }).Gt(map[interface{}]interface{}{'a': 0, 'b': 1, 'c': 2, })")

		runAndAssert(suite.Suite, expected_, r.Expr(map[interface{}]interface{}{"a": 0, "c": 2}).Gt(map[interface{}]interface{}{"a": 0, "b": 1, "c": 2}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #315")
	}

	// math_logic/comparison.yaml line #331
	// everything = r.expr([[],r.now(),r.binary(b"\x00"),false,null,-5,{},"a",r.maxval])
	suite.T().Log("Possibly executing: var everything r.Term = r.Expr([]interface{}{[]interface{}{}, r.Now(), r.Binary([]byte{0}), false, nil, -5, map[interface{}]interface{}{}, 'a', r.MaxVal})")

	everything := r.Expr([]interface{}{[]interface{}{}, r.Now(), r.Binary([]byte{0}), false, nil, -5, map[interface{}]interface{}{}, "a", r.MaxVal})
	_ = everything // Prevent any noused variable errors

	{
		// math_logic/comparison.yaml line #336
		/* true */
		var expected_ bool = true
		/* r.and_(r.args(everything.map(r.lt(r.minval, r.row)))) */

		suite.T().Log("About to run line #336: r.And(r.Args(everything.Map(r.Lt(r.MinVal, r.Row))))")

		runAndAssert(suite.Suite, expected_, r.And(r.Args(everything.Map(r.Lt(r.MinVal, r.Row)))), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #336")
	}

	{
		// math_logic/comparison.yaml line #341
		/* false */
		var expected_ bool = false
		/* r.or_(r.args(everything.map(r.gt(r.minval, r.row)))) */

		suite.T().Log("About to run line #341: r.Or(r.Args(everything.Map(r.Gt(r.MinVal, r.Row))))")

		runAndAssert(suite.Suite, expected_, r.Or(r.Args(everything.Map(r.Gt(r.MinVal, r.Row)))), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #341")
	}

	{
		// math_logic/comparison.yaml line #345
		/* true */
		var expected_ bool = true
		/* r.eq(r.minval, r.minval) */

		suite.T().Log("About to run line #345: r.Eq(r.MinVal, r.MinVal)")

		runAndAssert(suite.Suite, expected_, r.Eq(r.MinVal, r.MinVal), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #345")
	}

	{
		// math_logic/comparison.yaml line #348
		/* true */
		var expected_ bool = true
		/* r.expr([]) < True */

		suite.T().Log("About to run line #348: r.Expr([]interface{}{}).Lt(true)")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{}).Lt(true), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #348")
	}

	{
		// math_logic/comparison.yaml line #353
		/* true */
		var expected_ bool = true
		/* r.expr([1,2]) < False */

		suite.T().Log("About to run line #353: r.Expr([]interface{}{1, 2}).Lt(false)")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{1, 2}).Lt(false), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #353")
	}

	{
		// math_logic/comparison.yaml line #358
		/* false */
		var expected_ bool = false
		/* r.expr(False) < [] */

		suite.T().Log("About to run line #358: r.Expr(false).Lt([]interface{}{})")

		runAndAssert(suite.Suite, expected_, r.Expr(false).Lt([]interface{}{}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #358")
	}

	{
		// math_logic/comparison.yaml line #363
		/* true */
		var expected_ bool = true
		/* r.expr([]) < r.binary(b"\xAE") */

		suite.T().Log("About to run line #363: r.Expr([]interface{}{}).Lt(r.Binary([]byte{174}))")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{}).Lt(r.Binary([]byte{174})), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #363")
	}

	{
		// math_logic/comparison.yaml line #368
		/* true */
		var expected_ bool = true
		/* r.expr([1,2]) < r.binary(b"\xAE") */

		suite.T().Log("About to run line #368: r.Expr([]interface{}{1, 2}).Lt(r.Binary([]byte{174}))")

		runAndAssert(suite.Suite, expected_, r.Expr([]interface{}{1, 2}).Lt(r.Binary([]byte{174})), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #368")
	}

	{
		// math_logic/comparison.yaml line #373
		/* true */
		var expected_ bool = true
		/* True < r.expr(null) */

		suite.T().Log("About to run line #373: r.Lt(true, r.Expr(nil))")

		runAndAssert(suite.Suite, expected_, r.Lt(true, r.Expr(nil)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #373")
	}

	{
		// math_logic/comparison.yaml line #378
		/* true */
		var expected_ bool = true
		/* r.expr(null) > [] */

		suite.T().Log("About to run line #378: r.Expr(nil).Gt([]interface{}{})")

		runAndAssert(suite.Suite, expected_, r.Expr(nil).Gt([]interface{}{}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #378")
	}

	{
		// math_logic/comparison.yaml line #383
		/* true */
		var expected_ bool = true
		/* r.expr(null) < 12 */

		suite.T().Log("About to run line #383: r.Expr(nil).Lt(12)")

		runAndAssert(suite.Suite, expected_, r.Expr(nil).Lt(12), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #383")
	}

	{
		// math_logic/comparison.yaml line #388
		/* true */
		var expected_ bool = true
		/* r.expr(null) < -2 */

		suite.T().Log("About to run line #388: r.Expr(nil).Lt(-2)")

		runAndAssert(suite.Suite, expected_, r.Expr(nil).Lt(-2), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #388")
	}

	{
		// math_logic/comparison.yaml line #393
		/* true */
		var expected_ bool = true
		/* r.expr(-12) < {} */

		suite.T().Log("About to run line #393: r.Expr(-12).Lt(map[interface{}]interface{}{})")

		runAndAssert(suite.Suite, expected_, r.Expr(-12).Lt(map[interface{}]interface{}{}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #393")
	}

	{
		// math_logic/comparison.yaml line #398
		/* true */
		var expected_ bool = true
		/* r.expr(100) < {'a':-12} */

		suite.T().Log("About to run line #398: r.Expr(100).Lt(map[interface{}]interface{}{'a': -12, })")

		runAndAssert(suite.Suite, expected_, r.Expr(100).Lt(map[interface{}]interface{}{"a": -12}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #398")
	}

	{
		// math_logic/comparison.yaml line #403
		/* false */
		var expected_ bool = false
		/* r.expr(r.binary(b"\xAE")) < 12 */

		suite.T().Log("About to run line #403: r.Expr(r.Binary([]byte{174})).Lt(12)")

		runAndAssert(suite.Suite, expected_, r.Expr(r.Binary([]byte{174})).Lt(12), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #403")
	}

	{
		// math_logic/comparison.yaml line #408
		/* true */
		var expected_ bool = true
		/* r.binary(b"0xAE") < 'abc' */

		suite.T().Log("About to run line #408: r.Binary([]byte{48,120,65,69}).Lt('abc')")

		runAndAssert(suite.Suite, expected_, r.Binary([]byte{48, 120, 65, 69}).Lt("abc"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #408")
	}

	{
		// math_logic/comparison.yaml line #413
		/* false */
		var expected_ bool = false
		/* r.binary(b"0xAE") > r.now() */

		suite.T().Log("About to run line #413: r.Binary([]byte{48,120,65,69}).Gt(r.Now())")

		runAndAssert(suite.Suite, expected_, r.Binary([]byte{48, 120, 65, 69}).Gt(r.Now()), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #413")
	}

	{
		// math_logic/comparison.yaml line #418
		/* true */
		var expected_ bool = true
		/* r.now() > 12 */

		suite.T().Log("About to run line #418: r.Now().Gt(12)")

		runAndAssert(suite.Suite, expected_, r.Now().Gt(12), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #418")
	}

	{
		// math_logic/comparison.yaml line #422
		/* false */
		var expected_ bool = false
		/* r.now() > 'abc' */

		suite.T().Log("About to run line #422: r.Now().Gt('abc')")

		runAndAssert(suite.Suite, expected_, r.Now().Gt("abc"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #422")
	}

	{
		// math_logic/comparison.yaml line #426
		/* true */
		var expected_ bool = true
		/* r.expr("abc") > {'a':-12} */

		suite.T().Log("About to run line #426: r.Expr('abc').Gt(map[interface{}]interface{}{'a': -12, })")

		runAndAssert(suite.Suite, expected_, r.Expr("abc").Gt(map[interface{}]interface{}{"a": -12}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #426")
	}

	{
		// math_logic/comparison.yaml line #431
		/* true */
		var expected_ bool = true
		/* r.expr("abc") > {'abc':'abc'} */

		suite.T().Log("About to run line #431: r.Expr('abc').Gt(map[interface{}]interface{}{'abc': 'abc', })")

		runAndAssert(suite.Suite, expected_, r.Expr("abc").Gt(map[interface{}]interface{}{"abc": "abc"}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #431")
	}

	{
		// math_logic/comparison.yaml line #436
		/* true */
		var expected_ bool = true
		/* r.expr('zzz') > 128 */

		suite.T().Log("About to run line #436: r.Expr('zzz').Gt(128)")

		runAndAssert(suite.Suite, expected_, r.Expr("zzz").Gt(128), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #436")
	}

	{
		// math_logic/comparison.yaml line #441
		/* true */
		var expected_ bool = true
		/* r.expr('zzz') > {} */

		suite.T().Log("About to run line #441: r.Expr('zzz').Gt(map[interface{}]interface{}{})")

		runAndAssert(suite.Suite, expected_, r.Expr("zzz").Gt(map[interface{}]interface{}{}), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #441")
	}

	{
		// math_logic/comparison.yaml line #446
		/* true */
		var expected_ bool = true
		/* 'zzz' > r.expr(-152) */

		suite.T().Log("About to run line #446: r.Gt('zzz', r.Expr(-152))")

		runAndAssert(suite.Suite, expected_, r.Gt("zzz", r.Expr(-152)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #446")
	}

	{
		// math_logic/comparison.yaml line #451
		/* true */
		var expected_ bool = true
		/* 'zzz' > r.expr(null) */

		suite.T().Log("About to run line #451: r.Gt('zzz', r.Expr(nil))")

		runAndAssert(suite.Suite, expected_, r.Gt("zzz", r.Expr(nil)), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #451")
	}

	{
		// math_logic/comparison.yaml line #456
		/* true */
		var expected_ bool = true
		/* 'zzz' > r.expr([]) */

		suite.T().Log("About to run line #456: r.Gt('zzz', r.Expr([]interface{}{}))")

		runAndAssert(suite.Suite, expected_, r.Gt("zzz", r.Expr([]interface{}{})), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #456")
	}

	// math_logic/comparison.yaml line #463
	// everything2 = r.expr([r.minval,[],r.now(),r.binary(b"\x00"),false,null,-5,{},"a"])
	suite.T().Log("Possibly executing: var everything2 r.Term = r.Expr([]interface{}{r.MinVal, []interface{}{}, r.Now(), r.Binary([]byte{0}), false, nil, -5, map[interface{}]interface{}{}, 'a'})")

	everything2 := r.Expr([]interface{}{r.MinVal, []interface{}{}, r.Now(), r.Binary([]byte{0}), false, nil, -5, map[interface{}]interface{}{}, "a"})
	_ = everything2 // Prevent any noused variable errors

	{
		// math_logic/comparison.yaml line #467
		/* true */
		var expected_ bool = true
		/* r.and_(r.args(everything2.map(r.gt(r.maxval, r.row)))) */

		suite.T().Log("About to run line #467: r.And(r.Args(everything2.Map(r.Gt(r.MaxVal, r.Row))))")

		runAndAssert(suite.Suite, expected_, r.And(r.Args(everything2.Map(r.Gt(r.MaxVal, r.Row)))), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #467")
	}

	{
		// math_logic/comparison.yaml line #472
		/* false */
		var expected_ bool = false
		/* r.or_(r.args(everything2.map(r.lt(r.maxval, r.row)))) */

		suite.T().Log("About to run line #472: r.Or(r.Args(everything2.Map(r.Lt(r.MaxVal, r.Row))))")

		runAndAssert(suite.Suite, expected_, r.Or(r.Args(everything2.Map(r.Lt(r.MaxVal, r.Row)))), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #472")
	}

	{
		// math_logic/comparison.yaml line #476
		/* true */
		var expected_ bool = true
		/* r.eq(r.maxval, r.maxval) */

		suite.T().Log("About to run line #476: r.Eq(r.MaxVal, r.MaxVal)")

		runAndAssert(suite.Suite, expected_, r.Eq(r.MaxVal, r.MaxVal), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #476")
	}
}
