// Code generated by smithy-go-codegen DO NOT EDIT.

package kendraranking

import (
	"context"
	smithy "github.com/aws/smithy-go"
	smithyendpoints "github.com/aws/smithy-go/endpoints"
	"github.com/aws/smithy-go/ptr"
	"github.com/google/go-cmp/cmp"
	"net/http"
	"net/url"
	"strings"
	"testing"
)

// For region us-east-1 with FIPS enabled and DualStack enabled
func TestEndpointCase0(t *testing.T) {
	var params = EndpointParameters{
		Region:  ptr.String("us-east-1"),
		UseFIPS: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://kendra-ranking-fips.us-east-1.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// For region us-east-1 with FIPS disabled and DualStack enabled
func TestEndpointCase1(t *testing.T) {
	var params = EndpointParameters{
		Region:  ptr.String("us-east-1"),
		UseFIPS: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://kendra-ranking.us-east-1.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// For region cn-north-1 with FIPS enabled and DualStack enabled
func TestEndpointCase2(t *testing.T) {
	var params = EndpointParameters{
		Region:  ptr.String("cn-north-1"),
		UseFIPS: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://kendra-ranking-fips.cn-north-1.api.amazonwebservices.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// For region cn-north-1 with FIPS disabled and DualStack enabled
func TestEndpointCase3(t *testing.T) {
	var params = EndpointParameters{
		Region:  ptr.String("cn-north-1"),
		UseFIPS: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://kendra-ranking.cn-north-1.api.amazonwebservices.com.cn")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// For region us-gov-east-1 with FIPS enabled and DualStack enabled
func TestEndpointCase4(t *testing.T) {
	var params = EndpointParameters{
		Region:  ptr.String("us-gov-east-1"),
		UseFIPS: ptr.Bool(true),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://kendra-ranking-fips.us-gov-east-1.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// For region us-gov-east-1 with FIPS disabled and DualStack enabled
func TestEndpointCase5(t *testing.T) {
	var params = EndpointParameters{
		Region:  ptr.String("us-gov-east-1"),
		UseFIPS: ptr.Bool(false),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://kendra-ranking.us-gov-east-1.api.aws")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// For custom endpoint with region set and fips disabled and dualstack disabled
func TestEndpointCase6(t *testing.T) {
	var params = EndpointParameters{
		Region:   ptr.String("us-east-1"),
		UseFIPS:  ptr.Bool(false),
		Endpoint: ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// For custom endpoint with region not set and fips disabled and dualstack disabled
func TestEndpointCase7(t *testing.T) {
	var params = EndpointParameters{
		UseFIPS:  ptr.Bool(false),
		Endpoint: ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err != nil {
		t.Fatalf("expect no error, got %v", err)
	}

	uri, _ := url.Parse("https://example.com")

	expectEndpoint := smithyendpoints.Endpoint{
		URI:        *uri,
		Headers:    http.Header{},
		Properties: smithy.Properties{},
	}

	if e, a := expectEndpoint.URI, result.URI; e != a {
		t.Errorf("expect %v URI, got %v", e, a)
	}

	if diff := cmp.Diff(expectEndpoint.Headers, result.Headers); diff != "" {
		t.Errorf("expect headers to match\n%s", diff)
	}

	if diff := cmp.Diff(expectEndpoint.Properties, result.Properties,
		cmp.AllowUnexported(smithy.Properties{}),
	); diff != "" {
		t.Errorf("expect properties to match\n%s", diff)
	}
}

// For custom endpoint with fips enabled and dualstack disabled
func TestEndpointCase8(t *testing.T) {
	var params = EndpointParameters{
		Region:   ptr.String("us-east-1"),
		UseFIPS:  ptr.Bool(true),
		Endpoint: ptr.String("https://example.com"),
	}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: FIPS and custom endpoint are not supported", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}

// Missing region
func TestEndpointCase9(t *testing.T) {
	var params = EndpointParameters{}

	resolver := NewDefaultEndpointResolverV2()
	result, err := resolver.ResolveEndpoint(context.Background(), params)
	_, _ = result, err

	if err == nil {
		t.Fatalf("expect error, got none")
	}
	if e, a := "Invalid Configuration: Missing Region", err.Error(); !strings.Contains(a, e) {
		t.Errorf("expect %v error in %v", e, a)
	}
}
