// Code generated by smithy-go-codegen DO NOT EDIT.

package iotjobsdataplane

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/iotjobsdataplane/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Gets and starts the next pending (status IN_PROGRESS or QUEUED) job execution
// for a thing.
func (c *Client) StartNextPendingJobExecution(ctx context.Context, params *StartNextPendingJobExecutionInput, optFns ...func(*Options)) (*StartNextPendingJobExecutionOutput, error) {
	if params == nil {
		params = &StartNextPendingJobExecutionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartNextPendingJobExecution", params, optFns, c.addOperationStartNextPendingJobExecutionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartNextPendingJobExecutionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartNextPendingJobExecutionInput struct {

	// The name of the thing associated with the device.
	//
	// This member is required.
	ThingName *string

	// A collection of name/value pairs that describe the status of the job execution.
	// If not specified, the statusDetails are unchanged.
	StatusDetails map[string]string

	// Specifies the amount of time this device has to finish execution of this job.
	// If the job execution status is not set to a terminal state before this timer
	// expires, or before the timer is reset (by calling UpdateJobExecution , setting
	// the status to IN_PROGRESS and specifying a new timeout value in field
	// stepTimeoutInMinutes ) the job execution status will be automatically set to
	// TIMED_OUT . Note that setting this timeout has no effect on that job execution
	// timeout which may have been specified when the job was created ( CreateJob
	// using field timeoutConfig ).
	StepTimeoutInMinutes *int64

	noSmithyDocumentSerde
}

type StartNextPendingJobExecutionOutput struct {

	// A JobExecution object.
	Execution *types.JobExecution

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartNextPendingJobExecutionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartNextPendingJobExecution{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartNextPendingJobExecution{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartNextPendingJobExecution"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpStartNextPendingJobExecutionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartNextPendingJobExecution(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartNextPendingJobExecution(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartNextPendingJobExecution",
	}
}
