# Getting started

Hello, and thanks for your interest in contributing to Firefox DevTools!

DevTools is a complex web app, but if you're familiar with either HTML/CSS or JavaScript, you can contribute! The process goes like this:

- Claim a bug
- Set up your dev environment
- Write the patch and get it reviewed

Feel free to ask questions at any point on [Matrix](https://chat.mozilla.org/#/room/#devtools:mozilla.org).

## Claim a bug

Visit the [Codetribute](https://codetribute.mozilla.org/projects/devtools) bug tracker and find a bug you like. Anything labeled **good-first-bug** is perfect for a newcomer. Many of these tasks will make a visible impact to the DevTools UI.

Claim the bug by creating a Bugzilla account and posting a comment on the bug’s page to say that you’d like to work on it. Ask questions if you have any uncertainty about what the bug means.

## Set up your dev environment

Follow the steps of Firefox’s [contributor guide](https://firefox-source-docs.mozilla.org/contributing/how_to_contribute_firefox.html) to install and run Firefox locally. During installation, follow the steps for “Artifact Mode.” 

If you run into errors about missing libraries, search the web to learn how to install whatever is missing. If you get stuck, ask for help on [Matrix](https://chat.mozilla.org/#/room/#devtools:mozilla.org).

## Write the patch and get it reviewed

The rest of this documentation has info on coding standards as well as specifics of DevTools architecture.

When you’re ready to commit your changes, you can ask the bug’s mentor to review, or refer to the list of [DevTools team members](https://firefox-dev.tools/#about-devtools).
