import unittest

from selenium import webdriver
from selenium.webdriver.chrome.service import Service
from selenium.webdriver.support.wait import WebDriverWait
from selenium.webdriver.common.by import By
from selenium.webdriver.support.ui import Select
import os
import sys

class TestDmarcSrgWeb(unittest.TestCase):

    def setUp(self):
        self.data_dir = os.getenv('AUTOPKGTEST_TMP', default='/tmp') + '/google-chrome'

        # print('Using chrome data dir: ' + self.data_dir)

        options = webdriver.ChromeOptions()
        options.add_argument('--headless')
        options.add_argument('--no-sandbox')
        options.add_argument('--disable-gpu')
        options.add_argument('--disable-dev-shm-usage')
        options.add_argument('--profile-directory=Default')
        options.add_argument('--user-data-dir=' + self.data_dir)
        service = Service(executable_path=r'/usr/bin/chromedriver')
        self.driver = webdriver.Chrome(service=service, options=options)

    def tearDown(self):
        self.driver.close()

    def test_login_page(self):
        self.driver.get("http://localhost:8888/dmarc-srg/")
        self.assertIn("DMARC Reports", self.driver.title)

        vitals = WebDriverWait(self.driver, 60).until(lambda x: x.find_element(By.CLASS_NAME, "dialog"))

        self.assertIn("Authentication", vitals.text)
        self.assertIn("Password", vitals.text)

if __name__ == '__main__':
    suite = unittest.TestLoader().loadTestsFromTestCase(TestDmarcSrgWeb)
    result = unittest.TextTestRunner(verbosity=2).run(suite)

    if not result.wasSuccessful():
        sys.exit(1)
