{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdFanCount: TMFInt32;
    { Internal wrapper for property @code(FanCount). This wrapper API may change, we advise to access simpler @code(FanCount) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdFanCount: TMFInt32 read FFdFanCount;
    {  }
    procedure SetFanCount(const Value: array of Int32); overload;
    {  }
    procedure SetFanCount(const Value: TInt32List); overload;

{$endif read_interface}

{$ifdef read_implementation}

{ TTriangleFanSetNode ----------------------------------------------- }

procedure TTriangleFanSetNode.SetFanCount(const Value: array of Int32);
begin
  FdFanCount.Send(Value);
end;

procedure TTriangleFanSetNode.SetFanCount(const Value: TInt32List);
begin
  FdFanCount.Send(Value);
end;

class function TTriangleFanSetNode.ClassX3DType: String;
begin
  Result := 'TriangleFanSet';
end;

procedure TTriangleFanSetNode.CreateNode;
begin
  inherited;

  FFdFanCount := TMFInt32.Create(Self, True, 'fanCount', []);
   FdFanCount.ChangeAlways := chGeometry;
  AddField(FFdFanCount);
end;

{$endif read_implementation}
