{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetSize: TVector2;
    procedure SetSize(const Value: TVector2);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdSize: TSFVec2f;
    { Internal wrapper for property @code(Size). This wrapper API may change, we advise to access simpler @code(Size) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSize: TSFVec2f read FFdSize;
    {  }
    property Size: TVector2 read GetSize write SetSize;

    strict private FFdSolid: TSFBool;
    { Internal wrapper for property @code(Solid). This wrapper API may change, we advise to access simpler @code(Solid) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSolid: TSFBool read FFdSolid;

{$endif read_interface}

{$ifdef read_implementation}

{ TRectangle2DNode ----------------------------------------------- }

function TRectangle2DNode.GetSize: TVector2;
begin
  Result := FdSize.Value;
end;

procedure TRectangle2DNode.SetSize(const Value: TVector2);
begin
  FdSize.Send(Value);
end;

class function TRectangle2DNode.ClassX3DType: String;
begin
  Result := 'Rectangle2D';
end;

procedure TRectangle2DNode.CreateNode;
begin
  inherited;

  FFdSize := TSFVec2f.Create(Self, False, 'size', Vector2(2, 2));
   FdSize.ChangeAlways := chGeometry;
  AddField(FFdSize);

  FFdSolid := TSFBool.Create(Self, False, 'solid', false);
   FdSolid.ChangeAlways := chGeometry;
  AddField(FFdSolid);
end;

{$endif read_implementation}
