{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdFanCount: TMFInt32;
    { Internal wrapper for property @link(FanCount). This wrapper API may change, we advise to access simpler @link(FanCount) instead. }
    public property FdFanCount: TMFInt32 read FFdFanCount;
    {  }
    procedure SetFanCount(const Value: array of LongInt); overload;
    {  }
    procedure SetFanCount(const Value: TLongIntList); overload;

{$endif read_interface}

{$ifdef read_implementation}

{ TTriangleFanSetNode ----------------------------------------------- }

procedure TTriangleFanSetNode.SetFanCount(const Value: array of LongInt);
begin
  FdFanCount.Send(Value);
end;

procedure TTriangleFanSetNode.SetFanCount(const Value: TLongIntList);
begin
  FdFanCount.Send(Value);
end;

class function TTriangleFanSetNode.ClassX3DType: String;
begin
  Result := 'TriangleFanSet';
end;

procedure TTriangleFanSetNode.CreateNode;
begin
  inherited;

  FFdFanCount := TMFInt32.Create(Self, True, 'fanCount', []);
   FdFanCount.ChangeAlways := chGeometry;
  AddField(FFdFanCount);
end;

{$endif read_implementation}
