{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetWidth: Single;
    procedure SetWidth(const Value: Single);
    function GetHeight: Single;
    procedure SetHeight(const Value: Single);
    function GetDepth: Single;
    procedure SetDepth(const Value: Single);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;
    class function ForVRMLVersion(const Version: TX3DVersion): Boolean; override;

    strict private FFdWidth: TSFFloat;
    { Internal wrapper for property @link(Width). This wrapper API may change, we advise to access simpler @link(Width) instead. }
    public property FdWidth: TSFFloat read FFdWidth;
    {  }
    property Width: Single read GetWidth write SetWidth;

    strict private FFdHeight: TSFFloat;
    { Internal wrapper for property @link(Height). This wrapper API may change, we advise to access simpler @link(Height) instead. }
    public property FdHeight: TSFFloat read FFdHeight;
    {  }
    property Height: Single read GetHeight write SetHeight;

    strict private FFdDepth: TSFFloat;
    { Internal wrapper for property @link(Depth). This wrapper API may change, we advise to access simpler @link(Depth) instead. }
    public property FdDepth: TSFFloat read FFdDepth;
    {  }
    property Depth: Single read GetDepth write SetDepth;

{$endif read_interface}

{$ifdef read_implementation}

{ TCubeNode_1 ----------------------------------------------- }

function TCubeNode_1.GetWidth: Single;
begin
  Result := FdWidth.Value;
end;

procedure TCubeNode_1.SetWidth(const Value: Single);
begin
  FdWidth.Send(Value);
end;

function TCubeNode_1.GetHeight: Single;
begin
  Result := FdHeight.Value;
end;

procedure TCubeNode_1.SetHeight(const Value: Single);
begin
  FdHeight.Send(Value);
end;

function TCubeNode_1.GetDepth: Single;
begin
  Result := FdDepth.Value;
end;

procedure TCubeNode_1.SetDepth(const Value: Single);
begin
  FdDepth.Send(Value);
end;

class function TCubeNode_1.ForVRMLVersion(const Version: TX3DVersion): Boolean;
begin
  Result := Version.Major <= 1; // parse this node only in VRML 1.0 and Inventor files
end;

class function TCubeNode_1.ClassX3DType: String;
begin
  Result := 'Cube';
end;

procedure TCubeNode_1.CreateNode;
begin
  inherited;

  FFdWidth := TSFFloat.Create(Self, True, 'width', 2);
   FdWidth.ChangeAlways := chGeometry;
   FdWidth.MustBeNonnegative := true;
  AddField(FFdWidth);

  FFdHeight := TSFFloat.Create(Self, True, 'height', 2);
   FdHeight.ChangeAlways := chGeometry;
   FdHeight.MustBeNonnegative := true;
  AddField(FFdHeight);

  FFdDepth := TSFFloat.Create(Self, True, 'depth', 2);
   FdDepth.ChangeAlways := chGeometry;
   FdDepth.MustBeNonnegative := true;
  AddField(FFdDepth);
end;

{$endif read_implementation}
