// This file was GENERATED by command:
//     pump.py gtest-type-util.h.pump
// DO NOT EDIT BY HAND!!!

// Copyright 2008 Google Inc.
// All Rights Reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//     * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
//     * Neither the name of Google Inc. nor the names of its
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Author: wan@google.com (Zhanyong Wan)

// Type utilities needed for implementing typed and type-parameterized
// tests.  This file is generated by a SCRIPT.  DO NOT EDIT BY HAND!
//
// Currently we support at most 50 types in a list, and at most 50
// type-parameterized tests in one type-parameterized test case.
// Please contact googletestframework@googlegroups.com if you need
// more.

#ifndef GTEST_INCLUDE_GTEST_INTERNAL_GTEST_TYPE_UTIL_H_
#define GTEST_INCLUDE_GTEST_INTERNAL_GTEST_TYPE_UTIL_H_

#include "gtest/internal/gtest-port.h"

// #ifdef __GNUC__ is too general here.  It is possible to use gcc without using
// libstdc++ (which is where cxxabi.h comes from).
#if GTEST_HAS_CXXABI_H_
#include <cxxabi.h>
#elif defined(__HP_aCC)
#include <acxx_demangle.h>
#endif  // GTEST_HASH_CXXABI_H_

namespace testing
{
namespace internal
{
// GetTypeName<T>() returns a human-readable name of type T.
// NB: This function is also used in Google Mock, so don't move it inside of
// the typed-test-only section below.
template <typename T>
std::string GetTypeName()
{
#if GTEST_HAS_RTTI

	const char* const name = typeid(T).name();
#if GTEST_HAS_CXXABI_H_ || defined(__HP_aCC)
	int status = 0;
	// gcc's implementation of typeid(T).name() mangles the type name,
	// so we have to demangle it.
#if GTEST_HAS_CXXABI_H_
	using abi::__cxa_demangle;
#endif  // GTEST_HAS_CXXABI_H_
	char* const readable_name = __cxa_demangle(name, 0, 0, &status);
	const std::string name_str(status == 0 ? readable_name : name);
	free(readable_name);
	return name_str;
#else
	return name;
#endif  // GTEST_HAS_CXXABI_H_ || __HP_aCC

#else

	return "<type>";

#endif  // GTEST_HAS_RTTI
}

#if GTEST_HAS_TYPED_TEST || GTEST_HAS_TYPED_TEST_P

// AssertyTypeEq<T1, T2>::type is defined iff T1 and T2 are the same
// type.  This can be used as a compile-time assertion to ensure that
// two types are equal.

template <typename T1, typename T2>
struct AssertTypeEq;

template <typename T>
struct AssertTypeEq<T, T>
{
	typedef bool type;
};

// A unique type used as the default value for the arguments of class
// template Types.  This allows us to simulate variadic templates
// (e.g. Types<int>, Type<int, double>, and etc), which C++ doesn't
// support directly.
struct None
{
};

// The following family of struct and struct templates are used to
// represent type lists.  In particular, TypesN<T1, T2, ..., TN>
// represents a type list with N types (T1, T2, ..., and TN) in it.
// Except for Types0, every struct in the family has two member types:
// Head for the first type in the list, and Tail for the rest of the
// list.

// The empty type list.
struct Types0
{
};

// Type lists of length 1, 2, 3, and so on.

template <typename T1>
struct Types1
{
	typedef T1 Head;
	typedef Types0 Tail;
};
template <typename T1, typename T2>
struct Types2
{
	typedef T1 Head;
	typedef Types1<T2> Tail;
};

template <typename T1, typename T2, typename T3>
struct Types3
{
	typedef T1 Head;
	typedef Types2<T2, T3> Tail;
};

template <typename T1, typename T2, typename T3, typename T4>
struct Types4
{
	typedef T1 Head;
	typedef Types3<T2, T3, T4> Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5>
struct Types5
{
	typedef T1 Head;
	typedef Types4<T2, T3, T4, T5> Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6>
struct Types6
{
	typedef T1 Head;
	typedef Types5<T2, T3, T4, T5, T6> Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7>
struct Types7
{
	typedef T1 Head;
	typedef Types6<T2, T3, T4, T5, T6, T7> Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8>
struct Types8
{
	typedef T1 Head;
	typedef Types7<T2, T3, T4, T5, T6, T7, T8> Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9>
struct Types9
{
	typedef T1 Head;
	typedef Types8<T2, T3, T4, T5, T6, T7, T8, T9> Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10>
struct Types10
{
	typedef T1 Head;
	typedef Types9<T2, T3, T4, T5, T6, T7, T8, T9, T10> Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11>
struct Types11
{
	typedef T1 Head;
	typedef Types10<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12>
struct Types12
{
	typedef T1 Head;
	typedef Types11<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13>
struct Types13
{
	typedef T1 Head;
	typedef Types12<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14>
struct Types14
{
	typedef T1 Head;
	typedef Types13<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15>
struct Types15
{
	typedef T1 Head;
	typedef Types14<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
					T15>
		Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16>
struct Types16
{
	typedef T1 Head;
	typedef Types15<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
					T16>
		Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17>
struct Types17
{
	typedef T1 Head;
	typedef Types16<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
					T16, T17>
		Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18>
struct Types18
{
	typedef T1 Head;
	typedef Types17<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
					T16, T17, T18>
		Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19>
struct Types19
{
	typedef T1 Head;
	typedef Types18<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
					T16, T17, T18, T19>
		Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20>
struct Types20
{
	typedef T1 Head;
	typedef Types19<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
					T16, T17, T18, T19, T20>
		Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21>
struct Types21
{
	typedef T1 Head;
	typedef Types20<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
					T16, T17, T18, T19, T20, T21>
		Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22>
struct Types22
{
	typedef T1 Head;
	typedef Types21<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
					T16, T17, T18, T19, T20, T21, T22>
		Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23>
struct Types23
{
	typedef T1 Head;
	typedef Types22<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
					T16, T17, T18, T19, T20, T21, T22, T23>
		Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24>
struct Types24
{
	typedef T1 Head;
	typedef Types23<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
					T16, T17, T18, T19, T20, T21, T22, T23, T24>
		Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25>
struct Types25
{
	typedef T1 Head;
	typedef Types24<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
					T16, T17, T18, T19, T20, T21, T22, T23, T24, T25>
		Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26>
struct Types26
{
	typedef T1 Head;
	typedef Types25<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
					T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26>
		Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27>
struct Types27
{
	typedef T1 Head;
	typedef Types26<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
					T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27>
		Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28>
struct Types28
{
	typedef T1 Head;
	typedef Types27<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
					T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28>
		Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29>
struct Types29
{
	typedef T1 Head;
	typedef Types28<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
					T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28,
					T29>
		Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30>
struct Types30
{
	typedef T1 Head;
	typedef Types29<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
					T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
					T30>
		Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31>
struct Types31
{
	typedef T1 Head;
	typedef Types30<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
					T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
					T30, T31>
		Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32>
struct Types32
{
	typedef T1 Head;
	typedef Types31<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
					T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
					T30, T31, T32>
		Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32, typename T33>
struct Types33
{
	typedef T1 Head;
	typedef Types32<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
					T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
					T30, T31, T32, T33>
		Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32, typename T33, typename T34>
struct Types34
{
	typedef T1 Head;
	typedef Types33<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
					T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
					T30, T31, T32, T33, T34>
		Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32, typename T33, typename T34, typename T35>
struct Types35
{
	typedef T1 Head;
	typedef Types34<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
					T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
					T30, T31, T32, T33, T34, T35>
		Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32, typename T33, typename T34, typename T35,
		  typename T36>
struct Types36
{
	typedef T1 Head;
	typedef Types35<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
					T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
					T30, T31, T32, T33, T34, T35, T36>
		Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32, typename T33, typename T34, typename T35,
		  typename T36, typename T37>
struct Types37
{
	typedef T1 Head;
	typedef Types36<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
					T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
					T30, T31, T32, T33, T34, T35, T36, T37>
		Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32, typename T33, typename T34, typename T35,
		  typename T36, typename T37, typename T38>
struct Types38
{
	typedef T1 Head;
	typedef Types37<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
					T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
					T30, T31, T32, T33, T34, T35, T36, T37, T38>
		Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32, typename T33, typename T34, typename T35,
		  typename T36, typename T37, typename T38, typename T39>
struct Types39
{
	typedef T1 Head;
	typedef Types38<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
					T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
					T30, T31, T32, T33, T34, T35, T36, T37, T38, T39>
		Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32, typename T33, typename T34, typename T35,
		  typename T36, typename T37, typename T38, typename T39, typename T40>
struct Types40
{
	typedef T1 Head;
	typedef Types39<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
					T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
					T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40>
		Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32, typename T33, typename T34, typename T35,
		  typename T36, typename T37, typename T38, typename T39, typename T40,
		  typename T41>
struct Types41
{
	typedef T1 Head;
	typedef Types40<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
					T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
					T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41>
		Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32, typename T33, typename T34, typename T35,
		  typename T36, typename T37, typename T38, typename T39, typename T40,
		  typename T41, typename T42>
struct Types42
{
	typedef T1 Head;
	typedef Types41<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
					T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
					T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41, T42>
		Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32, typename T33, typename T34, typename T35,
		  typename T36, typename T37, typename T38, typename T39, typename T40,
		  typename T41, typename T42, typename T43>
struct Types43
{
	typedef T1 Head;
	typedef Types42<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
					T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
					T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41, T42,
					T43>
		Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32, typename T33, typename T34, typename T35,
		  typename T36, typename T37, typename T38, typename T39, typename T40,
		  typename T41, typename T42, typename T43, typename T44>
struct Types44
{
	typedef T1 Head;
	typedef Types43<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
					T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
					T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41, T42, T43,
					T44>
		Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32, typename T33, typename T34, typename T35,
		  typename T36, typename T37, typename T38, typename T39, typename T40,
		  typename T41, typename T42, typename T43, typename T44, typename T45>
struct Types45
{
	typedef T1 Head;
	typedef Types44<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
					T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
					T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41, T42, T43,
					T44, T45>
		Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32, typename T33, typename T34, typename T35,
		  typename T36, typename T37, typename T38, typename T39, typename T40,
		  typename T41, typename T42, typename T43, typename T44, typename T45,
		  typename T46>
struct Types46
{
	typedef T1 Head;
	typedef Types45<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
					T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
					T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41, T42, T43,
					T44, T45, T46>
		Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32, typename T33, typename T34, typename T35,
		  typename T36, typename T37, typename T38, typename T39, typename T40,
		  typename T41, typename T42, typename T43, typename T44, typename T45,
		  typename T46, typename T47>
struct Types47
{
	typedef T1 Head;
	typedef Types46<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
					T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
					T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41, T42, T43,
					T44, T45, T46, T47>
		Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32, typename T33, typename T34, typename T35,
		  typename T36, typename T37, typename T38, typename T39, typename T40,
		  typename T41, typename T42, typename T43, typename T44, typename T45,
		  typename T46, typename T47, typename T48>
struct Types48
{
	typedef T1 Head;
	typedef Types47<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
					T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
					T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41, T42, T43,
					T44, T45, T46, T47, T48>
		Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32, typename T33, typename T34, typename T35,
		  typename T36, typename T37, typename T38, typename T39, typename T40,
		  typename T41, typename T42, typename T43, typename T44, typename T45,
		  typename T46, typename T47, typename T48, typename T49>
struct Types49
{
	typedef T1 Head;
	typedef Types48<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
					T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
					T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41, T42, T43,
					T44, T45, T46, T47, T48, T49>
		Tail;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32, typename T33, typename T34, typename T35,
		  typename T36, typename T37, typename T38, typename T39, typename T40,
		  typename T41, typename T42, typename T43, typename T44, typename T45,
		  typename T46, typename T47, typename T48, typename T49, typename T50>
struct Types50
{
	typedef T1 Head;
	typedef Types49<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
					T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
					T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41, T42, T43,
					T44, T45, T46, T47, T48, T49, T50>
		Tail;
};

}  // namespace internal

// We don't want to require the users to write TypesN<...> directly,
// as that would require them to count the length.  Types<...> is much
// easier to write, but generates horrible messages when there is a
// compiler error, as gcc insists on printing out each template
// argument, even if it has the default value (this means Types<int>
// will appear as Types<int, None, None, ..., None> in the compiler
// errors).
//
// Our solution is to combine the best part of the two approaches: a
// user would write Types<T1, ..., TN>, and Google Test will translate
// that to TypesN<T1, ..., TN> internally to make error messages
// readable.  The translation is done by the 'type' member of the
// Types template.
template <typename T1 = internal::None, typename T2 = internal::None,
		  typename T3 = internal::None, typename T4 = internal::None,
		  typename T5 = internal::None, typename T6 = internal::None,
		  typename T7 = internal::None, typename T8 = internal::None,
		  typename T9 = internal::None, typename T10 = internal::None,
		  typename T11 = internal::None, typename T12 = internal::None,
		  typename T13 = internal::None, typename T14 = internal::None,
		  typename T15 = internal::None, typename T16 = internal::None,
		  typename T17 = internal::None, typename T18 = internal::None,
		  typename T19 = internal::None, typename T20 = internal::None,
		  typename T21 = internal::None, typename T22 = internal::None,
		  typename T23 = internal::None, typename T24 = internal::None,
		  typename T25 = internal::None, typename T26 = internal::None,
		  typename T27 = internal::None, typename T28 = internal::None,
		  typename T29 = internal::None, typename T30 = internal::None,
		  typename T31 = internal::None, typename T32 = internal::None,
		  typename T33 = internal::None, typename T34 = internal::None,
		  typename T35 = internal::None, typename T36 = internal::None,
		  typename T37 = internal::None, typename T38 = internal::None,
		  typename T39 = internal::None, typename T40 = internal::None,
		  typename T41 = internal::None, typename T42 = internal::None,
		  typename T43 = internal::None, typename T44 = internal::None,
		  typename T45 = internal::None, typename T46 = internal::None,
		  typename T47 = internal::None, typename T48 = internal::None,
		  typename T49 = internal::None, typename T50 = internal::None>
struct Types
{
	typedef internal::Types50<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26,
							  T27, T28, T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40,
							  T41, T42, T43, T44, T45, T46, T47, T48, T49, T50>
		type;
};

template <>
struct Types<internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None>
{
	typedef internal::Types0 type;
};
template <typename T1>
struct Types<T1, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None>
{
	typedef internal::Types1<T1> type;
};
template <typename T1, typename T2>
struct Types<T1, T2, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None>
{
	typedef internal::Types2<T1, T2> type;
};
template <typename T1, typename T2, typename T3>
struct Types<T1, T2, T3, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None>
{
	typedef internal::Types3<T1, T2, T3> type;
};
template <typename T1, typename T2, typename T3, typename T4>
struct Types<T1, T2, T3, T4, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None>
{
	typedef internal::Types4<T1, T2, T3, T4> type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5>
struct Types<T1, T2, T3, T4, T5, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None>
{
	typedef internal::Types5<T1, T2, T3, T4, T5> type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6>
struct Types<T1, T2, T3, T4, T5, T6, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None>
{
	typedef internal::Types6<T1, T2, T3, T4, T5, T6> type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7>
struct Types<T1, T2, T3, T4, T5, T6, T7, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None>
{
	typedef internal::Types7<T1, T2, T3, T4, T5, T6, T7> type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None>
{
	typedef internal::Types8<T1, T2, T3, T4, T5, T6, T7, T8> type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None>
{
	typedef internal::Types9<T1, T2, T3, T4, T5, T6, T7, T8, T9> type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None>
{
	typedef internal::Types10<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None>
{
	typedef internal::Types11<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None>
{
	typedef internal::Types12<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11,
							  T12>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None>
{
	typedef internal::Types13<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None>
{
	typedef internal::Types14<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None>
{
	typedef internal::Types15<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14, T15>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
			 T16, internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None>
{
	typedef internal::Types16<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14, T15, T16>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
			 T16, T17, internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None>
{
	typedef internal::Types17<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14, T15, T16, T17>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
			 T16, T17, T18, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None>
{
	typedef internal::Types18<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14, T15, T16, T17, T18>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
			 T16, T17, T18, T19, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None>
{
	typedef internal::Types19<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14, T15, T16, T17, T18, T19>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
			 T16, T17, T18, T19, T20, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None>
{
	typedef internal::Types20<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14, T15, T16, T17, T18, T19, T20>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
			 T16, T17, T18, T19, T20, T21, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None>
{
	typedef internal::Types21<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14, T15, T16, T17, T18, T19, T20, T21>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
			 T16, T17, T18, T19, T20, T21, T22, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None>
{
	typedef internal::Types22<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14, T15, T16, T17, T18, T19, T20, T21, T22>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
			 T16, T17, T18, T19, T20, T21, T22, T23, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None>
{
	typedef internal::Types23<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
			 T16, T17, T18, T19, T20, T21, T22, T23, T24, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None>
{
	typedef internal::Types24<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
			 T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None>
{
	typedef internal::Types25<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
			 T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None>
{
	typedef internal::Types26<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25,
							  T26>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
			 T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None>
{
	typedef internal::Types27<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26,
							  T27>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
			 T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None>
{
	typedef internal::Types28<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26,
							  T27, T28>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
			 T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None>
{
	typedef internal::Types29<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26,
							  T27, T28, T29>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
			 T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29, T30,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None>
{
	typedef internal::Types30<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26,
							  T27, T28, T29, T30>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
			 T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29, T30,
			 T31, internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None>
{
	typedef internal::Types31<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26,
							  T27, T28, T29, T30, T31>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
			 T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29, T30,
			 T31, T32, internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None>
{
	typedef internal::Types32<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26,
							  T27, T28, T29, T30, T31, T32>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32, typename T33>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
			 T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29, T30,
			 T31, T32, T33, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None>
{
	typedef internal::Types33<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26,
							  T27, T28, T29, T30, T31, T32, T33>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32, typename T33, typename T34>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
			 T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29, T30,
			 T31, T32, T33, T34, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None>
{
	typedef internal::Types34<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26,
							  T27, T28, T29, T30, T31, T32, T33, T34>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32, typename T33, typename T34, typename T35>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
			 T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29, T30,
			 T31, T32, T33, T34, T35, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None>
{
	typedef internal::Types35<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26,
							  T27, T28, T29, T30, T31, T32, T33, T34, T35>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32, typename T33, typename T34, typename T35,
		  typename T36>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
			 T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29, T30,
			 T31, T32, T33, T34, T35, T36, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None>
{
	typedef internal::Types36<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26,
							  T27, T28, T29, T30, T31, T32, T33, T34, T35, T36>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32, typename T33, typename T34, typename T35,
		  typename T36, typename T37>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
			 T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29, T30,
			 T31, T32, T33, T34, T35, T36, T37, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None>
{
	typedef internal::Types37<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26,
							  T27, T28, T29, T30, T31, T32, T33, T34, T35, T36, T37>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32, typename T33, typename T34, typename T35,
		  typename T36, typename T37, typename T38>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
			 T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29, T30,
			 T31, T32, T33, T34, T35, T36, T37, T38, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None>
{
	typedef internal::Types38<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26,
							  T27, T28, T29, T30, T31, T32, T33, T34, T35, T36, T37, T38>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32, typename T33, typename T34, typename T35,
		  typename T36, typename T37, typename T38, typename T39>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
			 T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29, T30,
			 T31, T32, T33, T34, T35, T36, T37, T38, T39, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None>
{
	typedef internal::Types39<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26,
							  T27, T28, T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32, typename T33, typename T34, typename T35,
		  typename T36, typename T37, typename T38, typename T39, typename T40>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
			 T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29, T30,
			 T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None>
{
	typedef internal::Types40<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26,
							  T27, T28, T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39,
							  T40>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32, typename T33, typename T34, typename T35,
		  typename T36, typename T37, typename T38, typename T39, typename T40,
		  typename T41>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
			 T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29, T30,
			 T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None, internal::None>
{
	typedef internal::Types41<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26,
							  T27, T28, T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40,
							  T41>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32, typename T33, typename T34, typename T35,
		  typename T36, typename T37, typename T38, typename T39, typename T40,
		  typename T41, typename T42>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
			 T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29, T30,
			 T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41, T42, internal::None,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None>
{
	typedef internal::Types42<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26,
							  T27, T28, T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40,
							  T41, T42>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32, typename T33, typename T34, typename T35,
		  typename T36, typename T37, typename T38, typename T39, typename T40,
		  typename T41, typename T42, typename T43>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
			 T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29, T30,
			 T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41, T42, T43,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None, internal::None>
{
	typedef internal::Types43<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26,
							  T27, T28, T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40,
							  T41, T42, T43>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32, typename T33, typename T34, typename T35,
		  typename T36, typename T37, typename T38, typename T39, typename T40,
		  typename T41, typename T42, typename T43, typename T44>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
			 T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29, T30,
			 T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41, T42, T43, T44,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None, internal::None>
{
	typedef internal::Types44<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26,
							  T27, T28, T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40,
							  T41, T42, T43, T44>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32, typename T33, typename T34, typename T35,
		  typename T36, typename T37, typename T38, typename T39, typename T40,
		  typename T41, typename T42, typename T43, typename T44, typename T45>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
			 T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29, T30,
			 T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41, T42, T43, T44, T45,
			 internal::None, internal::None, internal::None, internal::None,
			 internal::None>
{
	typedef internal::Types45<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26,
							  T27, T28, T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40,
							  T41, T42, T43, T44, T45>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32, typename T33, typename T34, typename T35,
		  typename T36, typename T37, typename T38, typename T39, typename T40,
		  typename T41, typename T42, typename T43, typename T44, typename T45,
		  typename T46>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
			 T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29, T30,
			 T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41, T42, T43, T44, T45,
			 T46, internal::None, internal::None, internal::None, internal::None>
{
	typedef internal::Types46<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26,
							  T27, T28, T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40,
							  T41, T42, T43, T44, T45, T46>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32, typename T33, typename T34, typename T35,
		  typename T36, typename T37, typename T38, typename T39, typename T40,
		  typename T41, typename T42, typename T43, typename T44, typename T45,
		  typename T46, typename T47>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
			 T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29, T30,
			 T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41, T42, T43, T44, T45,
			 T46, T47, internal::None, internal::None, internal::None>
{
	typedef internal::Types47<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26,
							  T27, T28, T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40,
							  T41, T42, T43, T44, T45, T46, T47>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32, typename T33, typename T34, typename T35,
		  typename T36, typename T37, typename T38, typename T39, typename T40,
		  typename T41, typename T42, typename T43, typename T44, typename T45,
		  typename T46, typename T47, typename T48>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
			 T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29, T30,
			 T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41, T42, T43, T44, T45,
			 T46, T47, T48, internal::None, internal::None>
{
	typedef internal::Types48<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26,
							  T27, T28, T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40,
							  T41, T42, T43, T44, T45, T46, T47, T48>
		type;
};
template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32, typename T33, typename T34, typename T35,
		  typename T36, typename T37, typename T38, typename T39, typename T40,
		  typename T41, typename T42, typename T43, typename T44, typename T45,
		  typename T46, typename T47, typename T48, typename T49>
struct Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,
			 T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29, T30,
			 T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41, T42, T43, T44, T45,
			 T46, T47, T48, T49, internal::None>
{
	typedef internal::Types49<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
							  T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26,
							  T27, T28, T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40,
							  T41, T42, T43, T44, T45, T46, T47, T48, T49>
		type;
};

namespace internal
{
#define GTEST_TEMPLATE_ template <typename T> \
class

// The template "selector" struct TemplateSel<Tmpl> is used to
// represent Tmpl, which must be a class template with one type
// parameter, as a type.  TemplateSel<Tmpl>::Bind<T>::type is defined
// as the type Tmpl<T>.  This allows us to actually instantiate the
// template "selected" by TemplateSel<Tmpl>.
//
// This trick is necessary for simulating typedef for class templates,
// which C++ doesn't support directly.
template <GTEST_TEMPLATE_ Tmpl>
struct TemplateSel
{
	template <typename T>
	struct Bind
	{
		typedef Tmpl<T> type;
	};
};

#define GTEST_BIND_(TmplSel, T) \
	TmplSel::template Bind<T>::type

// A unique struct template used as the default value for the
// arguments of class template Templates.  This allows us to simulate
// variadic templates (e.g. Templates<int>, Templates<int, double>,
// and etc), which C++ doesn't support directly.
template <typename T>
struct NoneT
{
};

// The following family of struct and struct templates are used to
// represent template lists.  In particular, TemplatesN<T1, T2, ...,
// TN> represents a list of N templates (T1, T2, ..., and TN).  Except
// for Templates0, every struct in the family has two member types:
// Head for the selector of the first template in the list, and Tail
// for the rest of the list.

// The empty template list.
struct Templates0
{
};

// Template lists of length 1, 2, 3, and so on.

template <GTEST_TEMPLATE_ T1>
struct Templates1
{
	typedef TemplateSel<T1> Head;
	typedef Templates0 Tail;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2>
struct Templates2
{
	typedef TemplateSel<T1> Head;
	typedef Templates1<T2> Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3>
struct Templates3
{
	typedef TemplateSel<T1> Head;
	typedef Templates2<T2, T3> Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4>
struct Templates4
{
	typedef TemplateSel<T1> Head;
	typedef Templates3<T2, T3, T4> Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5>
struct Templates5
{
	typedef TemplateSel<T1> Head;
	typedef Templates4<T2, T3, T4, T5> Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6>
struct Templates6
{
	typedef TemplateSel<T1> Head;
	typedef Templates5<T2, T3, T4, T5, T6> Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7>
struct Templates7
{
	typedef TemplateSel<T1> Head;
	typedef Templates6<T2, T3, T4, T5, T6, T7> Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8>
struct Templates8
{
	typedef TemplateSel<T1> Head;
	typedef Templates7<T2, T3, T4, T5, T6, T7, T8> Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9>
struct Templates9
{
	typedef TemplateSel<T1> Head;
	typedef Templates8<T2, T3, T4, T5, T6, T7, T8, T9> Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10>
struct Templates10
{
	typedef TemplateSel<T1> Head;
	typedef Templates9<T2, T3, T4, T5, T6, T7, T8, T9, T10> Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11>
struct Templates11
{
	typedef TemplateSel<T1> Head;
	typedef Templates10<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12>
struct Templates12
{
	typedef TemplateSel<T1> Head;
	typedef Templates11<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13>
struct Templates13
{
	typedef TemplateSel<T1> Head;
	typedef Templates12<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14>
struct Templates14
{
	typedef TemplateSel<T1> Head;
	typedef Templates13<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14>
		Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15>
struct Templates15
{
	typedef TemplateSel<T1> Head;
	typedef Templates14<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
						T15>
		Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16>
struct Templates16
{
	typedef TemplateSel<T1> Head;
	typedef Templates15<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
						T15, T16>
		Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17>
struct Templates17
{
	typedef TemplateSel<T1> Head;
	typedef Templates16<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
						T15, T16, T17>
		Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18>
struct Templates18
{
	typedef TemplateSel<T1> Head;
	typedef Templates17<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
						T15, T16, T17, T18>
		Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19>
struct Templates19
{
	typedef TemplateSel<T1> Head;
	typedef Templates18<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
						T15, T16, T17, T18, T19>
		Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20>
struct Templates20
{
	typedef TemplateSel<T1> Head;
	typedef Templates19<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
						T15, T16, T17, T18, T19, T20>
		Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21>
struct Templates21
{
	typedef TemplateSel<T1> Head;
	typedef Templates20<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
						T15, T16, T17, T18, T19, T20, T21>
		Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22>
struct Templates22
{
	typedef TemplateSel<T1> Head;
	typedef Templates21<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
						T15, T16, T17, T18, T19, T20, T21, T22>
		Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23>
struct Templates23
{
	typedef TemplateSel<T1> Head;
	typedef Templates22<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
						T15, T16, T17, T18, T19, T20, T21, T22, T23>
		Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24>
struct Templates24
{
	typedef TemplateSel<T1> Head;
	typedef Templates23<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
						T15, T16, T17, T18, T19, T20, T21, T22, T23, T24>
		Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25>
struct Templates25
{
	typedef TemplateSel<T1> Head;
	typedef Templates24<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
						T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25>
		Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26>
struct Templates26
{
	typedef TemplateSel<T1> Head;
	typedef Templates25<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
						T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26>
		Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27>
struct Templates27
{
	typedef TemplateSel<T1> Head;
	typedef Templates26<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
						T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27>
		Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28>
struct Templates28
{
	typedef TemplateSel<T1> Head;
	typedef Templates27<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
						T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27,
						T28>
		Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29>
struct Templates29
{
	typedef TemplateSel<T1> Head;
	typedef Templates28<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
						T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28,
						T29>
		Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30>
struct Templates30
{
	typedef TemplateSel<T1> Head;
	typedef Templates29<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
						T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28,
						T29, T30>
		Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31>
struct Templates31
{
	typedef TemplateSel<T1> Head;
	typedef Templates30<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
						T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28,
						T29, T30, T31>
		Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32>
struct Templates32
{
	typedef TemplateSel<T1> Head;
	typedef Templates31<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
						T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28,
						T29, T30, T31, T32>
		Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32, GTEST_TEMPLATE_ T33>
struct Templates33
{
	typedef TemplateSel<T1> Head;
	typedef Templates32<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
						T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28,
						T29, T30, T31, T32, T33>
		Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32, GTEST_TEMPLATE_ T33,
		  GTEST_TEMPLATE_ T34>
struct Templates34
{
	typedef TemplateSel<T1> Head;
	typedef Templates33<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
						T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28,
						T29, T30, T31, T32, T33, T34>
		Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32, GTEST_TEMPLATE_ T33,
		  GTEST_TEMPLATE_ T34, GTEST_TEMPLATE_ T35>
struct Templates35
{
	typedef TemplateSel<T1> Head;
	typedef Templates34<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
						T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28,
						T29, T30, T31, T32, T33, T34, T35>
		Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32, GTEST_TEMPLATE_ T33,
		  GTEST_TEMPLATE_ T34, GTEST_TEMPLATE_ T35, GTEST_TEMPLATE_ T36>
struct Templates36
{
	typedef TemplateSel<T1> Head;
	typedef Templates35<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
						T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28,
						T29, T30, T31, T32, T33, T34, T35, T36>
		Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32, GTEST_TEMPLATE_ T33,
		  GTEST_TEMPLATE_ T34, GTEST_TEMPLATE_ T35, GTEST_TEMPLATE_ T36,
		  GTEST_TEMPLATE_ T37>
struct Templates37
{
	typedef TemplateSel<T1> Head;
	typedef Templates36<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
						T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28,
						T29, T30, T31, T32, T33, T34, T35, T36, T37>
		Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32, GTEST_TEMPLATE_ T33,
		  GTEST_TEMPLATE_ T34, GTEST_TEMPLATE_ T35, GTEST_TEMPLATE_ T36,
		  GTEST_TEMPLATE_ T37, GTEST_TEMPLATE_ T38>
struct Templates38
{
	typedef TemplateSel<T1> Head;
	typedef Templates37<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
						T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28,
						T29, T30, T31, T32, T33, T34, T35, T36, T37, T38>
		Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32, GTEST_TEMPLATE_ T33,
		  GTEST_TEMPLATE_ T34, GTEST_TEMPLATE_ T35, GTEST_TEMPLATE_ T36,
		  GTEST_TEMPLATE_ T37, GTEST_TEMPLATE_ T38, GTEST_TEMPLATE_ T39>
struct Templates39
{
	typedef TemplateSel<T1> Head;
	typedef Templates38<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
						T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28,
						T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39>
		Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32, GTEST_TEMPLATE_ T33,
		  GTEST_TEMPLATE_ T34, GTEST_TEMPLATE_ T35, GTEST_TEMPLATE_ T36,
		  GTEST_TEMPLATE_ T37, GTEST_TEMPLATE_ T38, GTEST_TEMPLATE_ T39,
		  GTEST_TEMPLATE_ T40>
struct Templates40
{
	typedef TemplateSel<T1> Head;
	typedef Templates39<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
						T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28,
						T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40>
		Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32, GTEST_TEMPLATE_ T33,
		  GTEST_TEMPLATE_ T34, GTEST_TEMPLATE_ T35, GTEST_TEMPLATE_ T36,
		  GTEST_TEMPLATE_ T37, GTEST_TEMPLATE_ T38, GTEST_TEMPLATE_ T39,
		  GTEST_TEMPLATE_ T40, GTEST_TEMPLATE_ T41>
struct Templates41
{
	typedef TemplateSel<T1> Head;
	typedef Templates40<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
						T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28,
						T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41>
		Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32, GTEST_TEMPLATE_ T33,
		  GTEST_TEMPLATE_ T34, GTEST_TEMPLATE_ T35, GTEST_TEMPLATE_ T36,
		  GTEST_TEMPLATE_ T37, GTEST_TEMPLATE_ T38, GTEST_TEMPLATE_ T39,
		  GTEST_TEMPLATE_ T40, GTEST_TEMPLATE_ T41, GTEST_TEMPLATE_ T42>
struct Templates42
{
	typedef TemplateSel<T1> Head;
	typedef Templates41<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
						T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28,
						T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41,
						T42>
		Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32, GTEST_TEMPLATE_ T33,
		  GTEST_TEMPLATE_ T34, GTEST_TEMPLATE_ T35, GTEST_TEMPLATE_ T36,
		  GTEST_TEMPLATE_ T37, GTEST_TEMPLATE_ T38, GTEST_TEMPLATE_ T39,
		  GTEST_TEMPLATE_ T40, GTEST_TEMPLATE_ T41, GTEST_TEMPLATE_ T42,
		  GTEST_TEMPLATE_ T43>
struct Templates43
{
	typedef TemplateSel<T1> Head;
	typedef Templates42<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
						T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28,
						T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41, T42,
						T43>
		Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32, GTEST_TEMPLATE_ T33,
		  GTEST_TEMPLATE_ T34, GTEST_TEMPLATE_ T35, GTEST_TEMPLATE_ T36,
		  GTEST_TEMPLATE_ T37, GTEST_TEMPLATE_ T38, GTEST_TEMPLATE_ T39,
		  GTEST_TEMPLATE_ T40, GTEST_TEMPLATE_ T41, GTEST_TEMPLATE_ T42,
		  GTEST_TEMPLATE_ T43, GTEST_TEMPLATE_ T44>
struct Templates44
{
	typedef TemplateSel<T1> Head;
	typedef Templates43<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
						T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28,
						T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41, T42,
						T43, T44>
		Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32, GTEST_TEMPLATE_ T33,
		  GTEST_TEMPLATE_ T34, GTEST_TEMPLATE_ T35, GTEST_TEMPLATE_ T36,
		  GTEST_TEMPLATE_ T37, GTEST_TEMPLATE_ T38, GTEST_TEMPLATE_ T39,
		  GTEST_TEMPLATE_ T40, GTEST_TEMPLATE_ T41, GTEST_TEMPLATE_ T42,
		  GTEST_TEMPLATE_ T43, GTEST_TEMPLATE_ T44, GTEST_TEMPLATE_ T45>
struct Templates45
{
	typedef TemplateSel<T1> Head;
	typedef Templates44<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
						T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28,
						T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41, T42,
						T43, T44, T45>
		Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32, GTEST_TEMPLATE_ T33,
		  GTEST_TEMPLATE_ T34, GTEST_TEMPLATE_ T35, GTEST_TEMPLATE_ T36,
		  GTEST_TEMPLATE_ T37, GTEST_TEMPLATE_ T38, GTEST_TEMPLATE_ T39,
		  GTEST_TEMPLATE_ T40, GTEST_TEMPLATE_ T41, GTEST_TEMPLATE_ T42,
		  GTEST_TEMPLATE_ T43, GTEST_TEMPLATE_ T44, GTEST_TEMPLATE_ T45,
		  GTEST_TEMPLATE_ T46>
struct Templates46
{
	typedef TemplateSel<T1> Head;
	typedef Templates45<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
						T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28,
						T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41, T42,
						T43, T44, T45, T46>
		Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32, GTEST_TEMPLATE_ T33,
		  GTEST_TEMPLATE_ T34, GTEST_TEMPLATE_ T35, GTEST_TEMPLATE_ T36,
		  GTEST_TEMPLATE_ T37, GTEST_TEMPLATE_ T38, GTEST_TEMPLATE_ T39,
		  GTEST_TEMPLATE_ T40, GTEST_TEMPLATE_ T41, GTEST_TEMPLATE_ T42,
		  GTEST_TEMPLATE_ T43, GTEST_TEMPLATE_ T44, GTEST_TEMPLATE_ T45,
		  GTEST_TEMPLATE_ T46, GTEST_TEMPLATE_ T47>
struct Templates47
{
	typedef TemplateSel<T1> Head;
	typedef Templates46<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
						T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28,
						T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41, T42,
						T43, T44, T45, T46, T47>
		Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32, GTEST_TEMPLATE_ T33,
		  GTEST_TEMPLATE_ T34, GTEST_TEMPLATE_ T35, GTEST_TEMPLATE_ T36,
		  GTEST_TEMPLATE_ T37, GTEST_TEMPLATE_ T38, GTEST_TEMPLATE_ T39,
		  GTEST_TEMPLATE_ T40, GTEST_TEMPLATE_ T41, GTEST_TEMPLATE_ T42,
		  GTEST_TEMPLATE_ T43, GTEST_TEMPLATE_ T44, GTEST_TEMPLATE_ T45,
		  GTEST_TEMPLATE_ T46, GTEST_TEMPLATE_ T47, GTEST_TEMPLATE_ T48>
struct Templates48
{
	typedef TemplateSel<T1> Head;
	typedef Templates47<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
						T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28,
						T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41, T42,
						T43, T44, T45, T46, T47, T48>
		Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32, GTEST_TEMPLATE_ T33,
		  GTEST_TEMPLATE_ T34, GTEST_TEMPLATE_ T35, GTEST_TEMPLATE_ T36,
		  GTEST_TEMPLATE_ T37, GTEST_TEMPLATE_ T38, GTEST_TEMPLATE_ T39,
		  GTEST_TEMPLATE_ T40, GTEST_TEMPLATE_ T41, GTEST_TEMPLATE_ T42,
		  GTEST_TEMPLATE_ T43, GTEST_TEMPLATE_ T44, GTEST_TEMPLATE_ T45,
		  GTEST_TEMPLATE_ T46, GTEST_TEMPLATE_ T47, GTEST_TEMPLATE_ T48,
		  GTEST_TEMPLATE_ T49>
struct Templates49
{
	typedef TemplateSel<T1> Head;
	typedef Templates48<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
						T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28,
						T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41, T42,
						T43, T44, T45, T46, T47, T48, T49>
		Tail;
};

template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32, GTEST_TEMPLATE_ T33,
		  GTEST_TEMPLATE_ T34, GTEST_TEMPLATE_ T35, GTEST_TEMPLATE_ T36,
		  GTEST_TEMPLATE_ T37, GTEST_TEMPLATE_ T38, GTEST_TEMPLATE_ T39,
		  GTEST_TEMPLATE_ T40, GTEST_TEMPLATE_ T41, GTEST_TEMPLATE_ T42,
		  GTEST_TEMPLATE_ T43, GTEST_TEMPLATE_ T44, GTEST_TEMPLATE_ T45,
		  GTEST_TEMPLATE_ T46, GTEST_TEMPLATE_ T47, GTEST_TEMPLATE_ T48,
		  GTEST_TEMPLATE_ T49, GTEST_TEMPLATE_ T50>
struct Templates50
{
	typedef TemplateSel<T1> Head;
	typedef Templates49<T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
						T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28,
						T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41, T42,
						T43, T44, T45, T46, T47, T48, T49, T50>
		Tail;
};

// We don't want to require the users to write TemplatesN<...> directly,
// as that would require them to count the length.  Templates<...> is much
// easier to write, but generates horrible messages when there is a
// compiler error, as gcc insists on printing out each template
// argument, even if it has the default value (this means Templates<list>
// will appear as Templates<list, NoneT, NoneT, ..., NoneT> in the compiler
// errors).
//
// Our solution is to combine the best part of the two approaches: a
// user would write Templates<T1, ..., TN>, and Google Test will translate
// that to TemplatesN<T1, ..., TN> internally to make error messages
// readable.  The translation is done by the 'type' member of the
// Templates template.
template <GTEST_TEMPLATE_ T1 = NoneT, GTEST_TEMPLATE_ T2 = NoneT,
		  GTEST_TEMPLATE_ T3 = NoneT, GTEST_TEMPLATE_ T4 = NoneT,
		  GTEST_TEMPLATE_ T5 = NoneT, GTEST_TEMPLATE_ T6 = NoneT,
		  GTEST_TEMPLATE_ T7 = NoneT, GTEST_TEMPLATE_ T8 = NoneT,
		  GTEST_TEMPLATE_ T9 = NoneT, GTEST_TEMPLATE_ T10 = NoneT,
		  GTEST_TEMPLATE_ T11 = NoneT, GTEST_TEMPLATE_ T12 = NoneT,
		  GTEST_TEMPLATE_ T13 = NoneT, GTEST_TEMPLATE_ T14 = NoneT,
		  GTEST_TEMPLATE_ T15 = NoneT, GTEST_TEMPLATE_ T16 = NoneT,
		  GTEST_TEMPLATE_ T17 = NoneT, GTEST_TEMPLATE_ T18 = NoneT,
		  GTEST_TEMPLATE_ T19 = NoneT, GTEST_TEMPLATE_ T20 = NoneT,
		  GTEST_TEMPLATE_ T21 = NoneT, GTEST_TEMPLATE_ T22 = NoneT,
		  GTEST_TEMPLATE_ T23 = NoneT, GTEST_TEMPLATE_ T24 = NoneT,
		  GTEST_TEMPLATE_ T25 = NoneT, GTEST_TEMPLATE_ T26 = NoneT,
		  GTEST_TEMPLATE_ T27 = NoneT, GTEST_TEMPLATE_ T28 = NoneT,
		  GTEST_TEMPLATE_ T29 = NoneT, GTEST_TEMPLATE_ T30 = NoneT,
		  GTEST_TEMPLATE_ T31 = NoneT, GTEST_TEMPLATE_ T32 = NoneT,
		  GTEST_TEMPLATE_ T33 = NoneT, GTEST_TEMPLATE_ T34 = NoneT,
		  GTEST_TEMPLATE_ T35 = NoneT, GTEST_TEMPLATE_ T36 = NoneT,
		  GTEST_TEMPLATE_ T37 = NoneT, GTEST_TEMPLATE_ T38 = NoneT,
		  GTEST_TEMPLATE_ T39 = NoneT, GTEST_TEMPLATE_ T40 = NoneT,
		  GTEST_TEMPLATE_ T41 = NoneT, GTEST_TEMPLATE_ T42 = NoneT,
		  GTEST_TEMPLATE_ T43 = NoneT, GTEST_TEMPLATE_ T44 = NoneT,
		  GTEST_TEMPLATE_ T45 = NoneT, GTEST_TEMPLATE_ T46 = NoneT,
		  GTEST_TEMPLATE_ T47 = NoneT, GTEST_TEMPLATE_ T48 = NoneT,
		  GTEST_TEMPLATE_ T49 = NoneT, GTEST_TEMPLATE_ T50 = NoneT>
struct Templates
{
	typedef Templates50<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27,
						T28, T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41,
						T42, T43, T44, T45, T46, T47, T48, T49, T50>
		type;
};

template <>
struct Templates<NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT>
{
	typedef Templates0 type;
};
template <GTEST_TEMPLATE_ T1>
struct Templates<T1, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT>
{
	typedef Templates1<T1> type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2>
struct Templates<T1, T2, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT>
{
	typedef Templates2<T1, T2> type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3>
struct Templates<T1, T2, T3, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT>
{
	typedef Templates3<T1, T2, T3> type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4>
struct Templates<T1, T2, T3, T4, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT>
{
	typedef Templates4<T1, T2, T3, T4> type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5>
struct Templates<T1, T2, T3, T4, T5, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT>
{
	typedef Templates5<T1, T2, T3, T4, T5> type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6>
struct Templates<T1, T2, T3, T4, T5, T6, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT>
{
	typedef Templates6<T1, T2, T3, T4, T5, T6> type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7>
struct Templates<T1, T2, T3, T4, T5, T6, T7, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT>
{
	typedef Templates7<T1, T2, T3, T4, T5, T6, T7> type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT>
{
	typedef Templates8<T1, T2, T3, T4, T5, T6, T7, T8> type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT>
{
	typedef Templates9<T1, T2, T3, T4, T5, T6, T7, T8, T9> type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT>
{
	typedef Templates10<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT>
{
	typedef Templates11<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT>
{
	typedef Templates12<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT>
{
	typedef Templates13<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
						T13>
		type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT>
{
	typedef Templates14<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14>
		type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
				 T15, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT>
{
	typedef Templates15<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14, T15>
		type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
				 T15, T16, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT>
{
	typedef Templates16<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14, T15, T16>
		type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
				 T15, T16, T17, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT>
{
	typedef Templates17<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14, T15, T16, T17>
		type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
				 T15, T16, T17, T18, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT>
{
	typedef Templates18<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14, T15, T16, T17, T18>
		type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
				 T15, T16, T17, T18, T19, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT>
{
	typedef Templates19<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14, T15, T16, T17, T18, T19>
		type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
				 T15, T16, T17, T18, T19, T20, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT>
{
	typedef Templates20<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14, T15, T16, T17, T18, T19, T20>
		type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
				 T15, T16, T17, T18, T19, T20, T21, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT>
{
	typedef Templates21<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14, T15, T16, T17, T18, T19, T20, T21>
		type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
				 T15, T16, T17, T18, T19, T20, T21, T22, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT>
{
	typedef Templates22<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14, T15, T16, T17, T18, T19, T20, T21, T22>
		type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
				 T15, T16, T17, T18, T19, T20, T21, T22, T23, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT>
{
	typedef Templates23<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14, T15, T16, T17, T18, T19, T20, T21, T22, T23>
		type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
				 T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT>
{
	typedef Templates24<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24>
		type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
				 T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT>
{
	typedef Templates25<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25>
		type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
				 T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT>
{
	typedef Templates26<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26>
		type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
				 T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT>
{
	typedef Templates27<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26,
						T27>
		type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
				 T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT>
{
	typedef Templates28<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27,
						T28>
		type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
				 T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT>
{
	typedef Templates29<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27,
						T28, T29>
		type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
				 T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
				 T30, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT>
{
	typedef Templates30<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27,
						T28, T29, T30>
		type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
				 T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
				 T30, T31, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT>
{
	typedef Templates31<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27,
						T28, T29, T30, T31>
		type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
				 T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
				 T30, T31, T32, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT>
{
	typedef Templates32<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27,
						T28, T29, T30, T31, T32>
		type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32, GTEST_TEMPLATE_ T33>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
				 T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
				 T30, T31, T32, T33, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT>
{
	typedef Templates33<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27,
						T28, T29, T30, T31, T32, T33>
		type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32, GTEST_TEMPLATE_ T33,
		  GTEST_TEMPLATE_ T34>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
				 T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
				 T30, T31, T32, T33, T34, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT>
{
	typedef Templates34<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27,
						T28, T29, T30, T31, T32, T33, T34>
		type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32, GTEST_TEMPLATE_ T33,
		  GTEST_TEMPLATE_ T34, GTEST_TEMPLATE_ T35>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
				 T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
				 T30, T31, T32, T33, T34, T35, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT>
{
	typedef Templates35<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27,
						T28, T29, T30, T31, T32, T33, T34, T35>
		type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32, GTEST_TEMPLATE_ T33,
		  GTEST_TEMPLATE_ T34, GTEST_TEMPLATE_ T35, GTEST_TEMPLATE_ T36>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
				 T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
				 T30, T31, T32, T33, T34, T35, T36, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT>
{
	typedef Templates36<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27,
						T28, T29, T30, T31, T32, T33, T34, T35, T36>
		type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32, GTEST_TEMPLATE_ T33,
		  GTEST_TEMPLATE_ T34, GTEST_TEMPLATE_ T35, GTEST_TEMPLATE_ T36,
		  GTEST_TEMPLATE_ T37>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
				 T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
				 T30, T31, T32, T33, T34, T35, T36, T37, NoneT, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT>
{
	typedef Templates37<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27,
						T28, T29, T30, T31, T32, T33, T34, T35, T36, T37>
		type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32, GTEST_TEMPLATE_ T33,
		  GTEST_TEMPLATE_ T34, GTEST_TEMPLATE_ T35, GTEST_TEMPLATE_ T36,
		  GTEST_TEMPLATE_ T37, GTEST_TEMPLATE_ T38>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
				 T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
				 T30, T31, T32, T33, T34, T35, T36, T37, T38, NoneT, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT>
{
	typedef Templates38<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27,
						T28, T29, T30, T31, T32, T33, T34, T35, T36, T37, T38>
		type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32, GTEST_TEMPLATE_ T33,
		  GTEST_TEMPLATE_ T34, GTEST_TEMPLATE_ T35, GTEST_TEMPLATE_ T36,
		  GTEST_TEMPLATE_ T37, GTEST_TEMPLATE_ T38, GTEST_TEMPLATE_ T39>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
				 T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
				 T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT>
{
	typedef Templates39<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27,
						T28, T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39>
		type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32, GTEST_TEMPLATE_ T33,
		  GTEST_TEMPLATE_ T34, GTEST_TEMPLATE_ T35, GTEST_TEMPLATE_ T36,
		  GTEST_TEMPLATE_ T37, GTEST_TEMPLATE_ T38, GTEST_TEMPLATE_ T39,
		  GTEST_TEMPLATE_ T40>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
				 T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
				 T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, NoneT, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT>
{
	typedef Templates40<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27,
						T28, T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40>
		type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32, GTEST_TEMPLATE_ T33,
		  GTEST_TEMPLATE_ T34, GTEST_TEMPLATE_ T35, GTEST_TEMPLATE_ T36,
		  GTEST_TEMPLATE_ T37, GTEST_TEMPLATE_ T38, GTEST_TEMPLATE_ T39,
		  GTEST_TEMPLATE_ T40, GTEST_TEMPLATE_ T41>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
				 T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
				 T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41, NoneT, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT>
{
	typedef Templates41<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27,
						T28, T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40,
						T41>
		type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32, GTEST_TEMPLATE_ T33,
		  GTEST_TEMPLATE_ T34, GTEST_TEMPLATE_ T35, GTEST_TEMPLATE_ T36,
		  GTEST_TEMPLATE_ T37, GTEST_TEMPLATE_ T38, GTEST_TEMPLATE_ T39,
		  GTEST_TEMPLATE_ T40, GTEST_TEMPLATE_ T41, GTEST_TEMPLATE_ T42>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
				 T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
				 T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41, T42, NoneT,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT>
{
	typedef Templates42<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27,
						T28, T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41,
						T42>
		type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32, GTEST_TEMPLATE_ T33,
		  GTEST_TEMPLATE_ T34, GTEST_TEMPLATE_ T35, GTEST_TEMPLATE_ T36,
		  GTEST_TEMPLATE_ T37, GTEST_TEMPLATE_ T38, GTEST_TEMPLATE_ T39,
		  GTEST_TEMPLATE_ T40, GTEST_TEMPLATE_ T41, GTEST_TEMPLATE_ T42,
		  GTEST_TEMPLATE_ T43>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
				 T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
				 T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41, T42, T43,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT, NoneT>
{
	typedef Templates43<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27,
						T28, T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41,
						T42, T43>
		type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32, GTEST_TEMPLATE_ T33,
		  GTEST_TEMPLATE_ T34, GTEST_TEMPLATE_ T35, GTEST_TEMPLATE_ T36,
		  GTEST_TEMPLATE_ T37, GTEST_TEMPLATE_ T38, GTEST_TEMPLATE_ T39,
		  GTEST_TEMPLATE_ T40, GTEST_TEMPLATE_ T41, GTEST_TEMPLATE_ T42,
		  GTEST_TEMPLATE_ T43, GTEST_TEMPLATE_ T44>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
				 T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
				 T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41, T42, T43, T44,
				 NoneT, NoneT, NoneT, NoneT, NoneT, NoneT>
{
	typedef Templates44<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27,
						T28, T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41,
						T42, T43, T44>
		type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32, GTEST_TEMPLATE_ T33,
		  GTEST_TEMPLATE_ T34, GTEST_TEMPLATE_ T35, GTEST_TEMPLATE_ T36,
		  GTEST_TEMPLATE_ T37, GTEST_TEMPLATE_ T38, GTEST_TEMPLATE_ T39,
		  GTEST_TEMPLATE_ T40, GTEST_TEMPLATE_ T41, GTEST_TEMPLATE_ T42,
		  GTEST_TEMPLATE_ T43, GTEST_TEMPLATE_ T44, GTEST_TEMPLATE_ T45>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
				 T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
				 T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41, T42, T43, T44,
				 T45, NoneT, NoneT, NoneT, NoneT, NoneT>
{
	typedef Templates45<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27,
						T28, T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41,
						T42, T43, T44, T45>
		type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32, GTEST_TEMPLATE_ T33,
		  GTEST_TEMPLATE_ T34, GTEST_TEMPLATE_ T35, GTEST_TEMPLATE_ T36,
		  GTEST_TEMPLATE_ T37, GTEST_TEMPLATE_ T38, GTEST_TEMPLATE_ T39,
		  GTEST_TEMPLATE_ T40, GTEST_TEMPLATE_ T41, GTEST_TEMPLATE_ T42,
		  GTEST_TEMPLATE_ T43, GTEST_TEMPLATE_ T44, GTEST_TEMPLATE_ T45,
		  GTEST_TEMPLATE_ T46>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
				 T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
				 T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41, T42, T43, T44,
				 T45, T46, NoneT, NoneT, NoneT, NoneT>
{
	typedef Templates46<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27,
						T28, T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41,
						T42, T43, T44, T45, T46>
		type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32, GTEST_TEMPLATE_ T33,
		  GTEST_TEMPLATE_ T34, GTEST_TEMPLATE_ T35, GTEST_TEMPLATE_ T36,
		  GTEST_TEMPLATE_ T37, GTEST_TEMPLATE_ T38, GTEST_TEMPLATE_ T39,
		  GTEST_TEMPLATE_ T40, GTEST_TEMPLATE_ T41, GTEST_TEMPLATE_ T42,
		  GTEST_TEMPLATE_ T43, GTEST_TEMPLATE_ T44, GTEST_TEMPLATE_ T45,
		  GTEST_TEMPLATE_ T46, GTEST_TEMPLATE_ T47>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
				 T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
				 T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41, T42, T43, T44,
				 T45, T46, T47, NoneT, NoneT, NoneT>
{
	typedef Templates47<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27,
						T28, T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41,
						T42, T43, T44, T45, T46, T47>
		type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32, GTEST_TEMPLATE_ T33,
		  GTEST_TEMPLATE_ T34, GTEST_TEMPLATE_ T35, GTEST_TEMPLATE_ T36,
		  GTEST_TEMPLATE_ T37, GTEST_TEMPLATE_ T38, GTEST_TEMPLATE_ T39,
		  GTEST_TEMPLATE_ T40, GTEST_TEMPLATE_ T41, GTEST_TEMPLATE_ T42,
		  GTEST_TEMPLATE_ T43, GTEST_TEMPLATE_ T44, GTEST_TEMPLATE_ T45,
		  GTEST_TEMPLATE_ T46, GTEST_TEMPLATE_ T47, GTEST_TEMPLATE_ T48>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
				 T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
				 T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41, T42, T43, T44,
				 T45, T46, T47, T48, NoneT, NoneT>
{
	typedef Templates48<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27,
						T28, T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41,
						T42, T43, T44, T45, T46, T47, T48>
		type;
};
template <GTEST_TEMPLATE_ T1, GTEST_TEMPLATE_ T2, GTEST_TEMPLATE_ T3,
		  GTEST_TEMPLATE_ T4, GTEST_TEMPLATE_ T5, GTEST_TEMPLATE_ T6,
		  GTEST_TEMPLATE_ T7, GTEST_TEMPLATE_ T8, GTEST_TEMPLATE_ T9,
		  GTEST_TEMPLATE_ T10, GTEST_TEMPLATE_ T11, GTEST_TEMPLATE_ T12,
		  GTEST_TEMPLATE_ T13, GTEST_TEMPLATE_ T14, GTEST_TEMPLATE_ T15,
		  GTEST_TEMPLATE_ T16, GTEST_TEMPLATE_ T17, GTEST_TEMPLATE_ T18,
		  GTEST_TEMPLATE_ T19, GTEST_TEMPLATE_ T20, GTEST_TEMPLATE_ T21,
		  GTEST_TEMPLATE_ T22, GTEST_TEMPLATE_ T23, GTEST_TEMPLATE_ T24,
		  GTEST_TEMPLATE_ T25, GTEST_TEMPLATE_ T26, GTEST_TEMPLATE_ T27,
		  GTEST_TEMPLATE_ T28, GTEST_TEMPLATE_ T29, GTEST_TEMPLATE_ T30,
		  GTEST_TEMPLATE_ T31, GTEST_TEMPLATE_ T32, GTEST_TEMPLATE_ T33,
		  GTEST_TEMPLATE_ T34, GTEST_TEMPLATE_ T35, GTEST_TEMPLATE_ T36,
		  GTEST_TEMPLATE_ T37, GTEST_TEMPLATE_ T38, GTEST_TEMPLATE_ T39,
		  GTEST_TEMPLATE_ T40, GTEST_TEMPLATE_ T41, GTEST_TEMPLATE_ T42,
		  GTEST_TEMPLATE_ T43, GTEST_TEMPLATE_ T44, GTEST_TEMPLATE_ T45,
		  GTEST_TEMPLATE_ T46, GTEST_TEMPLATE_ T47, GTEST_TEMPLATE_ T48,
		  GTEST_TEMPLATE_ T49>
struct Templates<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,
				 T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28, T29,
				 T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41, T42, T43, T44,
				 T45, T46, T47, T48, T49, NoneT>
{
	typedef Templates49<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
						T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27,
						T28, T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41,
						T42, T43, T44, T45, T46, T47, T48, T49>
		type;
};

// The TypeList template makes it possible to use either a single type
// or a Types<...> list in TYPED_TEST_CASE() and
// INSTANTIATE_TYPED_TEST_CASE_P().

template <typename T>
struct TypeList
{
	typedef Types1<T> type;
};

template <typename T1, typename T2, typename T3, typename T4, typename T5,
		  typename T6, typename T7, typename T8, typename T9, typename T10,
		  typename T11, typename T12, typename T13, typename T14, typename T15,
		  typename T16, typename T17, typename T18, typename T19, typename T20,
		  typename T21, typename T22, typename T23, typename T24, typename T25,
		  typename T26, typename T27, typename T28, typename T29, typename T30,
		  typename T31, typename T32, typename T33, typename T34, typename T35,
		  typename T36, typename T37, typename T38, typename T39, typename T40,
		  typename T41, typename T42, typename T43, typename T44, typename T45,
		  typename T46, typename T47, typename T48, typename T49, typename T50>
struct TypeList<Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,
					  T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26, T27, T28,
					  T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40, T41, T42, T43,
					  T44, T45, T46, T47, T48, T49, T50> >
{
	typedef typename Types<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,
						   T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, T23, T24, T25, T26,
						   T27, T28, T29, T30, T31, T32, T33, T34, T35, T36, T37, T38, T39, T40,
						   T41, T42, T43, T44, T45, T46, T47, T48, T49, T50>::type type;
};

#endif  // GTEST_HAS_TYPED_TEST || GTEST_HAS_TYPED_TEST_P

}  // namespace internal
}  // namespace testing

#endif  // GTEST_INCLUDE_GTEST_INTERNAL_GTEST_TYPE_UTIL_H_
