package com.kreative.keyedit;

public enum WinLocale {
	AA            (0x1000, "aa",             "Afar"),
	AA_DJ         (0x1000, "aa-DJ",          "Afar (Djibouti)"),
	AA_ER         (0x1000, "aa-ER",          "Afar (Eritrea)"),
	AA_ET         (0x1000, "aa-ET",          "Afar (Ethiopia)"),
	AF            (0x0036, "af",             "Afrikaans"),
	AF_NA         (0x1000, "af-NA",          "Afrikaans (Namibia)"),
	AF_ZA         (0x0436, "af-ZA",          "Afrikaans (South Africa)"),
	AGQ           (0x1000, "agq",            "Aghem"),
	AGQ_CM        (0x1000, "agq-CM",         "Aghem (Cameroon)"),
	AK            (0x1000, "ak",             "Akan"),
	AK_GH         (0x1000, "ak-GH",          "Akan (Ghana)"),
	SQ            (0x001C, "sq",             "Albanian"),
	SQ_AL         (0x041C, "sq-AL",          "Albanian (Albania)"),
	SQ_XK         (0x1000, "sq-XK",          "Albanian (Kosovo)"),
	SQ_MK         (0x1000, "sq-MK",          "Albanian (Macedonia, FYRO)"),
	GSW           (0x0084, "gsw",            "Alsatian"),
	GSW_FR        (0x0484, "gsw-FR",         "Alsatian (France)"),
	GSW_LI        (0x1000, "gsw-LI",         "Alsatian (Liechtenstein)"),
	GSW_CH        (0x1000, "gsw-CH",         "Alsatian (Switzerland)"),
	AM            (0x005E, "am",             "Amharic"),
	AM_ET         (0x045E, "am-ET",          "Amharic (Ethiopia)"),
	AR            (0x0001, "ar",             "Arabic"),
	AR_DZ         (0x1401, "ar-DZ",          "Arabic (Algeria)"),
	AR_BH         (0x3C01, "ar-BH",          "Arabic (Bahrain)"),
	AR_TD         (0x1000, "ar-TD",          "Arabic (Chad)"),
	AR_KM         (0x1000, "ar-KM",          "Arabic (Comoros)"),
	AR_DJ         (0x1000, "ar-DJ",          "Arabic (Djibouti)"),
	AR_EG         (0x0C01, "ar-EG",          "Arabic (Egypt)"),
	AR_ER         (0x1000, "ar-ER",          "Arabic (Eritrea)"),
	AR_IQ         (0x0801, "ar-IQ",          "Arabic (Iraq)"),
	AR_IL         (0x1000, "ar-IL",          "Arabic (Israel)"),
	AR_JO         (0x2C01, "ar-JO",          "Arabic (Jordan)"),
	AR_KW         (0x3401, "ar-KW",          "Arabic (Kuwait)"),
	AR_LB         (0x3001, "ar-LB",          "Arabic (Lebanon)"),
	AR_LY         (0x1001, "ar-LY",          "Arabic (Libya)"),
	AR_MR         (0x1000, "ar-MR",          "Arabic (Mauritania)"),
	AR_MA         (0x1801, "ar-MA",          "Arabic (Morocco)"),
	AR_OM         (0x2001, "ar-OM",          "Arabic (Oman)"),
	AR_PS         (0x1000, "ar-PS",          "Arabic (Palestinian Authority)"),
	AR_QA         (0x4001, "ar-QA",          "Arabic (Qatar)"),
	AR_SA         (0x0401, "ar-SA",          "Arabic (Saudi Arabia)"),
	AR_SO         (0x1000, "ar-SO",          "Arabic (Somalia)"),
	AR_SS         (0x1000, "ar-SS",          "Arabic (South Sudan)"),
	AR_SD         (0x1000, "ar-SD",          "Arabic (Sudan)"),
	AR_SY         (0x2801, "ar-SY",          "Arabic (Syria)"),
	AR_TN         (0x1C01, "ar-TN",          "Arabic (Tunisia)"),
	AR_AE         (0x3801, "ar-AE",          "Arabic (U.A.E.)"),
	AR_001        (0x1000, "ar-001",         "Arabic (World)"),
	AR_YE         (0x2401, "ar-YE",          "Arabic (Yemen)"),
	HY            (0x002B, "hy",             "Armenian"),
	HY_AM         (0x042B, "hy-AM",          "Armenian (Armenia)"),
	AS            (0x004D, "as",             "Assamese"),
	AS_IN         (0x044D, "as-IN",          "Assamese (India)"),
	AST           (0x1000, "ast",            "Asturian"),
	AST_ES        (0x1000, "ast-ES",         "Asturian (Spain)"),
	ASA           (0x1000, "asa",            "Asu"),
	ASA_TZ        (0x1000, "asa-TZ",         "Asu (Tanzania)"),
	AZ            (0x002C, "az",             "Azerbaijani"),
	AZ_CYRL       (0x742C, "az-Cyrl",        "Azerbaijani (Cyrillic)"),
	AZ_CYRL_AZ    (0x082C, "az-Cyrl-AZ",     "Azerbaijani (Cyrillic, Azerbaijan)"),
	AZ_LATN       (0x782C, "az-Latn",        "Azerbaijani (Latin)"),
	AZ_LATN_AZ    (0x042C, "az-Latn-AZ",     "Azerbaijani (Latin, Azerbaijan)"),
	KSF           (0x1000, "ksf",            "Bafia"),
	KSF_CM        (0x1000, "ksf-CM",         "Bafia (Cameroon)"),
	BM            (0x1000, "bm",             "Bambara"),
	BM_LATN       (0x1000, "bm-Latn",        "Bambara (Latin)"),
	BM_LATN_ML    (0x1000, "bm-Latn-ML",     "Bambara (Latin, Mali)"),
	BN            (0x0045, "bn",             "Bangla"),
	BN_BD         (0x0845, "bn-BD",          "Bangla (Bangladesh)"),
	BN_IN         (0x0445, "bn-IN",          "Bangla (India)"),
	BAS           (0x1000, "bas",            "Basaa"),
	BAS_CM        (0x1000, "bas-CM",         "Basaa (Cameroon)"),
	BA            (0x006D, "ba",             "Bashkir"),
	BA_RU         (0x046D, "ba-RU",          "Bashkir (Russia)"),
	EU            (0x002D, "eu",             "Basque"),
	EU_ES         (0x042D, "eu-ES",          "Basque (Basque)"),
	BE            (0x0023, "be",             "Belarusian"),
	BE_BY         (0x0423, "be-BY",          "Belarusian (Belarus)"),
	BEM           (0x1000, "bem",            "Bemba"),
	BEM_ZM        (0x1000, "bem-ZM",         "Bemba (Zambia)"),
	BEZ           (0x1000, "bez",            "Bena"),
	BEZ_TZ        (0x1000, "bez-TZ",         "Bena (Tanzania)"),
	BYN           (0x1000, "byn",            "Blin"),
	BYN_ER        (0x1000, "byn-ER",         "Blin (Eritrea)"),
	BRX           (0x1000, "brx",            "Bodo"),
	BRX_IN        (0x1000, "brx-IN",         "Bodo (India)"),
	BS            (0x781A, "bs",             "Bosnian"),
	BS_CYRL       (0x641A, "bs-Cyrl",        "Bosnian (Cyrillic)"),
	BS_CYRL_BA    (0x201A, "bs-Cyrl-BA",     "Bosnian (Cyrillic, Bosnia and Herzegovina)"),
	BS_LATN       (0x681A, "bs-Latn",        "Bosnian (Latin)"),
	BS_LATN_BA    (0x141A, "bs-Latn-BA",     "Bosnian (Latin, Bosnia and Herzegovina)"),
	BR            (0x007E, "br",             "Breton"),
	BR_FR         (0x047E, "br-FR",          "Breton (France)"),
	BG            (0x0002, "bg",             "Bulgarian"),
	BG_BG         (0x0402, "bg-BG",          "Bulgarian (Bulgaria)"),
	MY            (0x0055, "my",             "Burmese"),
	MY_MM         (0x0455, "my-MM",          "Burmese (Myanmar)"),
	CA            (0x0003, "ca",             "Catalan"),
	CA_AD         (0x1000, "ca-AD",          "Catalan (Andorra)"),
	CA_ES         (0x0403, "ca-ES",          "Catalan (Catalan)"),
	CA_FR         (0x1000, "ca-FR",          "Catalan (France)"),
	CA_IT         (0x1000, "ca-IT",          "Catalan (Italy)"),
	TZM_ARAB      (0x1000, "tzm-Arab",       "Central Atlas Tamazight (Arabic)"),
	TZM_ARAB_MA   (0x045F, "tzm-Arab-MA",    "Central Atlas Tamazight (Arabic, Morocco)"),
	TZM_LATN_MA   (0x1000, "tzm-Latn-MA",    "Central Atlas Tamazight (Latin, Morocco)"),
	TZM_TFNG_MA   (0x105F, "tzm-Tfng-MA",    "Central Atlas Tamazight (Tifinagh, Morocco)"),
	KU            (0x0092, "ku",             "Central Kurdish"),
	KU_ARAB       (0x7C92, "ku-Arab",        "Central Kurdish (Arabic)"),
	KU_ARAB_IQ    (0x0492, "ku-Arab-IQ",     "Central Kurdish (Iraq)"),
	CE            (0x1000, "ce",             "Chechen"),
	CE_RU         (0x1000, "ce-RU",          "Chechen (Russia)"),
	CHR           (0x005C, "chr",            "Cherokee"),
	CHR_CHER      (0x7C5C, "chr-Cher",       "Cherokee (Cherokee)"),
	CHR_CHER_US   (0x045C, "chr-Cher-US",    "Cherokee (Cherokee, United States)"),
	CGG           (0x1000, "cgg",            "Chiga"),
	CGG_UG        (0x1000, "cgg-UG",         "Chiga (Uganda)"),
	ZH            (0x7804, "zh",             "Chinese"),
	ZH_HANS_HK    (0x1000, "zh-Hans-HK",     "Chinese (Simplified Han, Hong Kong SAR)"),
	ZH_HANS_MO    (0x1000, "zh-Hans-MO",     "Chinese (Simplified Han, Macao SAR)"),
	ZH_HANS       (0x0004, "zh-Hans",        "Chinese (Simplified)"),
	ZH_CN         (0x0804, "zh-CN",          "Chinese (Simplified, PRC)"),
	ZH_SG         (0x1004, "zh-SG",          "Chinese (Simplified, Singapore)"),
	ZH_HANT       (0x7C04, "zh-Hant",        "Chinese (Traditional)"),
	ZH_HK         (0x0C04, "zh-HK",          "Chinese (Traditional, Hong Kong S.A.R.)"),
	ZH_MO         (0x1404, "zh-MO",          "Chinese (Traditional, Macao S.A.R.)"),
	ZH_TW         (0x0404, "zh-TW",          "Chinese (Traditional, Taiwan)"),
	CU            (0x1000, "cu",             "Church Slavic"),
	CU_RU         (0x1000, "cu-RU",          "Church Slavic (Russia)"),
	KSH           (0x1000, "ksh",            "Colognian"),
	KW            (0x1000, "kw",             "Cornish"),
	KW_GB         (0x1000, "kw-GB",          "Cornish (United Kingdom)"),
	CO            (0x0083, "co",             "Corsican"),
	CO_FR         (0x0483, "co-FR",          "Corsican (France)"),
	HR            (0x001A, "hr",             "Croatian"),
	HR_HR         (0x041A, "hr-HR",          "Croatian (Croatia)"),
	HR_BA         (0x101A, "hr-BA",          "Croatian (Latin, Bosnia and Herzegovina)"),
	CS            (0x0005, "cs",             "Czech"),
	CS_CZ         (0x0405, "cs-CZ",          "Czech (Czech Republic)"),
	DA            (0x0006, "da",             "Danish"),
	DA_DK         (0x0406, "da-DK",          "Danish (Denmark)"),
	DA_GL         (0x1000, "da-GL",          "Danish (Greenland)"),
	PRS           (0x008C, "prs",            "Dari"),
	PRS_AF        (0x048C, "prs-AF",         "Dari (Afghanistan)"),
	DV            (0x0065, "dv",             "Divehi"),
	DV_MV         (0x0465, "dv-MV",          "Divehi (Maldives)"),
	DUA           (0x1000, "dua",            "Duala"),
	DUA_CM        (0x1000, "dua-CM",         "Duala (Cameroon)"),
	NL            (0x0013, "nl",             "Dutch"),
	NL_AW         (0x1000, "nl-AW",          "Dutch (Aruba)"),
	NL_BE         (0x0813, "nl-BE",          "Dutch (Belgium)"),
	NL_BQ         (0x1000, "nl-BQ",          "Dutch (Bonaire, Sint Eustatius and Saba)"),
	NL_CW         (0x1000, "nl-CW",          "Dutch (Curaçao)"),
	NL_NL         (0x0413, "nl-NL",          "Dutch (Netherlands)"),
	NL_SX         (0x1000, "nl-SX",          "Dutch (Sint Maarten)"),
	NL_SR         (0x1000, "nl-SR",          "Dutch (Suriname)"),
	DZ            (0x1000, "dz",             "Dzongkha"),
	DZ_BT         (0x0C51, "dz-BT",          "Dzongkha (Bhutan)"),
	BIN           (0x0066, "bin",            "Edo"),
	BIN_NG        (0x0466, "bin-NG",         "Edo (Nigeria)"),
	EBU           (0x1000, "ebu",            "Embu"),
	EBU_KE        (0x1000, "ebu-KE",         "Embu (Kenya)"),
	EN            (0x0009, "en",             "English"),
	EN_AS         (0x1000, "en-AS",          "English (American Samoa)"),
	EN_AI         (0x1000, "en-AI",          "English (Anguilla)"),
	EN_AG         (0x1000, "en-AG",          "English (Antigua and Barbuda)"),
	EN_AU         (0x0C09, "en-AU",          "English (Australia)"),
	EN_AT         (0x1000, "en-AT",          "English (Austria)"),
	EN_BS         (0x1000, "en-BS",          "English (Bahamas)"),
	EN_BB         (0x1000, "en-BB",          "English (Barbados)"),
	EN_BE         (0x1000, "en-BE",          "English (Belgium)"),
	EN_BZ         (0x2809, "en-BZ",          "English (Belize)"),
	EN_BM         (0x1000, "en-BM",          "English (Bermuda)"),
	EN_BW         (0x1000, "en-BW",          "English (Botswana)"),
	EN_IO         (0x1000, "en-IO",          "English (British Indian Ocean Territory)"),
	EN_VG         (0x1000, "en-VG",          "English (British Virgin Islands)"),
	EN_BI         (0x1000, "en-BI",          "English (Burundi)"),
	EN_CM         (0x1000, "en-CM",          "English (Cameroon)"),
	EN_CA         (0x1009, "en-CA",          "English (Canada)"),
	EN_029        (0x2409, "en-029",         "English (Caribbean)"),
	EN_KY         (0x1000, "en-KY",          "English (Cayman Islands)"),
	EN_CX         (0x1000, "en-CX",          "English (Christmas Island)"),
	EN_CC         (0x1000, "en-CC",          "English (Cocos [Keeling] Islands)"),
	EN_CK         (0x1000, "en-CK",          "English (Cook Islands)"),
	EN_CY         (0x1000, "en-CY",          "English (Cyprus)"),
	EN_DK         (0x1000, "en-DK",          "English (Denmark)"),
	EN_DM         (0x1000, "en-DM",          "English (Dominica)"),
	EN_ER         (0x1000, "en-ER",          "English (Eritrea)"),
	EN_150        (0x1000, "en-150",         "English (Europe)"),
	EN_FK         (0x1000, "en-FK",          "English (Falkland Islands)"),
	EN_FJ         (0x1000, "en-FJ",          "English (Fiji)"),
	EN_FI         (0x1000, "en-FI",          "English (Finland)"),
	EN_GM         (0x1000, "en-GM",          "English (Gambia)"),
	EN_DE         (0x1000, "en-DE",          "English (Germany)"),
	EN_GH         (0x1000, "en-GH",          "English (Ghana)"),
	EN_GI         (0x1000, "en-GI",          "English (Gibraltar)"),
	EN_GD         (0x1000, "en-GD",          "English (Grenada)"),
	EN_GU         (0x1000, "en-GU",          "English (Guam)"),
	EN_GG         (0x1000, "en-GG",          "English (Guernsey)"),
	EN_GY         (0x1000, "en-GY",          "English (Guyana)"),
	EN_HK         (0x3C09, "en-HK",          "English (Hong Kong SAR)"),
	EN_IN         (0x4009, "en-IN",          "English (India)"),
	EN_ID         (0x3809, "en-ID",          "English (Indonesia)"),
	EN_IE         (0x1809, "en-IE",          "English (Ireland)"),
	EN_IM         (0x1000, "en-IM",          "English (Isle of Man)"),
	EN_IL         (0x1000, "en-IL",          "English (Israel)"),
	EN_JM         (0x2009, "en-JM",          "English (Jamaica)"),
	EN_JE         (0x1000, "en-JE",          "English (Jersey)"),
	EN_KE         (0x1000, "en-KE",          "English (Kenya)"),
	EN_KI         (0x1000, "en-KI",          "English (Kiribati)"),
	EN_LS         (0x1000, "en-LS",          "English (Lesotho)"),
	EN_LR         (0x1000, "en-LR",          "English (Liberia)"),
	EN_MO         (0x1000, "en-MO",          "English (Macao SAR)"),
	EN_MG         (0x1000, "en-MG",          "English (Madagascar)"),
	EN_MW         (0x1000, "en-MW",          "English (Malawi)"),
	EN_MY         (0x4409, "en-MY",          "English (Malaysia)"),
	EN_MT         (0x1000, "en-MT",          "English (Malta)"),
	EN_MH         (0x1000, "en-MH",          "English (Marshall Islands)"),
	EN_MU         (0x1000, "en-MU",          "English (Mauritius)"),
	EN_FM         (0x1000, "en-FM",          "English (Micronesia)"),
	EN_MS         (0x1000, "en-MS",          "English (Montserrat)"),
	EN_NA         (0x1000, "en-NA",          "English (Namibia)"),
	EN_NR         (0x1000, "en-NR",          "English (Nauru)"),
	EN_NL         (0x1000, "en-NL",          "English (Netherlands)"),
	EN_NZ         (0x1409, "en-NZ",          "English (New Zealand)"),
	EN_NG         (0x1000, "en-NG",          "English (Nigeria)"),
	EN_NU         (0x1000, "en-NU",          "English (Niue)"),
	EN_NF         (0x1000, "en-NF",          "English (Norfolk Island)"),
	EN_MP         (0x1000, "en-MP",          "English (Northern Mariana Islands)"),
	EN_PK         (0x1000, "en-PK",          "English (Pakistan)"),
	EN_PW         (0x1000, "en-PW",          "English (Palau)"),
	EN_PG         (0x1000, "en-PG",          "English (Papua New Guinea)"),
	EN_PH         (0x3409, "en-PH",          "English (Philippines)"),
	EN_PN         (0x1000, "en-PN",          "English (Pitcairn Islands)"),
	EN_PR         (0x1000, "en-PR",          "English (Puerto Rico)"),
	EN_RW         (0x1000, "en-RW",          "English (Rwanda)"),
	EN_KN         (0x1000, "en-KN",          "English (Saint Kitts and Nevis)"),
	EN_LC         (0x1000, "en-LC",          "English (Saint Lucia)"),
	EN_VC         (0x1000, "en-VC",          "English (Saint Vincent and the Grenadines)"),
	EN_WS         (0x1000, "en-WS",          "English (Samoa)"),
	EN_SC         (0x1000, "en-SC",          "English (Seychelles)"),
	EN_SL         (0x1000, "en-SL",          "English (Sierra Leone)"),
	EN_SG         (0x4809, "en-SG",          "English (Singapore)"),
	EN_SX         (0x1000, "en-SX",          "English (Sint Maarten)"),
	EN_SI         (0x1000, "en-SI",          "English (Slovenia)"),
	EN_SB         (0x1000, "en-SB",          "English (Solomon Islands)"),
	EN_ZA         (0x1C09, "en-ZA",          "English (South Africa)"),
	EN_SS         (0x1000, "en-SS",          "English (South Sudan)"),
	EN_SH         (0x1000, "en-SH",          "English (St Helena, Ascension, Tristan da Cunha)"),
	EN_SD         (0x1000, "en-SD",          "English (Sudan)"),
	EN_SZ         (0x1000, "en-SZ",          "English (Swaziland)"),
	EN_SE         (0x1000, "en-SE",          "English (Sweden)"),
	EN_CH         (0x1000, "en-CH",          "English (Switzerland)"),
	EN_TZ         (0x1000, "en-TZ",          "English (Tanzania)"),
	EN_TK         (0x1000, "en-TK",          "English (Tokelau)"),
	EN_TO         (0x1000, "en-TO",          "English (Tonga)"),
	EN_TT         (0x2C09, "en-TT",          "English (Trinidad and Tobago)"),
	EN_TC         (0x1000, "en-TC",          "English (Turks and Caicos Islands)"),
	EN_TV         (0x1000, "en-TV",          "English (Tuvalu)"),
	EN_UG         (0x1000, "en-UG",          "English (Uganda)"),
	EN_GB         (0x0809, "en-GB",          "English (United Kingdom)"),
	EN_US         (0x0409, "en-US",          "English (United States)"),
	EN_UM         (0x1000, "en-UM",          "English (US Minor Outlying Islands)"),
	EN_VI         (0x1000, "en-VI",          "English (US Virgin Islands)"),
	EN_VU         (0x1000, "en-VU",          "English (Vanuatu)"),
	EN_001        (0x1000, "en-001",         "English (World)"),
	EN_ZM         (0x1000, "en-ZM",          "English (Zambia)"),
	EN_ZW         (0x3009, "en-ZW",          "English (Zimbabwe)"),
	EO            (0x1000, "eo",             "Esperanto"),
	EO_001        (0x1000, "eo-001",         "Esperanto (World)"),
	ET            (0x0025, "et",             "Estonian"),
	ET_EE         (0x0425, "et-EE",          "Estonian (Estonia)"),
	EE            (0x1000, "ee",             "Ewe"),
	EE_GH         (0x1000, "ee-GH",          "Ewe (Ghana)"),
	EE_TG         (0x1000, "ee-TG",          "Ewe (Togo)"),
	EWO           (0x1000, "ewo",            "Ewondo"),
	EWO_CM        (0x1000, "ewo-CM",         "Ewondo (Cameroon)"),
	FO            (0x0038, "fo",             "Faroese"),
	FO_DK         (0x1000, "fo-DK",          "Faroese (Denmark)"),
	FO_FO         (0x0438, "fo-FO",          "Faroese (Faroe Islands)"),
	FIL           (0x0064, "fil",            "Filipino"),
	FIL_PH        (0x0464, "fil-PH",         "Filipino (Philippines)"),
	FI            (0x000B, "fi",             "Finnish"),
	FI_FI         (0x040B, "fi-FI",          "Finnish (Finland)"),
	FR            (0x000C, "fr",             "French"),
	FR_DZ         (0x1000, "fr-DZ",          "French (Algeria)"),
	FR_BE         (0x080C, "fr-BE",          "French (Belgium)"),
	FR_BJ         (0x1000, "fr-BJ",          "French (Benin)"),
	FR_BF         (0x1000, "fr-BF",          "French (Burkina Faso)"),
	FR_BI         (0x1000, "fr-BI",          "French (Burundi)"),
	FR_CM         (0x2C0C, "fr-CM",          "French (Cameroon)"),
	FR_CA         (0x0C0C, "fr-CA",          "French (Canada)"),
	FR_029        (0x1C0C, "fr-029",         "French (Caribbean)"),
	FR_CF         (0x1000, "fr-CF",          "French (Central African Republic)"),
	FR_TD         (0x1000, "fr-TD",          "French (Chad)"),
	FR_KM         (0x1000, "fr-KM",          "French (Comoros)"),
	FR_CD         (0x240C, "fr-CD",          "French (Congo DRC)"),
	FR_CG         (0x1000, "fr-CG",          "French (Congo)"),
	FR_CI         (0x300C, "fr-CI",          "French (Côte d’Ivoire)"),
	FR_DJ         (0x1000, "fr-DJ",          "French (Djibouti)"),
	FR_GQ         (0x1000, "fr-GQ",          "French (Equatorial Guinea)"),
	FR_FR         (0x040C, "fr-FR",          "French (France)"),
	FR_GF         (0x1000, "fr-GF",          "French (French Guiana)"),
	FR_PF         (0x1000, "fr-PF",          "French (French Polynesia)"),
	FR_GA         (0x1000, "fr-GA",          "French (Gabon)"),
	FR_GP         (0x1000, "fr-GP",          "French (Guadeloupe)"),
	FR_GN         (0x1000, "fr-GN",          "French (Guinea)"),
	FR_HT         (0x3C0C, "fr-HT",          "French (Haiti)"),
	FR_LU         (0x140C, "fr-LU",          "French (Luxembourg)"),
	FR_MG         (0x1000, "fr-MG",          "French (Madagascar)"),
	FR_ML         (0x340C, "fr-ML",          "French (Mali)"),
	FR_MQ         (0x1000, "fr-MQ",          "French (Martinique)"),
	FR_MR         (0x1000, "fr-MR",          "French (Mauritania)"),
	FR_MU         (0x1000, "fr-MU",          "French (Mauritius)"),
	FR_YT         (0x1000, "fr-YT",          "French (Mayotte)"),
	FR_MC         (0x180C, "fr-MC",          "French (Monaco)"),
	FR_MA         (0x380C, "fr-MA",          "French (Morocco)"),
	FR_NC         (0x1000, "fr-NC",          "French (New Caledonia)"),
	FR_NE         (0x1000, "fr-NE",          "French (Niger)"),
	FR_RE         (0x200C, "fr-RE",          "French (Reunion)"),
	FR_RW         (0x1000, "fr-RW",          "French (Rwanda)"),
	FR_BL         (0x1000, "fr-BL",          "French (Saint Barthélemy)"),
	FR_MF         (0x1000, "fr-MF",          "French (Saint Martin)"),
	FR_PM         (0x1000, "fr-PM",          "French (Saint Pierre and Miquelon)"),
	FR_SN         (0x280C, "fr-SN",          "French (Senegal)"),
	FR_SC         (0x1000, "fr-SC",          "French (Seychelles)"),
	FR_CH         (0x100C, "fr-CH",          "French (Switzerland)"),
	FR_SY         (0x1000, "fr-SY",          "French (Syria)"),
	FR_TG         (0x1000, "fr-TG",          "French (Togo)"),
	FR_TN         (0x1000, "fr-TN",          "French (Tunisia)"),
	FR_VU         (0x1000, "fr-VU",          "French (Vanuatu)"),
	FR_WF         (0x1000, "fr-WF",          "French (Wallis and Futuna)"),
	FY            (0x0062, "fy",             "Frisian"),
	FY_NL         (0x0462, "fy-NL",          "Frisian (Netherlands)"),
	FUR           (0x1000, "fur",            "Friulian"),
	FUR_IT        (0x1000, "fur-IT",         "Friulian (Italy)"),
	FF            (0x0067, "ff",             "Fulah"),
	FF_CM         (0x1000, "ff-CM",          "Fulah (Cameroon)"),
	FF_GN         (0x1000, "ff-GN",          "Fulah (Guinea)"),
	FF_LATN       (0x7C67, "ff-Latn",        "Fulah (Latin)"),
	FF_LATN_SN    (0x0867, "ff-Latn-SN",     "Fulah (Latin, Senegal)"),
	FF_MR         (0x1000, "ff-MR",          "Fulah (Mauritania)"),
	FF_NG         (0x0467, "ff-NG",          "Fulah (Nigeria)"),
	GL            (0x0056, "gl",             "Galician"),
	GL_ES         (0x0456, "gl-ES",          "Galician (Galician)"),
	LG            (0x1000, "lg",             "Ganda"),
	LG_UG         (0x1000, "lg-UG",          "Ganda (Uganda)"),
	KA            (0x0037, "ka",             "Georgian"),
	KA_GE         (0x0437, "ka-GE",          "Georgian (Georgia)"),
	DE            (0x0007, "de",             "German"),
	DE_AT         (0x0C07, "de-AT",          "German (Austria)"),
	DE_BE         (0x1000, "de-BE",          "German (Belgium)"),
	DE_DE         (0x0407, "de-DE",          "German (Germany)"),
	DE_IT         (0x1000, "de-IT",          "German (Italy)"),
	DE_LI         (0x1407, "de-LI",          "German (Liechtenstein)"),
	DE_LU         (0x1007, "de-LU",          "German (Luxembourg)"),
	DE_CH         (0x0807, "de-CH",          "German (Switzerland)"),
	EL            (0x0008, "el",             "Greek"),
	EL_CY         (0x1000, "el-CY",          "Greek (Cyprus)"),
	EL_GR         (0x0408, "el-GR",          "Greek (Greece)"),
	KL            (0x006F, "kl",             "Greenlandic"),
	KL_GL         (0x046F, "kl-GL",          "Greenlandic (Greenland)"),
	GN            (0x0074, "gn",             "Guarani"),
	GN_PY         (0x0474, "gn-PY",          "Guarani (Paraguay)"),
	GU            (0x0047, "gu",             "Gujarati"),
	GU_IN         (0x0447, "gu-IN",          "Gujarati (India)"),
	GUZ           (0x1000, "guz",            "Gusii"),
	GUZ_KE        (0x1000, "guz-KE",         "Gusii (Kenya)"),
	HA            (0x0068, "ha",             "Hausa"),
	HA_LATN       (0x7C68, "ha-Latn",        "Hausa (Latin)"),
	HA_LATN_GH    (0x1000, "ha-Latn-GH",     "Hausa (Latin, Ghana)"),
	HA_LATN_NE    (0x1000, "ha-Latn-NE",     "Hausa (Latin, Niger)"),
	HA_LATN_NG    (0x0468, "ha-Latn-NG",     "Hausa (Latin, Nigeria)"),
	HAW           (0x0075, "haw",            "Hawaiian"),
	HAW_US        (0x0475, "haw-US",         "Hawaiian (United States)"),
	HE            (0x000D, "he",             "Hebrew"),
	HE_IL         (0x040D, "he-IL",          "Hebrew (Israel)"),
	HI            (0x0039, "hi",             "Hindi"),
	HI_IN         (0x0439, "hi-IN",          "Hindi (India)"),
	HU            (0x000E, "hu",             "Hungarian"),
	HU_HU         (0x040E, "hu-HU",          "Hungarian (Hungary)"),
	IBB           (0x0069, "ibb",            "Ibibio"),
	IBB_NG        (0x0469, "ibb-NG",         "Ibibio (Nigeria)"),
	IS            (0x000F, "is",             "Icelandic"),
	IS_IS         (0x040F, "is-IS",          "Icelandic (Iceland)"),
	IG            (0x0070, "ig",             "Igbo"),
	IG_NG         (0x0470, "ig-NG",          "Igbo (Nigeria)"),
	ID            (0x0021, "id",             "Indonesian"),
	ID_ID         (0x0421, "id-ID",          "Indonesian (Indonesia)"),
	IA            (0x1000, "ia",             "Interlingua"),
	IA_FR         (0x1000, "ia-FR",          "Interlingua (France)"),
	IA_001        (0x1000, "ia-001",         "Interlingua (World)"),
	IU            (0x005D, "iu",             "Inuktitut"),
	IU_LATN       (0x7C5D, "iu-Latn",        "Inuktitut (Latin)"),
	IU_LATN_CA    (0x085D, "iu-Latn-CA",     "Inuktitut (Latin, Canada)"),
	IU_CANS       (0x785D, "iu-Cans",        "Inuktitut (Syllabics)"),
	IU_CANS_CA    (0x045D, "iu-Cans-CA",     "Inuktitut (Syllabics, Canada)"),
	GA            (0x003C, "ga",             "Irish"),
	GA_IE         (0x083C, "ga-IE",          "Irish (Ireland)"),
	IT            (0x0010, "it",             "Italian"),
	IT_IT         (0x0410, "it-IT",          "Italian (Italy)"),
	IT_SM         (0x1000, "it-SM",          "Italian (San Marino)"),
	IT_CH         (0x0810, "it-CH",          "Italian (Switzerland)"),
	IT_VA         (0x1000, "it-VA",          "Italian (Vatican City)"),
	JA            (0x0011, "ja",             "Japanese"),
	JA_JP         (0x0411, "ja-JP",          "Japanese (Japan)"),
	JV            (0x1000, "jv",             "Javanese"),
	JV_JAVA       (0x1000, "jv-Java",        "Javanese (Javanese)"),
	JV_JAVA_ID    (0x1000, "jv-Java-ID",     "Javanese (Javanese, Indonesia)"),
	JV_LATN       (0x1000, "jv-Latn",        "Javanese (Latin)"),
	JV_LATN_ID    (0x1000, "jv-Latn-ID",     "Javanese (Latin, Indonesia)"),
	DYO           (0x1000, "dyo",            "Jola-Fonyi"),
	DYO_SN        (0x1000, "dyo-SN",         "Jola-Fonyi (Senegal)"),
	KEA           (0x1000, "kea",            "Kabuverdianu"),
	KEA_CV        (0x1000, "kea-CV",         "Kabuverdianu (Cabo Verde)"),
	KAB           (0x1000, "kab",            "Kabyle"),
	KAB_DZ        (0x1000, "kab-DZ",         "Kabyle (Algeria)"),
	KKJ           (0x1000, "kkj",            "Kako"),
	KKJ_CM        (0x1000, "kkj-CM",         "Kako (Cameroon)"),
	KLN           (0x1000, "kln",            "Kalenjin"),
	KLN_KE        (0x1000, "kln-KE",         "Kalenjin (Kenya)"),
	KAM           (0x1000, "kam",            "Kamba"),
	KAM_KE        (0x1000, "kam-KE",         "Kamba (Kenya)"),
	KN            (0x004B, "kn",             "Kannada"),
	KN_IN         (0x044B, "kn-IN",          "Kannada (India)"),
	KR            (0x0071, "kr",             "Kanuri"),
	KR_NG         (0x0471, "kr-NG",          "Kanuri (Nigeria)"),
	KS            (0x0060, "ks",             "Kashmiri"),
	KS_DEVA       (0x1000, "ks-Deva",        "Kashmiri (Devanagari)"),
	KS_DEVA_IN    (0x0860, "ks-Deva-IN",     "Kashmiri (Devanagari, India)"),
	KS_ARAB       (0x0460, "ks-Arab",        "Kashmiri (Perso-Arabic)"),
	KS_ARAB_IN    (0x1000, "ks-Arab-IN",     "Kashmiri (Perso-Arabic, India)"),
	KK            (0x003F, "kk",             "Kazakh"),
	KK_KZ         (0x043F, "kk-KZ",          "Kazakh (Kazakhstan)"),
	KM            (0x0053, "km",             "Khmer"),
	KM_KH         (0x0453, "km-KH",          "Khmer (Cambodia)"),
	KI            (0x1000, "ki",             "Kikuyu"),
	KI_KE         (0x1000, "ki-KE",          "Kikuyu (Kenya)"),
	RW            (0x0087, "rw",             "Kinyarwanda"),
	RW_RW         (0x0487, "rw-RW",          "Kinyarwanda (Rwanda)"),
	SW            (0x0041, "sw",             "Kiswahili"),
	SW_CD         (0x1000, "sw-CD",          "Kiswahili (Congo DRC)"),
	SW_KE         (0x0441, "sw-KE",          "Kiswahili (Kenya)"),
	SW_TZ         (0x1000, "sw-TZ",          "Kiswahili (Tanzania)"),
	SW_UG         (0x1000, "sw-UG",          "Kiswahili (Uganda)"),
	KOK           (0x0057, "kok",            "Konkani"),
	KOK_IN        (0x0457, "kok-IN",         "Konkani (India)"),
	KO            (0x0012, "ko",             "Korean"),
	KO_KR         (0x0412, "ko-KR",          "Korean (Korea)"),
	KO_KP         (0x1000, "ko-KP",          "Korean (North Korea)"),
	KHQ           (0x1000, "khq",            "Koyra Chiini"),
	KHQ_ML        (0x1000, "khq-ML",         "Koyra Chiini (Mali)"),
	SES           (0x1000, "ses",            "Koyraboro Senni"),
	SES_ML        (0x1000, "ses-ML",         "Koyraboro Senni (Mali)"),
	KU_ARAB_IR    (0x1000, "ku-Arab-IR",     "Kurdish (Perso-Arabic, Iran)"),
	NMG           (0x1000, "nmg",            "Kwasio"),
	NMG_CM        (0x1000, "nmg-CM",         "Kwasio (Cameroon)"),
	KY            (0x0040, "ky",             "Kyrgyz"),
	KY_KG         (0x0440, "ky-KG",          "Kyrgyz (Kyrgyzstan)"),
	QUC           (0x0086, "quc",            "K’iche’"),
	QUC_LATN      (0x7C86, "quc-Latn",       "K’iche’ (Latin)"),
	QUC_LATN_GT   (0x0486, "quc-Latn-GT",    "K’iche’ (Latin, Guatemala)"),
	LKT           (0x1000, "lkt",            "Lakota"),
	LKT_US        (0x1000, "lkt-US",         "Lakota (United States)"),
	LAG           (0x1000, "lag",            "Langi"),
	LAG_TZ        (0x1000, "lag-TZ",         "Langi (Tanzania)"),
	LO            (0x0054, "lo",             "Lao"),
	LO_LA         (0x0454, "lo-LA",          "Lao (Lao P.D.R.)"),
	LA            (0x0076, "la",             "Latin"),
	LA_001        (0x0476, "la-001",         "Latin (World)"),
	LV            (0x0026, "lv",             "Latvian"),
	LV_LV         (0x0426, "lv-LV",          "Latvian (Latvia)"),
	LN            (0x1000, "ln",             "Lingala"),
	LN_AO         (0x1000, "ln-AO",          "Lingala (Angola)"),
	LN_CF         (0x1000, "ln-CF",          "Lingala (Central African Republic)"),
	LN_CD         (0x1000, "ln-CD",          "Lingala (Congo DRC)"),
	LN_CG         (0x1000, "ln-CG",          "Lingala (Congo)"),
	LT            (0x0027, "lt",             "Lithuanian"),
	LT_LT         (0x0427, "lt-LT",          "Lithuanian (Lithuania)"),
	NDS           (0x1000, "nds",            "Low German"),
	NDS_DE        (0x1000, "nds-DE",         "Low German (Germany)"),
	NDS_NL        (0x1000, "nds-NL",         "Low German (Netherlands)"),
	DSB           (0x7C2E, "dsb",            "Lower Sorbian"),
	DSB_DE        (0x082E, "dsb-DE",         "Lower Sorbian (Germany)"),
	LU            (0x1000, "lu",             "Luba-Katanga"),
	LU_CD         (0x1000, "lu-CD",          "Luba-Katanga (Congo DRC)"),
	LUO           (0x1000, "luo",            "Luo"),
	LUO_KE        (0x1000, "luo-KE",         "Luo (Kenya)"),
	LB            (0x006E, "lb",             "Luxembourgish"),
	LB_LU         (0x046E, "lb-LU",          "Luxembourgish (Luxembourg)"),
	LUY           (0x1000, "luy",            "Luyia"),
	LUY_KE        (0x1000, "luy-KE",         "Luyia (Kenya)"),
	MK_MK         (0x042F, "mk-MK",          "Macedonian (Former Yugoslav Republic of Macedonia)"),
	MK            (0x002F, "mk",             "Macedonian (FYROM)"),
	JMC           (0x1000, "jmc",            "Machame"),
	JMC_TZ        (0x1000, "jmc-TZ",         "Machame (Tanzania)"),
	MGH           (0x1000, "mgh",            "Makhuwa-Meetto"),
	MGH_MZ        (0x1000, "mgh-MZ",         "Makhuwa-Meetto (Mozambique)"),
	KDE           (0x1000, "kde",            "Makonde"),
	KDE_TZ        (0x1000, "kde-TZ",         "Makonde (Tanzania)"),
	MG            (0x1000, "mg",             "Malagasy"),
	MG_MG         (0x1000, "mg-MG",          "Malagasy (Madagascar)"),
	MS            (0x003E, "ms",             "Malay"),
	MS_BN         (0x083E, "ms-BN",          "Malay (Brunei Darussalam)"),
	MS_SG         (0x1000, "ms-SG",          "Malay (Latin, Singapore)"),
	MS_MY         (0x043E, "ms-MY",          "Malay (Malaysia)"),
	ML            (0x004C, "ml",             "Malayalam"),
	ML_IN         (0x044C, "ml-IN",          "Malayalam (India)"),
	MT            (0x003A, "mt",             "Maltese"),
	MT_MT         (0x043A, "mt-MT",          "Maltese (Malta)"),
	MNI           (0x0058, "mni",            "Manipuri"),
	MNI_IN        (0x0458, "mni-IN",         "Manipuri (India)"),
	GV            (0x1000, "gv",             "Manx"),
	GV_IM         (0x1000, "gv-IM",          "Manx (Isle of Man)"),
	MI            (0x0081, "mi",             "Maori"),
	MI_NZ         (0x0481, "mi-NZ",          "Maori (New Zealand)"),
	ARN           (0x007A, "arn",            "Mapudungun"),
	ARN_CL        (0x047A, "arn-CL",         "Mapudungun (Chile)"),
	MR            (0x004E, "mr",             "Marathi"),
	MR_IN         (0x044E, "mr-IN",          "Marathi (India)"),
	MAS           (0x1000, "mas",            "Masai"),
	MAS_KE        (0x1000, "mas-KE",         "Masai (Kenya)"),
	MAS_TZ        (0x1000, "mas-TZ",         "Masai (Tanzania)"),
	MZN           (0x1000, "mzn",            "Mazanderani"),
	MZN_IR        (0x1000, "mzn-IR",         "Mazanderani (Iran)"),
	MER           (0x1000, "mer",            "Meru"),
	MER_KE        (0x1000, "mer-KE",         "Meru (Kenya)"),
	MGO           (0x1000, "mgo",            "Meta’"),
	MGO_CM        (0x1000, "mgo-CM",         "Meta’ (Cameroon)"),
	MOH           (0x007C, "moh",            "Mohawk"),
	MOH_CA        (0x047C, "moh-CA",         "Mohawk (Mohawk)"),
	MN            (0x0050, "mn",             "Mongolian"),
	MN_CYRL       (0x7850, "mn-Cyrl",        "Mongolian (Cyrillic)"),
	MN_MN         (0x0450, "mn-MN",          "Mongolian (Cyrillic, Mongolia)"),
	MN_MONG       (0x7C50, "mn-Mong",        "Mongolian (Traditional Mongolian)"),
	MN_MONG_MN    (0x0C50, "mn-Mong-MN",     "Mongolian (Traditional Mongolian, Mongolia)"),
	MN_MONG_CN    (0x0850, "mn-Mong-CN",     "Mongolian (Traditional Mongolian, PRC)"),
	MFE           (0x1000, "mfe",            "Morisyen"),
	MFE_MU        (0x1000, "mfe-MU",         "Morisyen (Mauritius)"),
	MUA           (0x1000, "mua",            "Mundang"),
	MUA_CM        (0x1000, "mua-CM",         "Mundang (Cameroon)"),
	NAQ           (0x1000, "naq",            "Nama"),
	NAQ_NA        (0x1000, "naq-NA",         "Nama (Namibia)"),
	NE            (0x0061, "ne",             "Nepali"),
	NE_IN         (0x0861, "ne-IN",          "Nepali (India)"),
	NE_NP         (0x0461, "ne-NP",          "Nepali (Nepal)"),
	NNH           (0x1000, "nnh",            "Ngiemboon"),
	NNH_CM        (0x1000, "nnh-CM",         "Ngiemboon (Cameroon)"),
	JGO           (0x1000, "jgo",            "Ngomba"),
	JGO_CM        (0x1000, "jgo-CM",         "Ngomba (Cameroon)"),
	ND            (0x1000, "nd",             "North Ndebele"),
	ND_ZW         (0x1000, "nd-ZW",          "North Ndebele (Zimbabwe)"),
	LRC           (0x1000, "lrc",            "Northern Luri"),
	LRC_IR        (0x1000, "lrc-IR",         "Northern Luri (Iran)"),
	LRC_IQ        (0x1000, "lrc-IQ",         "Northern Luri (Iraq)"),
	NO            (0x0014, "no",             "Norwegian"),
	NB            (0x7C14, "nb",             "Norwegian (Bokmål)"),
	NN            (0x7814, "nn",             "Norwegian (Nynorsk)"),
	NB_NO         (0x0414, "nb-NO",          "Norwegian, Bokmål (Norway)"),
	NB_SJ         (0x1000, "nb-SJ",          "Norwegian, Bokmål (Svalbard and Jan Mayen)"),
	NN_NO         (0x0814, "nn-NO",          "Norwegian, Nynorsk (Norway)"),
	NUS           (0x1000, "nus",            "Nuer"),
	NUS_SS        (0x1000, "nus-SS",         "Nuer (South Sudan)"),
	NYN           (0x1000, "nyn",            "Nyankole"),
	NYN_UG        (0x1000, "nyn-UG",         "Nyankole (Uganda)"),
	NQO           (0x1000, "nqo",            "N’ko"),
	NQO_GN        (0x1000, "nqo-GN",         "N’ko (Guinea)"),
	OC            (0x0082, "oc",             "Occitan"),
	OC_FR         (0x0482, "oc-FR",          "Occitan (France)"),
	OR            (0x0048, "or",             "Odia"),
	OR_IN         (0x0448, "or-IN",          "Odia (India)"),
	OM            (0x0072, "om",             "Oromo"),
	OM_ET         (0x0472, "om-ET",          "Oromo (Ethiopia)"),
	OM_KE         (0x1000, "om-KE",          "Oromo (Kenya)"),
	OS_GE         (0x1000, "os-GE",          "Ossetian (Cyrillic, Georgia)"),
	OS_RU         (0x1000, "os-RU",          "Ossetian (Cyrillic, Russia)"),
	OS            (0x1000, "os",             "Ossetic"),
	PAP           (0x0079, "pap",            "Papiamento"),
	PAP_029       (0x0479, "pap-029",        "Papiamento (Caribbean)"),
	PS            (0x0063, "ps",             "Pashto"),
	PS_AF         (0x0463, "ps-AF",          "Pashto (Afghanistan)"),
	FA            (0x0029, "fa",             "Persian"),
	FA_IR         (0x0429, "fa-IR",          "Persian (Iran)"),
	PL            (0x0015, "pl",             "Polish"),
	PL_PL         (0x0415, "pl-PL",          "Polish (Poland)"),
	PT            (0x0016, "pt",             "Portuguese"),
	PT_AO         (0x1000, "pt-AO",          "Portuguese (Angola)"),
	PT_BR         (0x0416, "pt-BR",          "Portuguese (Brazil)"),
	PT_CV         (0x1000, "pt-CV",          "Portuguese (Cabo Verde)"),
	PT_GQ         (0x1000, "pt-GQ",          "Portuguese (Equatorial Guinea)"),
	PT_GW         (0x1000, "pt-GW",          "Portuguese (Guinea-Bissau)"),
	PT_LU         (0x1000, "pt-LU",          "Portuguese (Luxembourg)"),
	PT_MO         (0x1000, "pt-MO",          "Portuguese (Macao SAR)"),
	PT_MZ         (0x1000, "pt-MZ",          "Portuguese (Mozambique)"),
	PT_PT         (0x0816, "pt-PT",          "Portuguese (Portugal)"),
	PT_CH         (0x1000, "pt-CH",          "Portuguese (Switzerland)"),
	PT_ST         (0x1000, "pt-ST",          "Portuguese (São Tomé and Príncipe)"),
	PT_TL         (0x1000, "pt-TL",          "Portuguese (Timor-Leste)"),
	PRG           (0x1000, "prg",            "Prussian"),
	PRG_001       (0x1000, "prg-001",        "Prussian (World)"),
	PA            (0x0046, "pa",             "Punjabi"),
	PA_ARAB       (0x7C46, "pa-Arab",        "Punjabi (Arabic)"),
	PA_IN         (0x0446, "pa-IN",          "Punjabi (India)"),
	PA_ARAB_PK    (0x0846, "pa-Arab-PK",     "Punjabi (Islamic Republic of Pakistan)"),
	QUZ           (0x006B, "quz",            "Quechua"),
	QUZ_BO        (0x046B, "quz-BO",         "Quechua (Bolivia)"),
	QUZ_EC        (0x086B, "quz-EC",         "Quechua (Ecuador)"),
	QUZ_PE        (0x0C6B, "quz-PE",         "Quechua (Peru)"),
	KSH_DE        (0x1000, "ksh-DE",         "Ripuarian (Germany)"),
	RO            (0x0018, "ro",             "Romanian"),
	RO_MD         (0x0818, "ro-MD",          "Romanian (Moldova)"),
	RO_RO         (0x0418, "ro-RO",          "Romanian (Romania)"),
	RM            (0x0017, "rm",             "Romansh"),
	RM_CH         (0x0417, "rm-CH",          "Romansh (Switzerland)"),
	ROF           (0x1000, "rof",            "Rombo"),
	ROF_TZ        (0x1000, "rof-TZ",         "Rombo (Tanzania)"),
	RN            (0x1000, "rn",             "Rundi"),
	RN_BI         (0x1000, "rn-BI",          "Rundi (Burundi)"),
	RU            (0x0019, "ru",             "Russian"),
	RU_BY         (0x1000, "ru-BY",          "Russian (Belarus)"),
	RU_KZ         (0x1000, "ru-KZ",          "Russian (Kazakhstan)"),
	RU_KG         (0x1000, "ru-KG",          "Russian (Kyrgyzstan)"),
	RU_MD         (0x0819, "ru-MD",          "Russian (Moldova)"),
	RU_RU         (0x0419, "ru-RU",          "Russian (Russia)"),
	RU_UA         (0x1000, "ru-UA",          "Russian (Ukraine)"),
	RWK           (0x1000, "rwk",            "Rwa"),
	RWK_TZ        (0x1000, "rwk-TZ",         "Rwa (Tanzania)"),
	SSY           (0x1000, "ssy",            "Saho"),
	SSY_ER        (0x1000, "ssy-ER",         "Saho (Eritrea)"),
	SAH           (0x0085, "sah",            "Sakha"),
	SAH_RU        (0x0485, "sah-RU",         "Sakha (Russia)"),
	SAQ           (0x1000, "saq",            "Samburu"),
	SAQ_KE        (0x1000, "saq-KE",         "Samburu (Kenya)"),
	SMN           (0x703B, "smn",            "Sami (Inari)"),
	SMJ           (0x7C3B, "smj",            "Sami (Lule)"),
	SE            (0x003B, "se",             "Sami (Northern)"),
	SMS           (0x743B, "sms",            "Sami (Skolt)"),
	SMA           (0x783B, "sma",            "Sami (Southern)"),
	SMN_FI        (0x243B, "smn-FI",         "Sami, Inari (Finland)"),
	SMJ_NO        (0x103B, "smj-NO",         "Sami, Lule (Norway)"),
	SMJ_SE        (0x143B, "smj-SE",         "Sami, Lule (Sweden)"),
	SE_FI         (0x0C3B, "se-FI",          "Sami, Northern (Finland)"),
	SE_NO         (0x043B, "se-NO",          "Sami, Northern (Norway)"),
	SE_SE         (0x083B, "se-SE",          "Sami, Northern (Sweden)"),
	SMS_FI        (0x203B, "sms-FI",         "Sami, Skolt (Finland)"),
	SMA_NO        (0x183B, "sma-NO",         "Sami, Southern (Norway)"),
	SMA_SE        (0x1C3B, "sma-SE",         "Sami, Southern (Sweden)"),
	SG            (0x1000, "sg",             "Sango"),
	SG_CF         (0x1000, "sg-CF",          "Sango (Central African Republic)"),
	SBP           (0x1000, "sbp",            "Sangu"),
	SBP_TZ        (0x1000, "sbp-TZ",         "Sangu (Tanzania)"),
	SA            (0x004F, "sa",             "Sanskrit"),
	SA_IN         (0x044F, "sa-IN",          "Sanskrit (India)"),
	GD            (0x0091, "gd",             "Scottish Gaelic"),
	GD_GB         (0x0491, "gd-GB",          "Scottish Gaelic (United Kingdom)"),
	SEH           (0x1000, "seh",            "Sena"),
	SEH_MZ        (0x1000, "seh-MZ",         "Sena (Mozambique)"),
	SR            (0x7C1A, "sr",             "Serbian"),
	SR_CYRL       (0x6C1A, "sr-Cyrl",        "Serbian (Cyrillic)"),
	SR_CYRL_BA    (0x1C1A, "sr-Cyrl-BA",     "Serbian (Cyrillic, Bosnia and Herzegovina)"),
	SR_CYRL_XK    (0x1000, "sr-Cyrl-XK",     "Serbian (Cyrillic, Kosovo)"),
	SR_CYRL_ME    (0x301A, "sr-Cyrl-ME",     "Serbian (Cyrillic, Montenegro)"),
	SR_CYRL_RS    (0x281A, "sr-Cyrl-RS",     "Serbian (Cyrillic, Serbia)"),
	SR_LATN       (0x701A, "sr-Latn",        "Serbian (Latin)"),
	SR_LATN_BA    (0x181A, "sr-Latn-BA",     "Serbian (Latin, Bosnia and Herzegovina)"),
	SR_LATN_XK    (0x1000, "sr-Latn-XK",     "Serbian (Latin, Kosovo)"),
	SR_LATN_ME    (0x2C1A, "sr-Latn-ME",     "Serbian (Latin, Montenegro)"),
	SR_LATN_RS    (0x241A, "sr-Latn-RS",     "Serbian (Latin, Serbia)"),
	ST_LS         (0x1000, "st-LS",          "Sesotho (Lesotho)"),
	NSO           (0x006C, "nso",            "Sesotho sa Leboa"),
	NSO_ZA        (0x046C, "nso-ZA",         "Sesotho sa Leboa (South Africa)"),
	TN            (0x0032, "tn",             "Setswana"),
	TN_BW         (0x0832, "tn-BW",          "Setswana (Botswana)"),
	TN_ZA         (0x0432, "tn-ZA",          "Setswana (South Africa)"),
	KSB           (0x1000, "ksb",            "Shambala"),
	KSB_TZ        (0x1000, "ksb-TZ",         "Shambala (Tanzania)"),
	SN            (0x1000, "sn",             "Shona"),
	SN_LATN       (0x1000, "sn-Latn",        "Shona (Latin)"),
	SN_LATN_ZW    (0x1000, "sn-Latn-ZW",     "Shona (Latin, Zimbabwe)"),
	SD            (0x0059, "sd",             "Sindhi"),
	SD_ARAB       (0x7C59, "sd-Arab",        "Sindhi (Arabic)"),
	SD_DEVA       (0x1000, "sd-Deva",        "Sindhi (Devanagari)"),
	SD_DEVA_IN    (0x0459, "sd-Deva-IN",     "Sindhi (Devanagari, India)"),
	SD_ARAB_PK    (0x0859, "sd-Arab-PK",     "Sindhi (Islamic Republic of Pakistan)"),
	SI            (0x005B, "si",             "Sinhala"),
	SI_LK         (0x045B, "si-LK",          "Sinhala (Sri Lanka)"),
	SK            (0x001B, "sk",             "Slovak"),
	SK_SK         (0x041B, "sk-SK",          "Slovak (Slovakia)"),
	SL            (0x0024, "sl",             "Slovenian"),
	SL_SI         (0x0424, "sl-SI",          "Slovenian (Slovenia)"),
	XOG           (0x1000, "xog",            "Soga"),
	XOG_UG        (0x1000, "xog-UG",         "Soga (Uganda)"),
	SO            (0x0077, "so",             "Somali"),
	SO_DJ         (0x1000, "so-DJ",          "Somali (Djibouti)"),
	SO_ET         (0x1000, "so-ET",          "Somali (Ethiopia)"),
	SO_KE         (0x1000, "so-KE",          "Somali (Kenya)"),
	SO_SO         (0x0477, "so-SO",          "Somali (Somalia)"),
	NR            (0x1000, "nr",             "South Ndebele"),
	NR_ZA         (0x1000, "nr-ZA",          "South Ndebele (South Africa)"),
	ST            (0x0030, "st",             "Southern Sotho"),
	ST_ZA         (0x0430, "st-ZA",          "Southern Sotho (South Africa)"),
	ES            (0x000A, "es",             "Spanish"),
	ES_AR         (0x2C0A, "es-AR",          "Spanish (Argentina)"),
	ES_BZ         (0x1000, "es-BZ",          "Spanish (Belize)"),
	ES_BO         (0x400A, "es-BO",          "Spanish (Bolivia)"),
	ES_BR         (0x1000, "es-BR",          "Spanish (Brazil)"),
	ES_CL         (0x340A, "es-CL",          "Spanish (Chile)"),
	ES_CO         (0x240A, "es-CO",          "Spanish (Colombia)"),
	ES_CR         (0x140A, "es-CR",          "Spanish (Costa Rica)"),
	ES_CU         (0x5C0A, "es-CU",          "Spanish (Cuba)"),
	ES_DO         (0x1C0A, "es-DO",          "Spanish (Dominican Republic)"),
	ES_EC         (0x300A, "es-EC",          "Spanish (Ecuador)"),
	ES_SV         (0x440A, "es-SV",          "Spanish (El Salvador)"),
	ES_GQ         (0x1000, "es-GQ",          "Spanish (Equatorial Guinea)"),
	ES_GT         (0x100A, "es-GT",          "Spanish (Guatemala)"),
	ES_HN         (0x480A, "es-HN",          "Spanish (Honduras)"),
	ES_419        (0x580A, "es-419",         "Spanish (Latin America)"),
	ES_MX         (0x080A, "es-MX",          "Spanish (Mexico)"),
	ES_NI         (0x4C0A, "es-NI",          "Spanish (Nicaragua)"),
	ES_PA         (0x180A, "es-PA",          "Spanish (Panama)"),
	ES_PY         (0x3C0A, "es-PY",          "Spanish (Paraguay)"),
	ES_PE         (0x280A, "es-PE",          "Spanish (Peru)"),
	ES_PH         (0x1000, "es-PH",          "Spanish (Philippines)"),
	ES_PR         (0x500A, "es-PR",          "Spanish (Puerto Rico)"),
	ES_ES         (0x0C0A, "es-ES",          "Spanish (Spain)"),
	ES_US         (0x540A, "es-US",          "Spanish (United States)"),
	ES_UY         (0x380A, "es-UY",          "Spanish (Uruguay)"),
	ES_VE         (0x200A, "es-VE",          "Spanish (Venezuela)"),
	ZGH           (0x1000, "zgh",            "Standard Moroccan Tamazight"),
	ZGH_TFNG      (0x1000, "zgh-Tfng",       "Standard Moroccan Tamazight (Tifinagh)"),
	ZGH_TFNG_MA   (0x1000, "zgh-Tfng-MA",    "Standard Moroccan Tamazight (Tifinagh, Morocco)"),
	SS            (0x1000, "ss",             "Swati"),
	SS_ZA         (0x1000, "ss-ZA",          "Swati (South Africa)"),
	SS_SZ         (0x1000, "ss-SZ",          "Swati (Swaziland)"),
	SV            (0x001D, "sv",             "Swedish"),
	SV_FI         (0x081D, "sv-FI",          "Swedish (Finland)"),
	SV_SE         (0x041D, "sv-SE",          "Swedish (Sweden)"),
	SV_AX         (0x1000, "sv-AX",          "Swedish (Åland Islands)"),
	SYR           (0x005A, "syr",            "Syriac"),
	SYR_SY        (0x045A, "syr-SY",         "Syriac (Syria)"),
	SHI           (0x1000, "shi",            "Tachelhit"),
	SHI_LATN      (0x1000, "shi-Latn",       "Tachelhit (Latin)"),
	SHI_LATN_MA   (0x1000, "shi-Latn-MA",    "Tachelhit (Latin, Morocco)"),
	SHI_TFNG      (0x1000, "shi-Tfng",       "Tachelhit (Tifinagh)"),
	SHI_TFNG_MA   (0x1000, "shi-Tfng-MA",    "Tachelhit (Tifinagh, Morocco)"),
	DAV           (0x1000, "dav",            "Taita"),
	DAV_KE        (0x1000, "dav-KE",         "Taita (Kenya)"),
	TG            (0x0028, "tg",             "Tajik"),
	TG_CYRL       (0x7C28, "tg-Cyrl",        "Tajik (Cyrillic)"),
	TG_CYRL_TJ    (0x0428, "tg-Cyrl-TJ",     "Tajik (Cyrillic, Tajikistan)"),
	TZM           (0x005F, "tzm",            "Tamazight"),
	TZM_LATN      (0x7C5F, "tzm-Latn",       "Tamazight (Latin)"),
	TZM_LATN_DZ   (0x085F, "tzm-Latn-DZ",    "Tamazight (Latin, Algeria)"),
	TZM_TFNG      (0x785F, "tzm-Tfng",       "Tamazight (Tifinagh)"),
	TA            (0x0049, "ta",             "Tamil"),
	TA_IN         (0x0449, "ta-IN",          "Tamil (India)"),
	TA_MY         (0x1000, "ta-MY",          "Tamil (Malaysia)"),
	TA_SG         (0x1000, "ta-SG",          "Tamil (Singapore)"),
	TA_LK         (0x0849, "ta-LK",          "Tamil (Sri Lanka)"),
	TWQ           (0x1000, "twq",            "Tasawaq"),
	TWQ_NE        (0x1000, "twq-NE",         "Tasawaq (Niger)"),
	TT            (0x0044, "tt",             "Tatar"),
	TT_RU         (0x0444, "tt-RU",          "Tatar (Russia)"),
	TE            (0x004A, "te",             "Telugu"),
	TE_IN         (0x044A, "te-IN",          "Telugu (India)"),
	TEO           (0x1000, "teo",            "Teso"),
	TEO_KE        (0x1000, "teo-KE",         "Teso (Kenya)"),
	TEO_UG        (0x1000, "teo-UG",         "Teso (Uganda)"),
	TH            (0x001E, "th",             "Thai"),
	TH_TH         (0x041E, "th-TH",          "Thai (Thailand)"),
	BO            (0x0051, "bo",             "Tibetan"),
	BO_IN         (0x1000, "bo-IN",          "Tibetan (India)"),
	BO_CN         (0x0451, "bo-CN",          "Tibetan (PRC)"),
	TIG           (0x1000, "tig",            "Tigre"),
	TIG_ER        (0x1000, "tig-ER",         "Tigre (Eritrea)"),
	TI            (0x0073, "ti",             "Tigrinya"),
	TI_ER         (0x0873, "ti-ER",          "Tigrinya (Eritrea)"),
	TI_ET         (0x0473, "ti-ET",          "Tigrinya (Ethiopia)"),
	TO            (0x1000, "to",             "Tongan"),
	TO_TO         (0x1000, "to-TO",          "Tongan (Tonga)"),
	TS            (0x0031, "ts",             "Tsonga"),
	TS_ZA         (0x0431, "ts-ZA",          "Tsonga (South Africa)"),
	TR            (0x001F, "tr",             "Turkish"),
	TR_CY         (0x1000, "tr-CY",          "Turkish (Cyprus)"),
	TR_TR         (0x041F, "tr-TR",          "Turkish (Turkey)"),
	TK            (0x0042, "tk",             "Turkmen"),
	TK_TM         (0x0442, "tk-TM",          "Turkmen (Turkmenistan)"),
	UK            (0x0022, "uk",             "Ukrainian"),
	UK_UA         (0x0422, "uk-UA",          "Ukrainian (Ukraine)"),
	HSB           (0x002E, "hsb",            "Upper Sorbian"),
	HSB_DE        (0x042E, "hsb-DE",         "Upper Sorbian (Germany)"),
	UR            (0x0020, "ur",             "Urdu"),
	UR_IN         (0x0820, "ur-IN",          "Urdu (India)"),
	UR_PK         (0x0420, "ur-PK",          "Urdu (Islamic Republic of Pakistan)"),
	UG            (0x0080, "ug",             "Uyghur"),
	UG_CN         (0x0480, "ug-CN",          "Uyghur (PRC)"),
	UZ            (0x0043, "uz",             "Uzbek"),
	UZ_CYRL       (0x7843, "uz-Cyrl",        "Uzbek (Cyrillic)"),
	UZ_CYRL_UZ    (0x0843, "uz-Cyrl-UZ",     "Uzbek (Cyrillic, Uzbekistan)"),
	UZ_LATN       (0x7C43, "uz-Latn",        "Uzbek (Latin)"),
	UZ_LATN_UZ    (0x0443, "uz-Latn-UZ",     "Uzbek (Latin, Uzbekistan)"),
	UZ_ARAB       (0x1000, "uz-Arab",        "Uzbek (Perso-Arabic)"),
	UZ_ARAB_AF    (0x1000, "uz-Arab-AF",     "Uzbek (Perso-Arabic, Afghanistan)"),
	VAI           (0x1000, "vai",            "Vai"),
	VAI_LATN      (0x1000, "vai-Latn",       "Vai (Latin)"),
	VAI_LATN_LR   (0x1000, "vai-Latn-LR",    "Vai (Latin, Liberia)"),
	VAI_VAII      (0x1000, "vai-Vaii",       "Vai (Vai)"),
	VAI_VAII_LR   (0x1000, "vai-Vaii-LR",    "Vai (Vai, Liberia)"),
	CA_ES_VALENCIA(0x0803, "ca-ES-valencia", "Valencian (Spain)"),
	VE            (0x0033, "ve",             "Venda"),
	VE_ZA         (0x0433, "ve-ZA",          "Venda (South Africa)"),
	VI            (0x002A, "vi",             "Vietnamese"),
	VI_VN         (0x042A, "vi-VN",          "Vietnamese (Vietnam)"),
	VO            (0x1000, "vo",             "Volapük"),
	VO_001        (0x1000, "vo-001",         "Volapük (World)"),
	VUN           (0x1000, "vun",            "Vunjo"),
	VUN_TZ        (0x1000, "vun-TZ",         "Vunjo (Tanzania)"),
	WAE           (0x1000, "wae",            "Walser"),
	WAE_CH        (0x1000, "wae-CH",         "Walser (Switzerland)"),
	CY            (0x0052, "cy",             "Welsh"),
	CY_GB         (0x0452, "cy-GB",          "Welsh (United Kingdom)"),
	WAL           (0x1000, "wal",            "Wolaytta"),
	WAL_ET        (0x1000, "wal-ET",         "Wolaytta (Ethiopia)"),
	WO            (0x0088, "wo",             "Wolof"),
	WO_SN         (0x0488, "wo-SN",          "Wolof (Senegal)"),
	XH            (0x0034, "xh",             "Xhosa"),
	XH_ZA         (0x0434, "xh-ZA",          "Xhosa (South Africa)"),
	YAV           (0x1000, "yav",            "Yangben"),
	YAV_CM        (0x1000, "yav-CM",         "Yangben (Cameroon)"),
	II            (0x0078, "ii",             "Yi"),
	II_CN         (0x0478, "ii-CN",          "Yi (PRC)"),
	YI            (0x003D, "yi",             "Yiddish"),
	YI_001        (0x043D, "yi-001",         "Yiddish (World)"),
	YO            (0x006A, "yo",             "Yoruba"),
	YO_BJ         (0x1000, "yo-BJ",          "Yoruba (Benin)"),
	YO_NG         (0x046A, "yo-NG",          "Yoruba (Nigeria)"),
	DJE           (0x1000, "dje",            "Zarma"),
	DJE_NE        (0x1000, "dje-NE",         "Zarma (Niger)"),
	ZU            (0x0035, "zu",             "Zulu"),
	ZU_ZA         (0x0435, "zu-ZA",          "Zulu (South Africa)");
	
	public final int lcid;
	public final String tag;
	public final String name;
	
	private WinLocale(int lcid, String tag, String name) {
		this.lcid = lcid;
		this.tag = tag;
		this.name = name;
	}
	
	public static WinLocale forTag(String tag, WinLocale def) {
		for (WinLocale locale : values()) {
			if (locale.tag.equalsIgnoreCase(tag)) {
				return locale;
			}
		}
		return def;
	}
	
	public static WinLocale forName(String name, WinLocale def) {
		for (WinLocale locale : values()) {
			if (locale.name.equalsIgnoreCase(name)) {
				return locale;
			}
		}
		return def;
	}
}
