/*
 * Copyright (c) 2018-2024, STMicroelectronics - All Rights Reserved
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef STM32MP2_PWR_H
#define STM32MP2_PWR_H

#include <lib/utils_def.h>

#define PWR_CR1					U(0x00)
#define PWR_CR2					U(0x04)
#define PWR_CR3					U(0x08)
#define PWR_CR4					U(0x0C)
#define PWR_CR5					U(0x10)
#define PWR_CR6					U(0x14)
#define PWR_CR7					U(0x18)
#define PWR_CR8					U(0x1C)
#define PWR_CR9					U(0x20)
#define PWR_CR10				U(0x24)
#define PWR_CR11				U(0x28)
#define PWR_CR12				U(0x2C)
#define PWR_UCPDR				U(0x30)
#define PWR_BDCR1				U(0x38)
#define PWR_BDCR2				U(0x3C)
#define PWR_CPU1CR				U(0x40)
#define PWR_CPU2CR				U(0x44)
#define PWR_CPU3CR				U(0x48)
#define PWR_D1CR				U(0x4C)
#define PWR_D2CR				U(0x50)
#define PWR_D3CR				U(0x54)
#define PWR_WKUPCR1				U(0x60)
#define PWR_WKUPCR2				U(0x64)
#define PWR_WKUPCR3				U(0x68)
#define PWR_WKUPCR4				U(0x6C)
#define PWR_WKUPCR5				U(0x70)
#define PWR_WKUPCR6				U(0x74)
#define PWR_D3WKUPENR				U(0x98)
#define PWR_RSECCFGR				U(0x100)
#define PWR_RPRIVCFGR				U(0x104)
#define PWR_R0CIDCFGR				U(0x108)
#define PWR_R1CIDCFGR				U(0x10C)
#define PWR_R2CIDCFGR				U(0x110)
#define PWR_R3CIDCFGR				U(0x114)
#define PWR_R4CIDCFGR				U(0x118)
#define PWR_R5CIDCFGR				U(0x11C)
#define PWR_R6CIDCFGR				U(0x120)
#define PWR_WIOSECCFGR				U(0x180)
#define PWR_WIOPRIVCFGR				U(0x184)
#define PWR_WIO1CIDCFGR				U(0x188)
#define PWR_WIO1SEMCR				U(0x18C)
#define PWR_WIO2CIDCFGR				U(0x190)
#define PWR_WIO2SEMCR				U(0x194)
#define PWR_WIO3CIDCFGR				U(0x198)
#define PWR_WIO3SEMCR				U(0x19C)
#define PWR_WIO4CIDCFGR				U(0x1A0)
#define PWR_WIO4SEMCR				U(0x1A4)
#define PWR_WIO5CIDCFGR				U(0x1A8)
#define PWR_WIO5SEMCR				U(0x1AC)
#define PWR_WIO6CIDCFGR				U(0x1B0)
#define PWR_WIO6SEMCR				U(0x1B4)
#define PWR_CPU1D1SR				U(0x200)
#define PWR_CPU2D2SR				U(0x204)
#define PWR_CPU3D3SR				U(0x208)
#define PWR_DBGR				U(0x308)
#define PWR_VERR				U(0x3F4)
#define PWR_IPIDR				U(0x3F8)
#define PWR_SIDR				U(0x3FC)

/* PWR_CR1 register fields */
#define PWR_CR1_VDDIO3VMEN			BIT_32(0)
#define PWR_CR1_VDDIO4VMEN			BIT_32(1)
#define PWR_CR1_USB33VMEN			BIT_32(2)
#define PWR_CR1_UCPDVMEN			BIT_32(3)
#define PWR_CR1_AVMEN				BIT_32(4)
#define PWR_CR1_VDDIO3SV			BIT_32(8)
#define PWR_CR1_VDDIO4SV			BIT_32(9)
#define PWR_CR1_USB33SV				BIT_32(10)
#define PWR_CR1_UCPDSV				BIT_32(11)
#define PWR_CR1_ASV				BIT_32(12)
#define PWR_CR1_VDDIO3RDY			BIT_32(16)
#define PWR_CR1_VDDIO4RDY			BIT_32(17)
#define PWR_CR1_USB33RDY			BIT_32(18)
#define PWR_CR1_UCPDRDY				BIT_32(19)
#define PWR_CR1_ARDY				BIT_32(20)
#define PWR_CR1_VDDIOVRSEL			BIT_32(24)
#define PWR_CR1_VDDIO3VRSEL			BIT_32(25)
#define PWR_CR1_VDDIO4VRSEL			BIT_32(26)
#define PWR_CR1_GPVMO				BIT_32(31)

/* PWR_CR2 register fields */
#define PWR_CR2_MONEN				BIT_32(0)
#define PWR_CR2_VBATL				BIT_32(8)
#define PWR_CR2_VBATH				BIT_32(9)
#define PWR_CR2_TEMPL				BIT_32(10)
#define PWR_CR2_TEMPH				BIT_32(11)

/* PWR_CR3 register fields */
#define PWR_CR3_PVDEN				BIT_32(0)
#define PWR_CR3_PVDO				BIT_32(8)

/* PWR_CR5 register fields */
#define PWR_CR5_VCOREMONEN			BIT_32(0)
#define PWR_CR5_VCOREL				BIT_32(8)
#define PWR_CR5_VCOREH				BIT_32(9)

/* PWR_CR6 register fields */
#define PWR_CR6_VCPUMONEN			BIT_32(0)
#define PWR_CR6_VCPULLS				BIT_32(4)
#define PWR_CR6_VCPUL				BIT_32(8)
#define PWR_CR6_VCPUH				BIT_32(9)

/* PWR_CR7 register fields */
#define PWR_CR7_VDDIO2VMEN			BIT_32(0)
#define PWR_CR7_VDDIO2SV			BIT_32(8)
#define PWR_CR7_VDDIO2RDY			BIT_32(16)
#define PWR_CR7_VDDIO2VRSEL			BIT_32(24)
#define PWR_CR7_VDDIO2VRSTBY			BIT_32(25)

/* PWR_CR8 register fields */
#define PWR_CR8_VDDIO1VMEN			BIT_32(0)
#define PWR_CR8_VDDIO1SV			BIT_32(8)
#define PWR_CR8_VDDIO1RDY			BIT_32(16)
#define PWR_CR8_VDDIO1VRSEL			BIT_32(24)
#define PWR_CR8_VDDIO1VRSTBY			BIT_32(25)

/* PWR_CR9 register fields */
#define PWR_CR9_BKPRBSEN			BIT_32(0)
#define PWR_CR9_LPR1BSEN			BIT_32(4)

/* PWR_CR10 register fields */
#define PWR_CR10_RETRBSEN_MASK			GENMASK_32(1, 0)
#define PWR_CR10_RETRBSEN_SHIFT			U(0)

/* PWR_CR11 register fields */
#define PWR_CR11_DDRRETDIS			BIT_32(0)

/* PWR_CR12 register fields */
#define PWR_CR12_GPUVMEN			BIT_32(0)
#define PWR_CR12_GPULVTEN			BIT_32(1)
#define PWR_CR12_GPUSV				BIT_32(8)
#define PWR_CR12_VDDGPURDY			BIT_32(16)

/* PWR_UCPDR register fields */
#define PWR_UCPDR_UCPD_DBDIS			BIT_32(0)
#define PWR_UCPDR_UCPD_STBY			BIT_32(1)

/* PWR_BDCR1 register fields */
#define PWR_BDCR1_DBD3P				BIT_32(0)

/* PWR_BDCR2 register fields */
#define PWR_BDCR2_DBP				BIT_32(0)

/* PWR_CPU1CR register fields */
#define PWR_CPU1CR_PDDS_D2			BIT_32(0)
#define PWR_CPU1CR_PDDS_D1			BIT_32(1)
#define PWR_CPU1CR_VBF				BIT_32(4)
#define PWR_CPU1CR_STOPF			BIT_32(5)
#define PWR_CPU1CR_SBF				BIT_32(6)
#define PWR_CPU1CR_SBF_D1			BIT_32(7)
#define PWR_CPU1CR_SBF_D3			BIT_32(8)
#define PWR_CPU1CR_CSSF				BIT_32(9)
#define PWR_CPU1CR_STANDBYWFIL2			BIT_32(15)
#define PWR_CPU1CR_LPDS_D1			BIT_32(16)
#define PWR_CPU1CR_LVDS_D1			BIT_32(17)

/* PWR_CPU2CR register fields */
#define PWR_CPU2CR_PDDS_D2			BIT_32(0)
#define PWR_CPU2CR_VBF				BIT_32(4)
#define PWR_CPU2CR_STOPF			BIT_32(5)
#define PWR_CPU2CR_SBF				BIT_32(6)
#define PWR_CPU2CR_SBF_D2			BIT_32(7)
#define PWR_CPU2CR_SBF_D3			BIT_32(8)
#define PWR_CPU2CR_CSSF				BIT_32(9)
#define PWR_CPU2CR_DEEPSLEEP			BIT_32(15)
#define PWR_CPU2CR_LPDS_D2			BIT_32(16)
#define PWR_CPU2CR_LVDS_D2			BIT_32(17)

/* PWR_CPU3CR register fields */
#define PWR_CPU3CR_VBF				BIT_32(4)
#define PWR_CPU3CR_SBF_D3			BIT_32(8)
#define PWR_CPU3CR_CSSF				BIT_32(9)
#define PWR_CPU3CR_DEEPSLEEP			BIT_32(15)

/* PWR_D1CR register fields */
#define PWR_D1CR_LPCFG_D1			BIT_32(0)
#define PWR_D1CR_POPL_D1_MASK			GENMASK_32(12, 8)
#define PWR_D1CR_POPL_D1_SHIFT			U(8)

/* PWR_D2CR register fields */
#define PWR_D2CR_LPCFG_D2			BIT_32(0)
#define PWR_D2CR_POPL_D2_MASK			GENMASK_32(12, 8)
#define PWR_D2CR_POPL_D2_SHIFT			U(8)
#define PWR_D2CR_LPLVDLY_D2_MASK		GENMASK_32(18, 16)
#define PWR_D2CR_LPLVDLY_D2_SHIFT		U(16)
#define PWR_D2CR_PODH_D2_MASK			GENMASK_32(27, 24)
#define PWR_D2CR_PODH_D2_SHIFT			U(24)

/* PWR_D3CR register fields */
#define PWR_D3CR_PDDS_D3			BIT_32(0)
#define PWR_D3CR_D3RDY				BIT_32(31)

/* PWR_WKUPCR1 register fields */
#define PWR_WKUPCR1_WKUPC			BIT_32(0)
#define PWR_WKUPCR1_WKUPP			BIT_32(8)
#define PWR_WKUPCR1_WKUPPUPD_MASK		GENMASK_32(13, 12)
#define PWR_WKUPCR1_WKUPPUPD_SHIFT		U(12)
#define PWR_WKUPCR1_WKUPENCPU1			BIT_32(16)
#define PWR_WKUPCR1_WKUPENCPU2			BIT_32(17)
#define PWR_WKUPCR1_WKUPF			BIT_32(31)

/* PWR_WKUPCR2 register fields */
#define PWR_WKUPCR2_WKUPC			BIT_32(0)
#define PWR_WKUPCR2_WKUPP			BIT_32(8)
#define PWR_WKUPCR2_WKUPPUPD_MASK		GENMASK_32(13, 12)
#define PWR_WKUPCR2_WKUPPUPD_SHIFT		U(12)
#define PWR_WKUPCR2_WKUPENCPU1			BIT_32(16)
#define PWR_WKUPCR2_WKUPENCPU2			BIT_32(17)
#define PWR_WKUPCR2_WKUPF			BIT_32(31)

/* PWR_WKUPCR3 register fields */
#define PWR_WKUPCR3_WKUPC			BIT_32(0)
#define PWR_WKUPCR3_WKUPP			BIT_32(8)
#define PWR_WKUPCR3_WKUPPUPD_MASK		GENMASK_32(13, 12)
#define PWR_WKUPCR3_WKUPPUPD_SHIFT		U(12)
#define PWR_WKUPCR3_WKUPENCPU1			BIT_32(16)
#define PWR_WKUPCR3_WKUPENCPU2			BIT_32(17)
#define PWR_WKUPCR3_WKUPF			BIT_32(31)

/* PWR_WKUPCR4 register fields */
#define PWR_WKUPCR4_WKUPC			BIT_32(0)
#define PWR_WKUPCR4_WKUPP			BIT_32(8)
#define PWR_WKUPCR4_WKUPPUPD_MASK		GENMASK_32(13, 12)
#define PWR_WKUPCR4_WKUPPUPD_SHIFT		U(12)
#define PWR_WKUPCR4_WKUPENCPU1			BIT_32(16)
#define PWR_WKUPCR4_WKUPENCPU2			BIT_32(17)
#define PWR_WKUPCR4_WKUPF			BIT_32(31)

/* PWR_WKUPCR5 register fields */
#define PWR_WKUPCR5_WKUPC			BIT_32(0)
#define PWR_WKUPCR5_WKUPP			BIT_32(8)
#define PWR_WKUPCR5_WKUPPUPD_MASK		GENMASK_32(13, 12)
#define PWR_WKUPCR5_WKUPPUPD_SHIFT		U(12)
#define PWR_WKUPCR5_WKUPENCPU1			BIT_32(16)
#define PWR_WKUPCR5_WKUPENCPU2			BIT_32(17)
#define PWR_WKUPCR5_WKUPF			BIT_32(31)

/* PWR_WKUPCR6 register fields */
#define PWR_WKUPCR6_WKUPC			BIT_32(0)
#define PWR_WKUPCR6_WKUPP			BIT_32(8)
#define PWR_WKUPCR6_WKUPPUPD_MASK		GENMASK_32(13, 12)
#define PWR_WKUPCR6_WKUPPUPD_SHIFT		U(12)
#define PWR_WKUPCR6_WKUPENCPU1			BIT_32(16)
#define PWR_WKUPCR6_WKUPENCPU2			BIT_32(17)
#define PWR_WKUPCR6_WKUPF			BIT_32(31)

/* PWR_D3WKUPENR register fields */
#define PWR_D3WKUPENR_TAMP_WKUPEN_D3		BIT_32(0)

/* PWR_RSECCFGR register fields */
#define PWR_RSECCFGR_RSEC0			BIT_32(0)
#define PWR_RSECCFGR_RSEC1			BIT_32(1)
#define PWR_RSECCFGR_RSEC2			BIT_32(2)
#define PWR_RSECCFGR_RSEC3			BIT_32(3)
#define PWR_RSECCFGR_RSEC4			BIT_32(4)
#define PWR_RSECCFGR_RSEC5			BIT_32(5)
#define PWR_RSECCFGR_RSEC6			BIT_32(6)

/* PWR_RPRIVCFGR register fields */
#define PWR_RPRIVCFGR_RPRIV0			BIT_32(0)
#define PWR_RPRIVCFGR_RPRIV1			BIT_32(1)
#define PWR_RPRIVCFGR_RPRIV2			BIT_32(2)
#define PWR_RPRIVCFGR_RPRIV3			BIT_32(3)
#define PWR_RPRIVCFGR_RPRIV4			BIT_32(4)
#define PWR_RPRIVCFGR_RPRIV5			BIT_32(5)
#define PWR_RPRIVCFGR_RPRIV6			BIT_32(6)

/* PWR_R0CIDCFGR register fields */
#define PWR_R0CIDCFGR_CFEN			BIT_32(0)
#define PWR_R0CIDCFGR_SCID_MASK			GENMASK_32(6, 4)
#define PWR_R0CIDCFGR_SCID_SHIFT		U(4)

/* PWR_R1CIDCFGR register fields */
#define PWR_R1CIDCFGR_CFEN			BIT_32(0)
#define PWR_R1CIDCFGR_SCID_MASK			GENMASK_32(6, 4)
#define PWR_R1CIDCFGR_SCID_SHIFT		U(4)

/* PWR_R2CIDCFGR register fields */
#define PWR_R2CIDCFGR_CFEN			BIT_32(0)
#define PWR_R2CIDCFGR_SCID_MASK			GENMASK_32(6, 4)
#define PWR_R2CIDCFGR_SCID_SHIFT		U(4)

/* PWR_R3CIDCFGR register fields */
#define PWR_R3CIDCFGR_CFEN			BIT_32(0)
#define PWR_R3CIDCFGR_SCID_MASK			GENMASK_32(6, 4)
#define PWR_R3CIDCFGR_SCID_SHIFT		U(4)

/* PWR_R4CIDCFGR register fields */
#define PWR_R4CIDCFGR_CFEN			BIT_32(0)
#define PWR_R4CIDCFGR_SCID_MASK			GENMASK_32(6, 4)
#define PWR_R4CIDCFGR_SCID_SHIFT		U(4)

/* PWR_R5CIDCFGR register fields */
#define PWR_R5CIDCFGR_CFEN			BIT_32(0)
#define PWR_R5CIDCFGR_SCID_MASK			GENMASK_32(6, 4)
#define PWR_R5CIDCFGR_SCID_SHIFT		U(4)

/* PWR_R6CIDCFGR register fields */
#define PWR_R6CIDCFGR_CFEN			BIT_32(0)
#define PWR_R6CIDCFGR_SCID_MASK			GENMASK_32(6, 4)
#define PWR_R6CIDCFGR_SCID_SHIFT		U(4)

/* PWR_WIOSECCFGR register fields */
#define PWR_WIOSECCFGR_WIOSEC1			BIT_32(0)
#define PWR_WIOSECCFGR_WIOSEC2			BIT_32(1)
#define PWR_WIOSECCFGR_WIOSEC3			BIT_32(2)
#define PWR_WIOSECCFGR_WIOSEC4			BIT_32(3)
#define PWR_WIOSECCFGR_WIOSEC5			BIT_32(4)
#define PWR_WIOSECCFGR_WIOSEC6			BIT_32(5)

/* PWR_WIOPRIVCFGR register fields */
#define PWR_WIOPRIVCFGR_WIOPRIV1		BIT_32(0)
#define PWR_WIOPRIVCFGR_WIOPRIV2		BIT_32(1)
#define PWR_WIOPRIVCFGR_WIOPRIV3		BIT_32(2)
#define PWR_WIOPRIVCFGR_WIOPRIV4		BIT_32(3)
#define PWR_WIOPRIVCFGR_WIOPRIV5		BIT_32(4)
#define PWR_WIOPRIVCFGR_WIOPRIV6		BIT_32(5)

/* PWR_WIO1CIDCFGR register fields */
#define PWR_WIO1CIDCFGR_CFEN			BIT_32(0)
#define PWR_WIO1CIDCFGR_SEM_EN			BIT_32(1)
#define PWR_WIO1CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define PWR_WIO1CIDCFGR_SCID_SHIFT		U(4)
#define PWR_WIO1CIDCFGR_SEMWLC0			BIT_32(16)
#define PWR_WIO1CIDCFGR_SEMWLC1			BIT_32(17)
#define PWR_WIO1CIDCFGR_SEMWLC2			BIT_32(18)
#define PWR_WIO1CIDCFGR_SEMWLC3			BIT_32(19)
#define PWR_WIO1CIDCFGR_SEMWLC4			BIT_32(20)
#define PWR_WIO1CIDCFGR_SEMWLC5			BIT_32(21)
#define PWR_WIO1CIDCFGR_SEMWLC6			BIT_32(22)
#define PWR_WIO1CIDCFGR_SEMWLC7			BIT_32(23)

/* PWR_WIO1SEMCR register fields */
#define PWR_WIO1SEMCR_SEM_MUTEX			BIT_32(0)
#define PWR_WIO1SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define PWR_WIO1SEMCR_SEMCID_SHIFT		U(4)

/* PWR_WIO2CIDCFGR register fields */
#define PWR_WIO2CIDCFGR_CFEN			BIT_32(0)
#define PWR_WIO2CIDCFGR_SEM_EN			BIT_32(1)
#define PWR_WIO2CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define PWR_WIO2CIDCFGR_SCID_SHIFT		U(4)
#define PWR_WIO2CIDCFGR_SEMWLC0			BIT_32(16)
#define PWR_WIO2CIDCFGR_SEMWLC1			BIT_32(17)
#define PWR_WIO2CIDCFGR_SEMWLC2			BIT_32(18)
#define PWR_WIO2CIDCFGR_SEMWLC3			BIT_32(19)
#define PWR_WIO2CIDCFGR_SEMWLC4			BIT_32(20)
#define PWR_WIO2CIDCFGR_SEMWLC5			BIT_32(21)
#define PWR_WIO2CIDCFGR_SEMWLC6			BIT_32(22)
#define PWR_WIO2CIDCFGR_SEMWLC7			BIT_32(23)

/* PWR_WIO2SEMCR register fields */
#define PWR_WIO2SEMCR_SEM_MUTEX			BIT_32(0)
#define PWR_WIO2SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define PWR_WIO2SEMCR_SEMCID_SHIFT		U(4)

/* PWR_WIO3CIDCFGR register fields */
#define PWR_WIO3CIDCFGR_CFEN			BIT_32(0)
#define PWR_WIO3CIDCFGR_SEM_EN			BIT_32(1)
#define PWR_WIO3CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define PWR_WIO3CIDCFGR_SCID_SHIFT		U(4)
#define PWR_WIO3CIDCFGR_SEMWLC0			BIT_32(16)
#define PWR_WIO3CIDCFGR_SEMWLC1			BIT_32(17)
#define PWR_WIO3CIDCFGR_SEMWLC2			BIT_32(18)
#define PWR_WIO3CIDCFGR_SEMWLC3			BIT_32(19)
#define PWR_WIO3CIDCFGR_SEMWLC4			BIT_32(20)
#define PWR_WIO3CIDCFGR_SEMWLC5			BIT_32(21)
#define PWR_WIO3CIDCFGR_SEMWLC6			BIT_32(22)
#define PWR_WIO3CIDCFGR_SEMWLC7			BIT_32(23)

/* PWR_WIO3SEMCR register fields */
#define PWR_WIO3SEMCR_SEM_MUTEX			BIT_32(0)
#define PWR_WIO3SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define PWR_WIO3SEMCR_SEMCID_SHIFT		U(4)

/* PWR_WIO4CIDCFGR register fields */
#define PWR_WIO4CIDCFGR_CFEN			BIT_32(0)
#define PWR_WIO4CIDCFGR_SEM_EN			BIT_32(1)
#define PWR_WIO4CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define PWR_WIO4CIDCFGR_SCID_SHIFT		U(4)
#define PWR_WIO4CIDCFGR_SEMWLC0			BIT_32(16)
#define PWR_WIO4CIDCFGR_SEMWLC1			BIT_32(17)
#define PWR_WIO4CIDCFGR_SEMWLC2			BIT_32(18)
#define PWR_WIO4CIDCFGR_SEMWLC3			BIT_32(19)
#define PWR_WIO4CIDCFGR_SEMWLC4			BIT_32(20)
#define PWR_WIO4CIDCFGR_SEMWLC5			BIT_32(21)
#define PWR_WIO4CIDCFGR_SEMWLC6			BIT_32(22)
#define PWR_WIO4CIDCFGR_SEMWLC7			BIT_32(23)

/* PWR_WIO4SEMCR register fields */
#define PWR_WIO4SEMCR_SEM_MUTEX			BIT_32(0)
#define PWR_WIO4SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define PWR_WIO4SEMCR_SEMCID_SHIFT		U(4)

/* PWR_WIO5CIDCFGR register fields */
#define PWR_WIO5CIDCFGR_CFEN			BIT_32(0)
#define PWR_WIO5CIDCFGR_SEM_EN			BIT_32(1)
#define PWR_WIO5CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define PWR_WIO5CIDCFGR_SCID_SHIFT		U(4)
#define PWR_WIO5CIDCFGR_SEMWLC0			BIT_32(16)
#define PWR_WIO5CIDCFGR_SEMWLC1			BIT_32(17)
#define PWR_WIO5CIDCFGR_SEMWLC2			BIT_32(18)
#define PWR_WIO5CIDCFGR_SEMWLC3			BIT_32(19)
#define PWR_WIO5CIDCFGR_SEMWLC4			BIT_32(20)
#define PWR_WIO5CIDCFGR_SEMWLC5			BIT_32(21)
#define PWR_WIO5CIDCFGR_SEMWLC6			BIT_32(22)
#define PWR_WIO5CIDCFGR_SEMWLC7			BIT_32(23)

/* PWR_WIO5SEMCR register fields */
#define PWR_WIO5SEMCR_SEM_MUTEX			BIT_32(0)
#define PWR_WIO5SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define PWR_WIO5SEMCR_SEMCID_SHIFT		U(4)

/* PWR_WIO6CIDCFGR register fields */
#define PWR_WIO6CIDCFGR_CFEN			BIT_32(0)
#define PWR_WIO6CIDCFGR_SEM_EN			BIT_32(1)
#define PWR_WIO6CIDCFGR_SCID_MASK		GENMASK_32(6, 4)
#define PWR_WIO6CIDCFGR_SCID_SHIFT		U(4)
#define PWR_WIO6CIDCFGR_SEMWLC0			BIT_32(16)
#define PWR_WIO6CIDCFGR_SEMWLC1			BIT_32(17)
#define PWR_WIO6CIDCFGR_SEMWLC2			BIT_32(18)
#define PWR_WIO6CIDCFGR_SEMWLC3			BIT_32(19)
#define PWR_WIO6CIDCFGR_SEMWLC4			BIT_32(20)
#define PWR_WIO6CIDCFGR_SEMWLC5			BIT_32(21)
#define PWR_WIO6CIDCFGR_SEMWLC6			BIT_32(22)
#define PWR_WIO6CIDCFGR_SEMWLC7			BIT_32(23)

/* PWR_WIO6SEMCR register fields */
#define PWR_WIO6SEMCR_SEM_MUTEX			BIT_32(0)
#define PWR_WIO6SEMCR_SEMCID_MASK		GENMASK_32(6, 4)
#define PWR_WIO6SEMCR_SEMCID_SHIFT		U(4)

/* PWR_CPU1D1SR register fields */
#define PWR_CPU1D1SR_HOLD_BOOT			BIT_32(0)
#define PWR_CPU1D1SR_CSTATE_MASK		GENMASK_32(3, 2)
#define PWR_CPU1D1SR_CSTATE_SHIFT		U(2)
#define PWR_CPU1D1SR_DSTATE_MASK		GENMASK_32(10, 8)
#define PWR_CPU1D1SR_DSTATE_SHIFT		U(8)

/* PWR_CPU2D2SR register fields */
#define PWR_CPU2D2SR_HOLD_BOOT			BIT_32(0)
#define PWR_CPU2D2SR_WFBEN			BIT_32(1)
#define PWR_CPU2D2SR_CSTATE_MASK		GENMASK_32(3, 2)
#define PWR_CPU2D2SR_CSTATE_SHIFT		U(2)
#define PWR_CPU2D2SR_DSTATE_MASK		GENMASK_32(10, 8)
#define PWR_CPU2D2SR_DSTATE_SHIFT		U(8)

/* PWR_CPU3D3SR register fields */
#define PWR_CPU3D3SR_CSTATE_MASK		GENMASK_32(3, 2)
#define PWR_CPU3D3SR_CSTATE_SHIFT		U(2)
#define PWR_CPU3D3SR_DSTATE_MASK		GENMASK_32(10, 8)
#define PWR_CPU3D3SR_DSTATE_SHIFT		U(8)

/* PWR_DBGR register fields */
#define PWR_DBGR_FD3S				BIT_32(0)
#define PWR_DBGR_VDDIOKRETRAM			BIT_32(16)
#define PWR_DBGR_VDDIOKBKPRAM			BIT_32(17)
#define PWR_DBGR_VDDIOKD3			BIT_32(18)
#define PWR_DBGR_VDDIOKLPSRAM1			BIT_32(19)

/* PWR_VERR register fields */
#define PWR_VERR_MINREV_MASK			GENMASK_32(3, 0)
#define PWR_VERR_MINREV_SHIFT			U(0)
#define PWR_VERR_MAJREV_MASK			GENMASK_32(7, 4)
#define PWR_VERR_MAJREV_SHIFT			U(4)

#endif /* STM32MP2_PWR_H */
