#include <locale.h>
#undef _DEFAULT_SOURCE
#include "src/util.c"

int
main (int    argc,
      char **argv)
{
        guint i;

        setlocale (LC_ALL, "C.UTF-8");

        if (argc > 1) {
                for (i = 1; i < argc; i++) {
                        g_autofree char *language = NULL;
                        g_autofree char *territory = NULL;
                        g_autofree char *codeset = NULL;
                        g_autofree char *modifier = NULL;

                        explode_locale (argv[i],
                                        &language,
                                        &territory,
                                        &codeset,
                                        &modifier);

                        g_print ("Locale: %s\n", argv[i]);
                        g_print ("\tlanguage: %s\n", language);
                        g_print ("\tterritory: %s\n", territory);
                        g_print ("\tcodeset: %s\n", codeset);
                        g_print ("\tmodifier: %s\n", modifier);
                        g_print ("\n");
                }
                return 0;
        }

        struct
        {
                const char *locale;
                const char *lang;
                const char *territory;
                const char *codeset;
                const char *modifier;
        } tests[] = {
                { "en",                     "en",  NULL, NULL,        NULL    },
                { "en_GB",                  "en",  "GB", NULL,        NULL    },
                { "en_GB.UTF-8",            "en",  "GB", "UTF-8",     NULL    },
                { "en_GB.UTF-8@latin",      "en",  "GB", "UTF-8",     "latin" },
                { "en_GB@latin",            "en",  "GB", NULL,        "latin" },
                { "en_GB.iso8859-1",        "en",  "GB", "iso8859-1", NULL    },
                { "1234",                   NULL,  NULL, NULL,        NULL    },
                { "Test Language 1",        NULL,  NULL, NULL,        NULL    },
                { "en_GB.UTF-8@latin WOOP", NULL,  NULL, NULL,        NULL    },
                { "ace",                    "ace", NULL, NULL,        NULL    },
                { "be@latin",               "be",  NULL, NULL,        "latin" },
                { "ca.us-ascii",            "ca",  NULL, "us-ascii",  NULL    },
                { "cs.cp1250",              "cs",  NULL, "cp1250",    NULL    },
                { "_GB.UTF-8",              NULL,  NULL, NULL,        NULL    },
                /* qaa-qtz is a fake locale erroneously generated by some
                 * downstream distributions because of a mistaken entry
                 * shipped in iso-codes. The ISO 639.2 registration authority
                 * intended all codes starting with "q" less than "qu" to be
                 * reserved for local use. Ensure the fake locale isn't
                 * allowed. */
                { "qaa-qtz",                NULL,  NULL, NULL,        NULL    },
                { "ru_RU.KOI8-R",           "ru",  "RU", "KOI8-R",    NULL    },
                { "",                       NULL,  NULL, NULL,        NULL    },
                { NULL },
        };

        for (i = 0; tests[i].locale != NULL; i++) {
                guint mask = 0;
                g_autofree char *language = NULL;
                g_autofree char *territory = NULL;
                g_autofree char *codeset = NULL;
                g_autofree char *modifier = NULL;
                int verify = 0;

                g_test_message ("Testing locale %s", tests[i].locale);

                mask = explode_locale (tests[i].locale,
                                       &language,
                                       &territory,
                                       &codeset,
                                       &modifier);
                g_assert_cmpstr (language, ==, tests[i].lang);
                g_assert_cmpstr (territory, ==, tests[i].territory);
                g_assert_cmpstr (codeset, ==, tests[i].codeset);
                g_assert_cmpstr (modifier, ==, tests[i].modifier);

                verify = verify_xpg_locale (tests[i].locale) ? 1 : 0;
                g_assert_cmpint (verify, ==, language != NULL);
                g_assert_cmpint (!!mask, ==, verify);
        }

        g_assert_cmpint (!!verify_locale (""), ==, TRUE);

        return 0;
}
