var g_CurrentModifiers = {};

function deriveModifications(techList)
{
	let techData = [];
	for (let techName of techList)
		techData.push(GetTechnologyBasicDataHelper(loadTechData(techName), g_SelectedCiv));

	return DeriveModificationsFromTechnologies(techData);
}

/**
 * Provided with an array containing basic information about possible
 * upgrades, such as that generated by globalscript's GetTemplateDataHelper,
 * this function loads the actual template data of the upgrades, overwrites
 * certain values within, then passes an array containing the template data
 * back to caller.
 */
function getActualUpgradeData(upgradesInfo)
{
	let newUpgrades = [];
	for (let upgrade of upgradesInfo)
	{
		upgrade.entity = upgrade.entity.replace(/\{(civ|native)\}/g, g_SelectedCiv);

		let data = GetTemplateDataHelper(loadTemplate(upgrade.entity), null, g_AuraData, g_ResourceData, g_DamageTypes);
		data.name.internal = upgrade.entity;
		data.cost = upgrade.cost;
		data.icon = upgrade.icon || data.icon;
		data.tooltip = upgrade.tooltip || data.tooltip;
		data.requiredTechnology = upgrade.requiredTechnology || data.requiredTechnology;

		newUpgrades.push(data);
	}
	return newUpgrades;
}

/**
 * Determines and returns the phase in which a given technology can be
 * first researched. Works recursively through the given tech's
 * pre-requisite and superseded techs if necessary.
 *
 * @param {string} techName - The Technology's name
 * @return The name of the phase the technology belongs to, or false if
 *         the current civ can't research this tech
 */
function getPhaseOfTechnology(techName)
{
	let phaseIdx = -1;

	if (basename(techName).startsWith("phase"))
	{
		if (!g_ParsedData.phases[techName].reqs)
			return false;

		phaseIdx = g_ParsedData.phaseList.indexOf(getActualPhase(techName));
		if (phaseIdx > 0)
			return g_ParsedData.phaseList[phaseIdx - 1];
	}

	if (!g_ParsedData.techs[g_SelectedCiv][techName])
	{
		let techData = loadTechnology(techName);
		g_ParsedData.techs[g_SelectedCiv][techName] = techData;
		warn("The \"" + techName + "\" technology is not researchable in any structure buildable by the " +
			g_SelectedCiv + " civilisation, but is required by something that this civ can research, train or build!");
	}

	let techReqs = g_ParsedData.techs[g_SelectedCiv][techName].reqs;
	if (!techReqs)
		return false;

	for (let option of techReqs)
		if (option.techs)
			for (let tech of option.techs)
			{
				if (basename(tech).startsWith("phase"))
					return tech;
				if (basename(tech).startsWith("pair"))
					continue;
				phaseIdx = Math.max(phaseIdx, g_ParsedData.phaseList.indexOf(getPhaseOfTechnology(tech)));
			}
	return g_ParsedData.phaseList[phaseIdx] || false;
}

/**
 * Returns the actual phase a certain phase tech represents or stands in for.
 *
 * For example, passing `phase_city_athen` would result in `phase_city`.
 *
 * @param {string} phaseName
 * @return {string}
 */
function getActualPhase(phaseName)
{
	if (g_ParsedData.phases[phaseName])
		return g_ParsedData.phases[phaseName].actualPhase;

	warn("Unrecognised phase (" + phaseName + ")");
	return g_ParsedData.phaseList[0];
}

/**
 * Returns the required phase of a given unit or structure.
 *
 * @param {object} template
 * @return {string}
 */
function getPhaseOfTemplate(template)
{
	if (!template.requiredTechnology)
		return g_ParsedData.phaseList[0];

	if (basename(template.requiredTechnology).startsWith("phase"))
		return getActualPhase(template.requiredTechnology);

	return getPhaseOfTechnology(template.requiredTechnology);
}

/**
 * This is needed because getEntityCostTooltip in tooltip.js needs to get
 * the template data of the different wallSet pieces. In the session this
 * function does some caching, but here we do that in loadTemplate already.
 */
function GetTemplateData(templateName)
{
	var template = loadTemplate(templateName);
	return GetTemplateDataHelper(template, null, g_AuraData, g_ResourceData, g_DamageTypes, g_CurrentModifiers);
}

function isPairTech(technologyCode)
{
	return !!loadTechData(technologyCode).top;
}

function mergeRequirements(reqsA, reqsB)
{
	if (reqsA === false || reqsB === false)
		return false;

	let finalReqs = clone(reqsA);

	for (let option of reqsB)
		for (let type in option)
			for (let opt in finalReqs)
			{
				if (!finalReqs[opt][type])
					finalReqs[opt][type] = [];
				finalReqs[opt][type] = finalReqs[opt][type].concat(option[type]);
			}

	return finalReqs;
}
