/*
 * Decompiled with CFR 0.152.
 */
package hughai.persistence;

import hughai.CSAI;
import hughai.PlayerObjects;
import hughai.VoiceCommandHandler;
import hughai.mapping.Maps;
import hughai.utils.LogFile;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class HeightMapPersistence {
    public String filename = "heightmap.bmp";
    LogFile logfile;
    CSAI CSAI;
    Maps maps;

    HeightMapPersistence(PlayerObjects playerObjects) {
        this.logfile = playerObjects.getLogFile();
        this.CSAI = playerObjects.getCSAI();
        this.maps = playerObjects.getMaps();
        this.logfile.WriteLine("HeightMapPersistence");
        SaveHandler saveHandler = new SaveHandler();
        this.logfile.WriteLine("csai == null? " + (this.CSAI == null));
        this.logfile.WriteLine("handler == null? " + (saveHandler == null));
        this.CSAI.RegisterVoiceCommand("saveheightmap", saveHandler);
    }

    void Save(String string, float[][] fArray) {
        int n = fArray.length;
        int n2 = fArray[0].length;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics graphics = bufferedImage.getGraphics();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n3 = (int)(fArray[i][j] * 255.0f);
                graphics.setColor(new Color(n3, n3, n3));
                graphics.drawRect(i, j, 1, 1);
            }
        }
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", new File(string));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public class SaveHandler
    implements VoiceCommandHandler {
        @Override
        public void commandReceived(String string, String[] stringArray, int n) {
        }
    }
}

