/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.jdbc;

import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftState;

class BooleanTypeUtil {
    private BooleanTypeUtil() {
    }

    static boolean castToBoolean(Object in) throws RedshiftException {
        if (in instanceof Boolean) {
            return (Boolean)in;
        }
        if (in instanceof String) {
            return BooleanTypeUtil.fromString((String)in);
        }
        if (in instanceof Character) {
            return BooleanTypeUtil.fromCharacter((Character)in);
        }
        if (in instanceof Number) {
            return BooleanTypeUtil.fromNumber((Number)in);
        }
        throw new RedshiftException("Cannot cast to boolean", RedshiftState.CANNOT_COERCE);
    }

    private static boolean fromString(String strval) throws RedshiftException {
        String val = strval.trim();
        if ("1".equals(val) || "1.0".equals(val) || "true".equalsIgnoreCase(val) || "t".equalsIgnoreCase(val) || "yes".equalsIgnoreCase(val) || "y".equalsIgnoreCase(val) || "on".equalsIgnoreCase(val)) {
            return true;
        }
        if ("0".equals(val) || "0.0".equals(val) || "false".equalsIgnoreCase(val) || "f".equalsIgnoreCase(val) || "no".equalsIgnoreCase(val) || "n".equalsIgnoreCase(val) || "off".equalsIgnoreCase(val)) {
            return false;
        }
        try {
            return !val.equalsIgnoreCase("false") && !val.equals("0") && !val.equals("0.0") && !val.equalsIgnoreCase("f");
        }
        catch (Exception ex) {
            throw BooleanTypeUtil.cannotCoerceException(strval);
        }
    }

    private static boolean fromCharacter(Character charval) throws RedshiftException {
        if ('1' == charval.charValue() || 't' == charval.charValue() || 'T' == charval.charValue() || 'y' == charval.charValue() || 'Y' == charval.charValue()) {
            return true;
        }
        if ('0' == charval.charValue() || 'f' == charval.charValue() || 'F' == charval.charValue() || 'n' == charval.charValue() || 'N' == charval.charValue()) {
            return false;
        }
        throw BooleanTypeUtil.cannotCoerceException(charval);
    }

    private static boolean fromNumber(Number numval) throws RedshiftException {
        double value = numval.doubleValue();
        if (value == 1.0) {
            return true;
        }
        if (value == 0.0) {
            return false;
        }
        try {
            String str = String.valueOf(numval);
            return BooleanTypeUtil.fromString(str);
        }
        catch (Exception ex) {
            throw BooleanTypeUtil.cannotCoerceException(numval);
        }
    }

    private static RedshiftException cannotCoerceException(Object value) {
        return new RedshiftException(GT.tr("Cannot cast to boolean: \"{0}\"", String.valueOf(value)), RedshiftState.CANNOT_COERCE);
    }
}

