/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.backend.panama;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.nfi.backend.panama.ErrorContext;
import com.oracle.truffle.nfi.backend.panama.FunctionExecuteNode;
import com.oracle.truffle.nfi.backend.panama.FunctionExecuteNodeGen;
import com.oracle.truffle.nfi.backend.panama.NFIError;
import com.oracle.truffle.nfi.backend.panama.NativePointer;
import com.oracle.truffle.nfi.backend.panama.NativeString;
import com.oracle.truffle.nfi.backend.panama.PanamaClosure;
import com.oracle.truffle.nfi.backend.panama.PanamaNFIContext;
import com.oracle.truffle.nfi.backend.panama.PanamaNFILanguage;
import com.oracle.truffle.nfi.backend.panama.PanamaSymbol;
import com.oracle.truffle.nfi.backend.panama.PanamaType;
import com.oracle.truffle.nfi.backend.spi.NFIBackendSignatureBuilderLibrary;
import com.oracle.truffle.nfi.backend.spi.NFIBackendSignatureLibrary;
import com.oracle.truffle.nfi.backend.spi.NFIState;
import com.oracle.truffle.nfi.backend.spi.types.NativeSimpleType;
import com.oracle.truffle.nfi.backend.spi.util.ProfiledArrayBuilder;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;

@ExportLibrary(value=NFIBackendSignatureLibrary.class, useForAOT=false)
final class PanamaSignature {
    private final FunctionDescriptor functionDescriptor;
    final CachedSignatureInfo signatureInfo;
    private final MethodType upcallType;

    @CompilerDirectives.TruffleBoundary
    public static PanamaSignature create(CachedSignatureInfo info, MethodType upcallType) {
        return new PanamaSignature(info.functionDescriptor, upcallType, info);
    }

    PanamaSignature(FunctionDescriptor functionDescriptor, MethodType upcallType, CachedSignatureInfo signatureInfo) {
        this.functionDescriptor = functionDescriptor;
        this.upcallType = upcallType;
        this.signatureInfo = signatureInfo;
    }

    MethodType getUpcallMethodType() {
        return this.upcallType;
    }

    @CompilerDirectives.TruffleBoundary
    MemorySegment bind(MethodHandle cachedHandle, Object receiver, Node location) {
        MethodHandle bound = cachedHandle.bindTo(receiver);
        Arena arena = PanamaNFIContext.get(null).getContextArena();
        try {
            return Linker.nativeLinker().upcallStub(bound, this.functionDescriptor, arena, new Linker.Option[0]);
        }
        catch (IllegalCallerException ic) {
            throw NFIError.illegalNativeAccess(location);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static CachedSignatureInfo prepareSignatureInfo(PanamaType retType, ArgsState state, Node location) {
        PanamaType[] argTypes = new PanamaType[state.argCount];
        ArgsState curState = state;
        for (int i = state.argCount - 1; i >= 0; --i) {
            argTypes[i] = curState.lastArg;
            curState = curState.prev;
        }
        FunctionDescriptor descriptor = PanamaSignature.createDescriptor(argTypes, retType);
        MethodHandle downcallHandle = PanamaSignature.createDowncallHandle(descriptor, location);
        return new CachedSignatureInfo(PanamaNFILanguage.get(null), retType, argTypes, descriptor, downcallHandle);
    }

    private static FunctionDescriptor createDescriptor(PanamaType[] argTypes, PanamaType retType) {
        FunctionDescriptor descriptor = FunctionDescriptor.ofVoid(new MemoryLayout[0]);
        descriptor = retType.nativeLayout == null ? descriptor.dropReturnLayout() : descriptor.changeReturnLayout(retType.nativeLayout);
        for (PanamaType argType : argTypes) {
            descriptor = descriptor.appendArgumentLayouts(argType.nativeLayout);
        }
        return descriptor;
    }

    static MethodHandle createDowncallHandle(FunctionDescriptor descriptor, Node location) {
        int parameterCount = descriptor.argumentLayouts().size();
        try {
            MethodHandle handle = Linker.nativeLinker().downcallHandle(descriptor, new Linker.Option[0]).asSpreader(Object[].class, parameterCount).asType(MethodType.methodType(Object.class, new Class[]{MemorySegment.class, Object[].class}));
            return handle;
        }
        catch (IllegalCallerException ic) {
            throw NFIError.illegalNativeAccess(location);
        }
    }

    static final class CachedSignatureInfo {
        final PanamaType retType;
        final PanamaType[] argTypes;
        final FunctionDescriptor functionDescriptor;
        final CallTarget callTarget;
        final MethodHandle downcallHandle;

        CachedSignatureInfo(PanamaNFILanguage language, PanamaType retType, PanamaType[] argTypes, FunctionDescriptor functionDescriptor, MethodHandle downcallHandle) {
            this.retType = retType;
            this.argTypes = argTypes;
            this.functionDescriptor = functionDescriptor;
            this.downcallHandle = downcallHandle;
            this.callTarget = FunctionExecuteNodeGen.SignatureExecuteNodeGen.create(language, this).getCallTarget();
        }

        PanamaType[] getArgTypes() {
            return this.argTypes;
        }

        PanamaType getRetType() {
            return this.retType;
        }

        Object execute(PanamaSignature signature, Object[] args, MemorySegment segment, Node node) {
            assert (signature.signatureInfo == this);
            CompilerAsserts.partialEvaluationConstant((Object)this.retType);
            PanamaNFILanguage language = PanamaNFILanguage.get(node);
            NFIState nfiState = language.getNFIState();
            ErrorContext ctx = (ErrorContext)language.errorContext.get();
            try {
                ctx.setNativeErrno(nfiState.getNFIErrno());
                Object result = this.downcall(args, segment);
                nfiState.setNFIErrno(ctx.getNativeErrno());
                if (result == null) {
                    return NativePointer.NULL;
                }
                if (this.retType.type == NativeSimpleType.STRING) {
                    long pointer = ((MemorySegment)result).address();
                    return new NativeString(pointer);
                }
                if (this.retType.type == NativeSimpleType.POINTER) {
                    return NativePointer.create((Long)result);
                }
                return result;
            }
            catch (Throwable t) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException(t);
            }
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private Object downcall(Object[] args, MemorySegment segment) throws Throwable {
            return this.downcallHandle.invokeExact(segment, args);
        }
    }

    static final class ArgsState {
        static final ArgsState NO_ARGS = new ArgsState(0, null, null);
        final int argCount;
        final PanamaType lastArg;
        final ArgsState prev;

        ArgsState(int argCount, PanamaType lastArg, ArgsState prev) {
            this.argCount = argCount;
            this.lastArg = lastArg;
            this.prev = prev;
        }

        ArgsState addArg(PanamaType type) {
            return new ArgsState(this.argCount + 1, type, this);
        }
    }

    @ExportLibrary(value=NFIBackendSignatureBuilderLibrary.class)
    static final class PanamaSignatureBuilder {
        MethodType downcallType;
        MethodType upcallType;
        PanamaType retType;
        ArgsState argsState = ArgsState.NO_ARGS;
        ProfiledArrayBuilder<PanamaType> argTypes;
        private static final ProfiledArrayBuilder.ArrayFactory<PanamaType> FACTORY = PanamaType[]::new;

        void addArg(PanamaType arg, ArgsState newState) {
            assert (this.argsState.argCount + 1 == newState.argCount);
            this.argTypes.add((Object)arg);
            this.argsState = newState;
        }

        PanamaSignatureBuilder(ProfiledArrayBuilder.ArrayBuilderFactory factory) {
            this.argTypes = factory.allocate(FACTORY);
            this.downcallType = MethodType.methodType(Void.TYPE);
            this.upcallType = MethodType.methodType(Void.TYPE, Object.class);
        }

        @CompilerDirectives.TruffleBoundary
        @ExportMessage
        void setReturnType(Object t) {
            PanamaType type;
            this.retType = type = (PanamaType)t;
            this.downcallType = this.downcallType.changeReturnType(type.javaType);
            this.upcallType = this.upcallType.changeReturnType(type.javaRetType);
        }

        @ExportMessage
        void makeVarargs() {
            throw new UnsupportedOperationException("Cannot make varargs because varargs are not implemented.");
        }

        @ExportMessage
        @ImportStatic(value={PanamaSignature.class})
        static class Build {
            Build() {
            }

            @Specialization(guards={"builder.argsState == cachedState", "builder.retType == cachedRetType"}, limit="3")
            static Object doCached(PanamaSignatureBuilder builder, @Bind Node node, @Cached(value="builder.retType") PanamaType cachedRetType, @Cached(value="builder.argsState") ArgsState cachedState, @Cached(value="prepareSignatureInfo(cachedRetType, cachedState, node)") CachedSignatureInfo cachedSignatureInfo) {
                return PanamaSignature.create(cachedSignatureInfo, builder.upcallType);
            }

            @Specialization(replaces={"doCached"})
            static Object doGeneric(PanamaSignatureBuilder builder, @Bind Node node) {
                CachedSignatureInfo sigInfo = PanamaSignature.prepareSignatureInfo(builder.retType, builder.argsState, node);
                return PanamaSignature.create(sigInfo, builder.upcallType);
            }
        }

        @ExportMessage
        static class AddArgument {
            AddArgument() {
            }

            @Specialization(guards={"builder.argsState == oldState", "type == cachedType"}, limit="1")
            static void doCached(PanamaSignatureBuilder builder, PanamaType type, @Cached(value="type") PanamaType cachedType, @Cached(value="builder.argsState") ArgsState oldState, @Cached(value="oldState.addArg(cachedType)") ArgsState newState) {
                assert (builder.argsState == oldState && type == cachedType);
                builder.addArg(cachedType, newState);
                AddArgument.appendParameterTypes(builder, type);
            }

            @Specialization(replaces={"doCached"})
            static void doGeneric(PanamaSignatureBuilder builder, PanamaType type) {
                ArgsState newState = builder.argsState.addArg(type);
                builder.addArg(type, newState);
            }

            @CompilerDirectives.TruffleBoundary
            private static void appendParameterTypes(PanamaSignatureBuilder builder, PanamaType type) {
                builder.downcallType = builder.downcallType.appendParameterTypes(type.javaType);
                builder.upcallType = builder.upcallType.appendParameterTypes(type.javaType);
            }
        }
    }

    @ExportMessage
    @ImportStatic(value={PanamaNFILanguage.class})
    static final class CreateClosure {
        CreateClosure() {
        }

        @Specialization(guards={"signature.signatureInfo == cachedSignatureInfo", "executable == cachedExecutable"}, assumptions={"getSingleContextAssumption()"}, limit="3")
        static PanamaClosure doCachedExecutable(PanamaSignature signature, Object executable, @Bind Node node, @Cached(value="signature.signatureInfo") CachedSignatureInfo cachedSignatureInfo, @Cached(value="executable") Object cachedExecutable, @Cached(value="create(cachedSignatureInfo, cachedExecutable)") PanamaClosure.MonomorphicClosureInfo cachedClosureInfo) {
            assert (signature.signatureInfo == cachedSignatureInfo && executable == cachedExecutable);
            MemorySegment ret = CreateClosure.createClosureHandle(cachedClosureInfo.handle, signature, cachedExecutable, node);
            return new PanamaClosure(ret);
        }

        @Specialization(replaces={"doCachedExecutable"}, guards={"signature.signatureInfo == cachedSignatureInfo"}, limit="3")
        static PanamaClosure doCachedSignature(PanamaSignature signature, Object executable, @Bind Node node, @Cached(value="signature.signatureInfo") CachedSignatureInfo cachedSignatureInfo, @Cached(value="create(cachedSignatureInfo)") PanamaClosure.PolymorphicClosureInfo cachedClosureInfo) {
            assert (signature.signatureInfo == cachedSignatureInfo);
            MemorySegment ret = CreateClosure.createClosureHandle(cachedClosureInfo.handle, signature, executable, node);
            return new PanamaClosure(ret);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(replaces={"doCachedSignature"})
        static PanamaClosure createClosure(PanamaSignature signature, Object executable, @Bind Node node) {
            PanamaClosure.PolymorphicClosureInfo cachedClosureInfo = PanamaClosure.PolymorphicClosureInfo.create(signature.signatureInfo);
            MemorySegment ret = CreateClosure.createClosureHandle(cachedClosureInfo.handle, signature, executable, node);
            return new PanamaClosure(ret);
        }

        @CompilerDirectives.TruffleBoundary
        private static MemorySegment createClosureHandle(MethodHandle cachedClosureInfo, PanamaSignature signature, Object executable, Node node) {
            MethodHandle cachedHandle = cachedClosureInfo.asType(signature.getUpcallMethodType());
            return signature.bind(cachedHandle, executable, node);
        }
    }

    @ExportMessage
    static final class Call {
        Call() {
        }

        @Specialization
        static Object callPanama(PanamaSignature self, PanamaSymbol functionPointer, Object[] args, @Cached.Exclusive @Cached FunctionExecuteNode functionExecute) throws ArityException, UnsupportedTypeException {
            long pointer = functionPointer.asPointer();
            return functionExecute.execute(pointer, self, args);
        }

        @Specialization(limit="3")
        @GenerateAOT.Exclude
        static Object callGeneric(PanamaSignature self, Object functionPointer, Object[] args, @CachedLibrary(value="functionPointer") InteropLibrary interop, @Bind Node node, @Cached InlinedBranchProfile isExecutable, @Cached InlinedBranchProfile toNative, @Cached InlinedBranchProfile error, @Cached.Exclusive @Cached FunctionExecuteNode functionExecute) throws ArityException, UnsupportedTypeException {
            long pointer;
            if (interop.isExecutable(functionPointer)) {
                try {
                    isExecutable.enter(node);
                    return interop.execute(functionPointer, args);
                }
                catch (UnsupportedMessageException e) {
                    error.enter(node);
                    throw UnsupportedTypeException.create((Object[])new Object[]{functionPointer}, (String)"functionPointer was executable but threw UnsupportedMessageException on execute()");
                }
            }
            if (!interop.isPointer(functionPointer)) {
                toNative.enter(node);
                interop.toNative(functionPointer);
            }
            try {
                pointer = interop.asPointer(functionPointer);
            }
            catch (UnsupportedMessageException e) {
                error.enter(node);
                throw UnsupportedTypeException.create((Object[])new Object[]{functionPointer}, (String)"functionPointer is not executable and not a pointer");
            }
            return functionExecute.execute(pointer, self, args);
        }
    }
}

