/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.explanation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.protege.editor.owl.ui.explanation.ExplanationManager;
import org.protege.editor.owl.ui.explanation.ExplanationPreferences;
import org.protege.editor.owl.ui.explanation.ExplanationResult;
import org.protege.editor.owl.ui.explanation.ExplanationService;
import org.semanticweb.owlapi.model.OWLAxiom;

public class ExplanationDialog
extends JPanel {
    private JPanel explanationContainer;
    private ExplanationResult explanation;
    private OWLAxiom axiom;

    public ExplanationDialog(ExplanationManager explanationManager, OWLAxiom axiom) {
        this.axiom = axiom;
        this.setLayout(new BorderLayout());
        Collection<ExplanationService> teachers = explanationManager.getTeachers(axiom);
        if (teachers.size() == 1) {
            this.explanation = teachers.iterator().next().explain(axiom);
        } else {
            JComboBox<ExplanationService> selector = this.createComboBox(teachers);
            this.add(selector, "North");
        }
        this.explanationContainer = new JPanel();
        this.explanationContainer.setLayout(new BoxLayout(this.explanationContainer, 1));
        if (this.explanation != null) {
            this.explanationContainer.add(this.explanation);
        }
        this.add((Component)this.explanationContainer, "Center");
    }

    private JComboBox<ExplanationService> createComboBox(Collection<ExplanationService> explanationServices) {
        ExplanationService[] teacherArray = explanationServices.toArray(new ExplanationService[explanationServices.size()]);
        JComboBox<ExplanationService> selector = new JComboBox<ExplanationService>(teacherArray);
        ExplanationPreferences prefs = ExplanationPreferences.create().load();
        if (teacherArray.length > 0) {
            String id;
            ExplanationService selected = teacherArray[0];
            if (prefs.useLastExplanationService && (id = prefs.defaultExplanationService) != null) {
                for (ExplanationService t : explanationServices) {
                    if (!id.equals(t.getPluginId())) continue;
                    selected = t;
                }
            }
            selector.setSelectedItem(selected);
            this.explanation = selected.explain(this.axiom);
        }
        selector.addActionListener(e -> {
            ExplanationService t = (ExplanationService)selector.getSelectedItem();
            prefs.load();
            prefs.defaultExplanationService = t.getPluginId();
            prefs.save();
            this.explanationContainer.removeAll();
            if (this.explanation != null) {
                this.explanation.dispose();
            }
            this.explanation = t.explain(this.axiom);
            this.explanationContainer.add(this.explanation);
            this.revalidate();
        });
        return selector;
    }

    public void dispose() {
        if (this.explanation != null) {
            this.explanation.dispose();
        }
    }
}

