/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.protege.editor.core.ui.util.FormLabel;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.editor.OWLObjectEditorHandler;
import org.protege.editor.owl.ui.find.EntityFinderField;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedObject;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.parameters.Imports;

public class IRIFromEntityEditor
implements OWLObjectEditor<IRI> {
    private OWLEditorKit editorKit;
    private JPanel component = new JPanel(new BorderLayout());
    private EntityFinderField entityFinderField;
    private OWLObjectEditorHandler<IRI> handler;
    private OWLEntity chosenEntity = null;
    private ChangeListener changeListener;

    public IRIFromEntityEditor(OWLEditorKit owlEditorKit) {
        this.editorKit = owlEditorKit;
        JPanel holder = new JPanel(new BorderLayout());
        this.entityFinderField = new EntityFinderField(holder, owlEditorKit);
        this.component.add((Component)holder, "North");
        FormLabel formLabel = new FormLabel("Entity IRI");
        holder.add((Component)formLabel, "North");
        holder.add((Component)((Object)this.entityFinderField), "South");
        this.entityFinderField.setEntityFoundHandler(entity -> {
            this.chosenEntity = entity;
            this.entityFinderField.setText(this.editorKit.getModelManager().getRendering((OWLObject)entity));
            if (this.changeListener != null) {
                this.changeListener.stateChanged(new ChangeEvent(entity));
            }
        });
        this.component.setBorder(BorderFactory.createEmptyBorder(7, 0, 0, 0));
    }

    @Override
    public boolean canEdit(Object object) {
        boolean contained = false;
        if (object instanceof IRI) {
            for (OWLOntology ontology : this.editorKit.getModelManager().getActiveOntologies()) {
                if (!ontology.containsEntityInSignature((IRI)object)) continue;
                contained = true;
                break;
            }
        }
        return contained;
    }

    public boolean isPreferred(Object object) {
        return false;
    }

    @Override
    public OWLObjectEditorHandler<IRI> getHandler() {
        return this.handler;
    }

    @Override
    public void setHandler(OWLObjectEditorHandler<IRI> iriEditorHandler) {
        this.handler = iriEditorHandler;
    }

    @Override
    @Nonnull
    public JComponent getEditorComponent() {
        return this.component;
    }

    @Override
    public Set<IRI> getEditedObjects() {
        IRI selObj = this.getEditedObject();
        if (selObj != null) {
            return Collections.singleton(selObj);
        }
        return Collections.emptySet();
    }

    @Override
    @Nullable
    public IRI getEditedObject() {
        return Optional.ofNullable(this.chosenEntity).map(OWLNamedObject::getIRI).orElse(null);
    }

    @Override
    public boolean isMultiEditSupported() {
        return false;
    }

    @Override
    public void clear() {
        this.setEditedObject(null);
    }

    @Override
    public boolean setEditedObject(IRI object) {
        if (object == null) {
            this.chosenEntity = null;
            this.entityFinderField.setText("");
        } else {
            this.chosenEntity = this.getEntityFromIri(object);
            this.entityFinderField.setText(this.editorKit.getOWLModelManager().getRendering((OWLObject)object));
        }
        return true;
    }

    @Nullable
    private OWLEntity getEntityFromIri(IRI object) {
        OWLDataFactory df = this.editorKit.getOWLModelManager().getOWLDataFactory();
        OWLOntology ont = this.editorKit.getOWLModelManager().getActiveOntology();
        if (ont.containsClassInSignature(object, Imports.INCLUDED)) {
            return df.getOWLClass(object);
        }
        if (ont.containsObjectPropertyInSignature(object, Imports.INCLUDED)) {
            return df.getOWLObjectProperty(object);
        }
        if (ont.containsDataPropertyInSignature(object, Imports.INCLUDED)) {
            return df.getOWLDataProperty(object);
        }
        if (ont.containsIndividualInSignature(object, Imports.INCLUDED)) {
            return df.getOWLNamedIndividual(object);
        }
        if (ont.containsAnnotationPropertyInSignature(object, Imports.INCLUDED)) {
            return df.getOWLAnnotationProperty(object);
        }
        if (ont.containsDatatypeInSignature(object, Imports.INCLUDED)) {
            return df.getOWLDatatype(object);
        }
        return null;
    }

    @Override
    @Nonnull
    public String getEditorTypeName() {
        return "Entity IRI";
    }

    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public void dispose() {
    }

    public void addSelectionListener(ChangeListener listener) {
        this.changeListener = listener;
    }

    public void removeSelectionListener(ChangeListener listener) {
    }
}

