/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.util;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.elk.core.math.ElkMargin;
import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.ContentAlignment;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.options.EdgeLabelPlacement;
import org.eclipse.elk.core.options.NodeLabelPlacement;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.options.SizeOptions;
import org.eclipse.elk.core.util.IGraphElementVisitor;
import org.eclipse.elk.core.util.adapters.GraphAdapters;
import org.eclipse.elk.core.validation.GraphIssue;
import org.eclipse.elk.core.validation.GraphValidationException;
import org.eclipse.elk.core.validation.IValidatingGraphElementVisitor;
import org.eclipse.elk.graph.ElkBendPoint;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkGraphFactory;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.ElkShape;
import org.eclipse.elk.graph.util.ElkGraphUtil;
import org.eclipse.emf.ecore.EObject;

public final class ElkUtil {
    public static final float DEFAULT_MIN_WIDTH = 20.0f;
    public static final float DEFAULT_MIN_HEIGHT = 20.0f;

    private ElkUtil() {
    }

    public static PortSide calcPortSide(ElkPort port, Direction direction) {
        if (port.getParent() == null) {
            throw new IllegalStateException("port must have a parent node to calculate the port side");
        }
        ElkNode node = port.getParent();
        double nodeWidth = node.getWidth();
        double nodeHeight = node.getHeight();
        if (nodeWidth <= 0.0 && nodeHeight <= 0.0) {
            return PortSide.UNDEFINED;
        }
        double xpos = port.getX();
        double ypos = port.getY();
        switch (direction) {
            case RIGHT: 
            case LEFT: {
                if (xpos < 0.0) {
                    return PortSide.WEST;
                }
                if (!(xpos + port.getWidth() > nodeWidth)) break;
                return PortSide.EAST;
            }
            case DOWN: 
            case UP: {
                if (ypos < 0.0) {
                    return PortSide.NORTH;
                }
                if (!(ypos + port.getHeight() > nodeHeight)) break;
                return PortSide.SOUTH;
            }
        }
        double widthPercent = (xpos + port.getWidth() / 2.0) / nodeWidth;
        double heightPercent = (ypos + port.getHeight() / 2.0) / nodeHeight;
        if (widthPercent + heightPercent <= 1.0 && widthPercent - heightPercent <= 0.0) {
            return PortSide.WEST;
        }
        if (widthPercent + heightPercent >= 1.0 && widthPercent - heightPercent >= 0.0) {
            return PortSide.EAST;
        }
        if (heightPercent < 0.5) {
            return PortSide.NORTH;
        }
        return PortSide.SOUTH;
    }

    public static double calcPortOffset(ElkPort port, PortSide side) {
        if (port.getParent() == null) {
            throw new IllegalStateException("port must have a parent node to calculate the port side");
        }
        ElkNode node = port.getParent();
        switch (side) {
            case NORTH: {
                return -(port.getY() + port.getHeight());
            }
            case EAST: {
                return port.getX() - node.getWidth();
            }
            case SOUTH: {
                return port.getY() - node.getHeight();
            }
            case WEST: {
                return -(port.getX() + port.getWidth());
            }
        }
        return 0.0;
    }

    public static KVector resizeNode(ElkNode node) {
        Set sizeConstraint = node.getProperty(CoreOptions.NODE_SIZE_CONSTRAINTS);
        if (sizeConstraint.isEmpty()) {
            return null;
        }
        double newWidth = 0.0;
        double newHeight = 0.0;
        if (sizeConstraint.contains((Object)SizeConstraint.PORTS)) {
            PortConstraints portConstraints = node.getProperty(CoreOptions.PORT_CONSTRAINTS);
            double minNorth = 2.0;
            double minEast = 2.0;
            double minSouth = 2.0;
            double minWest = 2.0;
            Direction direction = node.getParent() == null ? node.getProperty(CoreOptions.DIRECTION) : node.getParent().getProperty(CoreOptions.DIRECTION);
            for (ElkPort port : node.getPorts()) {
                PortSide portSide = port.getProperty(CoreOptions.PORT_SIDE);
                if (portSide == PortSide.UNDEFINED) {
                    portSide = ElkUtil.calcPortSide(port, direction);
                    port.setProperty(CoreOptions.PORT_SIDE, portSide);
                }
                if (portConstraints == PortConstraints.FIXED_POS) {
                    switch (portSide) {
                        case NORTH: {
                            minNorth = Math.max(minNorth, port.getX() + port.getWidth());
                            break;
                        }
                        case EAST: {
                            minEast = Math.max(minEast, port.getY() + port.getHeight());
                            break;
                        }
                        case SOUTH: {
                            minSouth = Math.max(minSouth, port.getX() + port.getWidth());
                            break;
                        }
                        case WEST: {
                            minWest = Math.max(minWest, port.getY() + port.getHeight());
                        }
                    }
                    continue;
                }
                switch (portSide) {
                    case NORTH: {
                        minNorth += port.getWidth() + 2.0;
                        break;
                    }
                    case EAST: {
                        minEast += port.getHeight() + 2.0;
                        break;
                    }
                    case SOUTH: {
                        minSouth += port.getWidth() + 2.0;
                        break;
                    }
                    case WEST: {
                        minWest += port.getHeight() + 2.0;
                    }
                }
            }
            newWidth = Math.max(minNorth, minSouth);
            newHeight = Math.max(minEast, minWest);
        }
        return ElkUtil.resizeNode(node, newWidth, newHeight, true, true);
    }

    public static KVector resizeNode(ElkNode node, double newWidth, double newHeight, boolean movePorts, boolean moveLabels) {
        KVector oldSize = new KVector(node.getWidth(), node.getHeight());
        KVector newSize = ElkUtil.effectiveMinSizeConstraintFor(node);
        newSize.x = Math.max(newSize.x, newWidth);
        newSize.y = Math.max(newSize.y, newHeight);
        double widthRatio = newSize.x / oldSize.x;
        double heightRatio = newSize.y / oldSize.y;
        double widthDiff = newSize.x - oldSize.x;
        double heightDiff = newSize.y - oldSize.y;
        if (movePorts) {
            Direction direction = node.getParent() == null ? node.getProperty(CoreOptions.DIRECTION) : node.getParent().getProperty(CoreOptions.DIRECTION);
            boolean fixedPorts = node.getProperty(CoreOptions.PORT_CONSTRAINTS) == PortConstraints.FIXED_POS;
            for (ElkPort port : node.getPorts()) {
                PortSide portSide = port.getProperty(CoreOptions.PORT_SIDE);
                if (portSide == PortSide.UNDEFINED) {
                    portSide = ElkUtil.calcPortSide(port, direction);
                    port.setProperty(CoreOptions.PORT_SIDE, portSide);
                }
                switch (portSide) {
                    case NORTH: {
                        if (fixedPorts) break;
                        port.setX(port.getX() * widthRatio);
                        break;
                    }
                    case EAST: {
                        port.setX(port.getX() + widthDiff);
                        if (fixedPorts) break;
                        port.setY(port.getY() * heightRatio);
                        break;
                    }
                    case SOUTH: {
                        if (!fixedPorts) {
                            port.setX(port.getX() * widthRatio);
                        }
                        port.setY(port.getY() + heightDiff);
                        break;
                    }
                    case WEST: {
                        if (fixedPorts) break;
                        port.setY(port.getY() * heightRatio);
                    }
                }
            }
        }
        node.setDimensions(newSize.x, newSize.y);
        if (moveLabels) {
            for (ElkLabel label : node.getLabels()) {
                double midy;
                double heightPercent;
                double midx = label.getX() + label.getWidth() / 2.0;
                double widthPercent = midx / oldSize.x;
                if (!(widthPercent + (heightPercent = (midy = label.getY() + label.getHeight() / 2.0) / oldSize.y) >= 1.0)) continue;
                if (widthPercent - heightPercent > 0.0 && midy >= 0.0) {
                    label.setX(label.getX() + widthDiff);
                    label.setY(label.getY() + heightDiff * heightPercent);
                    continue;
                }
                if (!(widthPercent - heightPercent < 0.0) || !(midx >= 0.0)) continue;
                label.setX(label.getX() + widthDiff * widthPercent);
                label.setY(label.getY() + heightDiff);
            }
        }
        node.setProperty(CoreOptions.NODE_SIZE_CONSTRAINTS, SizeConstraint.fixed());
        return new KVector(widthRatio, heightRatio);
    }

    public static KVector effectiveMinSizeConstraintFor(ElkNode node) {
        Set sizeConstraint = node.getProperty(CoreOptions.NODE_SIZE_CONSTRAINTS);
        if (sizeConstraint.contains((Object)SizeConstraint.MINIMUM_SIZE)) {
            Set sizeOptions = node.getProperty(CoreOptions.NODE_SIZE_OPTIONS);
            KVector minSize = new KVector(node.getProperty(CoreOptions.NODE_SIZE_MINIMUM));
            if (sizeOptions.contains((Object)SizeOptions.DEFAULT_MINIMUM_SIZE)) {
                if (minSize.x <= 0.0) {
                    minSize.x = 20.0;
                }
                if (minSize.y <= 0.0) {
                    minSize.y = 20.0;
                }
            }
            return minSize;
        }
        return new KVector();
    }

    public static void applyConfiguredNodeScaling(ElkNode node) {
        double scalingFactor = node.getProperty(CoreOptions.SCALE_FACTOR);
        if (scalingFactor == 1.0) {
            return;
        }
        node.setDimensions(scalingFactor * node.getWidth(), scalingFactor * node.getHeight());
        Iterable portLabels = Iterables.concat(Iterables.transform(node.getPorts(), p -> p.getLabels()));
        for (ElkShape elkShape : Iterables.concat(node.getLabels(), node.getPorts(), portLabels)) {
            elkShape.setLocation(scalingFactor * elkShape.getX(), scalingFactor * elkShape.getY());
            elkShape.setDimensions(scalingFactor * elkShape.getWidth(), scalingFactor * elkShape.getHeight());
            KVector anchor = elkShape.getProperty(CoreOptions.PORT_ANCHOR);
            if (anchor == null) continue;
            anchor.x *= scalingFactor;
            anchor.y *= scalingFactor;
        }
    }

    public static void computeChildAreaDimensions(ElkNode node) {
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = 0.0;
        double maxY = 0.0;
        Iterable<Object> edgeLabels = new ArrayList();
        for (ElkEdge elkEdge : node.getContainedEdges()) {
            edgeLabels = Iterables.concat(edgeLabels, elkEdge.getLabels());
        }
        for (ElkShape elkShape : Iterables.concat(node.getLabels(), node.getChildren(), edgeLabels)) {
            ElkMargin margins = elkShape.getProperty(CoreOptions.MARGINS);
            if (minX > elkShape.getX() - margins.left) {
                minX = elkShape.getX() - margins.left;
            }
            if (minY > elkShape.getY() - margins.top) {
                minY = elkShape.getY() - margins.top;
            }
            if (maxX < elkShape.getX() + elkShape.getWidth() + margins.right) {
                maxX = elkShape.getX() + elkShape.getWidth() + margins.right;
            }
            if (!(maxY < elkShape.getY() + elkShape.getHeight() + margins.bottom)) continue;
            maxY = elkShape.getY() + elkShape.getHeight() + margins.bottom;
        }
        for (ElkEdge elkEdge : node.getContainedEdges()) {
            for (ElkEdgeSection section : elkEdge.getSections()) {
                double sX = section.getStartX();
                double eX = section.getEndX();
                double sY = section.getStartY();
                double eY = section.getEndY();
                minX = Math.min(minX, sX);
                minX = Math.min(minX, eX);
                maxX = Math.max(maxX, sX);
                maxX = Math.max(maxX, eX);
                minY = Math.min(minY, sY);
                minY = Math.min(minY, eY);
                maxY = Math.max(maxY, sY);
                maxY = Math.max(maxY, eY);
                for (ElkBendPoint bendpoint : section.getBendPoints()) {
                    minX = Math.min(minX, bendpoint.getX());
                    maxX = Math.max(maxX, bendpoint.getX());
                    minY = Math.min(minY, bendpoint.getY());
                    maxY = Math.max(maxY, bendpoint.getY());
                }
            }
        }
        node.setProperty(CoreOptions.CHILD_AREA_WIDTH, maxX - minX);
        node.setProperty(CoreOptions.CHILD_AREA_HEIGHT, maxY - minY);
    }

    public static KVectorChain determineJunctionPoints(ElkEdge edge) {
        if (edge.getSections().size() != 1) {
            throw new IllegalArgumentException("The edge needs to have exactly one edge section. Found: " + edge.getSections().size());
        }
        KVectorChain junctionPoints = new KVectorChain();
        if (ElkGraphUtil.connectableShapeToPort((ElkConnectableShape)edge.getSources().get(0)) != null) {
            junctionPoints.addAll(ElkUtil.determineJunctionPoints(edge, ElkGraphUtil.connectableShapeToPort((ElkConnectableShape)edge.getSources().get(0)), false));
        }
        if (ElkGraphUtil.connectableShapeToPort((ElkConnectableShape)edge.getTargets().get(0)) != null) {
            junctionPoints.addAll(ElkUtil.determineJunctionPoints(edge, ElkGraphUtil.connectableShapeToPort((ElkConnectableShape)edge.getTargets().get(0)), true));
        }
        return junctionPoints;
    }

    private static KVectorChain determineJunctionPoints(ElkEdge edge, ElkPort port, boolean reverse) {
        assert (edge.getSections().size() == 1);
        ElkEdgeSection section = (ElkEdgeSection)edge.getSections().get(0);
        KVectorChain junctionPoints = new KVectorChain();
        HashMap<ElkEdgeSection, ArrayList<KVector>> pointsMap = Maps.newHashMap();
        ArrayList<KVector> sectionPoints = ElkUtil.getPoints(section);
        pointsMap.put(section, sectionPoints);
        HashMap<ElkEdgeSection, KVector> offsetMap = Maps.newHashMap();
        LinkedList<ElkEdgeSection> allConnectedSections = Lists.newLinkedList();
        for (ElkEdge otherEdge : ElkGraphUtil.allIncidentEdges(port)) {
            if (edge.getSections().size() != 1) {
                throw new IllegalArgumentException("The edge needs to have exactly one edge section. Found: " + edge.getSections().size());
            }
            if (otherEdge == edge) continue;
            ElkEdgeSection otherSection = (ElkEdgeSection)otherEdge.getSections().get(0);
            allConnectedSections.add(otherSection);
            ArrayList<KVector> otherPoints = (ArrayList<KVector>)pointsMap.get(otherSection);
            if (otherPoints == null) {
                otherPoints = ElkUtil.getPoints(otherSection);
                pointsMap.put(otherSection, otherPoints);
            }
            KVector offset = reverse ? new KVector(sectionPoints.get(sectionPoints.size() - 1)).sub(otherPoints.get(otherPoints.size() - 1)) : new KVector(sectionPoints.get(0)).sub(otherPoints.get(0));
            offsetMap.put(otherSection, offset);
        }
        if (!allConnectedSections.isEmpty()) {
            KVector p1 = sectionPoints.get(reverse ? sectionPoints.size() - 1 : 0);
            int i = 1;
            while (i < sectionPoints.size()) {
                KVector p2 = sectionPoints.get(reverse ? sectionPoints.size() - 1 - i : i);
                Iterator allSectIter = allConnectedSections.iterator();
                while (allSectIter.hasNext()) {
                    ElkEdgeSection otherSection = (ElkEdgeSection)allSectIter.next();
                    ArrayList otherPoints = (ArrayList)pointsMap.get(otherSection);
                    if (otherPoints.size() <= i) {
                        allSectIter.remove();
                        continue;
                    }
                    KVector p3 = new KVector((KVector)otherPoints.get(reverse ? otherPoints.size() - 1 - i : i)).add((KVector)offsetMap.get(otherSection));
                    if (p2.x == p3.x && p2.y == p3.y) continue;
                    double dx3 = p3.x - p1.x;
                    double dy2 = p2.y - p1.y;
                    double dy3 = p3.y - p1.y;
                    double dx2 = p2.x - p1.x;
                    if (dx3 * dy2 == dy3 * dx2 && Math.signum(dx2) == Math.signum(dx3) && Math.signum(dy2) == Math.signum(dy3)) {
                        if (Math.abs(dx2) < Math.abs(dx3) || Math.abs(dy2) < Math.abs(dy3)) {
                            junctionPoints.add(p2);
                        }
                    } else if (i > 1) {
                        junctionPoints.add(p1);
                    }
                    allSectIter.remove();
                }
                p1 = p2;
                ++i;
            }
        }
        return junctionPoints;
    }

    public static ElkRectangle getLabelsBounds(GraphAdapters.PortAdapter<?> port) {
        ElkRectangle bounds = null;
        for (GraphAdapters.LabelAdapter<?> label : port.getLabels()) {
            ElkRectangle currentLabelBounds = new ElkRectangle(label.getPosition().x, label.getPosition().y, label.getSize().x, label.getSize().y);
            if (bounds == null) {
                bounds = currentLabelBounds;
                continue;
            }
            bounds.union(currentLabelBounds);
        }
        if (bounds == null) {
            bounds = new ElkRectangle();
        }
        return bounds;
    }

    public static double computeInsidePart(GraphAdapters.PortAdapter<?> port, double portBorderOffset) {
        ElkRectangle labelBounds = ElkUtil.getLabelsBounds(port);
        return ElkUtil.computeInsidePart(new KVector(labelBounds.x, labelBounds.y), new KVector(labelBounds.width, labelBounds.height), port.getSize(), portBorderOffset, port.getSide());
    }

    public static double computeInsidePart(KVector labelPosition, KVector labelSize, KVector portSize, double portBorderOffset, PortSide portSide) {
        double insidePart = 0.0;
        switch (portSide) {
            case NORTH: {
                insidePart = Math.max(0.0, labelSize.y + labelPosition.y - (portSize.y + portBorderOffset));
                break;
            }
            case SOUTH: {
                insidePart = Math.max(0.0, -labelPosition.y - portBorderOffset);
                break;
            }
            case EAST: {
                insidePart = Math.max(0.0, -labelPosition.x - portBorderOffset);
                break;
            }
            case WEST: {
                insidePart = Math.max(0.0, labelSize.x + labelPosition.x - (portSize.x + portBorderOffset));
            }
        }
        return insidePart;
    }

    public static void translate(ElkNode parent, double xoffset, double yoffset) {
        for (ElkNode child : parent.getChildren()) {
            child.setLocation(child.getX() + xoffset, child.getY() + yoffset);
        }
        parent.getContainedEdges().forEach(edge -> ElkUtil.translate(edge, xoffset, yoffset));
    }

    public static void translate(ElkEdge edge, double xoffset, double yoffset) {
        edge.getSections().stream().forEach(s -> ElkUtil.translate(s, xoffset, yoffset));
        edge.getLabels().stream().forEach(label -> label.setLocation(label.getX() + xoffset, label.getY() + yoffset));
        KVectorChain junctionPoints = edge.getProperty(CoreOptions.JUNCTION_POINTS);
        if (junctionPoints != null) {
            junctionPoints.offset(xoffset, yoffset);
        }
    }

    public static void translate(ElkEdgeSection section, double xoffset, double yoffset) {
        section.setStartLocation(section.getStartX() + xoffset, section.getStartY() + yoffset);
        for (ElkBendPoint bendPoint : section.getBendPoints()) {
            bendPoint.set(bendPoint.getX() + xoffset, bendPoint.getY() + yoffset);
        }
        section.setEndLocation(section.getEndX() + xoffset, section.getEndY() + yoffset);
    }

    public static void translate(ElkNode parent, KVector newSize, KVector oldSize) {
        Set contentAlignment = parent.getProperty(CoreOptions.CONTENT_ALIGNMENT);
        double xTranslate = 0.0;
        double yTranslate = 0.0;
        if (newSize.x > oldSize.x) {
            if (contentAlignment.contains((Object)ContentAlignment.H_CENTER)) {
                xTranslate = (newSize.x - oldSize.x) / 2.0;
            } else if (contentAlignment.contains((Object)ContentAlignment.H_RIGHT)) {
                xTranslate = newSize.x - oldSize.x;
            }
        }
        if (newSize.y > oldSize.y) {
            if (contentAlignment.contains((Object)ContentAlignment.V_CENTER)) {
                yTranslate = (newSize.y - oldSize.y) / 2.0;
            } else if (contentAlignment.contains((Object)ContentAlignment.V_BOTTOM)) {
                yTranslate = newSize.y - oldSize.y;
            }
        }
        ElkUtil.translate(parent, xTranslate, yTranslate);
    }

    public static KVector absolutePosition(ElkGraphElement element) {
        if (element instanceof ElkNode) {
            ElkNode node = (ElkNode)element;
            return ElkUtil.toAbsolute(new KVector(node.getX(), node.getY()), node.getParent());
        }
        if (element instanceof ElkPort) {
            ElkPort port = (ElkPort)element;
            return ElkUtil.toAbsolute(new KVector(port.getX(), port.getY()), port.getParent());
        }
        if (element instanceof ElkEdge) {
            ElkEdge edge = (ElkEdge)element;
            return ElkUtil.absolutePosition(edge.getContainingNode());
        }
        if (element instanceof ElkLabel) {
            ElkLabel label = (ElkLabel)element;
            KVector absoluteParentPosition = ElkUtil.absolutePosition(label.getParent());
            return new KVector(absoluteParentPosition.x + label.getX(), absoluteParentPosition.y + label.getY());
        }
        return null;
    }

    public static KVector toAbsolute(KVector point, ElkNode parent) {
        ElkNode node = parent;
        while (node != null) {
            point.add(node.getX(), node.getY());
            node = node.getParent();
        }
        return point;
    }

    public static KVector toRelative(KVector point, ElkNode parent) {
        ElkNode node = parent;
        while (node != null) {
            point.add(-node.getX(), -node.getY());
            node = node.getParent();
        }
        return point;
    }

    private static ArrayList<KVector> getPoints(ElkEdgeSection section) {
        int n = section.getBendPoints().size() + 2;
        ArrayList<KVector> points = new ArrayList<KVector>(n);
        points.add(new KVector(section.getStartX(), section.getStartY()));
        section.getBendPoints().stream().forEach(bendPoint -> {
            boolean bl = points.add(new KVector(bendPoint.getX(), bendPoint.getY()));
        });
        points.add(new KVector(section.getEndX(), section.getEndY()));
        int i = 1;
        while (i < points.size() - 1) {
            KVector p1 = points.get(i - 1);
            KVector p2 = points.get(i);
            KVector p3 = points.get(i + 1);
            if (p1.x == p2.x && p2.x == p3.x || p1.y == p2.y && p2.y == p3.y) {
                points.remove(i);
                continue;
            }
            ++i;
        }
        return points;
    }

    public static KVectorChain createVectorChain(ElkEdgeSection edgeSection) {
        KVectorChain chain = new KVectorChain();
        chain.add(new KVector(edgeSection.getStartX(), edgeSection.getStartY()));
        for (ElkBendPoint bendPoint : edgeSection.getBendPoints()) {
            chain.add(new KVector(bendPoint.getX(), bendPoint.getY()));
        }
        chain.add(new KVector(edgeSection.getEndX(), edgeSection.getEndY()));
        return chain;
    }

    public static void applyVectorChain(KVectorChain vectorChain, ElkEdgeSection section) {
        if (vectorChain.size() < 2) {
            throw new IllegalArgumentException("The vector chain must contain at least a source and a target point.");
        }
        KVector firstPoint = (KVector)vectorChain.getFirst();
        section.setStartLocation(firstPoint.x, firstPoint.y);
        ListIterator<ElkBendPoint> oldPointIter = section.getBendPoints().listIterator();
        ListIterator newPointIter = vectorChain.listIterator(1);
        while (newPointIter.nextIndex() < vectorChain.size() - 1) {
            ElkBendPoint bendpoint;
            KVector nextPoint = (KVector)newPointIter.next();
            if (oldPointIter.hasNext()) {
                bendpoint = (ElkBendPoint)oldPointIter.next();
            } else {
                bendpoint = ElkGraphFactory.eINSTANCE.createElkBendPoint();
                oldPointIter.add(bendpoint);
            }
            bendpoint.set(nextPoint.x, nextPoint.y);
        }
        while (oldPointIter.hasNext()) {
            oldPointIter.next();
            oldPointIter.remove();
        }
        KVector lastPoint = (KVector)vectorChain.getLast();
        section.setEndLocation(lastPoint.x, lastPoint.y);
    }

    public static void configureDefaultsRecursively(ElkNode graph) {
        UnmodifiableIterator<EObject> kgeIt = Iterators.filter(graph.eAllContents(), e -> e instanceof ElkGraphElement);
        while (kgeIt.hasNext()) {
            EObject kge = (EObject)kgeIt.next();
            if (kge instanceof ElkNode) {
                ElkUtil.configureWithDefaultValues((ElkNode)kge);
                continue;
            }
            if (kge instanceof ElkPort) {
                ElkUtil.configureWithDefaultValues((ElkPort)kge);
                continue;
            }
            if (!(kge instanceof ElkEdge)) continue;
            ElkUtil.configureWithDefaultValues((ElkEdge)kge);
        }
    }

    public static void configureWithDefaultValues(ElkNode node) {
        Set sc = node.getProperty(CoreOptions.NODE_SIZE_CONSTRAINTS);
        if (sc.equals(SizeConstraint.fixed()) && node.getWidth() == 0.0 && node.getHeight() == 0.0) {
            node.setWidth(80.0);
            node.setHeight(80.0);
        }
        ElkUtil.ensureLabel(node);
        Set nlp = node.getProperty(CoreOptions.NODE_LABELS_PLACEMENT);
        if (nlp.equals(NodeLabelPlacement.fixed())) {
            node.setProperty(CoreOptions.NODE_LABELS_PLACEMENT, NodeLabelPlacement.insideCenter());
        }
    }

    public static void configureWithDefaultValues(ElkPort port) {
        if (port.getWidth() == 0.0 && port.getHeight() == 0.0) {
            port.setWidth(5.0);
            port.setHeight(5.0);
        }
        ElkUtil.ensureLabel(port);
    }

    public static void configureWithDefaultValues(ElkEdge edge) {
        if (!edge.hasProperty(CoreOptions.EDGE_LABELS_PLACEMENT)) {
            edge.setProperty(CoreOptions.EDGE_LABELS_PLACEMENT, EdgeLabelPlacement.CENTER);
        }
    }

    private static void ensureLabel(ElkGraphElement klge) {
        if (klge.getLabels().isEmpty() && !Strings.isNullOrEmpty(klge.getIdentifier())) {
            ElkLabel label = ElkGraphUtil.createLabel(klge);
            label.setText(klge.getIdentifier());
        }
    }

    public static void applyVisitors(ElkNode graph, IGraphElementVisitor ... visitors) {
        Iterator<EObject> allElements = ElkGraphUtil.propertiesSkippingIteratorFor(graph, true);
        while (allElements.hasNext()) {
            EObject nextElement = allElements.next();
            if (!(nextElement instanceof ElkGraphElement)) continue;
            ElkGraphElement graphElement = (ElkGraphElement)nextElement;
            int i = 0;
            while (i < visitors.length) {
                visitors[i].visit(graphElement);
                ++i;
            }
        }
    }

    public static void applyVisitorsWithValidation(ElkNode graph, IGraphElementVisitor ... visitors) throws GraphValidationException {
        ElkUtil.applyVisitors(graph, visitors);
        ArrayList<GraphIssue> allIssues = null;
        int i = 0;
        while (i < visitors.length) {
            Collection<GraphIssue> issues;
            if (visitors[i] instanceof IValidatingGraphElementVisitor && !(issues = ((IValidatingGraphElementVisitor)visitors[i]).getIssues()).isEmpty()) {
                if (allIssues == null) {
                    allIssues = new ArrayList<GraphIssue>(issues);
                } else {
                    allIssues.addAll(issues);
                }
            }
            ++i;
        }
        if (allIssues != null && allIssues.stream().anyMatch(issue -> issue.getSeverity() == GraphIssue.Severity.ERROR)) {
            StringBuilder message = new StringBuilder();
            for (GraphIssue issue2 : allIssues) {
                if (message.length() > 0) {
                    message.append("\n");
                }
                message.append((Object)issue2.getSeverity()).append(": ").append(issue2.getMessage()).append("\n\tat ");
                ElkUtil.printElementPath(issue2.getElement(), message);
            }
            throw new GraphValidationException(message.toString(), allIssues);
        }
    }

    public static void printElementPath(ElkGraphElement element, StringBuilder builder) {
        ElkEdge edge;
        String text;
        if (element.eContainer() instanceof ElkGraphElement) {
            ElkUtil.printElementPath((ElkGraphElement)element.eContainer(), builder);
            builder.append(" > ");
        } else {
            builder.append("Root ");
        }
        String className = element.eClass().getName();
        if (className.startsWith("Elk")) {
            builder.append(className.substring(3));
        } else {
            builder.append(className);
        }
        String identifier = element.getIdentifier();
        if (!Strings.isNullOrEmpty(identifier)) {
            builder.append(' ').append(identifier);
            return;
        }
        if (element instanceof ElkLabel && !Strings.isNullOrEmpty(text = ((ElkLabel)element).getText())) {
            builder.append(' ').append(text);
            return;
        }
        for (ElkLabel label : element.getLabels()) {
            String text2 = label.getText();
            if (Strings.isNullOrEmpty(text2)) continue;
            builder.append(' ').append(text2);
            return;
        }
        if (element instanceof ElkEdge && (edge = (ElkEdge)element).isConnected()) {
            builder.append(" (");
            ListIterator sourceIter = edge.getSources().listIterator();
            while (sourceIter.hasNext()) {
                if (sourceIter.nextIndex() > 0) {
                    builder.append(", ");
                }
                ElkUtil.printElementPath((ElkGraphElement)sourceIter.next(), builder);
            }
            builder.append(" -> ");
            ListIterator targetIter = edge.getTargets().listIterator();
            while (targetIter.hasNext()) {
                if (targetIter.nextIndex() > 0) {
                    builder.append(", ");
                }
                ElkUtil.printElementPath((ElkGraphElement)targetIter.next(), builder);
            }
            builder.append(")");
        }
    }

    public static String debugFolderPath(String ... subfolders) {
        String userHome = System.getProperty("user.home");
        if (userHome != null) {
            StringBuilder path = new StringBuilder(userHome);
            if (path.charAt(path.length() - 1) != File.separatorChar) {
                path.append(File.separatorChar);
            }
            path.append("elk").append(File.separatorChar);
            if (subfolders != null) {
                String[] stringArray = subfolders;
                int n = subfolders.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    path.append(s).append(File.separatorChar);
                    ++n2;
                }
            }
            return path.toString();
        }
        return null;
    }

    public static String toSafePathName(String name) {
        Pattern whitespace = Pattern.compile("\\s");
        String nameWithoutWhitespace = whitespace.matcher(name).replaceAll("_");
        Pattern allButAllowedCharacters = Pattern.compile("[^a-zA-Z0-9_]");
        return allButAllowedCharacters.matcher(nameWithoutWhitespace).replaceAll("-");
    }

    public static void createIdentifier(ElkGraphElement element) {
        element.setIdentifier(Integer.toString(element.hashCode()));
    }
}

