/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.dot;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.dot.ExeState;
import net.sourceforge.plantuml.dot.Graphviz;
import net.sourceforge.plantuml.dot.GraphvizFactory;
import net.sourceforge.plantuml.dot.GraphvizLinux;
import net.sourceforge.plantuml.dot.GraphvizVersion;
import net.sourceforge.plantuml.dot.GraphvizVersionFinder;
import net.sourceforge.plantuml.dot.GraphvizWindowsLite;
import net.sourceforge.plantuml.dot.GraphvizWindowsOld;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.utils.Log;
import net.sourceforge.plantuml.vizjs.GraphvizJs;
import net.sourceforge.plantuml.vizjs.VizJsEngine;

public class GraphvizRuntimeEnvironment {
    public static final String VIZJS = "vizjs";
    private static final GraphvizRuntimeEnvironment singleton = new GraphvizRuntimeEnvironment();
    private final Map<File, GraphvizVersion> map = new ConcurrentHashMap<File, GraphvizVersion>();
    private String dotExecutable;
    private String dotVersion;

    private GraphvizRuntimeEnvironment() {
    }

    public static GraphvizRuntimeEnvironment getInstance() {
        return singleton;
    }

    private static boolean isWindows() {
        return SFile.separatorChar == '\\';
    }

    public GraphvizVersion getVersion(File f) {
        if (f == null) {
            return null;
        }
        GraphvizVersion result = this.map.get(f);
        if (result != null) {
            return result;
        }
        result = new GraphvizVersionFinder(new File(f.getAbsolutePath())).getVersion();
        this.map.put(f, result);
        return result;
    }

    public final void setDotExecutable(String value) {
        if (value != null && value.length() == 1) {
            throw new IllegalArgumentException("setDotExecutable failure");
        }
        this.dotExecutable = value == null ? null : value.trim();
    }

    public String getenvGraphvizDot() {
        if (StringUtils.isNotEmpty(this.dotExecutable)) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(this.dotExecutable);
        }
        String env = System.getProperty("GRAPHVIZ_DOT");
        if (StringUtils.isNotEmpty(env)) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(env);
        }
        String getenv = System.getenv("GRAPHVIZ_DOT");
        if (StringUtils.isNotEmpty(getenv)) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(getenv);
        }
        return null;
    }

    public Graphviz createForSystemDot(ISkinParam skinParam, String dotString, String ... type) {
        Graphviz result = this.createWithFactory(skinParam, dotString, type);
        if (result != null) {
            return result;
        }
        if (this.useVizJs(skinParam)) {
            Log.info(() -> "Using vizjs");
            return new GraphvizJs(dotString);
        }
        result = GraphvizRuntimeEnvironment.isWindows() ? new GraphvizWindowsOld(skinParam, dotString, type) : new GraphvizLinux(skinParam, dotString, type);
        if (result.getExeState() != ExeState.OK && VizJsEngine.isOk()) {
            Graphviz result2 = result;
            Log.info(() -> "Error with file " + result2.getDotExe() + ": " + result2.getExeState().getTextMessage());
            Log.info(() -> "Using vizjs");
            return new GraphvizJs(dotString);
        }
        return result;
    }

    public Graphviz create(ISkinParam skinParam, String dotString, String ... type) {
        Graphviz result = this.createWithFactory(skinParam, dotString, type);
        if (result != null) {
            return result;
        }
        if (this.useVizJs(skinParam)) {
            Log.info(() -> "Using vizjs");
            return new GraphvizJs(dotString);
        }
        result = GraphvizRuntimeEnvironment.isWindows() ? new GraphvizWindowsLite(skinParam, dotString, type) : new GraphvizLinux(skinParam, dotString, type);
        if (result.getExeState() != ExeState.OK && VizJsEngine.isOk()) {
            Graphviz result2 = result;
            Log.info(() -> "Error with file " + result2.getDotExe() + ": " + result2.getExeState().getTextMessage());
            Log.info(() -> "Using vizjs");
            return new GraphvizJs(dotString);
        }
        return result;
    }

    private Graphviz createWithFactory(ISkinParam skinParam, String dotString, String ... type) {
        for (GraphvizFactory factory : ServiceLoader.load(GraphvizFactory.class)) {
            Graphviz graphviz = factory.create(skinParam, dotString, type);
            if (graphviz == null) continue;
            Log.info(() -> "Using " + graphviz.getClass().getName() + " created by " + factory.getClass().getName());
            return graphviz;
        }
        return null;
    }

    public boolean useVizJs(ISkinParam skinParam) {
        if (skinParam != null && skinParam.isUseVizJs() && VizJsEngine.isOk()) {
            return true;
        }
        return VIZJS.equalsIgnoreCase(GraphvizRuntimeEnvironment.getInstance().getenvGraphvizDot()) && VizJsEngine.isOk();
    }

    public File getDotExe() {
        return this.create(null, "png", new String[0]).getDotExe();
    }

    public String dotVersion() throws IOException, InterruptedException {
        if (this.dotVersion == null) {
            File dotExe = this.getDotExe();
            ExeState exeState = ExeState.checkFile(dotExe);
            this.dotVersion = exeState == ExeState.OK ? this.create(null, "png", new String[0]).dotVersion() : "Error:" + exeState.getTextMessage(dotExe);
        }
        return this.dotVersion;
    }

    public boolean graphviz244onWindows() {
        try {
            return this.create(null, "png", new String[0]).graphviz244onWindows();
        }
        catch (Exception e) {
            Logme.error(e);
            return false;
        }
    }

    public int retrieveVersion(String s) {
        if (s == null) {
            return -1;
        }
        Pattern p = Pattern.compile("\\s(\\d+)\\.(\\d\\d?)\\D");
        Matcher m = p.matcher(s);
        if (!m.find()) {
            return -1;
        }
        return 100 * Integer.parseInt(m.group(1)) + Integer.parseInt(m.group(2));
    }

    public int getDotVersion() throws IOException, InterruptedException {
        return this.retrieveVersion(this.dotVersion());
    }
}

