/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.notifications.action;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.commons.notifications.model.ChannelMessage;
import org.opensearch.commons.notifications.model.EventSource;
import org.opensearch.commons.utils.HelpersKt;
import org.opensearch.commons.utils.XContentHelpersKt;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0001\"B/\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bB\u000f\b\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u001c\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006#"}, d2={"Lorg/opensearch/commons/notifications/action/SendNotificationRequest;", "Lorg/opensearch/action/ActionRequest;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "eventSource", "Lorg/opensearch/commons/notifications/model/EventSource;", "channelMessage", "Lorg/opensearch/commons/notifications/model/ChannelMessage;", "channelIds", "", "", "threadContext", "(Lorg/opensearch/commons/notifications/model/EventSource;Lorg/opensearch/commons/notifications/model/ChannelMessage;Ljava/util/List;Ljava/lang/String;)V", "input", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getChannelIds", "()Ljava/util/List;", "getChannelMessage", "()Lorg/opensearch/commons/notifications/model/ChannelMessage;", "getEventSource", "()Lorg/opensearch/commons/notifications/model/EventSource;", "getThreadContext", "()Ljava/lang/String;", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "validate", "Lorg/opensearch/action/ActionRequestValidationException;", "writeTo", "", "output", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "common-utils"})
public final class SendNotificationRequest
extends ActionRequest
implements ToXContentObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EventSource eventSource;
    @NotNull
    private final ChannelMessage channelMessage;
    @NotNull
    private final List<String> channelIds;
    @Nullable
    private final String threadContext;
    @NotNull
    private static final Lazy<Logger> log$delegate = HelpersKt.logger(SendNotificationRequest.class);
    @NotNull
    private static final Writeable.Reader<SendNotificationRequest> reader = SendNotificationRequest::reader$lambda$0;

    @NotNull
    public final EventSource getEventSource() {
        return this.eventSource;
    }

    @NotNull
    public final ChannelMessage getChannelMessage() {
        return this.channelMessage;
    }

    @NotNull
    public final List<String> getChannelIds() {
        return this.channelIds;
    }

    @Nullable
    public final String getThreadContext() {
        return this.threadContext;
    }

    public SendNotificationRequest(@NotNull EventSource eventSource, @NotNull ChannelMessage channelMessage, @NotNull List<String> channelIds, @Nullable String threadContext) {
        Intrinsics.checkNotNullParameter((Object)eventSource, (String)"eventSource");
        Intrinsics.checkNotNullParameter((Object)channelMessage, (String)"channelMessage");
        Intrinsics.checkNotNullParameter(channelIds, (String)"channelIds");
        this.eventSource = eventSource;
        this.channelMessage = channelMessage;
        this.channelIds = channelIds;
        this.threadContext = threadContext;
    }

    public SendNotificationRequest(@NotNull StreamInput input) throws IOException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        super(input);
        Object object = EventSource.Companion.getReader().read(input);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"read(...)");
        this.eventSource = (EventSource)object;
        Object object2 = ChannelMessage.Companion.getReader().read(input);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"read(...)");
        this.channelMessage = (ChannelMessage)object2;
        List list = input.readStringList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"readStringList(...)");
        this.channelIds = list;
        this.threadContext = input.readOptionalString();
    }

    public void writeTo(@NotNull StreamOutput output) throws IOException {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        super.writeTo(output);
        this.eventSource.writeTo(output);
        this.channelMessage.writeTo(output);
        output.writeStringCollection((Collection)this.channelIds);
        output.writeOptionalString(this.threadContext);
    }

    @NotNull
    public XContentBuilder toXContent(@Nullable XContentBuilder builder, @Nullable ToXContent.Params params) {
        Intrinsics.checkNotNull((Object)builder);
        XContentBuilder xContentBuilder = builder.startObject().field("event_source", (ToXContent)this.eventSource).field("channel_message", (ToXContent)this.channelMessage).field("channel_id_list", (Iterable)this.channelIds);
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"field(...)");
        XContentBuilder xContentBuilder2 = XContentHelpersKt.fieldIfNotNull(xContentBuilder, "context", this.threadContext).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"endObject(...)");
        return xContentBuilder2;
    }

    @Nullable
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.channelIds.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"channelIds is empty", validationException);
        }
        return validationException;
    }

    private static final SendNotificationRequest reader$lambda$0(StreamInput it) {
        Intrinsics.checkNotNull((Object)it);
        return new SendNotificationRequest(it);
    }

    @JvmStatic
    @NotNull
    public static final SendNotificationRequest parse(@NotNull XContentParser parser) throws IOException {
        return Companion.parse(parser);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001f\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lorg/opensearch/commons/notifications/action/SendNotificationRequest$Companion;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "reader", "Lorg/opensearch/core/common/io/stream/Writeable$Reader;", "Lorg/opensearch/commons/notifications/action/SendNotificationRequest;", "kotlin.jvm.PlatformType", "getReader", "()Lorg/opensearch/core/common/io/stream/Writeable$Reader;", "parse", "parser", "Lorg/opensearch/core/xcontent/XContentParser;", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        @NotNull
        public final Writeable.Reader<SendNotificationRequest> getReader() {
            return reader;
        }

        @JvmStatic
        @NotNull
        public final SendNotificationRequest parse(@NotNull XContentParser parser) throws IOException {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            EventSource eventSource = null;
            ChannelMessage channelMessage = null;
            List<String> channelIds = null;
            String threadContext = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            block12: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName;
                block20: {
                    fieldName = parser.currentName();
                    parser.nextToken();
                    String string = fieldName;
                    if (string == null) break block20;
                    int n = -1;
                    switch (string.hashCode()) {
                        case 951530927: {
                            if (string.equals("context")) {
                                n = 1;
                            }
                            break;
                        }
                        case 1055568224: {
                            if (string.equals("event_source")) {
                                n = 2;
                            }
                            break;
                        }
                        case -578391861: {
                            if (string.equals("channel_message")) {
                                n = 3;
                            }
                            break;
                        }
                        case 119260678: {
                            if (string.equals("channel_id_list")) {
                                n = 4;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 2: {
                            eventSource = EventSource.Companion.parse(parser);
                            continue block12;
                        }
                        case 3: {
                            channelMessage = ChannelMessage.Companion.parse(parser);
                            continue block12;
                        }
                        case 4: {
                            channelIds = XContentHelpersKt.stringList(parser);
                            continue block12;
                        }
                        case 1: {
                            threadContext = parser.textOrNull();
                            continue block12;
                        }
                    }
                }
                parser.skipChildren();
                this.getLog().info("Unexpected field: " + fieldName + ", while parsing SendNotificationRequest");
            }
            if (eventSource == null) {
                throw new IllegalArgumentException("event_source field absent");
            }
            if (channelMessage == null) {
                throw new IllegalArgumentException("channel_message field absent");
            }
            if (channelIds == null) {
                throw new IllegalArgumentException("channel_id_list field absent");
            }
            return new SendNotificationRequest(eventSource, channelMessage, channelIds, threadContext);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

