/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.config.property;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GlobalProperty {
    public static final Pattern globalSymbolPattern = Pattern.compile("\\$\\{([\\w\\.-]+)\\}");
    protected String value = null;

    public static String stripGlobalSymbol(String symbol) {
        Matcher matcher = globalSymbolPattern.matcher(symbol);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return symbol;
    }

    protected GlobalProperty() {
    }

    public GlobalProperty(GlobalProperty other) {
        this.value = other.value;
    }

    public GlobalProperty(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GlobalProperty)) {
            return false;
        }
        GlobalProperty that = (GlobalProperty)o;
        String tmpValue = this.getValue();
        String otherValue = that.getValue();
        return tmpValue != null ? tmpValue.equals(otherValue) : otherValue == null;
    }

    public int hashCode() {
        String tmpValue = this.getValue();
        return tmpValue != null ? tmpValue.hashCode() : 0;
    }

    public static boolean isGlobalProperty(String s) {
        return globalSymbolPattern.matcher(s).matches();
    }

    public static boolean hasGlobalProperty(String s) {
        return globalSymbolPattern.matcher(s).find();
    }

    public static String getPropertyName(String gpn) {
        Matcher m = globalSymbolPattern.matcher(gpn);
        if (m.matches()) {
            return m.group(1);
        }
        return gpn;
    }
}

