/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.model.customization;

import org.eclipse.yasson.internal.components.AdapterBinding;
import org.eclipse.yasson.internal.model.customization.CustomizationBase;
import org.eclipse.yasson.internal.model.customization.PropertyCustomizationBuilder;
import org.eclipse.yasson.internal.serializer.JsonbDateFormatter;
import org.eclipse.yasson.internal.serializer.JsonbNumberFormatter;

public class PropertyCustomization
extends CustomizationBase {
    private final String jsonReadName;
    private final String jsonWriteName;
    private final JsonbNumberFormatter serializeNumberFormatter;
    private final JsonbNumberFormatter deserializeNumberFormatter;
    private final JsonbDateFormatter serializeDateFormatter;
    private final JsonbDateFormatter deserializeDateFormatter;
    private final AdapterBinding serializeAdapter;
    private final AdapterBinding deserializeAdapter;
    private boolean readTransient;
    private boolean writeTransient;
    private final Class<?> implementationClass;

    public PropertyCustomization(PropertyCustomizationBuilder builder) {
        super(builder);
        this.serializeAdapter = builder.getSerializeAdapter();
        this.deserializeAdapter = builder.getDeserializeAdapter();
        this.jsonReadName = builder.getJsonReadName();
        this.jsonWriteName = builder.getJsonWriteName();
        this.serializeNumberFormatter = builder.getSerializeNumberFormatter();
        this.deserializeNumberFormatter = builder.getDeserializeNumberFormatter();
        this.serializeDateFormatter = builder.getSerializeDateFormatter();
        this.deserializeDateFormatter = builder.getDeserializeDateFormatter();
        this.readTransient = builder.isReadTransient();
        this.writeTransient = builder.isWriteTransient();
        this.implementationClass = builder.getImplementationClass();
    }

    public String getJsonReadName() {
        return this.jsonReadName;
    }

    public String getJsonWriteName() {
        return this.jsonWriteName;
    }

    @Override
    public JsonbNumberFormatter getSerializeNumberFormatter() {
        return this.serializeNumberFormatter;
    }

    @Override
    public JsonbNumberFormatter getDeserializeNumberFormatter() {
        return this.deserializeNumberFormatter;
    }

    @Override
    public JsonbDateFormatter getSerializeDateFormatter() {
        return this.serializeDateFormatter;
    }

    @Override
    public JsonbDateFormatter getDeserializeDateFormatter() {
        return this.deserializeDateFormatter;
    }

    public boolean isReadTransient() {
        return this.readTransient;
    }

    public boolean isWriteTransient() {
        return this.writeTransient;
    }

    public Class<?> getImplementationClass() {
        return this.implementationClass;
    }

    @Override
    public AdapterBinding getDeserializeAdapterBinding() {
        return this.deserializeAdapter;
    }

    @Override
    public AdapterBinding getSerializeAdapterBinding() {
        return this.serializeAdapter;
    }
}

