/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.utils;

import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.memorycontainer.MemoryConfiguration;
import org.opensearch.ml.common.memorycontainer.MemoryStrategy;

public final class MemorySearchQueryBuilder {
    @Generated
    private static final Logger log = LogManager.getLogger(MemorySearchQueryBuilder.class);

    public static XContentBuilder buildNeuralQuery(String queryText, String embeddingModelId) throws IOException {
        return JsonXContent.jsonXContent.contentBuilder().startObject().startObject("neural").startObject("memory_embedding").field("query_text", queryText).field("model_id", embeddingModelId).endObject().endObject().endObject();
    }

    public static XContentBuilder buildNeuralSparseQuery(String queryText, String embeddingModelId) throws IOException {
        return JsonXContent.jsonXContent.contentBuilder().startObject().startObject("neural_sparse").startObject("memory_embedding").field("query_text", queryText).field("model_id", embeddingModelId).endObject().endObject().endObject();
    }

    public static XContentBuilder buildMatchQuery(String queryText) throws IOException {
        return JsonXContent.jsonXContent.contentBuilder().startObject().startObject("match").field("memory", queryText).endObject().endObject();
    }

    public static XContentBuilder buildQueryByStorageType(String queryText, MemoryConfiguration memoryConfig) throws IOException {
        if (memoryConfig != null) {
            if (memoryConfig.getEmbeddingModelType() == FunctionName.TEXT_EMBEDDING) {
                return MemorySearchQueryBuilder.buildNeuralQuery(queryText, memoryConfig.getEmbeddingModelId());
            }
            if (memoryConfig.getEmbeddingModelType() == FunctionName.SPARSE_ENCODING) {
                return MemorySearchQueryBuilder.buildNeuralSparseQuery(queryText, memoryConfig.getEmbeddingModelId());
            }
            throw new IllegalStateException("Unsupported embedding model type: " + String.valueOf(memoryConfig.getEmbeddingModelType()));
        }
        return MemorySearchQueryBuilder.buildMatchQuery(queryText);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static QueryBuilder buildFactSearchQuery(MemoryStrategy strategy, String fact, Map<String, String> namespace, String ownerId, MemoryConfiguration memoryConfig, String memoryContainerId) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        for (String key : strategy.getNamespace()) {
            if (!namespace.containsKey(key)) {
                throw new IllegalArgumentException("Namespace does not contain key: " + key);
            }
            boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)("namespace." + key), (String)namespace.get(key)));
        }
        if (ownerId != null) {
            boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"owner_id", (String)ownerId));
        }
        boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"namespace_size", (int)strategy.getNamespace().size()));
        boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"strategy_id", (String)strategy.getId()));
        if (memoryContainerId != null && !memoryContainerId.isBlank()) {
            boolQuery.filter((QueryBuilder)QueryBuilders.termQuery((String)"memory_container_id", (String)memoryContainerId));
        }
        if (memoryConfig != null) {
            if (memoryConfig.getEmbeddingModelType() == FunctionName.TEXT_EMBEDDING) {
                StringBuilder neuralSearchQuery = new StringBuilder().append("{\"neural\":{\"").append("memory_embedding").append("\":{\"query_text\":\"").append(StringEscapeUtils.escapeJson((String)fact)).append("\",\"model_id\":\"").append(memoryConfig.getEmbeddingModelId()).append("\"}}}");
                boolQuery.must((QueryBuilder)QueryBuilders.wrapperQuery((String)neuralSearchQuery.toString()));
                return boolQuery;
            } else {
                if (memoryConfig.getEmbeddingModelType() != FunctionName.SPARSE_ENCODING) throw new IllegalStateException("Unsupported embedding model type: " + String.valueOf(memoryConfig.getEmbeddingModelType()));
                StringBuilder neuralSparseQuery = new StringBuilder().append("{\"neural_sparse\":{\"").append("memory_embedding").append("\":{\"query_text\":\"").append(StringEscapeUtils.escapeJson((String)fact)).append("\",\"model_id\":\"").append(memoryConfig.getEmbeddingModelId()).append("\"}}}");
                boolQuery.must((QueryBuilder)QueryBuilders.wrapperQuery((String)neuralSparseQuery.toString()));
            }
            return boolQuery;
        } else {
            boolQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)"memory", (Object)fact));
        }
        return boolQuery;
    }

    @Generated
    private MemorySearchQueryBuilder() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

